/*
 * Decompiled with CFR 0.152.
 */
package ehouse4java;

import ehouse4java.EhouseTCP;
import ehouse4java.GraphicObject;
import ehouse4java.ehousecommunication;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Calendar;

public class StatusEhouse {
    static final int STATUS_OFFSET = 2;
    static final int RM_STATUS_ADC = 3;
    static final int RM_STATUS_OUT = 19;
    static final int HM_STATUS_OUT = 35;
    static final int RM_STATUS_IN = 22;
    static final int RM_STATUS_INT = 23;
    static final int RM_STATUS_OUT25 = 24;
    static final int RM_STATUS_LIGHT = 25;
    static final int RM_STATUS_ZONE_PGM = 28;
    static final int RM_STATUS_PROGRAM = 29;
    static final int RM_STATUS_INPUTEXT_A_ACTIVE = 30;
    static final int RM_STATUS_INPUTEXT_B_ACTIVE = 34;
    static final int RM_STATUS_INPUTEXT_C_ACTIVE = 38;
    static final int RM_STATUS_INPUTEXT_A = 42;
    static final int RM_STATUS_INPUTEXT_B = 52;
    static final int RM_STATUS_INPUTEXT_C = 62;
    static final int HM_STATUS_PROGRAM = 38;
    static final int HM_STATUS_KOMINEK = 48;
    static final int HM_STATUS_RECU = 50;
    static final int HM_WENT_MODE = 51;
    public String XML = "";
    public long CheckSum = 0L;
    public String recent = "";
    public boolean InitializedMatrix = false;
    int STATUS_INDEX = -1;
    static final int OUTPUTS_COUNT_RM = 35;
    static final int INPUTS_COUNT_RM = 16;
    static final int SENSORS_COUNT_RM = 16;
    static final int SENSORS_COUNT_ALARM = 128;
    static final int STATUS_SIZE = 256;
    static final int GRAPHIC_OBJECTS_OTHER = 1000;
    static final int GRAPHIC_OBJECTS_CURRENT = 3000;
    static final int DIMMERS_COUNT_RM = 3;
    static final int DIMMERS_RGB_COUNT_RM = 1;
    static final int PROGRAMS_COUNT_RM = 24;
    static final int GRAPHICS_OBJECTS_MAX = 5;
    public String DeviceName;
    public String[] ProgramNames = new String[24];
    public String[] OutputNames = new String[35];
    public String[] DimmerNames = new String[3];
    public String[] DimmerRGBNames = new String[1];
    public int[] Dimmer = new int[3];
    public boolean XmlChanged = false;
    public int[] DimmerRGB = new int[1];
    public GraphicObject[] OtherViews = new GraphicObject[1000];
    public int OtherViewsIndex = 0;
    public int CurrentViewStatIndex = 0;
    public GraphicObject[] CurrentViewStat = new GraphicObject[3000];
    public GraphicObject[][] OutputViewL = new GraphicObject[35][5];
    public GraphicObject[][] OutputViewH = new GraphicObject[35][5];
    public String[] InputNames = new String[16];
    public GraphicObject[][] InputViewL = new GraphicObject[16][5];
    public GraphicObject[][] InputViewH = new GraphicObject[16][5];
    public String[] SensorNames = new String[16];
    public int[] SensorType = new int[16];
    public GraphicObject[][] SensorViewL = new GraphicObject[16][5];
    public GraphicObject[][] SensorViewOK = new GraphicObject[16][5];
    public GraphicObject[][] SensorViewH = new GraphicObject[16][5];
    public int[] SensorABSValues = new int[16];
    public int[] Calibration = new int[16];
    public Double[] SensorTemps = new Double[16];
    public Double[] SensorPercents = new Double[16];
    public Double[] SensorLights = new Double[16];
    public Double[] SensorVolts = new Double[16];
    public Boolean[] OutputStates = new Boolean[35];
    public Boolean[] InputStates = new Boolean[16];
    public Boolean[] AlarmSensorsActive = new Boolean[128];
    public GraphicObject[][] AlarmViewSensorsL = new GraphicObject[128][5];
    public GraphicObject[][] AlarmViewSensorsH = new GraphicObject[128][5];
    public Boolean[] AlarmSensorsWarning = new Boolean[128];
    public GraphicObject[][] WarningViewSensorsL = new GraphicObject[128][5];
    public GraphicObject[][] WarningViewSensorsH = new GraphicObject[128][5];
    public Boolean[] MonitoringSensorsWarning = new Boolean[128];
    public GraphicObject[][] MonitoringViewSensorsL = new GraphicObject[128][5];
    public GraphicObject[][] MonitoringViewSensorsH = new GraphicObject[128][5];
    public GraphicObject[][] ActiveViewSensorsL = new GraphicObject[128][5];
    public GraphicObject[][] ActiveViewSensorsH = new GraphicObject[128][5];
    public Boolean[] AlarmSensorsAlarm = new Boolean[128];
    public String[] AlarmSensorsNames = new String[128];
    public int DevAdrH;
    public int DevAdrL;
    public boolean changed;
    public boolean AdcChanged;
    public int CurrentProgram;
    public String CurrentProgramName;
    public int CurrentZone;
    public String CurrentZoneName;
    public Byte[] CurrentStatus = new Byte[256];
    public boolean IsBatch;
    public boolean IsRM;
    public boolean IsHM;
    public boolean IsEM;
    public boolean IsAlarm;
    public boolean IsEthernet;
    public int VCC;
    static final int ADC_N_OFFSET = 4;
    static final int O_N_OFFSET = 20;
    static final int I_N_OFFSET = 55;
    public Thread MakeXml = new Thread(){

        @Override
        public void run() {
            this.setPriority(1);
            while (!ehousecommunication.Terminate) {
                int i;
                while (!StatusEhouse.this.XmlChanged) {
                    try {
                        1.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!ehousecommunication.Terminate) continue;
                    return;
                }
                StatusEhouse.this.XmlChanged = false;
                String eol = "\r\n";
                StatusEhouse.this.XML = "";
                String header = "";
                if (StatusEhouse.this.DevAdrH == 2) {
                    header = "\r\n";
                }
                header = header + "<?xml version=\"1.0\" encoding=\"UTF-8\" ?> \r\n <eHouse xmlns=\"http://www.isys.pl\" \r\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n            xsi:schemaLocation=\"http://www.openremote.org protocol.xsd\">";
                header = header + "<Device>" + eol;
                header = header + "<Name>" + StatusEhouse.this.DeviceName + "</Name>" + eol;
                header = header + "<Address>" + StatusEhouse.this.DevAdrH + "," + StatusEhouse.this.DevAdrL + "</Address>" + eol;
                header = header + "<StateModified>" + ehousecommunication.bo(StatusEhouse.this.changed) + "</StateModified>" + eol;
                header = header + "<ADCModified>" + ehousecommunication.bo(StatusEhouse.this.AdcChanged) + "</ADCModified>" + eol;
                header = header + "<CurrentProgram>" + ehousecommunication.i(StatusEhouse.this.CurrentProgram) + "</CurrentProgram>" + eol;
                header = header + "<CurrentProgramName> " + StatusEhouse.this.CurrentProgramName + " </CurrentProgramName>" + eol;
                header = header + "<CurrentStatus>" + ehousecommunication.hx(StatusEhouse.this.CurrentStatus, 256) + "</CurrentStatus>" + eol;
                header = header + "<RecentStatus>" + StatusEhouse.this.recent + "</RecentStatus>" + eol;
                if (StatusEhouse.this.IsRM) {
                    header = header + "<Devicetype>RoomManager</Devicetype>" + eol;
                }
                if (StatusEhouse.this.IsEM) {
                    header = header + "<Devicetype>ExternalManager</Devicetype>" + eol;
                }
                if (StatusEhouse.this.IsHM) {
                    header = header + "<Devicetype>HeatManager</Devicetype>" + eol;
                }
                if (StatusEhouse.this.IsEthernet) {
                    header = header + "<InterfaceType>Ethernet</InterfaceType>" + eol;
                }
                if (StatusEhouse.this.IsEM) {
                    header = header + "<CurrentZone>" + ehousecommunication.i(StatusEhouse.this.CurrentZone) + "</CurrentZone>" + eol;
                    header = header + "<CurrentZoneName>" + StatusEhouse.this.CurrentZoneName + "</CurrentZoneName>" + eol;
                }
                String bodyheader = eol + "<Outputs>" + eol;
                String body = "";
                int maxio = 35;
                if (StatusEhouse.this.IsRM || StatusEhouse.this.IsEM) {
                    maxio = 35;
                }
                if (StatusEhouse.this.IsHM) {
                    maxio = 21;
                }
                for (i = 0; i < maxio; ++i) {
                    if (ehousecommunication.IgnoreAtChar && StatusEhouse.this.OutputNames[i].indexOf("@") >= 0) continue;
                    int[] tmp = new int[]{StatusEhouse.this.DevAdrH, StatusEhouse.this.DevAdrL, 1, 0, 1, 0, 0, 0, 0, 0};
                    tmp[3] = i;
                    String state = "0";
                    String value = "Off";
                    if (StatusEhouse.this.OutputStates[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    }
                    body = body + "    <Item>" + eol + "        <Name>" + StatusEhouse.this.OutputNames[i] + "</Name>" + eol + "        <No>" + String.valueOf(i + 1) + "</No>" + eol + "        <State>" + state + "</State>" + eol + "        <Value>" + value + "</Value>" + eol;
                    if (!StatusEhouse.this.IsHM) {
                        String Event2 = ehousecommunication.hix(tmp, 10);
                        body = body + "        <EventOn>" + Event2 + "</EventOn>" + eol;
                        tmp[4] = 0;
                        Event2 = ehousecommunication.hix(tmp, 10);
                        body = body + "        <EventOff>" + Event2 + "</EventOff>" + eol;
                        tmp[4] = 2;
                        Event2 = ehousecommunication.hix(tmp, 10);
                        body = body + "        <EventToggle>" + Event2 + "</EventToggle>" + eol;
                    }
                    body = body + "    </Item>" + eol + eol;
                }
                String bodyfooter = eol + "</Outputs>" + eol;
                header = header + bodyheader + body + bodyfooter + eol;
                bodyheader = eol + "<ADCInputs>" + eol;
                body = eol;
                bodyfooter = eol + "</ADCInputs>" + eol;
                maxio = 16;
                if (!StatusEhouse.this.IsHM) {
                    maxio = 8;
                }
                for (i = 0; i < maxio; ++i) {
                    if (ehousecommunication.IgnoreAtChar && StatusEhouse.this.SensorNames[i].indexOf("@") >= 0) continue;
                    body = body + "    <Item>" + eol + "        <Name>" + StatusEhouse.this.SensorNames[i] + "</Name>" + eol + "        <ADCValue>" + StatusEhouse.this.SensorABSValues[i] + "</ADCValue>" + eol + "        <ADCTempValue>" + StatusEhouse.this.SensorTemps[i] + "</ADCTempValue>" + eol + "        <ADCLM335TempValue>" + StatusEhouse.this.SensorTemps[i] + "</ADCLM335TempValue>" + eol + "        <ADCPercentValue>" + StatusEhouse.this.SensorPercents[i] + "</ADCPercentValue>" + eol + "        <ADCInvertedPercentValue>" + StatusEhouse.this.SensorLights[i] + "</ADCInvertedPercentValue>" + eol + "        <ADCVoltageValue>" + StatusEhouse.this.SensorVolts[i].toString() + "</ADCVoltageValue>" + eol + "        <ADCCalibrationValue>" + StatusEhouse.this.Calibration[i] + "</ADCCalibrationValue>" + eol + "        <No>" + String.valueOf(i + 1) + "</No>" + eol + "        <SensorType>" + StatusEhouse.this.SensorType[i] + "</SensorType>" + eol;
                    body = body + "    </Item>" + eol + eol;
                }
                header = header + bodyheader + body + bodyfooter + eol;
                bodyheader = eol + "<Inputs>" + eol;
                body = eol;
                bodyfooter = eol;
                maxio = 16;
                if (StatusEhouse.this.IsRM || StatusEhouse.this.IsHM || StatusEhouse.this.IsEM) {
                    maxio = 12;
                }
                for (i = 0; i < maxio; ++i) {
                    if (ehousecommunication.IgnoreAtChar && StatusEhouse.this.InputNames[i].indexOf("@") >= 0) continue;
                    String state = "0";
                    String value = "On";
                    if (StatusEhouse.this.IsEM) {
                        if (!StatusEhouse.this.InputStates[i].booleanValue()) {
                            state = "1";
                            value = "Off";
                        } else {
                            state = "0";
                            value = "On";
                        }
                    } else if (!StatusEhouse.this.InputStates[i].booleanValue()) {
                        state = "0";
                        value = "On";
                    } else {
                        state = "1";
                        value = "Off";
                    }
                    body = body + "    <Item>" + eol + "        <Name>" + StatusEhouse.this.InputNames[i] + "</Name>" + eol + "        <No>" + String.valueOf(i + 1) + "</No>" + eol + "        <State>" + state + "</State>" + eol + "        <Value>" + value + "</Value>" + eol;
                    if (StatusEhouse.this.IsEM) {
                        if (!StatusEhouse.this.AlarmSensorsActive[i].booleanValue()) {
                            state = "0";
                            value = "Off";
                        } else {
                            state = "1";
                            value = "On";
                        }
                        body = body + "        <ActiveState>" + state + "</ActiveState>" + eol + "        <ActiveValue>" + value + "</ActiveValue>" + eol;
                        if (!StatusEhouse.this.AlarmSensorsWarning[i].booleanValue()) {
                            state = "0";
                            value = "Off";
                        } else {
                            state = "1";
                            value = "On";
                        }
                        body = body + "        <WarningState>" + state + "</WarningState>" + eol + "        <WarningValue>" + value + "</WarningValue>" + eol;
                        body = body + "        <MonitoringState>" + state + "</MonitoringState>" + eol + "        <MonitoringValue>" + value + "</MonitoringValue>" + eol;
                        if (!StatusEhouse.this.AlarmSensorsAlarm[i].booleanValue()) {
                            state = "0";
                            value = "Off";
                        } else {
                            state = "1";
                            value = "On";
                        }
                        body = body + "        <AlarmState>" + state + "</AlarmState>" + eol + "        <AlarmValue>" + value + "</AlarmValue>" + eol;
                    }
                    String inversion = "Normal";
                    body = body + "        <Type>" + inversion + "</Type>" + eol;
                    body = body + "    </Item>" + eol + eol;
                }
                bodyfooter = eol + "</Inputs>" + eol;
                header = header + bodyheader + body + bodyfooter + eol;
                String footer = "</Device>\r\n";
                footer = footer + "\r\n</eHouse> \r\n";
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(ehousecommunication.path + "logs/" + StatusEhouse.this.DeviceName + ".xml"));
                    out.write(header + footer);
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                StatusEhouse.this.XML = header + footer;
            }
        }
    };

    public void SetStatusIndex(int nr) {
        this.STATUS_INDEX = nr;
    }

    String CHDYN(String str) {
        int i;
        if (str == null) {
            return "";
        }
        String Line = str;
        if (Line.indexOf("%OutputName") >= 0) {
            for (i = 0; i < 35; ++i) {
                Line.replaceAll("%OutputName" + String.valueOf(i + 1) + "%", this.OutputNames[i]);
            }
        }
        if (Line.indexOf("%InputName") >= 0) {
            for (i = 0; i < 16; ++i) {
                Line.replaceAll("%InputName" + String.valueOf(i + 1) + "%", this.InputNames[i]);
            }
        }
        if (Line.indexOf("%ADCSensorName") >= 0) {
            for (i = 0; i < 16; ++i) {
                Line.replaceAll("%ADCSensorName" + String.valueOf(i + 1) + "%", this.SensorNames[i]);
            }
        }
        if (Line.indexOf("%AlarmSensorName") >= 0) {
            for (i = 0; i < 128; ++i) {
                Line.replaceAll("%AlarmSensorName" + String.valueOf(i + 1) + "%", this.AlarmSensorsNames[i]);
            }
        }
        if (Line.indexOf("%DimmerName") >= 0) {
            for (i = 0; i < 3; ++i) {
                Line.replaceAll("%DimmerName" + String.valueOf(i + 1) + "%", this.DimmerNames[i]);
            }
        }
        if (Line.indexOf("%DimmerRGBName") >= 0) {
            for (i = 0; i < 1; ++i) {
                Line.replaceAll("%DimmerRGBName" + String.valueOf(i + 1) + "%", this.DimmerRGBNames[i]);
            }
        }
        if (Line.indexOf("%ProgramName") >= 0) {
            for (i = 0; i < 24; ++i) {
                Line.replaceAll("%ProgramName" + String.valueOf(i + 1) + "%", this.ProgramNames[i]);
            }
        }
        return Line;
    }

    public void ClearAllVisualisationItems() {
        int z;
        int m;
        int z2;
        if (this.DeviceName == null) {
            return;
        }
        if (this.DeviceName == "") {
            return;
        }
        for (z2 = 0; z2 < 1000; ++z2) {
            this.OtherViews[z2].event_name = null;
            this.OtherViews[z2].DeviceName = null;
        }
        for (z2 = 0; z2 < 3000; ++z2) {
            this.CurrentViewStat[z2].event_name = null;
            this.CurrentViewStat[z2].DeviceName = null;
        }
        this.CurrentViewStatIndex = 0;
        this.OtherViewsIndex = 0;
        for (m = 0; m < 35; ++m) {
            for (z = 0; z < 5; ++z) {
                this.OutputViewH[m][z].event_name = null;
                this.OutputViewL[m][z].event_name = null;
                this.OutputViewH[m][z].DeviceName = null;
                this.OutputViewL[m][z].DeviceName = null;
            }
        }
        for (m = 0; m < 16; ++m) {
            for (z = 0; z < 5; ++z) {
                this.InputViewH[m][z].event_name = null;
                this.InputViewL[m][z].event_name = null;
                this.InputViewH[m][z].DeviceName = null;
                this.InputViewL[m][z].DeviceName = null;
            }
        }
        for (m = 0; m < 16; ++m) {
            for (z = 0; z < 5; ++z) {
                this.SensorViewL[m][z].event_name = null;
                this.SensorViewH[m][z].event_name = null;
                this.SensorViewOK[m][z].event_name = null;
                this.SensorViewL[m][z].DeviceName = null;
                this.SensorViewH[m][z].DeviceName = null;
                this.SensorViewOK[m][z].DeviceName = null;
            }
        }
        for (m = 0; m < 128; ++m) {
            for (z = 0; z < 5; ++z) {
                this.ActiveViewSensorsL[m][z].event_name = null;
                this.ActiveViewSensorsH[m][z].event_name = null;
                this.AlarmViewSensorsH[m][z].event_name = null;
                this.AlarmViewSensorsL[m][z].event_name = null;
                this.WarningViewSensorsH[m][z].event_name = null;
                this.WarningViewSensorsL[m][z].event_name = null;
                this.MonitoringViewSensorsH[m][z].event_name = null;
                this.MonitoringViewSensorsL[m][z].event_name = null;
                this.ActiveViewSensorsL[m][z].DeviceName = null;
                this.ActiveViewSensorsH[m][z].DeviceName = null;
                this.AlarmViewSensorsH[m][z].DeviceName = null;
                this.AlarmViewSensorsL[m][z].DeviceName = null;
                this.WarningViewSensorsH[m][z].DeviceName = null;
                this.WarningViewSensorsL[m][z].DeviceName = null;
                this.MonitoringViewSensorsH[m][z].DeviceName = null;
                this.MonitoringViewSensorsL[m][z].DeviceName = null;
            }
        }
    }

    public void ClearActiveVisualization() {
        for (int z = 0; z < 3000; ++z) {
            this.CurrentViewStat[z].event_name = null;
            this.CurrentViewStat[z].DeviceName = null;
        }
        this.CurrentViewStatIndex = 0;
    }

    public void InitVisualisationItems() {
        int z;
        int m;
        int z2;
        if (this.InitializedMatrix) {
            return;
        }
        for (z2 = 0; z2 < 1000; ++z2) {
            this.OtherViews[z2] = new GraphicObject("");
        }
        for (z2 = 0; z2 < 3000; ++z2) {
            this.CurrentViewStat[z2] = new GraphicObject("");
        }
        for (m = 0; m < 35; ++m) {
            this.OutputNames[m] = "";
            this.OutputStates[m] = false;
            for (z = 0; z < 5; ++z) {
                this.OutputViewH[m][z] = new GraphicObject("");
                this.OutputViewL[m][z] = new GraphicObject("");
            }
        }
        for (m = 0; m < 3; ++m) {
            this.DimmerNames[m] = "";
        }
        for (m = 0; m < 1; ++m) {
            this.DimmerRGBNames[m] = "";
        }
        for (m = 0; m < 24; ++m) {
            this.ProgramNames[m] = "";
        }
        for (m = 0; m < 16; ++m) {
            this.InputNames[m] = "";
            this.InputStates[m] = false;
            for (z = 0; z < 5; ++z) {
                this.InputViewH[m][z] = new GraphicObject("");
                this.InputViewL[m][z] = new GraphicObject("");
            }
        }
        for (m = 0; m < 16; ++m) {
            this.SensorNames[m] = "";
            for (z = 0; z < 5; ++z) {
                this.SensorViewL[m][z] = new GraphicObject("");
                this.SensorViewH[m][z] = new GraphicObject("");
                this.SensorViewOK[m][z] = new GraphicObject("");
            }
        }
        for (m = 0; m < 128; ++m) {
            this.AlarmSensorsNames[m] = "";
            for (z = 0; z < 5; ++z) {
                this.AlarmSensorsActive[m] = false;
                this.AlarmSensorsWarning[m] = false;
                this.MonitoringSensorsWarning[m] = false;
                this.AlarmSensorsAlarm[m] = false;
                this.AlarmSensorsWarning[m] = false;
                this.ActiveViewSensorsL[m][z] = new GraphicObject("");
                this.ActiveViewSensorsH[m][z] = new GraphicObject("");
                this.AlarmViewSensorsH[m][z] = new GraphicObject("");
                this.AlarmViewSensorsL[m][z] = new GraphicObject("");
                this.WarningViewSensorsH[m][z] = new GraphicObject("");
                this.WarningViewSensorsL[m][z] = new GraphicObject("");
                this.MonitoringViewSensorsH[m][z] = new GraphicObject("");
                this.MonitoringViewSensorsL[m][z] = new GraphicObject("");
            }
        }
        this.InitializedMatrix = true;
    }

    public void CreateVisualization() {
        int m;
        this.ClearActiveVisualization();
        this.CurrentViewStatIndex = 0;
        for (int z = 0; z < this.OtherViewsIndex; ++z) {
            if (this.OtherViews[z].event_name == null) continue;
            this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(this.OtherViews[z]);
            this.CurrentViewStat[this.CurrentViewStatIndex].Label_text = this.ChangeDynamic(this.CurrentViewStat[this.CurrentViewStatIndex].Label_text);
            ++this.CurrentViewStatIndex;
        }
        for (m = 0; m < 35; ++m) {
            this.UpdateIOStatus(this.OutputStates[m], this.OutputViewH[m], this.OutputViewL[m], 5);
        }
        for (m = 0; m < 16; ++m) {
            this.UpdateIOStatus(this.InputStates[m], this.InputViewH[m], this.InputViewL[m], 5);
        }
        for (m = 0; m < 16; ++m) {
            this.UpdateIOStatus(true, this.SensorViewL[m], this.SensorViewH[m], 5);
        }
        for (m = 0; m < 128; ++m) {
            this.UpdateIOStatus(this.AlarmSensorsActive[m], this.ActiveViewSensorsH[m], this.ActiveViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsWarning[m], this.WarningViewSensorsH[m], this.WarningViewSensorsL[m], 5);
            this.UpdateIOStatus(this.MonitoringSensorsWarning[m], this.MonitoringViewSensorsH[m], this.MonitoringViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsAlarm[m], this.AlarmViewSensorsH[m], this.AlarmViewSensorsL[m], 5);
        }
        int Max_ADC = 8;
        if (this.IsHM) {
            Max_ADC = 16;
        }
        for (int i = 0; i < Max_ADC; ++i) {
            this.UpdateADC(i, 5.0f, 0.0f, 10.0f, this.SensorViewL[i], this.SensorViewH[i], this.SensorViewOK[i], 5);
        }
    }

    public boolean ChkIsAdcChanged() {
        if (this.AdcChanged) {
            this.AdcChanged = false;
            return true;
        }
        return false;
    }

    public boolean IsDeviceName(String dname) {
        if (this.DeviceName == null) {
            return false;
        }
        if (this.DeviceName.length() == 0) {
            return false;
        }
        return dname.length() > 0 && dname.compareTo(this.DeviceName) == 0;
    }

    private double gettemplm(int dta, int calibration, double k, int VCC) {
        double temp = (double)(dta * VCC) / (1023.0 * k) + (double)(calibration / 100);
        temp = (double)Math.round(temp * 10.0) / 10.0;
        return temp;
    }

    private int check_in(String stt, int defaut) {
        double dd = Double.valueOf(stt);
        int ino = (int)dd;
        return ino;
    }

    public void ReadAlarmSensorsNames(String pat) {
        int i = 0;
        boolean z = false;
        if (ehousecommunication.FileExists(pat)) {
            String[] AlarmS = ehousecommunication.getfile(pat);
            while (AlarmS[i] != null) {
                this.AlarmSensorsActive[i] = false;
                this.AlarmSensorsAlarm[i] = false;
                this.AlarmSensorsWarning[i] = false;
                this.AlarmSensorsNames[i] = AlarmS[i];
                if (++i != 128) continue;
            }
            while (i < 128) {
                this.AlarmSensorsActive[i] = false;
                this.AlarmSensorsAlarm[i] = false;
                this.AlarmSensorsWarning[i] = false;
                this.AlarmSensorsNames[i] = "";
                ++i;
            }
        }
    }

    public void ReadHMSensorsNames() {
        String[] AlarmS;
        int i = 0;
        boolean z = false;
        String pat = "hmtemps.txt";
        if (ehousecommunication.FileExists(ehousecommunication.locpath + pat)) {
            AlarmS = ehousecommunication.getfile(ehousecommunication.locpath + pat);
            while (AlarmS[i] != null) {
                this.SensorNames[i] = AlarmS[i];
                if (++i != 16) continue;
            }
            while (i < 16) {
                this.SensorNames[i] = "";
                ++i;
            }
        }
        i = 0;
        pat = "hmouts.txt";
        if (ehousecommunication.FileExists(ehousecommunication.locpath + pat)) {
            AlarmS = ehousecommunication.getfile(ehousecommunication.locpath + pat);
            while (AlarmS[i] != null) {
                this.OutputNames[i] = AlarmS[i];
                if (++i != 35) continue;
            }
            while (i < 35) {
                this.OutputNames[i] = "";
                ++i;
            }
        }
        i = 0;
        pat = "heater.evs";
        if (ehousecommunication.FileExists(ehousecommunication.locpath + pat)) {
            AlarmS = ehousecommunication.getfile(ehousecommunication.locpath + pat);
            while (AlarmS[i] != null) {
                this.ProgramNames[i] = AlarmS[i];
                if (++i != 24) continue;
            }
            while (i < 24) {
                this.ProgramNames[i] = "";
                ++i;
            }
        }
    }

    public void LoadDta(String name) {
        if (ehousecommunication.FileExists(name)) {
            int i;
            String[] SteH = ehousecommunication.getfile(name);
            this.InitVisualisationItems();
            this.DeviceName = SteH[0];
            this.DevAdrH = this.check_in(SteH[1], 0);
            this.DevAdrL = this.check_in(SteH[2], 0);
            String temp = SteH[3];
            if (temp.compareTo("HM") == 0) {
                this.IsHM = true;
            }
            if (temp.compareTo("EM") == 0) {
                this.IsEM = true;
            }
            if (temp.compareTo("RM") == 0) {
                this.IsRM = true;
            }
            for (i = 0; i < 16; ++i) {
                this.SensorNames[i] = SteH[4 + i];
                if (this.SensorNames[i] == null) {
                    this.SensorNames[i] = "@ADC" + String.valueOf(i + 1);
                }
                if (this.SensorNames[i].length() == 0) {
                    this.SensorNames[i] = "@ADC" + String.valueOf(i + 1);
                }
                this.SensorABSValues[i] = 0;
                this.SensorTemps[i] = 0.0;
                this.SensorPercents[i] = 0.0;
                this.SensorLights[i] = 0.0;
                this.SensorVolts[i] = 0.0;
                this.Calibration[i] = -27315;
            }
            this.VCC = 5000;
            for (i = 0; i < 35; ++i) {
                this.OutputNames[i] = SteH[4 + i + 16];
                if (this.OutputNames[i] == null) {
                    this.OutputNames[i] = "@OUT" + String.valueOf(i + 1);
                }
                if (this.OutputNames[i].length() == 0) {
                    this.OutputNames[i] = "@OUT" + String.valueOf(i + 1);
                }
                this.OutputStates[i] = false;
            }
            for (i = 0; i < 16; ++i) {
                this.InputNames[i] = SteH[4 + i + 35 + 16];
                if (this.InputNames[i] == null) {
                    this.InputNames[i] = "@IN" + String.valueOf(i + 1);
                }
                if (this.InputNames[i].length() == 0) {
                    this.InputNames[i] = "@IN" + String.valueOf(i + 1);
                }
                this.InputStates[i] = false;
            }
            this.changed = false;
            this.CurrentProgram = 0;
            this.CurrentProgramName = "";
            for (i = 0; i < 256; ++i) {
                this.CurrentStatus[i] = 0;
            }
            this.IsBatch = false;
            this.IsAlarm = false;
            this.IsEthernet = false;
            if (ehousecommunication.EnableXMLStatus) {
                this.MakeXml.start();
            }
        }
    }

    public double calculate_percent(int dta) {
        double tmp = (double)Math.round((double)(dta * 100 / 1023) * 100.0) / 100.0;
        return tmp;
    }

    public double calculate_voltage(int dta) {
        double tmp = Math.round((double)(dta * this.VCC / 1023) * 100.0);
        return tmp /= 100000.0;
    }

    public double getlight(int dta) {
        double dtta = dta * 100;
        return (double)Math.round((dtta /= 1023.0) * 10.0) / 10.0;
    }

    public String ADCVal(int index) {
        if (!this.IsHM && index == 0) {
            return this.SensorLights[index].toString() + " %";
        }
        return this.SensorTemps[index].toString() + " C";
    }

    public boolean GetInOutValue(int dta, int offset) {
        int temp = dta >> offset;
        return (temp & 1) > 0;
    }

    public int[] GetOptsIndex(String EventName, int AlarmState) {
        int i;
        int[] m = new int[2];
        for (i = 0; i < 35; ++i) {
            if (this.OutputNames[i].length() <= 0 || EventName.compareTo(this.OutputNames[i]) != 0) continue;
            m[1] = i;
            m[0] = 1;
            return m;
        }
        for (i = 0; i < 16; ++i) {
            if (this.InputNames[i].length() <= 0 || EventName.compareTo(this.InputNames[i]) != 0) continue;
            m[1] = i;
            m[0] = 2;
            return m;
        }
        for (i = 0; i < 16; ++i) {
            if (this.SensorNames[i].length() <= 0 || EventName.compareTo(this.SensorNames[i]) != 0) continue;
            m[1] = i;
            m[0] = 3;
            return m;
        }
        if (this.IsEM) {
            for (i = 0; i < 128; ++i) {
                if (this.AlarmSensorsNames[i].length() <= 0 || EventName.compareTo(this.AlarmSensorsNames[i]) != 0) continue;
                m[1] = i;
                m[0] = 4 + AlarmState;
                return m;
            }
        }
        m[1] = 255;
        m[0] = 255;
        return m;
    }

    void UpdateIOStatus(boolean State2, GraphicObject[] ON, GraphicObject[] OFF, int size) {
        GraphicObject gr = new GraphicObject("");
        if (this.CurrentViewStatIndex >= 3000) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            gr = State2 ? new GraphicObject(ON[i]) : new GraphicObject(OFF[i]);
            if (gr.event_name != null) {
                if (gr.event_name.length() > 0) {
                    this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(gr);
                    ++this.CurrentViewStatIndex;
                    if (this.CurrentViewStatIndex < 3000) continue;
                    return;
                }
                return;
            }
            return;
        }
    }

    public String ChangeDynamic(String st) {
        String str = st;
        int kk = str.indexOf("%");
        int mm = -1;
        int indeee = 0;
        if (kk >= 0) {
            mm = str.indexOf("%", kk + 1);
        }
        if (kk < 0 || mm < 0) {
            return str;
        }
        if (str.indexOf("%HEATER_") >= 0) {
            str = str.replaceFirst("%HEATER_KOMSTAT%", EhouseTCP.HEATER_KOMSTAT);
            str = str.replaceFirst("%HEATER_RECUPERATOR_MODE%", EhouseTCP.HEATER_RECUPERATOR_MODE);
            str = str.replaceFirst("%HEATER_RECUPERATOR_SPEED%", EhouseTCP.HEATER_RECUPERATOR_SPEED);
            str = str.replaceFirst("%HEATER_RECUPERATOR_TEMP%", EhouseTCP.HEATER_RECUPERATOR_TEMP);
            str = str.replaceFirst("%HEATER_PROGRAM%", EhouseTCP.HEATER_PROGRAM);
        }
        if (str.indexOf("%EXTERNAL_") >= 0) {
            str = str.replaceFirst("%EXTERNAL_CURRENTZONE%", EhouseTCP.EXTERNAL_CURRENTZONE);
            str = str.replaceFirst("%EXTERNAL_CURRENTZONENAME%", EhouseTCP.EXTERNAL_CURRENTZONENAME);
            str = str.replaceFirst("%EXTERNAL_CURRENTPROGRAM%", EhouseTCP.External_currentprogram);
            str = str.replaceFirst("%EXTERNAL_CURRENTPROGRAMNAME%", EhouseTCP.External_currentprogramname);
        }
        str = str.replaceFirst("%CURRENTPROGRAM%", String.valueOf(this.CurrentProgram));
        str = str.replaceFirst("%CURRENTPROGRAMNAME%", this.CurrentProgramName);
        kk = str.indexOf("%");
        mm = -1;
        if (kk >= 0) {
            mm = str.indexOf("%", kk + 1);
        }
        while (kk >= 0 && mm >= 0) {
            str = str.replaceFirst("%TEMP" + indeee + "%", this.SensorTemps[indeee].toString());
            str = str.replaceFirst("%ADC" + indeee + "%", String.valueOf(this.SensorABSValues[indeee]));
            str = str.replaceFirst("%PERCENT" + indeee + "%", this.SensorPercents[indeee].toString());
            str = str.replaceFirst("%LIGHT" + indeee + "%", this.SensorLights[indeee].toString());
            str = str.replaceFirst("%INVADC" + indeee + "%", String.valueOf(1023 - this.SensorABSValues[indeee]));
            str = str.replaceFirst("%INVPERCENT" + indeee + "%", String.valueOf(100.0 - this.SensorPercents[indeee]));
            str = str.replaceFirst("%VOLT" + indeee + "%", String.valueOf(this.SensorVolts[indeee]));
            kk = str.indexOf("%");
            mm = -1;
            if (kk >= 0) {
                mm = str.indexOf("%", kk + 1);
            }
            if (++indeee < 16) continue;
            break;
        }
        return str;
    }

    void UpdateADC(int InputNr, float Value, float Min, float Max, GraphicObject[] LOW, GraphicObject[] HIGH, GraphicObject[] OK, int size) {
        GraphicObject gr = new GraphicObject("");
        if (this.CurrentViewStatIndex >= 3000) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            gr = Value < Min ? new GraphicObject(LOW[i]) : (Value > Max ? new GraphicObject(HIGH[i]) : new GraphicObject(OK[i]));
            if (gr.DeviceName != null) {
                if (gr.Label_text != null && gr.Label_text.indexOf("%") >= 0) {
                    String str = gr.Label_text;
                    str = str.replaceFirst("%TEMP%", this.SensorTemps[InputNr].toString());
                    str = str.replaceFirst("%ADC%", String.valueOf(this.SensorABSValues[InputNr]));
                    str = str.replaceFirst("%PERCENT%", this.SensorPercents[InputNr].toString());
                    str = str.replaceFirst("%LIGHT%", this.SensorLights[InputNr].toString());
                    str = str.replaceFirst("%INVADC%", String.valueOf(1023 - this.SensorABSValues[InputNr]));
                    str = str.replaceFirst("%INVPERCENT%", String.valueOf(100.0 - this.SensorPercents[InputNr]));
                    str = str.replaceFirst("%VOLT%", this.SensorVolts[InputNr].toString());
                    gr.Label_text = str = this.ChangeDynamic(str);
                }
                this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(gr);
                ++this.CurrentViewStatIndex;
                if (this.CurrentViewStatIndex < 3000) continue;
                return;
            }
            return;
        }
    }

    public boolean WriteCheckIfChangedAndCpy(byte[] dta, boolean InitFromPrevious) {
        int i;
        EhouseTCP.FinishedEH1 = false;
        int sss = 0;
        boolean tempboolean = false;
        boolean unconditional = InitFromPrevious;
        int Max_ADC = 8;
        Calendar c = Calendar.getInstance();
        this.recent = c.getTime().toLocaleString();
        this.changed = InitFromPrevious;
        if (!InitFromPrevious) {
            for (i = 0; i < 256; ++i) {
                if (this.CurrentStatus[i] == dta[i]) continue;
                this.CurrentStatus[i] = dta[i];
                this.changed = true;
            }
        }
        if (this.changed) {
            int ii;
            int k;
            this.ClearActiveVisualization();
            if (this.IsRM || this.IsEM) {
                Max_ADC = 8;
                if (this.IsRM && !InitFromPrevious) {
                    this.CurrentStatus[255] = 0;
                }
                for (k = 0; k < 8; ++k) {
                    this.OutputStates[k] = this.GetInOutValue((int)(this.CurrentStatus[19] & 0xFF), k);
                    sss = k;
                    this.UpdateIOStatus(this.OutputStates[sss], this.OutputViewH[sss], this.OutputViewL[sss], 5);
                    this.OutputStates[k + 8] = this.GetInOutValue((int)(this.CurrentStatus[20] & 0xFF), k);
                    sss = k + 8;
                    this.UpdateIOStatus(this.OutputStates[sss], this.OutputViewH[sss], this.OutputViewL[sss], 5);
                    this.OutputStates[k + 16] = this.GetInOutValue((int)(this.CurrentStatus[21] & 0xFF), k);
                    sss = k + 16;
                    this.UpdateIOStatus(this.OutputStates[sss], this.OutputViewH[sss], this.OutputViewL[sss], 5);
                    this.OutputStates[k + 24] = this.GetInOutValue((int)(this.CurrentStatus[24] & 0xFF), k);
                    sss = k + 24;
                    this.UpdateIOStatus(this.OutputStates[sss], this.OutputViewH[sss], this.OutputViewL[sss], 5);
                    this.InputStates[k] = this.GetInOutValue((int)(this.CurrentStatus[22] & 0xFF), k);
                    sss = k;
                    this.UpdateIOStatus(this.InputStates[sss], this.InputViewH[sss], this.InputViewL[sss], 5);
                    this.InputStates[k + 8] = this.GetInOutValue((int)(this.CurrentStatus[23] & 0xFF), k);
                    sss = k + 8;
                    this.UpdateIOStatus(this.InputStates[sss], this.InputViewH[sss], this.InputViewL[sss], 5);
                    if (!this.IsEM) continue;
                    this.AlarmSensorsActive[k] = this.GetInOutValue((int)(this.CurrentStatus[30] & 0xFF), k);
                    sss = k;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 8] = this.GetInOutValue((int)(this.CurrentStatus[31] & 0xFF), k);
                    sss = k + 8;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 16] = this.GetInOutValue((int)(this.CurrentStatus[32] & 0xFF), k);
                    sss = k + 16;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 24] = this.GetInOutValue((int)(this.CurrentStatus[33] & 0xFF), k);
                    sss = k + 24;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 32] = this.GetInOutValue((int)(this.CurrentStatus[46] & 0xFF), k);
                    sss = k + 32;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 40] = this.GetInOutValue((int)(this.CurrentStatus[34] & 0xFF), k);
                    sss = k + 40;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 48] = this.GetInOutValue((int)(this.CurrentStatus[35] & 0xFF), k);
                    sss = k + 48;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 56] = this.GetInOutValue((int)(this.CurrentStatus[36] & 0xFF), k);
                    sss = k + 56;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 64] = this.GetInOutValue((int)(this.CurrentStatus[37] & 0xFF), k);
                    sss = k + 64;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 72] = this.GetInOutValue((int)(this.CurrentStatus[56] & 0xFF), k);
                    sss = k + 72;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 80] = this.GetInOutValue((int)(this.CurrentStatus[38] & 0xFF), k);
                    sss = k + 80;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 88] = this.GetInOutValue((int)(this.CurrentStatus[39] & 0xFF), k);
                    sss = k + 88;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 96] = this.GetInOutValue((int)(this.CurrentStatus[40] & 0xFF), k);
                    sss = k + 96;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 104] = this.GetInOutValue((int)(this.CurrentStatus[41] & 0xFF), k);
                    sss = k + 104;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsActive[k + 112] = this.GetInOutValue((int)(this.CurrentStatus[66] & 0xFF), k);
                    sss = k + 112;
                    this.UpdateIOStatus(this.AlarmSensorsActive[sss], this.ActiveViewSensorsH[sss], this.ActiveViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k] = this.GetInOutValue((int)(this.CurrentStatus[42] & 0xFF), k);
                    sss = k;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 8] = this.GetInOutValue((int)(this.CurrentStatus[43] & 0xFF), k);
                    sss = k + 8;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 16] = this.GetInOutValue((int)(this.CurrentStatus[44] & 0xFF), k);
                    sss = k + 16;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 24] = this.GetInOutValue((int)(this.CurrentStatus[45] & 0xFF), k);
                    sss = k + 24;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 32] = this.GetInOutValue((int)(this.CurrentStatus[46] & 0xFF), k);
                    sss = k + 32;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 40] = this.GetInOutValue((int)(this.CurrentStatus[52] & 0xFF), k);
                    sss = k + 40;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 48] = this.GetInOutValue((int)(this.CurrentStatus[53] & 0xFF), k);
                    sss = k + 48;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 56] = this.GetInOutValue((int)(this.CurrentStatus[54] & 0xFF), k);
                    sss = k + 56;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 64] = this.GetInOutValue((int)(this.CurrentStatus[55] & 0xFF), k);
                    sss = k + 64;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 72] = this.GetInOutValue((int)(this.CurrentStatus[56] & 0xFF), k);
                    sss = k + 72;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 80] = this.GetInOutValue((int)(this.CurrentStatus[52] & 0xFF), k);
                    sss = k + 80;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 88] = this.GetInOutValue((int)(this.CurrentStatus[53] & 0xFF), k);
                    sss = k + 88;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 96] = this.GetInOutValue((int)(this.CurrentStatus[54] & 0xFF), k);
                    sss = k + 96;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 104] = this.GetInOutValue((int)(this.CurrentStatus[55] & 0xFF), k);
                    sss = k + 104;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                    this.AlarmSensorsAlarm[k + 112] = this.GetInOutValue((int)(this.CurrentStatus[56] & 0xFF), k);
                    sss = k + 112;
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[sss], this.AlarmViewSensorsH[sss], this.AlarmViewSensorsL[sss], 5);
                }
                this.CurrentProgram = this.CurrentStatus[29] & 0xFF;
                this.CurrentZone = this.CurrentStatus[28] & 0xFF;
                this.CurrentProgramName = "";
                this.CurrentZoneName = "";
            }
            if (this.IsEM) {
                this.CurrentProgramName = "";
            }
            if (this.IsHM) {
                Max_ADC = 16;
                this.CurrentProgram = this.CurrentStatus[38] & 0xFF;
                this.CurrentProgramName = "";
                for (k = 0; k < 8; ++k) {
                    boolean mm = false;
                    sss = k;
                    this.UpdateIOStatus(this.OutputStates[sss], this.OutputViewH[sss], this.OutputViewL[sss], 5);
                    this.OutputStates[k] = this.GetInOutValue((int)(this.CurrentStatus[35] & 0xFF), k);
                    sss = k + 8;
                    this.UpdateIOStatus(this.OutputStates[sss], this.OutputViewH[sss], this.OutputViewL[sss], 5);
                    this.OutputStates[k + 8] = this.GetInOutValue((int)(this.CurrentStatus[36] & 0xFF), k);
                    sss = k + 16;
                    this.UpdateIOStatus(this.OutputStates[sss], this.OutputViewH[sss], this.OutputViewL[sss], 5);
                    this.OutputStates[k + 16] = this.GetInOutValue((int)(this.CurrentStatus[37] & 0xFF), k);
                }
            }
            for (i = 0; i < Max_ADC; ++i) {
                int temppp = this.CurrentStatus[i * 2 + 3 + 1] & 0xFF;
                if (temppp < 0) {
                    temppp += 256;
                }
                if (this.SensorABSValues[i] != (temppp += (this.CurrentStatus[3 + i * 2] & 0xFF) << 8)) {
                    this.AdcChanged = true;
                }
                this.SensorABSValues[i] = temppp;
                this.SensorTemps[i] = this.gettemplm(temppp, this.Calibration[i], 10.0, this.VCC);
                this.SensorPercents[i] = this.calculate_percent(temppp);
                this.SensorLights[i] = 100.0 - this.SensorPercents[i];
                this.SensorVolts[i] = this.calculate_voltage(temppp);
                this.UpdateADC(i, 5.0f, 0.0f, 10.0f, this.SensorViewL[i], this.SensorViewH[i], this.SensorViewOK[i], 5);
            }
            int m = 0;
            for (ii = 0; ii < 1; ++ii) {
                this.DimmerRGB[ii] = 0;
            }
            for (ii = 0; ii < 3; ++ii) {
                this.DimmerRGB[ii / 3] = this.CurrentStatus[25 + ii % 3] & 0xFF;
                if (ii % 3 != 2) {
                    this.DimmerRGB[ii / 3] = this.DimmerRGB[ii / 3] << 8;
                }
                this.Dimmer[ii] = this.CurrentStatus[25 + ii] & 0xFF;
            }
            while (this.OtherViews[m].event_name != null) {
                this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(this.OtherViews[m]);
                this.CurrentViewStat[this.CurrentViewStatIndex].Label_text = this.ChangeDynamic(this.CurrentViewStat[this.CurrentViewStatIndex].Label_text);
                ++this.CurrentViewStatIndex;
                if (this.CurrentViewStatIndex >= 3000) {
                    EhouseTCP.FinishedEH1 = true;
                    return true;
                }
                ++m;
            }
        }
        if (this.changed) {
            this.XmlChanged = true;
        }
        EhouseTCP.FinishedEH1 = true;
        return this.changed;
    }

    public boolean isAddress(int devadrh, int devadrl) {
        return devadrh == this.DevAdrH && devadrl == this.DevAdrL;
    }
}

