/*
 * Decompiled with CFR 0.152.
 */
package ehouse4java;

import ehouse4java.EhouseTCP;
import ehouse4java.GraphicObject;
import ehouse4java.ehousecommunication;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Calendar;

public class StatusEthernet {
    public String recent = "";
    public static String sep = System.getProperty("file.separator");
    public boolean InitializedMatrix = false;
    public long CheckSum = 0L;
    public long PrevCheckSum = 0L;
    public boolean XmlChanged = false;
    public double MCP9700x = 10000.0;
    public double MCP9701x = 19500.0;
    public double MCP9700_Offset = -500.0;
    public double MCP9701_Offset = -400.0;
    int STATUS_INDEX = -1;
    static final int GRAPHICS_OBJECTS_MAX = 5;
    static int OUTPUTS_COUNT_RM = 256;
    static int ADC_PROGRAMS_COUNT_RM = 12;
    static int INPUTS_COUNT_RM = 128;
    static int SENSORS_COUNT_RM = 16;
    static int ZONES_MAX = 21;
    static final int DIMMERS_COUNT_RM = 3;
    static final int DIMMERS_RGB_COUNT_RM = 1;
    static final int PROGRAMS_COUNT_RM = 24;
    public String[] ProgramNames = new String[24];
    public String[] ZoneNames = new String[ZONES_MAX];
    public String[] ADCProgramNames = new String[ADC_PROGRAMS_COUNT_RM];
    public String[] DimmerNames = new String[3];
    public String[] DimmerRGBNames = new String[1];
    static int SENSORS_COUNT_ALARM = 128;
    static int STATUS_SIZE = 256;
    static final int GRAPHIC_OBJECTS_OTHER = 1000;
    static final int GRAPHIC_OBJECTS_CURRENT = 3000;
    public int[] Dimmer = new int[3];
    public int[] DimmerRGB = new int[1];
    public String XML = "";
    public String DeviceName;
    public int StatusCurrentSize = 0;
    public String[] OutputNames = new String[OUTPUTS_COUNT_RM];
    public GraphicObject[] OtherViews = new GraphicObject[1000];
    public int OtherViewsIndex = 0;
    public int CurrentViewStatIndex = 0;
    public GraphicObject[] CurrentViewStat = new GraphicObject[3000];
    public GraphicObject[][] OutputViewL = new GraphicObject[OUTPUTS_COUNT_RM][5];
    public GraphicObject[][] OutputViewH = new GraphicObject[OUTPUTS_COUNT_RM][5];
    public String[] InputNames = new String[INPUTS_COUNT_RM];
    public GraphicObject[][] InputViewL = new GraphicObject[INPUTS_COUNT_RM][5];
    public GraphicObject[][] InputViewH = new GraphicObject[INPUTS_COUNT_RM][5];
    public String[] SensorNames = new String[SENSORS_COUNT_RM];
    public GraphicObject[][] SensorViewL = new GraphicObject[SENSORS_COUNT_RM][5];
    public GraphicObject[][] SensorViewOK = new GraphicObject[SENSORS_COUNT_RM][5];
    public GraphicObject[][] SensorViewH = new GraphicObject[SENSORS_COUNT_RM][5];
    public int[] SensorType = new int[SENSORS_COUNT_RM];
    public Double[] SensorTempsLM35 = new Double[SENSORS_COUNT_RM];
    public Double[] SensorTempsMCP9700 = new Double[SENSORS_COUNT_RM];
    public Double[] SensorTempsMCP9701 = new Double[SENSORS_COUNT_RM];
    public String[] SensorTypeName = new String[SENSORS_COUNT_RM];
    public int[] SensorABSValues = new int[SENSORS_COUNT_RM];
    public int[] Calibration = new int[SENSORS_COUNT_RM];
    public Double[] SensorTemps = new Double[SENSORS_COUNT_RM];
    public Double[] SensorPercents = new Double[SENSORS_COUNT_RM];
    public Double[] SensorLights = new Double[SENSORS_COUNT_RM];
    public Double[] SensorVolts = new Double[SENSORS_COUNT_RM];
    public Boolean[] OutputStates = new Boolean[OUTPUTS_COUNT_RM];
    public Boolean[] InputStates = new Boolean[INPUTS_COUNT_RM];
    public Boolean[] InputInverts = new Boolean[INPUTS_COUNT_RM];
    public Boolean[] AlarmSensorsActive = new Boolean[SENSORS_COUNT_ALARM];
    public GraphicObject[][] AlarmViewSensors = new GraphicObject[SENSORS_COUNT_ALARM][5];
    public GraphicObject[][] AlarmViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM][5];
    public GraphicObject[][] AlarmViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM][5];
    public Boolean[] AlarmSensorsWarning = new Boolean[SENSORS_COUNT_ALARM];
    public Boolean[] AlarmSensorsMonitoring = new Boolean[SENSORS_COUNT_ALARM];
    public Boolean[] AlarmSensorsAlarm = new Boolean[SENSORS_COUNT_ALARM];
    public String[] AlarmSensorsNames = new String[SENSORS_COUNT_ALARM];
    public GraphicObject[][] WarningViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM][5];
    public GraphicObject[][] WarningViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM][5];
    public GraphicObject[][] MonitoringViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM][5];
    public GraphicObject[][] MonitoringViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM][5];
    public GraphicObject[][] ActiveViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM][5];
    public GraphicObject[][] ActiveViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM][5];
    public int DevAdrH;
    public int DevAdrL;
    public String DevAdr;
    public boolean changed;
    public boolean AdcChanged;
    public int CurrentProgram = 0;
    public String CurrentProgramName = "";
    public int ADCCurrentProgram = 0;
    public String ADCCurrentProgramName = "";
    public int CurrentZone = 0;
    public String CurrentZoneName = "";
    public Byte[] CurrentStatus = new Byte[STATUS_SIZE];
    public boolean IsBatch;
    public boolean IsCommManager;
    public boolean IsLevelManager;
    public boolean IsERM;
    public boolean IsEEM;
    public boolean IsEHM;
    public boolean IsAlarm;
    public boolean IsEthernet;
    public int VCC;
    static final int STATUS_TCP_OFFSET = 2;
    static final int STATUS_COMMMANAGER_OFFSET = 70;
    static final int STATUS_ADC_ETH = 0;
    static final int STATUS_ADC_ETH_END = 32;
    static final int STATUS_OUT_I2C = 32;
    static final int STATUS_INPUTS_I2C = 52;
    static final int STATUS_ALARM_I2C = 64;
    static final int STATUS_WARNING_I2C = 76;
    static final int STATUS_MONITORING_I2C = 88;
    static final int STATUS_PROGRAM_NR = 100;
    static final int STATUS_ZONE_NR = 101;
    static final int STATUS_ADC_PROGRAM = 102;
    static final int STATUS_LIGHT_LEVEL = 104;
    static final int STATUS_PROFILE_RM = 179;
    static final int STATUS_LIGHT = 175;
    static final int STATUS_ZONE_NO = 178;
    static final int ADC_N_OFFSET = 4;
    static final int O_N_OFFSET = 20;
    static final int I_N_OFFSET = 55;
    public Thread MakeXml = new Thread(){

        @Override
        public void run() {
            this.setPriority(1);
            while (!ehousecommunication.Terminate) {
                int i;
                while (!StatusEthernet.this.XmlChanged) {
                    try {
                        1.sleep(200L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!ehousecommunication.Terminate) continue;
                    return;
                }
                StatusEthernet.this.XmlChanged = false;
                String eol = "\r\n";
                StatusEthernet.this.XML = "";
                String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?> \r\n <eHouse xmlns=\"http://www.isys.pl\" \r\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n            xsi:schemaLocation=\"http://www.openremote.org protocol.xsd\">";
                header = header + "<Device>" + eol;
                header = header + "<Name>" + StatusEthernet.this.DeviceName + "</Name>" + eol;
                header = header + "<Address>" + StatusEthernet.this.DevAdrH + "," + StatusEthernet.this.DevAdrL + "</Address>" + eol;
                header = header + "<IPAddress>192.168." + StatusEthernet.this.DevAdrH + "." + StatusEthernet.this.DevAdrL + "</IPAddress>" + eol;
                header = header + "<AddressCombined>" + StatusEthernet.this.DevAdr + "</AddressCombined>" + eol;
                header = header + "<StateModified>" + ehousecommunication.bo(StatusEthernet.this.changed) + "</StateModified>" + eol;
                header = header + "<ADCModified>" + ehousecommunication.bo(StatusEthernet.this.AdcChanged) + "</ADCModified>" + eol;
                header = header + "<CurrentProgram>" + ehousecommunication.i(StatusEthernet.this.CurrentProgram) + "</CurrentProgram>" + eol;
                header = header + "<CurrentProgramName> " + StatusEthernet.this.CurrentProgramName + " </CurrentProgramName>" + eol;
                header = header + "<ADCCurrentProgram>" + ehousecommunication.i(StatusEthernet.this.ADCCurrentProgram) + "</ADCCurrentProgram>" + eol;
                header = header + "<ADCCurrentProgramName> " + StatusEthernet.this.ADCCurrentProgramName + " </ADCCurrentProgramName>" + eol;
                header = header + "<CurrentStatus>" + ehousecommunication.hx(StatusEthernet.this.CurrentStatus, STATUS_SIZE) + "</CurrentStatus>" + eol;
                header = header + "<RecentStatus>" + StatusEthernet.this.recent + "</RecentStatus>" + eol;
                if (StatusEthernet.this.IsERM) {
                    header = header + "<Devicetype>EthernetRoomManager</Devicetype>" + eol;
                }
                if (StatusEthernet.this.IsCommManager) {
                    header = header + "<Devicetype>CommManager</Devicetype>" + eol;
                }
                if (StatusEthernet.this.IsEHM) {
                    header = header + "<Devicetype>EthernetRoomManager</Devicetype>" + eol;
                }
                if (StatusEthernet.this.IsLevelManager) {
                    header = header + "<Devicetype>LevelManager</Devicetype>" + eol;
                }
                if (StatusEthernet.this.IsEthernet) {
                    header = header + "<InterfaceType>Ethernet</InterfaceType>" + eol;
                }
                if (StatusEthernet.this.IsCommManager) {
                    header = header + "<CurrentZone>" + ehousecommunication.i(StatusEthernet.this.CurrentZone) + "</CurrentZone>" + eol;
                    header = header + "<CurrentZoneName>" + StatusEthernet.this.CurrentZoneName + "</CurrentZoneName>" + eol;
                }
                String bodyheader = eol + "<Outputs>" + eol;
                String body = "";
                int maxio = OUTPUTS_COUNT_RM;
                if (StatusEthernet.this.IsERM || StatusEthernet.this.IsEHM || StatusEthernet.this.IsEEM) {
                    maxio = 35;
                }
                for (i = 0; i < maxio; ++i) {
                    if (ehousecommunication.IgnoreAtChar && StatusEthernet.this.OutputNames[i].indexOf("@") >= 0) continue;
                    int[] tmp = new int[]{StatusEthernet.this.DevAdrH, StatusEthernet.this.DevAdrL, 33, 0, 1, 0, 0, 0, 0, 0};
                    tmp[3] = i;
                    String state = "0";
                    String value = "Off";
                    if (StatusEthernet.this.OutputStates[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    }
                    body = body + "    <Item>" + eol + "        <Name>" + StatusEthernet.this.OutputNames[i] + "</Name>" + eol + "        <No>" + String.valueOf(i + 1) + "</No>" + eol + "        <State>" + state + "</State>" + eol + "        <Value>" + value + "</Value>" + eol;
                    String Event2 = ehousecommunication.hix(tmp, 10);
                    body = body + "        <EventOn>" + Event2 + "</EventOn>" + eol;
                    tmp[4] = 0;
                    Event2 = ehousecommunication.hix(tmp, 10);
                    body = body + "        <EventOff>" + Event2 + "</EventOff>" + eol;
                    tmp[4] = 2;
                    Event2 = ehousecommunication.hix(tmp, 10);
                    body = body + "        <EventToggle>" + Event2 + "</EventToggle>" + eol + "    </Item>" + eol + eol;
                }
                String bodyfooter = eol + "</Outputs>" + eol;
                header = header + bodyheader + body + bodyfooter + eol;
                bodyheader = eol + "<ADCInputs>" + eol;
                body = eol;
                bodyfooter = eol + "</ADCInputs>" + eol;
                maxio = SENSORS_COUNT_RM;
                for (i = 0; i < maxio; ++i) {
                    if (ehousecommunication.IgnoreAtChar && StatusEthernet.this.SensorNames[i].indexOf("@") >= 0) continue;
                    body = body + "    <Item>" + eol + "        <Name>" + StatusEthernet.this.SensorNames[i] + "</Name>" + eol + "        <ADCValue>" + StatusEthernet.this.SensorABSValues[i] + "</ADCValue>" + eol + "        <ADCTempValue>" + StatusEthernet.this.SensorTemps[i] + "</ADCTempValue>" + eol + "        <ADCLM335TempValue>" + StatusEthernet.this.SensorTemps[i] + "</ADCLM335TempValue>" + eol + "        <ADCLM35TempValue>" + StatusEthernet.this.SensorTempsLM35[i] + "</ADCLM35TempValue>" + eol + "        <ADCMCP9700TempValue>" + StatusEthernet.this.SensorTempsMCP9700[i] + "</ADCMCP9700TempValue>" + eol + "        <ADCMCP9701TempValue>" + StatusEthernet.this.SensorTempsMCP9701[i] + "</ADCMCP9701TempValue>" + eol + "        <ADCPercentValue>" + StatusEthernet.this.SensorPercents[i] + "</ADCPercentValue>" + eol + "        <ADCInvertedPercentValue>" + StatusEthernet.this.SensorLights[i] + "</ADCInvertedPercentValue>" + eol + "        <ADCVoltageValue>" + StatusEthernet.this.SensorVolts[i] + "</ADCVoltageValue>" + eol + "        <ADCCalibrationValue>" + StatusEthernet.this.Calibration[i] + "</ADCCalibrationValue>" + eol + "        <No>" + String.valueOf(i + 1) + "</No>" + eol + "        <SensorType>" + StatusEthernet.this.SensorType[i] + "</SensorType>" + eol + "        <SensorTypeName>" + StatusEthernet.this.SensorTypeName[i] + "</SensorTypeName>" + eol;
                    body = body + "    </Item>" + eol + eol;
                }
                header = header + bodyheader + body + bodyfooter + eol;
                bodyheader = eol + "<Inputs>" + eol;
                body = eol;
                bodyfooter = eol;
                maxio = INPUTS_COUNT_RM;
                if (StatusEthernet.this.IsERM || StatusEthernet.this.IsEHM || StatusEthernet.this.IsEEM) {
                    maxio = 12;
                }
                for (i = 0; i < maxio; ++i) {
                    if (ehousecommunication.IgnoreAtChar && StatusEthernet.this.InputNames[i].indexOf("@") >= 0) continue;
                    String state = "0";
                    String value = "Off";
                    if (StatusEthernet.this.InputStates[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    } else {
                        state = "0";
                        value = "Off";
                    }
                    body = body + "    <Item>" + eol + "        <Name>" + StatusEthernet.this.InputNames[i] + "</Name>" + eol + "        <No>" + String.valueOf(i + 1) + "</No>" + eol + "        <State>" + state + "</State>" + eol + "        <Value>" + value + "</Value>" + eol;
                    if (StatusEthernet.this.IsCommManager || StatusEthernet.this.IsLevelManager) {
                        if (StatusEthernet.this.AlarmSensorsActive[i].booleanValue()) {
                            state = "1";
                            value = "On";
                        } else {
                            state = "0";
                            value = "Off";
                        }
                        body = body + "        <ActiveState>" + state + "</ActiveState>" + eol + "        <ActiveValue>" + value + "</ActiveValue>" + eol;
                        if (StatusEthernet.this.AlarmSensorsWarning[i].booleanValue()) {
                            state = "1";
                            value = "On";
                        } else {
                            state = "0";
                            value = "Off";
                        }
                        body = body + "        <WarningState>" + state + "</WarningState>" + eol + "        <WarningValue>" + value + "</WarningValue>" + eol;
                        if (StatusEthernet.this.AlarmSensorsMonitoring[i].booleanValue()) {
                            state = "1";
                            value = "On";
                        } else {
                            state = "0";
                            value = "Off";
                        }
                        body = body + "        <MonitoringState>" + state + "</MonitoringState>" + eol + "        <MonitoringValue>" + value + "</MonitoringValue>" + eol;
                        if (StatusEthernet.this.AlarmSensorsAlarm[i].booleanValue()) {
                            state = "1";
                            value = "On";
                        } else {
                            state = "0";
                            value = "Off";
                        }
                        body = body + "        <AlarmState>" + state + "</AlarmState>" + eol + "        <AlarmValue>" + value + "</AlarmValue>" + eol;
                    }
                    String inversion = "Normal";
                    if (StatusEthernet.this.InputInverts[i].booleanValue()) {
                        inversion = "Inverted";
                    }
                    body = body + "        <Type>" + inversion + "</Type>" + eol;
                    body = body + "    </Item>" + eol + eol;
                }
                bodyfooter = eol + "</Inputs>" + eol;
                header = header + bodyheader + body + bodyfooter + eol;
                String footer = "</Device>\r\n";
                footer = footer + "\r\n</eHouse> \r\n";
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(ehousecommunication.path + "logs/" + StatusEthernet.this.DeviceName + ".xml"));
                    out.write(header + footer);
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                StatusEthernet.this.XML = header + footer;
            }
        }
    };

    public void SetStatusIndex(int nr) {
        this.STATUS_INDEX = nr;
    }

    public double calculate_voltage(int dta) {
        double tmp = Math.round((double)(dta * this.VCC / 1023) * 100.0);
        return tmp /= 100000.0;
    }

    public double calculate_MCP9700(int dta) {
        double tmp = (double)(dta * this.VCC / 1023) + this.MCP9700_Offset;
        tmp = (double)Math.round(tmp / this.MCP9700x * 10.0 * 1000.0) / 10.0;
        return tmp;
    }

    public double calculate_MCP9701(int dta) {
        double tmp = (double)(dta * this.VCC / 1023) + this.MCP9701_Offset;
        tmp = (double)Math.round(tmp / this.MCP9701x * 10.0 * 1000.0) / 10.0;
        return tmp;
    }

    public String CHDYN(String str) {
        int i;
        if (str == null) {
            return "";
        }
        String Line = str;
        if (Line.indexOf("%OutputName") >= 0) {
            for (i = 0; i < OUTPUTS_COUNT_RM; ++i) {
                Line.replaceAll("%OutputName" + String.valueOf(i + 1) + "%", this.OutputNames[i]);
            }
        }
        if (Line.indexOf("%InputName") >= 0) {
            for (i = 0; i < INPUTS_COUNT_RM; ++i) {
                Line.replaceAll("%InputName" + String.valueOf(i + 1) + "%", this.InputNames[i]);
            }
        }
        if (Line.indexOf("%ADCSensorName") >= 0) {
            for (i = 0; i < SENSORS_COUNT_RM; ++i) {
                Line.replaceAll("%ADCSensorName" + String.valueOf(i + 1) + "%", this.SensorNames[i]);
            }
        }
        if (Line.indexOf("%AlarmSensorName") >= 0) {
            for (i = 0; i < SENSORS_COUNT_ALARM; ++i) {
                Line.replaceAll("%AlarmSensorName" + String.valueOf(i + 1) + "%", this.AlarmSensorsNames[i]);
            }
        }
        if (Line.indexOf("%DimmerName") >= 0) {
            for (i = 0; i < 3; ++i) {
                Line.replaceAll("%DimmerName" + String.valueOf(i + 1) + "%", this.DimmerNames[i]);
            }
        }
        if (Line.indexOf("%DimmerRGBName") >= 0) {
            for (i = 0; i < 1; ++i) {
                Line.replaceAll("%DimmerRGBName" + String.valueOf(i + 1) + "%", this.DimmerRGBNames[i]);
            }
        }
        if (Line.indexOf("%ProgramName") >= 0) {
            for (i = 0; i < 24; ++i) {
                Line.replaceAll("%ProgramName" + String.valueOf(i + 1) + "%", this.ProgramNames[i]);
            }
        }
        if (Line.indexOf("%Output") >= 0) {
            for (i = 0; i < OUTPUTS_COUNT_RM; ++i) {
                Line.replaceAll("%Output" + String.valueOf(i + 1) + "%", this.OutputNames[i]);
            }
        }
        if (Line.indexOf("%Input") >= 0) {
            for (i = 0; i < INPUTS_COUNT_RM; ++i) {
                Line.replaceAll("%Input" + String.valueOf(i + 1) + "%", this.InputNames[i]);
            }
        }
        if (Line.indexOf("%ADCSensor") >= 0) {
            for (i = 0; i < SENSORS_COUNT_RM; ++i) {
                Line.replaceAll("%ADCSensor" + String.valueOf(i + 1) + "%", this.SensorNames[i]);
            }
        }
        if (Line.indexOf("%AlarmSensor") >= 0) {
            for (i = 0; i < SENSORS_COUNT_ALARM; ++i) {
                Line.replaceAll("%AlarmSensor" + String.valueOf(i + 1) + "%", this.AlarmSensorsNames[i]);
            }
        }
        if (Line.indexOf("%Dimmer") >= 0) {
            for (i = 0; i < 3; ++i) {
                Line.replaceAll("%Dimmer" + String.valueOf(i + 1) + "%", this.DimmerNames[i]);
            }
        }
        if (Line.indexOf("%DimmerRGBNames") >= 0) {
            for (i = 0; i < 1; ++i) {
                Line.replaceAll("%DimmerRGBNames" + String.valueOf(i + 1) + "%", this.DimmerRGBNames[i]);
            }
        }
        if (Line.indexOf("%Program") >= 0) {
            for (i = 0; i < 24; ++i) {
                Line.replaceAll("%Program" + String.valueOf(i + 1) + "%", this.ProgramNames[i]);
            }
        }
        if (Line.indexOf("%ADCProgram") >= 0) {
            for (i = 0; i < 24; ++i) {
                Line.replaceAll("%ADCProgram" + String.valueOf(i + 1) + "%", this.ADCProgramNames[i]);
            }
        }
        return Line;
    }

    public String hix(int[] dta, int size) {
        String res = "";
        for (int i = 0; i < size; ++i) {
            res = res + ehousecommunication.ConvertAsciHex(dta[i]);
        }
        return res;
    }

    public String hx(Byte[] dta, int size) {
        String res = "";
        for (int i = 0; i < size; ++i) {
            res = res + ehousecommunication.ConvertAsciHex(dta[i].byteValue());
        }
        return res;
    }

    public String i(int data) {
        return String.valueOf(data);
    }

    public String bo(boolean data) {
        if (data) {
            return "1";
        }
        return "0";
    }

    public void ClearAllVisualisationItems() {
        int z;
        int m;
        int z2;
        if (this.DeviceName == null) {
            return;
        }
        if (this.DeviceName == "") {
            return;
        }
        for (z2 = 0; z2 < 1000; ++z2) {
            this.OtherViews[z2].event_name = null;
            this.OtherViews[z2].DeviceName = null;
        }
        for (z2 = 0; z2 < 3000; ++z2) {
            this.CurrentViewStat[z2].event_name = null;
            this.CurrentViewStat[z2].DeviceName = null;
        }
        this.CurrentViewStatIndex = 0;
        this.OtherViewsIndex = 0;
        for (m = 0; m < OUTPUTS_COUNT_RM; ++m) {
            for (z = 0; z < 5; ++z) {
                this.OutputViewH[m][z].event_name = null;
                this.OutputViewL[m][z].event_name = null;
                this.OutputViewH[m][z].DeviceName = null;
                this.OutputViewL[m][z].DeviceName = null;
            }
        }
        for (m = 0; m < INPUTS_COUNT_RM; ++m) {
            for (z = 0; z < 5; ++z) {
                this.InputViewH[m][z].event_name = null;
                this.InputViewL[m][z].event_name = null;
                this.InputViewH[m][z].DeviceName = null;
                this.InputViewL[m][z].DeviceName = null;
            }
        }
        for (m = 0; m < SENSORS_COUNT_RM; ++m) {
            for (z = 0; z < 5; ++z) {
                this.SensorViewL[m][z].event_name = null;
                this.SensorViewH[m][z].event_name = null;
                this.SensorViewOK[m][z].event_name = null;
                this.SensorViewL[m][z].DeviceName = null;
                this.SensorViewH[m][z].DeviceName = null;
                this.SensorViewOK[m][z].DeviceName = null;
            }
        }
        for (m = 0; m < SENSORS_COUNT_ALARM; ++m) {
            for (z = 0; z < 5; ++z) {
                this.ActiveViewSensorsL[m][z].event_name = null;
                this.ActiveViewSensorsH[m][z].event_name = null;
                this.AlarmViewSensorsH[m][z].event_name = null;
                this.AlarmViewSensorsL[m][z].event_name = null;
                this.WarningViewSensorsH[m][z].event_name = null;
                this.WarningViewSensorsL[m][z].event_name = null;
                this.MonitoringViewSensorsH[m][z].event_name = null;
                this.MonitoringViewSensorsL[m][z].event_name = null;
                this.ActiveViewSensorsL[m][z].DeviceName = null;
                this.ActiveViewSensorsH[m][z].DeviceName = null;
                this.AlarmViewSensorsH[m][z].DeviceName = null;
                this.AlarmViewSensorsL[m][z].DeviceName = null;
                this.WarningViewSensorsH[m][z].DeviceName = null;
                this.WarningViewSensorsL[m][z].DeviceName = null;
                this.MonitoringViewSensorsH[m][z].DeviceName = null;
                this.MonitoringViewSensorsL[m][z].DeviceName = null;
            }
        }
    }

    public void ClearActiveVisualization() {
        for (int z = 0; z < 3000; ++z) {
            this.CurrentViewStat[z].event_name = null;
            this.CurrentViewStat[z].DeviceName = null;
        }
        this.CurrentViewStatIndex = 0;
    }

    public void InitVisualisationItems() {
        int z;
        int z2;
        int m;
        if (this.InitializedMatrix) {
            return;
        }
        for (m = 0; m < 3; ++m) {
            this.DimmerNames[m] = "";
        }
        for (m = 0; m < 1; ++m) {
            this.DimmerRGBNames[m] = "";
        }
        for (m = 0; m < 24; ++m) {
            this.ProgramNames[m] = "";
        }
        for (z2 = 0; z2 < 1000; ++z2) {
            this.OtherViews[z2] = new GraphicObject("");
        }
        for (z2 = 0; z2 < 3000; ++z2) {
            this.CurrentViewStat[z2] = new GraphicObject("");
        }
        for (m = 0; m < OUTPUTS_COUNT_RM; ++m) {
            this.OutputNames[m] = "";
            this.OutputStates[m] = false;
            for (z = 0; z < 5; ++z) {
                this.OutputViewH[m][z] = new GraphicObject("");
                this.OutputViewL[m][z] = new GraphicObject("");
            }
        }
        for (m = 0; m < INPUTS_COUNT_RM; ++m) {
            this.InputNames[m] = "";
            this.InputStates[m] = false;
            for (z = 0; z < 5; ++z) {
                this.InputViewH[m][z] = new GraphicObject("");
                this.InputViewL[m][z] = new GraphicObject("");
            }
        }
        for (m = 0; m < SENSORS_COUNT_RM; ++m) {
            this.SensorNames[m] = "";
            for (z = 0; z < 5; ++z) {
                this.SensorViewL[m][z] = new GraphicObject("");
                this.SensorViewH[m][z] = new GraphicObject("");
                this.SensorViewOK[m][z] = new GraphicObject("");
            }
        }
        for (m = 0; m < SENSORS_COUNT_ALARM; ++m) {
            this.AlarmSensorsNames[m] = "";
            for (z = 0; z < 5; ++z) {
                this.AlarmSensorsActive[m] = false;
                this.AlarmSensorsWarning[m] = false;
                this.AlarmSensorsMonitoring[m] = false;
                this.AlarmSensorsAlarm[m] = false;
                this.AlarmSensorsWarning[m] = false;
                this.ActiveViewSensorsL[m][z] = new GraphicObject("");
                this.ActiveViewSensorsH[m][z] = new GraphicObject("");
                this.AlarmViewSensorsH[m][z] = new GraphicObject("");
                this.AlarmViewSensorsL[m][z] = new GraphicObject("");
                this.WarningViewSensorsH[m][z] = new GraphicObject("");
                this.WarningViewSensorsL[m][z] = new GraphicObject("");
                this.MonitoringViewSensorsH[m][z] = new GraphicObject("");
                this.MonitoringViewSensorsL[m][z] = new GraphicObject("");
            }
        }
        this.InitializedMatrix = true;
    }

    public void CreateVisualization() {
        int m;
        this.ClearActiveVisualization();
        for (int z = 0; z < this.OtherViewsIndex; ++z) {
            this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(this.OtherViews[z]);
            this.CurrentViewStat[this.CurrentViewStatIndex].Label_text = this.ChangeDynamic(this.CurrentViewStat[this.CurrentViewStatIndex].Label_text);
            ++this.CurrentViewStatIndex;
        }
        for (m = 0; m < OUTPUTS_COUNT_RM; ++m) {
            this.UpdateIOStatus(this.OutputStates[m], this.OutputViewH[m], this.OutputViewL[m], 5);
        }
        for (m = 0; m < INPUTS_COUNT_RM; ++m) {
            this.UpdateIOStatus(this.InputStates[m], this.InputViewH[m], this.InputViewL[m], 5);
        }
        for (m = 0; m < SENSORS_COUNT_RM; ++m) {
            this.UpdateIOStatus(true, this.SensorViewL[m], this.SensorViewH[m], 5);
        }
        for (m = 0; m < SENSORS_COUNT_ALARM; ++m) {
            this.UpdateIOStatus(this.AlarmSensorsActive[m], this.ActiveViewSensorsH[m], this.ActiveViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsWarning[m], this.WarningViewSensorsH[m], this.WarningViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsMonitoring[m], this.MonitoringViewSensorsH[m], this.MonitoringViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsAlarm[m], this.AlarmViewSensorsH[m], this.AlarmViewSensorsL[m], 5);
        }
        int Max_ADC = 12;
        if (this.IsEHM) {
            Max_ADC = 16;
        }
        for (int i = 0; i < Max_ADC; ++i) {
            this.UpdateADC(i, 5.0f, 0.0f, 10.0f, this.SensorViewL[i], this.SensorViewH[i], this.SensorViewOK[i], 5);
        }
    }

    public boolean ChkIsAdcChanged() {
        if (this.AdcChanged) {
            this.AdcChanged = false;
            return true;
        }
        return false;
    }

    public boolean IsDeviceName(String dname) {
        if (this.DeviceName == null) {
            return false;
        }
        if (this.DeviceName.length() == 0) {
            return false;
        }
        return dname.length() > 0 && dname.compareTo(this.DeviceName) == 0;
    }

    private double gettemplm(int dta, int calibration, double k, int VCC) {
        double temp = (double)(dta * VCC) / (1023.0 * k) + (double)(calibration / 100);
        temp = Math.round(temp * 10.0);
        return temp /= 10.0;
    }

    private double gettemplm35(int dta) {
        double temp = dta * this.VCC / 10230;
        temp = Math.round(temp * 10.0);
        return temp /= 10.0;
    }

    private int check_in(String stt, int defaut) {
        double dd = Double.valueOf(stt);
        int ino = (int)dd;
        return ino;
    }

    public void ReadAlarmSensorsNames(String pat) {
        int i = 0;
        boolean z = false;
        if (ehousecommunication.FileExists(pat)) {
            String[] AlarmS = ehousecommunication.getfile(pat);
            while (AlarmS[i] != null) {
                this.AlarmSensorsActive[i] = false;
                this.AlarmSensorsAlarm[i] = false;
                this.InputInverts[i] = false;
                this.AlarmSensorsWarning[i] = false;
                this.AlarmSensorsMonitoring[i] = false;
                this.AlarmSensorsNames[i] = AlarmS[i];
                if (++i != SENSORS_COUNT_ALARM) continue;
            }
            while (i < SENSORS_COUNT_ALARM) {
                this.AlarmSensorsActive[i] = false;
                this.AlarmSensorsAlarm[i] = false;
                this.AlarmSensorsWarning[i] = false;
                this.InputInverts[i] = false;
                this.AlarmSensorsMonitoring[i] = false;
                this.AlarmSensorsNames[i] = "";
                ++i;
            }
        }
    }

    public void LoadDta(String name) {
        if (ehousecommunication.FileExists(name)) {
            int i;
            this.InitVisualisationItems();
            String[] st = ehousecommunication.getfile(name);
            this.DeviceName = st[1];
            String adrh = st[0].substring(0, 3);
            String adrl = st[0].substring(3);
            this.DevAdrH = this.check_in(adrh, 0);
            this.DevAdrL = this.check_in(adrl, 0);
            this.DevAdr = String.valueOf(this.DevAdrL);
            this.DevAdr = st[0];
            String temp = st[2];
            if (temp != null) {
                if (temp.compareTo("CM") == 0) {
                    this.IsCommManager = true;
                    ehousecommunication.CommManagerName = this.DeviceName;
                }
                if (temp.compareTo("LM") == 0) {
                    this.IsLevelManager = true;
                }
                if (temp.compareTo("ERM") == 0) {
                    this.IsERM = true;
                }
                if (temp.compareTo("EHM") == 0) {
                    this.IsEHM = true;
                }
                if (temp.compareTo("EEM") == 0) {
                    this.IsEEM = true;
                }
            }
            st = ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "AdcNames.txt");
            String[] senstypes = ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "ADCSensorTypes.txt");
            String[] senstype = ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "AdcConfig.cfg");
            for (i = 0; i < SENSORS_COUNT_RM; ++i) {
                if (st[i] == null) {
                    st[i] = "@ADC" + String.valueOf(i + 1);
                }
                if (st[i].length() == 0) {
                    st[i] = "@ADC" + String.valueOf(i + 1);
                }
                this.SensorNames[i] = st[i];
                int senstyp = 0;
                try {
                    senstyp = Integer.parseInt(senstype[i]);
                }
                catch (Exception e) {
                    senstyp = 0;
                }
                this.SensorType[i] = senstyp;
                this.SensorTypeName[i] = senstypes[senstyp];
                if (this.SensorNames[i] == null) {
                    this.SensorNames[i] = "@" + String.valueOf(i + 1);
                }
                this.SensorABSValues[i] = 0;
                this.SensorTemps[i] = 0.0;
                this.SensorPercents[i] = 0.0;
                this.SensorLights[i] = 0.0;
                this.SensorVolts[i] = 0.0;
                this.Calibration[i] = -27315;
                this.SensorTemps[i] = 0.0;
                this.SensorTempsLM35[i] = 0.0;
                this.SensorTempsMCP9700[i] = 0.0;
                this.SensorTempsMCP9701[i] = 0.0;
            }
            this.VCC = 3300;
            st = this.IsCommManager || this.IsLevelManager ? ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "AdditionalOutputNames.txt") : ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "OutputNames.txt");
            for (i = 0; i < OUTPUTS_COUNT_RM; ++i) {
                if (st[i] == null) {
                    st[i] = "@Out" + String.valueOf(i + 1);
                }
                if (st[i].length() == 0) {
                    st[i] = "@Out" + String.valueOf(i + 1);
                }
                this.OutputNames[i] = st[i];
                this.OutputStates[i] = false;
            }
            st = ehousecommunication.FileExists(ehousecommunication.path + this.DevAdr + sep + "InputNames.txt") ? ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "InputNames.txt") : ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "SensorNames.txt");
            String[] inv = ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "SensorsInverts.cfg");
            for (i = 0; i < INPUTS_COUNT_RM; ++i) {
                if (st[i] == null) {
                    st[i] = "@In" + String.valueOf(i + 1);
                }
                if (st[i].length() == 0) {
                    st[i] = "@In" + String.valueOf(i + 1);
                }
                this.AlarmSensorsNames[i] = st[i];
                this.InputNames[i] = st[i];
                this.InputStates[i] = false;
                this.InputInverts[i] = false;
                if (inv[i] != null && inv[i].trim().equalsIgnoreCase("1")) {
                    this.InputInverts[i] = true;
                }
                this.AlarmSensorsActive[i] = false;
                this.AlarmSensorsWarning[i] = false;
                this.AlarmSensorsMonitoring[i] = false;
                this.AlarmSensorsAlarm[i] = false;
            }
            if (ehousecommunication.FileExists(ehousecommunication.path + this.DevAdr + sep + "Programs.txt")) {
                st = ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "Programs.txt");
                for (i = 0; i < 24; ++i) {
                    if (st[i] == null) {
                        st[i] = "@Program " + String.valueOf(i + 1);
                    }
                    if (st[i].length() == 0) {
                        st[i] = "@Program" + String.valueOf(i + 1);
                    }
                    this.ProgramNames[i] = st[i].trim();
                }
            } else if (ehousecommunication.FileExists(ehousecommunication.path + this.DevAdr + sep + "SecuPrograms.txt")) {
                st = ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "SecuPrograms.txt");
                for (i = 0; i < 24; ++i) {
                    if (st[i] == null) {
                        st[i] = "@Program " + String.valueOf(i + 1);
                    }
                    if (st[i].length() == 0) {
                        st[i] = "@Program" + String.valueOf(i + 1);
                    }
                    this.ProgramNames[i] = st[i].trim();
                }
            }
            if (ehousecommunication.FileExists(ehousecommunication.path + this.DevAdr + sep + "AdcPrograms.txt")) {
                st = ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "AdcPrograms.txt");
                for (i = 0; i < ADC_PROGRAMS_COUNT_RM; ++i) {
                    if (st[i] == null) {
                        st[i] = "@ADC Program " + String.valueOf(i + 1);
                    }
                    if (st[i].length() == 0) {
                        st[i] = "@ADC Program " + String.valueOf(i + 1);
                    }
                    this.ADCProgramNames[i] = st[i];
                }
            }
            if (this.IsCommManager && ehousecommunication.FileExists(ehousecommunication.path + this.DevAdr + sep + "ZonesNames.txt")) {
                st = ehousecommunication.getfile(ehousecommunication.path + this.DevAdr + sep + "ZonesNames.txt");
                for (i = 0; i < ZONES_MAX; ++i) {
                    if (st[i] == null) {
                        st[i] = "@Zone " + String.valueOf(i + 1);
                    }
                    this.ZoneNames[i] = st[i];
                }
            }
            this.changed = false;
            this.CurrentProgram = 0;
            this.CurrentProgramName = "";
            for (i = 0; i < STATUS_SIZE; ++i) {
                this.CurrentStatus[i] = 0;
            }
            if (ehousecommunication.EnableXMLStatus) {
                this.MakeXml.start();
            }
            this.IsBatch = false;
            this.IsAlarm = false;
            this.IsEthernet = true;
        }
    }

    public double calculate_percent(int dta) {
        long ltmp = Math.round((double)dta * 10000.0 / 1023.0);
        double tmp = ltmp / 100L;
        return tmp;
    }

    public double getlight(int dta) {
        double dtta = dta * 100;
        return (double)Math.round((dtta /= 1023.0) * 10.0) / 10.0;
    }

    public boolean GetInOutValue(int dta, int offset) {
        int temp = dta >> offset;
        return (temp & 1) > 0;
    }

    public boolean ginv(boolean val, boolean inv) {
        if (this.IsCommManager) {
            return val ^ inv;
        }
        return !val ^ inv;
    }

    public int[] GetOptsIndex(String EventName, int AlarmState) {
        int i;
        int[] m = new int[2];
        for (i = 0; i < OUTPUTS_COUNT_RM; ++i) {
            if (this.OutputNames[i].length() <= 0 || EventName.compareTo(this.OutputNames[i]) != 0) continue;
            m[1] = i;
            m[0] = 1;
            return m;
        }
        for (i = 0; i < INPUTS_COUNT_RM; ++i) {
            if (this.InputNames[i].length() <= 0 || EventName.compareTo(this.InputNames[i]) != 0) continue;
            m[1] = i;
            m[0] = 2;
            return m;
        }
        for (i = 0; i < SENSORS_COUNT_RM; ++i) {
            if (this.SensorNames[i].length() <= 0 || EventName.compareTo(this.SensorNames[i]) != 0) continue;
            m[1] = i;
            m[0] = 3;
            return m;
        }
        if (this.IsEEM) {
            for (i = 0; i < SENSORS_COUNT_ALARM; ++i) {
                if (this.AlarmSensorsNames[i].length() <= 0 || EventName.compareTo(this.AlarmSensorsNames[i]) != 0) continue;
                m[1] = i;
                m[0] = 4 + AlarmState;
                return m;
            }
        }
        m[1] = 255;
        m[0] = 255;
        return m;
    }

    void UpdateIOStatus(boolean State2, GraphicObject[] ON, GraphicObject[] OFF, int size) {
        GraphicObject gr = new GraphicObject("");
        if (this.CurrentViewStatIndex >= 3000) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            gr = State2 ? new GraphicObject(ON[i]) : new GraphicObject(OFF[i]);
            if (gr.event_name != null) {
                if (gr.event_name.length() > 0) {
                    this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(gr);
                    ++this.CurrentViewStatIndex;
                    if (this.CurrentViewStatIndex < 3000) continue;
                    return;
                }
                return;
            }
            return;
        }
    }

    String ChangeDynamic(String st) {
        String str = st;
        int kk = str.indexOf("%");
        int mm = -1;
        int indeee = 0;
        if (kk >= 0) {
            mm = str.indexOf("%", kk + 1);
        }
        if (kk < 0 || mm < 0) {
            return str;
        }
        if (str.indexOf("%HEATER_") >= 0) {
            str = str.replaceFirst("%HEATER_KOMSTAT%", EhouseTCP.HEATER_KOMSTAT);
            str = str.replaceFirst("%HEATER_RECUPERATOR_MODE%", EhouseTCP.HEATER_RECUPERATOR_MODE);
            str = str.replaceFirst("%HEATER_RECUPERATOR_SPEED%", EhouseTCP.HEATER_RECUPERATOR_SPEED);
            str = str.replaceFirst("%HEATER_RECUPERATOR_TEMP%", EhouseTCP.HEATER_RECUPERATOR_TEMP);
            str = str.replaceFirst("%HEATER_PROGRAM%", EhouseTCP.HEATER_PROGRAM);
        }
        if (str.indexOf("%EXTERNAL_") >= 0) {
            str = str.replaceFirst("%EXTERNAL_CURRENTZONE%", EhouseTCP.EXTERNAL_CURRENTZONE);
            str = str.replaceFirst("%EXTERNAL_CURRENTZONENAME%", EhouseTCP.EXTERNAL_CURRENTZONENAME);
            str = str.replaceFirst("%EXTERNAL_CURRENTPROGRAM%", EhouseTCP.External_currentprogram);
            str = str.replaceFirst("%EXTERNAL_CURRENTPROGRAMNAME%", EhouseTCP.External_currentprogramname);
        }
        str = str.replaceFirst("%CURRENTPROGRAM%", String.valueOf(this.CurrentProgram));
        str = str.replaceFirst("%CURRENTPROGRAMNAME%", this.CurrentProgramName);
        str = str.replaceFirst("%CURRENTADCPROGRAM%", String.valueOf(this.ADCCurrentProgram));
        str = str.replaceFirst("%CURRENTADCPROGRAMNAME%", this.ADCCurrentProgramName);
        str = str.replaceFirst("%CURRENTZONE%", String.valueOf(this.CurrentZone));
        str = str.replaceFirst("%CURRENTZONENAME%", this.CurrentZoneName);
        kk = str.indexOf("%");
        mm = -1;
        if (kk >= 0) {
            mm = str.indexOf("%", kk + 1);
        }
        while (kk >= 0 && mm >= 0) {
            str = str.replaceFirst("%TEMP" + indeee + "%", this.SensorTemps[indeee].toString());
            str = str.replaceFirst("%ADC" + indeee + "%", String.valueOf(this.SensorABSValues[indeee]));
            str = str.replaceFirst("%PERCENT" + indeee + "%", this.SensorPercents[indeee].toString());
            str = str.replaceFirst("%LIGHT" + indeee + "%", this.SensorLights[indeee].toString());
            str = str.replaceFirst("%INVADC" + indeee + "%", String.valueOf(1023 - this.SensorABSValues[indeee]));
            str = str.replaceFirst("%INVPERCENT" + indeee + "%", String.valueOf(100.0 - this.SensorPercents[indeee]));
            str = str.replaceFirst("%VOLT" + indeee + "%", String.valueOf(this.SensorVolts[indeee]));
            str = str.replaceFirst("%MCP9700_" + indeee + "%", this.SensorTempsMCP9700[indeee].toString());
            str = str.replaceFirst("%MCP9701_" + indeee + "%", this.SensorTempsMCP9701[indeee].toString());
            kk = str.indexOf("%");
            mm = -1;
            if (kk >= 0) {
                mm = str.indexOf("%", kk + 1);
            }
            if (++indeee < SENSORS_COUNT_RM) continue;
            break;
        }
        return str;
    }

    void UpdateADC(int InputNr, float Value, float Min, float Max, GraphicObject[] LOW, GraphicObject[] HIGH, GraphicObject[] OK, int size) {
        GraphicObject gr = new GraphicObject("");
        if (this.CurrentViewStatIndex >= 3000) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            gr = Value < Min ? new GraphicObject(LOW[i]) : (Value > Max ? new GraphicObject(HIGH[i]) : new GraphicObject(OK[i]));
            if (gr.DeviceName != null) {
                if (gr.Label_text != null && gr.Label_text.indexOf("%") >= 0) {
                    String str = gr.Label_text;
                    str = str.replaceFirst("%TEMP%", this.SensorTemps[InputNr].toString());
                    str = str.replaceFirst("%ADC%", String.valueOf(this.SensorABSValues[InputNr]));
                    str = str.replaceFirst("%PERCENT%", this.SensorPercents[InputNr].toString());
                    str = str.replaceFirst("%LIGHT%", this.SensorLights[InputNr].toString());
                    str = str.replaceFirst("%INVADC%", String.valueOf(1023 - this.SensorABSValues[InputNr]));
                    str = str.replaceFirst("%INVPERCENT%", String.valueOf(100.0 - this.SensorPercents[InputNr]));
                    str = str.replaceFirst("%VOLT%", this.SensorVolts[InputNr].toString());
                    str = str.replaceFirst("%TEMPLM35%", this.SensorTempsLM35[InputNr].toString());
                    str = str.replaceFirst("%TEMPMCP9700%", this.SensorTempsMCP9700[InputNr].toString());
                    str = str.replaceFirst("%TEMPMCP9701%", this.SensorTempsMCP9701[InputNr].toString());
                    gr.Label_text = str = this.ChangeDynamic(str);
                }
                this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(gr);
                ++this.CurrentViewStatIndex;
                if (this.CurrentViewStatIndex < 3000) continue;
                return;
            }
            return;
        }
    }

    public boolean WriteCheckIfChangedAndCpy(byte[] dta, boolean InitFromPrevious, boolean CommManager) {
        int i;
        int sss = 0;
        EhouseTCP.FinishedEthernet = false;
        boolean tempboolean = false;
        boolean unconditional = InitFromPrevious;
        int TotalOffset = 2;
        if (CommManager) {
            TotalOffset += 70;
        }
        int CurrentSize = dta[0] & 0xFF;
        int Max_ADC = 16;
        Calendar c = Calendar.getInstance();
        this.recent = c.getTime().toLocaleString();
        this.changed = InitFromPrevious;
        if (!InitFromPrevious) {
            if (this.PrevCheckSum != this.CheckSum) {
                this.changed = true;
                for (i = 0; i < CurrentSize; ++i) {
                    this.CurrentStatus[i] = dta[i];
                }
            } else if (this.CheckSum == 0L) {
                for (i = 0; i < CurrentSize; ++i) {
                    if (this.CurrentStatus[i] == dta[i]) continue;
                    this.CurrentStatus[i] = dta[i];
                    this.changed = true;
                }
            }
        }
        this.PrevCheckSum = this.CheckSum;
        if (this.changed) {
            int off;
            int k;
            this.ClearActiveVisualization();
            for (k = 0; k < 8; ++k) {
                off = 0;
                for (sss = 0; sss < 160; sss += 8) {
                    this.OutputStates[k + sss] = this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + 32 + off] & 0xFF), k);
                    this.UpdateIOStatus(this.OutputStates[k + sss], this.OutputViewH[k + sss], this.OutputViewL[k + sss], 5);
                    ++off;
                }
            }
            for (k = 0; k < 8; ++k) {
                off = 0;
                for (sss = 0; sss < 96; sss += 8) {
                    this.InputStates[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + 52 + off] & 0xFF), k), this.InputInverts[k + sss]);
                    this.UpdateIOStatus(this.InputStates[k + sss], this.InputViewH[k + sss], this.InputViewL[k + sss], 5);
                    ++off;
                }
            }
            if (this.IsCommManager) {
                for (k = 0; k < 8; ++k) {
                    off = 0;
                    for (sss = 0; sss < 96; sss += 8) {
                        this.AlarmSensorsActive[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + 52 + off] & 0xFF), k), this.InputInverts[k + sss]);
                        this.UpdateIOStatus(this.AlarmSensorsActive[k + sss], this.ActiveViewSensorsH[k + sss], this.ActiveViewSensorsL[k + sss], 5);
                        this.AlarmSensorsAlarm[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + 64 + off] & 0xFF), k), this.InputInverts[k + sss]);
                        this.UpdateIOStatus(this.AlarmSensorsAlarm[k + sss], this.AlarmViewSensorsH[k + sss], this.AlarmViewSensorsL[k + sss], 5);
                        this.AlarmSensorsWarning[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + 76 + off] & 0xFF), k), this.InputInverts[k + sss]);
                        this.UpdateIOStatus(this.AlarmSensorsWarning[k + sss], this.WarningViewSensorsH[k + sss], this.WarningViewSensorsL[k + sss], 5);
                        this.AlarmSensorsMonitoring[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + 88 + off] & 0xFF), k), this.InputInverts[k + sss]);
                        this.UpdateIOStatus(this.AlarmSensorsMonitoring[k + sss], this.MonitoringViewSensorsH[k + sss], this.MonitoringViewSensorsL[k + sss], 5);
                        ++off;
                    }
                }
            }
            if (this.IsCommManager) {
                this.CurrentProgram = this.CurrentStatus[TotalOffset + 100] & 0xFF;
                this.CurrentZone = this.CurrentStatus[TotalOffset + 101] & 0xFF;
            } else {
                this.CurrentProgram = this.CurrentStatus[TotalOffset + 100] & 0xFF;
                this.CurrentZone = this.CurrentStatus[TotalOffset + 101] & 0xFF;
                this.CurrentProgram = this.CurrentStatus[179] + 1;
                this.Dimmer[0] = this.CurrentStatus[175].byteValue();
                this.Dimmer[1] = this.CurrentStatus[176].byteValue();
                this.Dimmer[2] = this.CurrentStatus[177].byteValue();
                this.CurrentZone = this.CurrentStatus[178].byteValue();
                this.ADCCurrentProgram = this.CurrentStatus[TotalOffset + 102] + 1;
            }
            this.CurrentProgramName = "";
            this.CurrentZoneName = this.CurrentZone < ZONES_MAX ? this.ZoneNames[this.CurrentZone] : "-";
            if (this.CurrentZoneName == null) {
                this.CurrentZoneName = "";
            }
            this.ADCCurrentProgramName = "";
        }
        for (i = 0; i < Max_ADC; ++i) {
            int temppp = this.CurrentStatus[TotalOffset + i * 2 + 1] & 0xFF;
            if (this.SensorABSValues[i] != (temppp += (this.CurrentStatus[TotalOffset + i * 2] & 0xFF) << 8)) {
                this.changed = true;
                this.AdcChanged = true;
            }
            this.SensorABSValues[i] = temppp;
            this.SensorTemps[i] = this.gettemplm(temppp, this.Calibration[i], 10.0, this.VCC);
            this.SensorPercents[i] = this.calculate_percent(temppp);
            this.SensorLights[i] = 100.0 - this.SensorPercents[i];
            this.SensorTempsLM35[i] = this.gettemplm35(temppp);
            this.SensorTempsMCP9700[i] = this.calculate_MCP9700(temppp);
            this.SensorTempsMCP9701[i] = this.calculate_MCP9701(temppp);
            this.SensorVolts[i] = this.calculate_voltage(temppp);
            this.UpdateADC(i, 5.0f, 0.0f, 10.0f, this.SensorViewL[i], this.SensorViewH[i], this.SensorViewOK[i], 5);
        }
        int m = 0;
        while (this.OtherViews[m].event_name != null) {
            this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(this.OtherViews[m]);
            this.CurrentViewStat[this.CurrentViewStatIndex].Label_text = this.ChangeDynamic(this.CurrentViewStat[this.CurrentViewStatIndex].Label_text);
            ++this.CurrentViewStatIndex;
            if (this.CurrentViewStatIndex >= 3000) {
                EhouseTCP.FinishedEthernet = true;
                return false;
            }
            ++m;
        }
        if (this.changed) {
            this.XmlChanged = true;
        }
        EhouseTCP.FinishedEthernet = true;
        return this.changed;
    }

    public boolean isAddress(int devadrh, int devadrl) {
        int devadrhh = devadrh;
        int devadrll = devadrl;
        if (devadrhh < 0) {
            devadrhh = 256 + devadrhh;
        }
        if (devadrll < 0) {
            devadrll = 256 + devadrll;
        }
        return devadrhh == this.DevAdrH && devadrll == this.DevAdrL;
    }
}

