/*
 * Decompiled with CFR 0.152.
 */
package ehouse4java;

import ehouse4java.EhouseTCP;
import ehouse4java.GraphicObject;
import ehouse4java.ehousecommunication;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Calendar;

public class StatusPro {
    public static int INT_SIZE = 2;
    public String recent = "";
    public static String sep = System.getProperty("file.separator");
    public boolean InitializedMatrix = false;
    public long CheckSum = 0L;
    public long PrevCheckSum = 0L;
    public boolean XmlChanged = false;
    public double MCP9700x = 10000.0;
    public double MCP9701x = 19500.0;
    public double MCP9700_Offset = -500.0;
    public double MCP9701_Offset = -400.0;
    int STATUS_INDEX = -1;
    static final int GRAPHICS_OBJECTS_MAX = 5;
    static int OUTPUTS_COUNT_PRO = 256;
    static int ADC_PROGRAMS_COUNT_PRO = 256;
    static int INPUTS_COUNT_PRO = 256;
    static int SENSORS_COUNT_PRO = 256;
    static int ZONES_COUNT_PRO = 256;
    static final int DIMMERS_COUNT_PRO = 256;
    static final int DIMMERS_RGB_COUNT_PRO = 85;
    static final int PROGRAMS_COUNT_PRO = 256;
    static final int SECU_PROGRAMS_COUNT_PRO = 256;
    public String[] ProgramNames = new String[256];
    public String[] SecuProgramNames = new String[256];
    public String[] ZoneNames = new String[ZONES_COUNT_PRO];
    public String[] ADCProgramNames = new String[ADC_PROGRAMS_COUNT_PRO];
    public String[] DimmerNames = new String[256];
    public String[] DimmerRGBNames = new String[85];
    public String[] RollerNames = new String[OUTPUTS_COUNT_PRO / 2];
    static int SENSORS_COUNT_ALARM_PRO = 256;
    static int STATUS_SIZE = 5000;
    static final int GRAPHIC_OBJECTS_OTHER = 1000;
    static final int GRAPHIC_OBJECTS_CURRENT = 10000;
    public int[] Dimmer = new int[256];
    public int[] DimmerRGB = new int[85];
    public String XML = "";
    public String DeviceName;
    public int StatusCurrentSize = 0;
    public String[] OutputNames = new String[OUTPUTS_COUNT_PRO];
    public GraphicObject[] OtherViews = new GraphicObject[1000];
    public int OtherViewsIndex = 0;
    public int CurrentViewStatIndex = 0;
    public GraphicObject[] CurrentViewStat = new GraphicObject[10000];
    public GraphicObject[][] OutputViewL = new GraphicObject[OUTPUTS_COUNT_PRO][5];
    public GraphicObject[][] OutputViewH = new GraphicObject[OUTPUTS_COUNT_PRO][5];
    public String[] InputNames = new String[INPUTS_COUNT_PRO];
    public GraphicObject[][] InputViewL = new GraphicObject[INPUTS_COUNT_PRO][5];
    public GraphicObject[][] InputViewH = new GraphicObject[INPUTS_COUNT_PRO][5];
    public String[] SensorNames = new String[SENSORS_COUNT_PRO];
    public GraphicObject[][] SensorViewL = new GraphicObject[SENSORS_COUNT_PRO][5];
    public GraphicObject[][] SensorViewOK = new GraphicObject[SENSORS_COUNT_PRO][5];
    public GraphicObject[][] SensorViewH = new GraphicObject[SENSORS_COUNT_PRO][5];
    public int[] SensorType = new int[SENSORS_COUNT_PRO];
    public Double[] SensorTempsLM35 = new Double[SENSORS_COUNT_PRO];
    public Double[] SensorTempsMCP9700 = new Double[SENSORS_COUNT_PRO];
    public Double[] SensorTempsMCP9701 = new Double[SENSORS_COUNT_PRO];
    public String[] SensorTypeName = new String[SENSORS_COUNT_PRO];
    public int[] SensorABSValues = new int[SENSORS_COUNT_PRO];
    public int[] Calibration = new int[SENSORS_COUNT_PRO];
    public Double[] SensorTemps = new Double[SENSORS_COUNT_PRO];
    public Double[] SensorPercents = new Double[SENSORS_COUNT_PRO];
    public Double[] SensorLights = new Double[SENSORS_COUNT_PRO];
    public Double[] SensorVolts = new Double[SENSORS_COUNT_PRO];
    public Boolean[] OutputStates = new Boolean[OUTPUTS_COUNT_PRO];
    public Boolean[] InputStates = new Boolean[INPUTS_COUNT_PRO];
    public Boolean[] InputInverts = new Boolean[INPUTS_COUNT_PRO];
    public Boolean[] AlarmSensorsActive = new Boolean[SENSORS_COUNT_ALARM_PRO];
    public Boolean[] AlarmSensorsSMS = new Boolean[SENSORS_COUNT_ALARM_PRO];
    public Boolean[] AlarmSensorsSilent = new Boolean[SENSORS_COUNT_ALARM_PRO];
    public Boolean[] AlarmSensorsEarlyWarning = new Boolean[SENSORS_COUNT_ALARM_PRO];
    public Boolean[] AlarmSensorsHorn = new Boolean[SENSORS_COUNT_ALARM_PRO];
    public GraphicObject[][] HornViewSensors = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] HornViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] HornViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] EarlyViewSensors = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] EarlyViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] EarlyViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] SMSViewSensors = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] SMSViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] SMSViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] SilentViewSensors = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] SilentViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] SilentViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] AlarmViewSensors = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] AlarmViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] AlarmViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public Boolean[] AlarmSensorsWarning = new Boolean[SENSORS_COUNT_ALARM_PRO];
    public Boolean[] AlarmSensorsMonitoring = new Boolean[SENSORS_COUNT_ALARM_PRO];
    public Boolean[] AlarmSensorsAlarm = new Boolean[SENSORS_COUNT_ALARM_PRO];
    public String[] AlarmSensorsNames = new String[SENSORS_COUNT_ALARM_PRO];
    public GraphicObject[][] WarningViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] WarningViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] MonitoringViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] MonitoringViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] ActiveViewSensorsL = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public GraphicObject[][] ActiveViewSensorsH = new GraphicObject[SENSORS_COUNT_ALARM_PRO][5];
    public int DevAdrH;
    public int DevAdrL;
    public String DevAdr;
    public boolean changed;
    public boolean AdcChanged;
    public int CurrentProgram = 0;
    public String CurrentProgramName = "";
    public int CurrentSecuProgram = 0;
    public String CurrentSecuProgramName = "";
    public int ADCCurrentProgram = 0;
    public String ADCCurrentProgramName = "";
    public int CurrentZone = 0;
    public String CurrentZoneName = "";
    public Byte[] CurrentStatus = new Byte[STATUS_SIZE];
    public boolean IsBatch;
    public boolean IsAlarm;
    public boolean IsEthernet;
    public int VCC;
    static final int STATUS_PRO_OFFSET = 6;
    static final int STATUS_ADC_PRO = 0;
    static final int STATUS_ADC_PRO_END = 256;
    static final int STATUS_OUT_PRO = 256;
    static final int STATUS_INPUTS_PRO = 256 + OUTPUTS_COUNT_PRO / 8;
    static final int STATUS_HORN_PRO = STATUS_INPUTS_PRO + INPUTS_COUNT_PRO / 8;
    static final int STATUS_WARNING_PRO = STATUS_HORN_PRO + INPUTS_COUNT_PRO / 8;
    static final int STATUS_MONITORING_PRO = STATUS_WARNING_PRO + INPUTS_COUNT_PRO / 8;
    static final int STATUS_SILENT_PRO = STATUS_MONITORING_PRO + INPUTS_COUNT_PRO / 8;
    static final int STATUS_EARLY_PRO = STATUS_SILENT_PRO + INPUTS_COUNT_PRO / 8;
    static final int STATUS_SMS_PRO = STATUS_EARLY_PRO + INPUTS_COUNT_PRO / 8;
    static final int STATUS_ALARM_PRO = STATUS_SMS_PRO + INPUTS_COUNT_PRO / 8;
    static final int STATUS_DIMMERS_PRO = STATUS_ALARM_PRO + INPUTS_COUNT_PRO / 8;
    static final int STATUS_PROGRAM_NR = STATUS_DIMMERS_PRO + 256;
    static final int STATUS_ADC_PROGRAM = STATUS_PROGRAM_NR + 1 * INT_SIZE;
    static final int STATUS_SECU_PROGRAM_NR = STATUS_PROGRAM_NR + 2 * INT_SIZE;
    static final int STATUS_ZONE_NR = STATUS_PROGRAM_NR + 3 * INT_SIZE;
    static final int STATUS_HW_STATES = STATUS_PROGRAM_NR + 4 * INT_SIZE;
    static final int STATUS_FUTURE = STATUS_PROGRAM_NR + 5 * INT_SIZE;
    static final int STATUS_ADDITIONAL = STATUS_FUTURE + 180;
    static final int STATUS_PROFILE_RM = 179;
    static final int STATUS_LIGHT = 175;
    static final int STATUS_ZONE_NO = 178;
    static final int ADC_N_OFFSET = 4;
    static final int O_N_OFFSET = 20;
    static final int I_N_OFFSET = 55;
    public Thread MakeXml = new Thread(){

        @Override
        public void run() {
            this.setPriority(1);
            while (!ehousecommunication.Terminate) {
                int i;
                while (!StatusPro.this.XmlChanged) {
                    try {
                        1.sleep(200L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!ehousecommunication.Terminate) continue;
                    return;
                }
                StatusPro.this.XmlChanged = false;
                String eol = "\r\n";
                StatusPro.this.XML = "";
                String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?> \r\n <eHouse xmlns=\"http://www.isys.pl\" \r\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n            xsi:schemaLocation=\"http://www.openremote.org protocol.xsd\">";
                header = header + "<Device>" + eol;
                header = header + "<Name>" + StatusPro.this.DeviceName + "</Name>" + eol;
                header = header + "<Address>" + StatusPro.this.DevAdrH + "," + StatusPro.this.DevAdrL + "</Address>" + eol;
                header = header + "<IPAddress>192.168." + StatusPro.this.DevAdrH + "." + StatusPro.this.DevAdrL + "</IPAddress>" + eol;
                header = header + "<AddressCombined>" + StatusPro.this.DevAdr + "</AddressCombined>" + eol;
                header = header + "<StateModified>" + ehousecommunication.bo(StatusPro.this.changed) + "</StateModified>" + eol;
                header = header + "<ADCModified>" + ehousecommunication.bo(StatusPro.this.AdcChanged) + "</ADCModified>" + eol;
                header = header + "<CurrentProgram>" + ehousecommunication.i(StatusPro.this.CurrentProgram + 1) + "</CurrentProgram>" + eol;
                header = header + "<CurrentProgramName> " + StatusPro.this.CurrentProgramName + " </CurrentProgramName>" + eol;
                header = header + "<CurrentSecuProgram>" + ehousecommunication.i(StatusPro.this.CurrentSecuProgram + 1) + "</CurrentSecuProgram>" + eol;
                header = header + "<CurrentSecuProgramName> " + StatusPro.this.CurrentSecuProgramName + " </CurrentSecuProgramName>" + eol;
                header = header + "<ADCCurrentProgram>" + ehousecommunication.i(StatusPro.this.ADCCurrentProgram + 1) + "</ADCCurrentProgram>" + eol;
                header = header + "<ADCCurrentProgramName> " + StatusPro.this.ADCCurrentProgramName + " </ADCCurrentProgramName>" + eol;
                header = header + "<CurrentStatus>" + ehousecommunication.hx(StatusPro.this.CurrentStatus, STATUS_SIZE) + "</CurrentStatus>" + eol;
                header = header + "<RecentStatus>" + StatusPro.this.recent + "</RecentStatus>" + eol;
                header = header + "<Devicetype>eHousePRO</Devicetype>" + eol;
                if (StatusPro.this.IsEthernet) {
                    header = header + "<InterfaceType>Ethernet</InterfaceType>" + eol;
                }
                header = header + "<CurrentZone>" + ehousecommunication.i(StatusPro.this.CurrentZone + 1) + "</CurrentZone>" + eol;
                header = header + "<CurrentZoneName>" + StatusPro.this.CurrentZoneName + "</CurrentZoneName>" + eol;
                String bodyheader = eol + "<Outputs>" + eol;
                String body = "";
                int maxio = OUTPUTS_COUNT_PRO;
                for (i = 0; i < maxio; ++i) {
                    if (ehousecommunication.IgnoreAtChar && StatusPro.this.OutputNames[i].indexOf("@") >= 0) continue;
                    int[] tmp = new int[]{StatusPro.this.DevAdrH, StatusPro.this.DevAdrL, 33, 0, 1, 0, 0, 0, 0, 0};
                    tmp[3] = i;
                    String state = "0";
                    String value = "Off";
                    if (StatusPro.this.OutputStates[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    }
                    body = body + "    <Item>" + eol + "        <Name>" + StatusPro.this.OutputNames[i] + "</Name>" + eol + "        <No>" + String.valueOf(i + 1) + "</No>" + eol + "        <State>" + state + "</State>" + eol + "        <Value>" + value + "</Value>" + eol;
                    String Event2 = ehousecommunication.hix(tmp, 10);
                    body = body + "        <EventOn>" + Event2 + "</EventOn>" + eol;
                    tmp[4] = 0;
                    Event2 = ehousecommunication.hix(tmp, 10);
                    body = body + "        <EventOff>" + Event2 + "</EventOff>" + eol;
                    tmp[4] = 2;
                    Event2 = ehousecommunication.hix(tmp, 10);
                    body = body + "        <EventToggle>" + Event2 + "</EventToggle>" + eol + "    </Item>" + eol + eol;
                }
                String bodyfooter = eol + "</Outputs>" + eol;
                header = header + bodyheader + body + bodyfooter + eol;
                bodyheader = eol + "<ADCInputs>" + eol;
                body = eol;
                bodyfooter = eol + "</ADCInputs>" + eol;
                maxio = 0;
                for (i = 0; i < maxio; ++i) {
                    if (ehousecommunication.IgnoreAtChar && StatusPro.this.SensorNames[i].indexOf("@") >= 0) continue;
                    body = body + "    <Item>" + eol + "        <Name>" + StatusPro.this.SensorNames[i] + "</Name>" + eol + "        <ADCValue>" + StatusPro.this.SensorABSValues[i] + "</ADCValue>" + eol + "        <ADCTempValue>" + StatusPro.this.SensorTemps[i] + "</ADCTempValue>" + eol + "        <ADCLM335TempValue>" + StatusPro.this.SensorTemps[i] + "</ADCLM335TempValue>" + eol + "        <ADCLM35TempValue>" + StatusPro.this.SensorTempsLM35[i] + "</ADCLM35TempValue>" + eol + "        <ADCMCP9700TempValue>" + StatusPro.this.SensorTempsMCP9700[i] + "</ADCMCP9700TempValue>" + eol + "        <ADCMCP9701TempValue>" + StatusPro.this.SensorTempsMCP9701[i] + "</ADCMCP9701TempValue>" + eol + "        <ADCPercentValue>" + StatusPro.this.SensorPercents[i] + "</ADCPercentValue>" + eol + "        <ADCInvertedPercentValue>" + StatusPro.this.SensorLights[i] + "</ADCInvertedPercentValue>" + eol + "        <ADCVoltageValue>" + StatusPro.this.SensorVolts[i] + "</ADCVoltageValue>" + eol + "        <ADCCalibrationValue>" + StatusPro.this.Calibration[i] + "</ADCCalibrationValue>" + eol + "        <No>" + String.valueOf(i + 1) + "</No>" + eol + "        <SensorType>" + StatusPro.this.SensorType[i] + "</SensorType>" + eol + "        <SensorTypeName>" + StatusPro.this.SensorTypeName[i] + "</SensorTypeName>" + eol;
                    body = body + "    </Item>" + eol + eol;
                }
                header = header + bodyheader + body + bodyfooter + eol;
                bodyheader = eol + "<Inputs>" + eol;
                body = eol;
                bodyfooter = eol;
                maxio = INPUTS_COUNT_PRO;
                for (i = 0; i < maxio; ++i) {
                    if (ehousecommunication.IgnoreAtChar && StatusPro.this.InputNames[i].indexOf("@") >= 0) continue;
                    String state = "0";
                    String value = "Off";
                    if (StatusPro.this.InputStates[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    } else {
                        state = "0";
                        value = "Off";
                    }
                    body = body + "    <Item>" + eol + "        <Name>" + StatusPro.this.InputNames[i] + "</Name>" + eol + "        <No>" + String.valueOf(i + 1) + "</No>" + eol + "        <State>" + state + "</State>" + eol + "        <Value>" + value + "</Value>" + eol;
                    if (StatusPro.this.AlarmSensorsActive[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    } else {
                        state = "0";
                        value = "Off";
                    }
                    body = body + "        <ActiveState>" + state + "</ActiveState>" + eol + "        <ActiveValue>" + value + "</ActiveValue>" + eol;
                    if (StatusPro.this.AlarmSensorsWarning[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    } else {
                        state = "0";
                        value = "Off";
                    }
                    body = body + "        <WarningState>" + state + "</WarningState>" + eol + "        <WarningValue>" + value + "</WarningValue>" + eol;
                    if (StatusPro.this.AlarmSensorsMonitoring[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    } else {
                        state = "0";
                        value = "Off";
                    }
                    body = body + "        <MonitoringState>" + state + "</MonitoringState>" + eol + "        <MonitoringValue>" + value + "</MonitoringValue>" + eol;
                    if (StatusPro.this.AlarmSensorsAlarm[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    } else {
                        state = "0";
                        value = "Off";
                    }
                    body = body + "        <AlarmState>" + state + "</AlarmState>" + eol + "        <AlarmValue>" + value + "</AlarmValue>" + eol;
                    if (StatusPro.this.AlarmSensorsSMS[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    } else {
                        state = "0";
                        value = "Off";
                    }
                    body = body + "        <SMSState>" + state + "</SMSState>" + eol + "        <SMSValue>" + value + "</SMSValue>" + eol;
                    if (StatusPro.this.AlarmSensorsSilent[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    } else {
                        state = "0";
                        value = "Off";
                    }
                    body = body + "        <SilentState>" + state + "</SilentState>" + eol + "        <SilentValue>" + value + "</SilentValue>" + eol;
                    if (StatusPro.this.AlarmSensorsEarlyWarning[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    } else {
                        state = "0";
                        value = "Off";
                    }
                    body = body + "        <EarlyState>" + state + "</EarlyState>" + eol + "        <EarlyValue>" + value + "</EarlyValue>" + eol;
                    if (StatusPro.this.AlarmSensorsHorn[i].booleanValue()) {
                        state = "1";
                        value = "On";
                    } else {
                        state = "0";
                        value = "Off";
                    }
                    body = body + "        <HornState>" + state + "</HornState>" + eol + "        <HornValue>" + value + "</HornValue>" + eol;
                    String inversion = "Normal";
                    if (StatusPro.this.InputInverts[i].booleanValue()) {
                        inversion = "Inverted";
                    }
                    body = body + "        <Type>" + inversion + "</Type>" + eol;
                    body = body + "    </Item>" + eol + eol;
                }
                bodyfooter = eol + "</Inputs>" + eol;
                header = header + bodyheader + body + bodyfooter + eol;
                String footer = "</Device>\r\n";
                footer = footer + "\r\n</eHouse> \r\n";
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(ehousecommunication.path + "logs/" + StatusPro.this.DeviceName + ".xml"));
                    out.write(header + footer);
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                StatusPro.this.XML = header + footer;
            }
        }
    };

    public void SetStatusIndex(int nr) {
        this.STATUS_INDEX = nr;
    }

    public double calculate_voltage(int dta) {
        double tmp = Math.round((double)(dta * this.VCC / 1023) * 100.0);
        return tmp /= 100000.0;
    }

    public double calculate_MCP9700(int dta) {
        double tmp = (double)(dta * this.VCC / 1023) + this.MCP9700_Offset;
        tmp = (double)Math.round(tmp / this.MCP9700x * 10.0 * 1000.0) / 10.0;
        return tmp;
    }

    public double calculate_MCP9701(int dta) {
        double tmp = (double)(dta * this.VCC / 1023) + this.MCP9701_Offset;
        tmp = (double)Math.round(tmp / this.MCP9701x * 10.0 * 1000.0) / 10.0;
        return tmp;
    }

    public String CHDYN(String str) {
        int i;
        if (str == null) {
            return "";
        }
        String Line = str;
        if (Line.indexOf("%Output") >= 0) {
            for (i = 0; i < OUTPUTS_COUNT_PRO; ++i) {
                Line.replaceAll("%Output" + String.valueOf(i + 1) + "%", this.OutputNames[i]);
            }
        }
        if (Line.indexOf("%Input") >= 0) {
            for (i = 0; i < INPUTS_COUNT_PRO; ++i) {
                Line.replaceAll("%Input" + String.valueOf(i + 1) + "%", this.InputNames[i]);
            }
        }
        if (Line.indexOf("%ADCSensor") >= 0) {
            for (i = 0; i < SENSORS_COUNT_PRO; ++i) {
                Line.replaceAll("%ADCSensor" + String.valueOf(i + 1) + "%", this.SensorNames[i]);
            }
        }
        if (Line.indexOf("%AlarmSensor") >= 0) {
            for (i = 0; i < SENSORS_COUNT_ALARM_PRO; ++i) {
                Line.replaceAll("%AlarmSensor" + String.valueOf(i + 1) + "%", this.AlarmSensorsNames[i]);
            }
        }
        if (Line.indexOf("%Dimmer") >= 0) {
            for (i = 0; i < 256; ++i) {
                Line.replaceAll("%Dimmer" + String.valueOf(i + 1) + "%", this.DimmerNames[i]);
            }
        }
        if (Line.indexOf("%DimmerRGBNames") >= 0) {
            for (i = 0; i < 85; ++i) {
                Line.replaceAll("%DimmerRGBNames" + String.valueOf(i + 1) + "%", this.DimmerRGBNames[i]);
            }
        }
        if (Line.indexOf("%Program") >= 0) {
            for (i = 0; i < 256; ++i) {
                Line.replaceAll("%Program" + String.valueOf(i + 1) + "%", this.ProgramNames[i]);
            }
        }
        if (Line.indexOf("%ADCProgram") >= 0) {
            for (i = 0; i < 256; ++i) {
                Line.replaceAll("%ADCProgram" + String.valueOf(i + 1) + "%", this.ADCProgramNames[i]);
            }
        }
        return Line;
    }

    public String hix(int[] dta, int size) {
        String res = "";
        for (int i = 0; i < size; ++i) {
            res = res + ehousecommunication.ConvertAsciHex(dta[i]);
        }
        return res;
    }

    public String hx(Byte[] dta, int size) {
        String res = "";
        for (int i = 0; i < size; ++i) {
            res = res + ehousecommunication.ConvertAsciHex(dta[i].byteValue());
        }
        return res;
    }

    public String i(int data) {
        return String.valueOf(data);
    }

    public String bo(boolean data) {
        if (data) {
            return "1";
        }
        return "0";
    }

    public void ClearAllVisualisationItems() {
        int z;
        int m;
        int z2;
        if (this.DeviceName == null) {
            return;
        }
        if (this.DeviceName == "") {
            return;
        }
        for (z2 = 0; z2 < 1000; ++z2) {
            this.OtherViews[z2].event_name = null;
            this.OtherViews[z2].DeviceName = null;
        }
        for (z2 = 0; z2 < 10000; ++z2) {
            this.CurrentViewStat[z2].event_name = null;
            this.CurrentViewStat[z2].DeviceName = null;
        }
        this.CurrentViewStatIndex = 0;
        this.OtherViewsIndex = 0;
        for (m = 0; m < OUTPUTS_COUNT_PRO; ++m) {
            for (z = 0; z < 5; ++z) {
                this.OutputViewH[m][z].event_name = null;
                this.OutputViewL[m][z].event_name = null;
                this.OutputViewH[m][z].DeviceName = null;
                this.OutputViewL[m][z].DeviceName = null;
            }
        }
        for (m = 0; m < INPUTS_COUNT_PRO; ++m) {
            for (z = 0; z < 5; ++z) {
                this.InputViewH[m][z].event_name = null;
                this.InputViewL[m][z].event_name = null;
                this.InputViewH[m][z].DeviceName = null;
                this.InputViewL[m][z].DeviceName = null;
            }
        }
        for (m = 0; m < SENSORS_COUNT_PRO; ++m) {
            for (z = 0; z < 5; ++z) {
                this.SensorViewL[m][z].event_name = null;
                this.SensorViewH[m][z].event_name = null;
                this.SensorViewOK[m][z].event_name = null;
                this.SensorViewL[m][z].DeviceName = null;
                this.SensorViewH[m][z].DeviceName = null;
                this.SensorViewOK[m][z].DeviceName = null;
            }
        }
        for (m = 0; m < SENSORS_COUNT_ALARM_PRO; ++m) {
            for (z = 0; z < 5; ++z) {
                this.ActiveViewSensorsL[m][z].event_name = null;
                this.ActiveViewSensorsH[m][z].event_name = null;
                this.AlarmViewSensorsH[m][z].event_name = null;
                this.AlarmViewSensorsL[m][z].event_name = null;
                this.WarningViewSensorsH[m][z].event_name = null;
                this.WarningViewSensorsL[m][z].event_name = null;
                this.MonitoringViewSensorsH[m][z].event_name = null;
                this.MonitoringViewSensorsL[m][z].event_name = null;
                this.SMSViewSensorsL[m][z].event_name = null;
                this.SMSViewSensorsH[m][z].event_name = null;
                this.HornViewSensorsH[m][z].event_name = null;
                this.HornViewSensorsL[m][z].event_name = null;
                this.EarlyViewSensorsH[m][z].event_name = null;
                this.EarlyViewSensorsL[m][z].event_name = null;
                this.SilentViewSensorsH[m][z].event_name = null;
                this.SilentViewSensorsL[m][z].event_name = null;
                this.ActiveViewSensorsL[m][z].DeviceName = null;
                this.ActiveViewSensorsH[m][z].DeviceName = null;
                this.AlarmViewSensorsH[m][z].DeviceName = null;
                this.AlarmViewSensorsL[m][z].DeviceName = null;
                this.WarningViewSensorsH[m][z].DeviceName = null;
                this.WarningViewSensorsL[m][z].DeviceName = null;
                this.MonitoringViewSensorsH[m][z].DeviceName = null;
                this.MonitoringViewSensorsL[m][z].DeviceName = null;
                this.SMSViewSensorsL[m][z].DeviceName = null;
                this.SMSViewSensorsH[m][z].DeviceName = null;
                this.HornViewSensorsH[m][z].DeviceName = null;
                this.HornViewSensorsL[m][z].DeviceName = null;
                this.EarlyViewSensorsH[m][z].DeviceName = null;
                this.EarlyViewSensorsL[m][z].DeviceName = null;
                this.SilentViewSensorsH[m][z].DeviceName = null;
                this.SilentViewSensorsL[m][z].DeviceName = null;
            }
        }
    }

    public void ClearActiveVisualization() {
        for (int z = 0; z < 10000; ++z) {
            this.CurrentViewStat[z].event_name = null;
            this.CurrentViewStat[z].DeviceName = null;
        }
        this.CurrentViewStatIndex = 0;
    }

    public void InitVisualisationItems() {
        int z;
        int z2;
        int m;
        if (this.InitializedMatrix) {
            return;
        }
        for (m = 0; m < 256; ++m) {
            this.DimmerNames[m] = "";
        }
        for (m = 0; m < 85; ++m) {
            this.DimmerRGBNames[m] = "";
        }
        for (m = 0; m < 256; ++m) {
            this.ProgramNames[m] = "";
        }
        for (m = 0; m < 256; ++m) {
            this.SecuProgramNames[m] = "";
        }
        for (m = 0; m < ADC_PROGRAMS_COUNT_PRO; ++m) {
            this.ADCProgramNames[m] = "";
        }
        for (m = 0; m < ZONES_COUNT_PRO; ++m) {
            this.ZoneNames[m] = "";
        }
        for (z2 = 0; z2 < 1000; ++z2) {
            this.OtherViews[z2] = new GraphicObject("");
        }
        for (z2 = 0; z2 < 10000; ++z2) {
            this.CurrentViewStat[z2] = new GraphicObject("");
        }
        for (m = 0; m < OUTPUTS_COUNT_PRO; ++m) {
            this.OutputNames[m] = "";
            this.OutputStates[m] = false;
            for (z = 0; z < 5; ++z) {
                this.OutputViewH[m][z] = new GraphicObject("");
                this.OutputViewL[m][z] = new GraphicObject("");
            }
        }
        for (m = 0; m < INPUTS_COUNT_PRO; ++m) {
            this.InputNames[m] = "";
            this.InputStates[m] = false;
            for (z = 0; z < 5; ++z) {
                this.InputViewH[m][z] = new GraphicObject("");
                this.InputViewL[m][z] = new GraphicObject("");
            }
        }
        for (m = 0; m < SENSORS_COUNT_PRO; ++m) {
            this.SensorNames[m] = "";
            for (z = 0; z < 5; ++z) {
                this.SensorViewL[m][z] = new GraphicObject("");
                this.SensorViewH[m][z] = new GraphicObject("");
                this.SensorViewOK[m][z] = new GraphicObject("");
            }
        }
        for (m = 0; m < SENSORS_COUNT_ALARM_PRO; ++m) {
            this.AlarmSensorsNames[m] = "";
            for (z = 0; z < 5; ++z) {
                this.AlarmSensorsActive[m] = false;
                this.AlarmSensorsWarning[m] = false;
                this.AlarmSensorsMonitoring[m] = false;
                this.AlarmSensorsAlarm[m] = false;
                this.AlarmSensorsHorn[m] = false;
                this.AlarmSensorsSilent[m] = false;
                this.AlarmSensorsSMS[m] = false;
                this.AlarmSensorsEarlyWarning[m] = false;
                this.ActiveViewSensorsL[m][z] = new GraphicObject("");
                this.ActiveViewSensorsH[m][z] = new GraphicObject("");
                this.AlarmViewSensorsH[m][z] = new GraphicObject("");
                this.AlarmViewSensorsL[m][z] = new GraphicObject("");
                this.WarningViewSensorsH[m][z] = new GraphicObject("");
                this.WarningViewSensorsL[m][z] = new GraphicObject("");
                this.MonitoringViewSensorsH[m][z] = new GraphicObject("");
                this.MonitoringViewSensorsL[m][z] = new GraphicObject("");
                this.EarlyViewSensorsL[m][z] = new GraphicObject("");
                this.EarlyViewSensorsH[m][z] = new GraphicObject("");
                this.SilentViewSensorsH[m][z] = new GraphicObject("");
                this.SilentViewSensorsL[m][z] = new GraphicObject("");
                this.SMSViewSensorsH[m][z] = new GraphicObject("");
                this.SMSViewSensorsL[m][z] = new GraphicObject("");
                this.HornViewSensorsH[m][z] = new GraphicObject("");
                this.HornViewSensorsL[m][z] = new GraphicObject("");
            }
        }
        this.InitializedMatrix = true;
    }

    public void CreateVisualization() {
        int m;
        this.ClearActiveVisualization();
        for (int z = 0; z < this.OtherViewsIndex; ++z) {
            this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(this.OtherViews[z]);
            this.CurrentViewStat[this.CurrentViewStatIndex].Label_text = this.ChangeDynamic(this.CurrentViewStat[this.CurrentViewStatIndex].Label_text);
            ++this.CurrentViewStatIndex;
        }
        for (m = 0; m < OUTPUTS_COUNT_PRO; ++m) {
            this.UpdateIOStatus(this.OutputStates[m], this.OutputViewH[m], this.OutputViewL[m], 5);
        }
        for (m = 0; m < INPUTS_COUNT_PRO; ++m) {
            this.UpdateIOStatus(this.InputStates[m], this.InputViewH[m], this.InputViewL[m], 5);
        }
        for (m = 0; m < SENSORS_COUNT_PRO; ++m) {
            this.UpdateIOStatus(true, this.SensorViewL[m], this.SensorViewH[m], 5);
        }
        for (m = 0; m < SENSORS_COUNT_ALARM_PRO; ++m) {
            this.UpdateIOStatus(this.AlarmSensorsActive[m], this.ActiveViewSensorsH[m], this.ActiveViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsWarning[m], this.WarningViewSensorsH[m], this.WarningViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsMonitoring[m], this.MonitoringViewSensorsH[m], this.MonitoringViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsAlarm[m], this.AlarmViewSensorsH[m], this.AlarmViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsSMS[m], this.SMSViewSensorsH[m], this.SMSViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsSilent[m], this.SilentViewSensorsH[m], this.SilentViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsHorn[m], this.HornViewSensorsH[m], this.HornViewSensorsL[m], 5);
            this.UpdateIOStatus(this.AlarmSensorsEarlyWarning[m], this.EarlyViewSensorsH[m], this.EarlyViewSensorsL[m], 5);
        }
        int Max_ADC = 0;
        for (int i = 0; i < Max_ADC; ++i) {
            this.UpdateADC(i, 5.0f, 0.0f, 10.0f, this.SensorViewL[i], this.SensorViewH[i], this.SensorViewOK[i], 5);
        }
    }

    public boolean ChkIsAdcChanged() {
        if (this.AdcChanged) {
            this.AdcChanged = false;
            return true;
        }
        return false;
    }

    public boolean IsDeviceName(String dname) {
        if (this.DeviceName == null) {
            return false;
        }
        if (this.DeviceName.length() == 0) {
            return false;
        }
        return dname.length() > 0 && dname.compareTo(this.DeviceName) == 0;
    }

    private double gettemplm(int dta, int calibration, double k, int VCC) {
        double temp = (double)(dta * VCC) / (1023.0 * k) + (double)(calibration / 100);
        temp = Math.round(temp * 10.0);
        return temp /= 10.0;
    }

    private double gettemplm35(int dta) {
        double temp = dta * this.VCC / 10230;
        temp = Math.round(temp * 10.0);
        return temp /= 10.0;
    }

    private int check_in(String stt, int defaut) {
        double dd = Double.valueOf(stt);
        int ino = (int)dd;
        return ino;
    }

    public void ReadAlarmSensorsNames(String pat) {
        int i = 0;
        boolean z = false;
        if (ehousecommunication.FileExists(pat)) {
            String[] AlarmS = ehousecommunication.getfile(pat);
            while (AlarmS[i] != null) {
                this.AlarmSensorsActive[i] = false;
                this.AlarmSensorsAlarm[i] = false;
                this.InputInverts[i] = false;
                this.AlarmSensorsWarning[i] = false;
                this.AlarmSensorsMonitoring[i] = false;
                this.AlarmSensorsNames[i] = AlarmS[i];
                if (++i != SENSORS_COUNT_ALARM_PRO) continue;
            }
            while (i < SENSORS_COUNT_ALARM_PRO) {
                this.AlarmSensorsActive[i] = false;
                this.AlarmSensorsAlarm[i] = false;
                this.AlarmSensorsWarning[i] = false;
                this.AlarmSensorsMonitoring[i] = false;
                this.AlarmSensorsSMS[i] = false;
                this.AlarmSensorsHorn[i] = false;
                this.AlarmSensorsSilent[i] = false;
                this.AlarmSensorsEarlyWarning[i] = false;
                this.InputInverts[i] = false;
                this.AlarmSensorsNames[i] = "";
                ++i;
            }
        }
    }

    public void LoadDta(String name) {
        String[] st = new String[300];
        if (ehousecommunication.FileExists(name)) {
            int i;
            this.InitVisualisationItems();
            st = ehousecommunication.getfile(name + sep + "names/name.txt");
            this.DeviceName = st[0];
            if (st[1] == null) {
                st[1] = "000200";
            }
            if (st[1].length() < 6) {
                st[1] = "000200";
            }
            String adrh = st[1].substring(0, 3);
            String adrl = st[1].substring(3);
            this.DevAdrH = this.check_in(adrh, 0);
            this.DevAdrL = this.check_in(adrl, 0);
            this.DevAdr = String.valueOf(this.DevAdrL);
            this.DevAdr = st[1];
            this.IsAlarm = true;
            this.IsEthernet = true;
            ehousecommunication.ProName = this.DeviceName;
            String[] senstypes = new String[1000];
            if (ehousecommunication.FileExists(ehousecommunication.path + "ADCSensorTypes.txt")) {
                senstypes = ehousecommunication.getfile(ehousecommunication.path + "ADCSensorTypes.txt");
            } else {
                for (i = 0; i < 256; ++i) {
                    senstypes[i] = "N/A";
                }
            }
            String[] senstype = new String[1000];
            if (ehousecommunication.FileExists(ehousecommunication.path + "AdcConfig.cfg")) {
                senstype = ehousecommunication.getfile(ehousecommunication.path + "AdcConfig.cfg");
            } else {
                for (i = 0; i < 256; ++i) {
                    senstypes[i] = "0";
                }
            }
            if (ehousecommunication.FileExists(name + sep + "names/adcs.txt")) {
                st = ehousecommunication.getfile(name + sep + "names/adcs.txt");
            } else {
                for (i = 0; i < 256; ++i) {
                    st[i] = "";
                }
            }
            for (i = 0; i < SENSORS_COUNT_PRO; ++i) {
                if (st[i] == null) {
                    st[i] = "@ADC" + String.valueOf(i + 1);
                }
                if (st[i].length() == 0) {
                    st[i] = "@ADC" + String.valueOf(i + 1);
                }
                this.SensorNames[i] = st[i];
                int senstyp = 0;
                try {
                    senstyp = Integer.parseInt(senstype[i]);
                }
                catch (Exception e) {
                    senstyp = 0;
                }
                this.SensorType[i] = senstyp;
                this.SensorTypeName[i] = senstypes[senstyp];
                if (this.SensorNames[i] == null) {
                    this.SensorNames[i] = "@" + String.valueOf(i + 1);
                }
                this.SensorABSValues[i] = 0;
                this.SensorTemps[i] = 0.0;
                this.SensorPercents[i] = 0.0;
                this.SensorLights[i] = 0.0;
                this.SensorVolts[i] = 0.0;
                this.Calibration[i] = -27315;
                this.SensorTemps[i] = 0.0;
                this.SensorTempsLM35[i] = 0.0;
                this.SensorTempsMCP9700[i] = 0.0;
                this.SensorTempsMCP9701[i] = 0.0;
            }
            this.VCC = 3300;
            if (ehousecommunication.FileExists(name + sep + "names/outputs.txt")) {
                st = ehousecommunication.getfile(name + sep + "names/outputs.txt");
            } else {
                for (i = 0; i < 256; ++i) {
                    st[i] = "";
                }
            }
            for (i = 0; i < OUTPUTS_COUNT_PRO; ++i) {
                if (st[i] == null) {
                    st[i] = "@Out" + String.valueOf(i + 1);
                }
                if (st[i].length() == 0) {
                    st[i] = "@Out" + String.valueOf(i + 1);
                }
                this.OutputNames[i] = st[i];
                this.OutputStates[i] = false;
            }
            if (ehousecommunication.FileExists(name + sep + "names/inputs.txt")) {
                st = ehousecommunication.getfile(name + sep + "names/inputs.txt");
            } else {
                for (i = 0; i < 256; ++i) {
                    st[i] = "";
                }
            }
            for (i = 0; i < INPUTS_COUNT_PRO; ++i) {
                if (st[i] == null) {
                    st[i] = "@In" + String.valueOf(i + 1);
                }
                if (st[i].length() == 0) {
                    st[i] = "@In" + String.valueOf(i + 1);
                }
                this.AlarmSensorsNames[i] = st[i];
                this.InputNames[i] = st[i];
                this.InputStates[i] = false;
                this.InputInverts[i] = false;
                this.InputInverts[i] = false;
                this.AlarmSensorsActive[i] = false;
                this.AlarmSensorsWarning[i] = false;
                this.AlarmSensorsMonitoring[i] = false;
                this.AlarmSensorsAlarm[i] = false;
                this.AlarmSensorsHorn[i] = false;
                this.AlarmSensorsEarlyWarning[i] = false;
                this.AlarmSensorsSilent[i] = false;
                this.AlarmSensorsSMS[i] = false;
            }
            if (ehousecommunication.FileExists(name + sep + "names/programs.txt")) {
                st = ehousecommunication.getfile(name + sep + "names/programs.txt");
            } else {
                for (i = 0; i < 256; ++i) {
                    st[i] = "";
                }
            }
            for (i = 0; i < 256; ++i) {
                if (st[i] == null) {
                    st[i] = "@Program" + String.valueOf(i + 1);
                }
                if (st[i].length() == 0) {
                    st[i] = "@Program" + String.valueOf(i + 1);
                }
                this.ProgramNames[i] = st[i].trim();
            }
            if (ehousecommunication.FileExists(name + sep + "names/rollers.txt")) {
                st = ehousecommunication.getfile(name + sep + "names/rollers.txt");
            } else {
                for (i = 0; i < 256; ++i) {
                    st[i] = "";
                }
            }
            for (i = 0; i < OUTPUTS_COUNT_PRO / 2; ++i) {
                if (st[i] == null) {
                    st[i] = "@Roller " + String.valueOf(i + 1);
                }
                if (st[i].length() == 0) {
                    st[i] = "@Roller " + String.valueOf(i + 1);
                }
                this.RollerNames[i] = st[i].trim();
            }
            if (ehousecommunication.FileExists(name + sep + "names/secuprograms.txt")) {
                st = ehousecommunication.getfile(name + sep + "names/secuprograms.txt");
            } else {
                for (i = 0; i < 256; ++i) {
                    st[i] = "";
                }
            }
            for (i = 0; i < 256; ++i) {
                if (st[i] == null) {
                    st[i] = "@SecuProgram" + String.valueOf(i + 1);
                }
                if (st[i].length() == 0) {
                    st[i] = "@SecuProgram" + String.valueOf(i + 1);
                }
                this.SecuProgramNames[i] = st[i].trim();
            }
            if (ehousecommunication.FileExists(name + sep + "names/adcprograms.txt")) {
                st = ehousecommunication.getfile(name + sep + "names/adcprograms.txt");
            } else {
                for (i = 0; i < 256; ++i) {
                    st[i] = "";
                }
            }
            for (i = 0; i < ADC_PROGRAMS_COUNT_PRO; ++i) {
                if (st[i] == null) {
                    st[i] = "@ADC Program " + String.valueOf(i + 1);
                }
                if (st[i].length() == 0) {
                    st[i] = "@ADC Program " + String.valueOf(i + 1);
                }
                this.ADCProgramNames[i] = st[i];
            }
            if (ehousecommunication.FileExists(name + sep + "names/zones.txt")) {
                st = ehousecommunication.getfile(name + sep + "names/zones.txt");
            } else {
                for (i = 0; i < 256; ++i) {
                    st[i] = "";
                }
            }
            for (i = 0; i < ZONES_COUNT_PRO; ++i) {
                if (st[i] == null) {
                    st[i] = "@Zone " + String.valueOf(i + 1);
                }
                this.ZoneNames[i] = st[i];
            }
            this.changed = false;
            this.CurrentProgram = 0;
            this.CurrentZone = 0;
            this.CurrentSecuProgram = 0;
            this.ADCCurrentProgram = 0;
            this.CurrentProgramName = "";
            for (i = 0; i < STATUS_SIZE; ++i) {
                this.CurrentStatus[i] = 0;
            }
            if (ehousecommunication.EnableXMLStatus) {
                this.MakeXml.start();
            }
            this.IsBatch = false;
            this.IsAlarm = false;
            this.IsEthernet = true;
        }
    }

    public double calculate_percent(int dta) {
        long ltmp = Math.round((double)dta * 10000.0 / 1023.0);
        double tmp = ltmp / 100L;
        return tmp;
    }

    public double getlight(int dta) {
        double dtta = dta * 100;
        return (double)Math.round((dtta /= 1023.0) * 10.0) / 10.0;
    }

    public boolean GetInOutValue(int dta, int offset) {
        int temp = dta >> offset;
        return (temp & 1) > 0;
    }

    public boolean ginv(boolean val, boolean inv) {
        return val;
    }

    public int[] GetOptsIndex(String EventName, int AlarmState) {
        int i;
        int[] m = new int[2];
        for (i = 0; i < OUTPUTS_COUNT_PRO; ++i) {
            if (this.OutputNames[i].length() <= 0 || EventName.compareTo(this.OutputNames[i]) != 0) continue;
            m[1] = i;
            m[0] = 1;
            return m;
        }
        for (i = 0; i < INPUTS_COUNT_PRO; ++i) {
            if (this.InputNames[i].length() <= 0 || EventName.compareTo(this.InputNames[i]) != 0) continue;
            m[1] = i;
            m[0] = 2;
            return m;
        }
        for (i = 0; i < SENSORS_COUNT_PRO; ++i) {
            if (this.SensorNames[i].length() <= 0 || EventName.compareTo(this.SensorNames[i]) != 0) continue;
            m[1] = i;
            m[0] = 3;
            return m;
        }
        for (i = 0; i < SENSORS_COUNT_ALARM_PRO; ++i) {
            if (this.AlarmSensorsNames[i].length() <= 0 || EventName.compareTo(this.AlarmSensorsNames[i]) != 0) continue;
            m[1] = i;
            m[0] = 4 + AlarmState;
            return m;
        }
        m[1] = 255;
        m[0] = 255;
        return m;
    }

    void UpdateIOStatus(boolean State2, GraphicObject[] ON, GraphicObject[] OFF, int size) {
        GraphicObject gr = new GraphicObject("");
        if (this.CurrentViewStatIndex >= 10000) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            gr = State2 ? new GraphicObject(ON[i]) : new GraphicObject(OFF[i]);
            if (gr.event_name != null) {
                if (gr.event_name.length() > 0) {
                    this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(gr);
                    ++this.CurrentViewStatIndex;
                    if (this.CurrentViewStatIndex < 10000) continue;
                    return;
                }
                return;
            }
            return;
        }
    }

    String ChangeDynamic(String st) {
        String str = st;
        int kk = str.indexOf("%");
        int mm = -1;
        int indeee = 0;
        if (kk >= 0) {
            mm = str.indexOf("%", kk + 1);
        }
        if (kk < 0 || mm < 0) {
            return str;
        }
        if (str.indexOf("%HEATER_") >= 0) {
            str = str.replaceFirst("%HEATER_KOMSTAT%", EhouseTCP.HEATER_KOMSTAT);
            str = str.replaceFirst("%HEATER_RECUPERATOR_MODE%", EhouseTCP.HEATER_RECUPERATOR_MODE);
            str = str.replaceFirst("%HEATER_RECUPERATOR_SPEED%", EhouseTCP.HEATER_RECUPERATOR_SPEED);
            str = str.replaceFirst("%HEATER_RECUPERATOR_TEMP%", EhouseTCP.HEATER_RECUPERATOR_TEMP);
            str = str.replaceFirst("%HEATER_PROGRAM%", EhouseTCP.HEATER_PROGRAM);
        }
        if (str.indexOf("%EXTERNAL_") >= 0) {
            str = str.replaceFirst("%EXTERNAL_CURRENTZONE%", EhouseTCP.EXTERNAL_CURRENTZONE);
            str = str.replaceFirst("%EXTERNAL_CURRENTZONENAME%", EhouseTCP.EXTERNAL_CURRENTZONENAME);
            str = str.replaceFirst("%EXTERNAL_CURRENTPROGRAM%", EhouseTCP.External_currentprogram);
            str = str.replaceFirst("%EXTERNAL_CURRENTPROGRAMNAME%", EhouseTCP.External_currentprogramname);
        }
        str = str.replaceFirst("%CURRENTPROGRAM%", String.valueOf(this.CurrentProgram + 1));
        str = str.replaceFirst("%CURRENTPROGRAMNAME%", this.CurrentProgramName);
        str = str.replaceFirst("%CURRENTSECUPROGRAM%", String.valueOf(this.CurrentSecuProgram + 1));
        str = str.replaceFirst("%CURRENTSECUPROGRAMNAME%", this.CurrentSecuProgramName);
        str = str.replaceFirst("%CURRENTADCPROGRAM%", String.valueOf(this.ADCCurrentProgram + 1));
        str = str.replaceFirst("%CURRENTADCPROGRAMNAME%", this.ADCCurrentProgramName);
        str = str.replaceFirst("%CURRENTZONE%", String.valueOf(this.CurrentZone + 1));
        str = str.replaceFirst("%CURRENTZONENAME%", this.CurrentZoneName);
        kk = str.indexOf("%");
        mm = -1;
        if (kk >= 0) {
            mm = str.indexOf("%", kk + 1);
        }
        while (kk >= 0 && mm >= 0) {
            str = str.replaceFirst("%TEMP" + indeee + "%", this.SensorTemps[indeee].toString());
            str = str.replaceFirst("%ADC" + indeee + "%", String.valueOf(this.SensorABSValues[indeee]));
            str = str.replaceFirst("%PERCENT" + indeee + "%", this.SensorPercents[indeee].toString());
            str = str.replaceFirst("%LIGHT" + indeee + "%", this.SensorLights[indeee].toString());
            str = str.replaceFirst("%INVADC" + indeee + "%", String.valueOf(1023 - this.SensorABSValues[indeee]));
            str = str.replaceFirst("%INVPERCENT" + indeee + "%", String.valueOf(100.0 - this.SensorPercents[indeee]));
            str = str.replaceFirst("%VOLT" + indeee + "%", String.valueOf(this.SensorVolts[indeee]));
            str = str.replaceFirst("%MCP9700_" + indeee + "%", this.SensorTempsMCP9700[indeee].toString());
            str = str.replaceFirst("%MCP9701_" + indeee + "%", this.SensorTempsMCP9701[indeee].toString());
            kk = str.indexOf("%");
            mm = -1;
            if (kk >= 0) {
                mm = str.indexOf("%", kk + 1);
            }
            if (++indeee < SENSORS_COUNT_PRO) continue;
            break;
        }
        return str;
    }

    void UpdateADC(int InputNr, float Value, float Min, float Max, GraphicObject[] LOW, GraphicObject[] HIGH, GraphicObject[] OK, int size) {
        GraphicObject gr = new GraphicObject("");
        if (this.CurrentViewStatIndex >= 10000) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            gr = Value < Min ? new GraphicObject(LOW[i]) : (Value > Max ? new GraphicObject(HIGH[i]) : new GraphicObject(OK[i]));
            if (gr.DeviceName != null) {
                if (gr.Label_text != null && gr.Label_text.indexOf("%") >= 0) {
                    String str = gr.Label_text;
                    str = str.replaceFirst("%TEMP%", this.SensorTemps[InputNr].toString());
                    str = str.replaceFirst("%ADC%", String.valueOf(this.SensorABSValues[InputNr]));
                    str = str.replaceFirst("%PERCENT%", this.SensorPercents[InputNr].toString());
                    str = str.replaceFirst("%LIGHT%", this.SensorLights[InputNr].toString());
                    str = str.replaceFirst("%INVADC%", String.valueOf(1023 - this.SensorABSValues[InputNr]));
                    str = str.replaceFirst("%INVPERCENT%", String.valueOf(100.0 - this.SensorPercents[InputNr]));
                    str = str.replaceFirst("%VOLT%", this.SensorVolts[InputNr].toString());
                    str = str.replaceFirst("%TEMPLM35%", this.SensorTempsLM35[InputNr].toString());
                    str = str.replaceFirst("%TEMPMCP9700%", this.SensorTempsMCP9700[InputNr].toString());
                    str = str.replaceFirst("%TEMPMCP9701%", this.SensorTempsMCP9701[InputNr].toString());
                    gr.Label_text = str = this.ChangeDynamic(str);
                }
                this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(gr);
                ++this.CurrentViewStatIndex;
                if (this.CurrentViewStatIndex < 10000) continue;
                return;
            }
            return;
        }
    }

    public boolean WriteCheckIfChangedAndCpy(byte[] dta, boolean InitFromPrevious, int size) {
        int i;
        int sss = 0;
        EhouseTCP.FinishedEthernet = false;
        boolean tempboolean = false;
        boolean unconditional = InitFromPrevious;
        int TotalOffset = 6;
        int Max_ADC = 128;
        int CurrentSize = size;
        Calendar c = Calendar.getInstance();
        this.recent = c.getTime().toLocaleString();
        this.changed = InitFromPrevious;
        if (!InitFromPrevious) {
            if (this.PrevCheckSum != this.CheckSum) {
                this.changed = true;
                for (i = 0; i < CurrentSize; ++i) {
                    this.CurrentStatus[i] = dta[i];
                }
            } else if (this.CheckSum == 0L) {
                for (i = 0; i < CurrentSize; ++i) {
                    if (this.CurrentStatus[i] == dta[i]) continue;
                    this.CurrentStatus[i] = dta[i];
                    this.changed = true;
                }
            }
        }
        this.PrevCheckSum = this.CheckSum;
        if (this.changed) {
            int off;
            int k;
            this.ClearActiveVisualization();
            for (k = 0; k < 8; ++k) {
                off = 0;
                for (sss = 0; sss < OUTPUTS_COUNT_PRO; sss += 8) {
                    this.OutputStates[k + sss] = this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + 256 + off] & 0xFF), k);
                    this.UpdateIOStatus(this.OutputStates[k + sss], this.OutputViewH[k + sss], this.OutputViewL[k + sss], 5);
                    ++off;
                }
            }
            for (k = 0; k < 8; ++k) {
                off = 0;
                for (sss = 0; sss < INPUTS_COUNT_PRO; sss += 8) {
                    this.InputStates[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + STATUS_INPUTS_PRO + off] & 0xFF), k), this.InputInverts[k + sss]);
                    this.UpdateIOStatus(this.InputStates[k + sss], this.InputViewH[k + sss], this.InputViewL[k + sss], 5);
                    ++off;
                }
            }
            for (k = 0; k < 8; ++k) {
                off = 0;
                for (sss = 0; sss < INPUTS_COUNT_PRO; sss += 8) {
                    this.AlarmSensorsActive[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + STATUS_INPUTS_PRO + off] & 0xFF), k), this.InputInverts[k + sss]);
                    this.UpdateIOStatus(this.AlarmSensorsActive[k + sss], this.InputViewH[k + sss], this.InputViewL[k + sss], 5);
                    this.AlarmSensorsAlarm[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + STATUS_ALARM_PRO + off] & 0xFF), k), this.InputInverts[k + sss]);
                    this.UpdateIOStatus(this.AlarmSensorsAlarm[k + sss], this.AlarmViewSensorsH[k + sss], this.AlarmViewSensorsL[k + sss], 5);
                    this.AlarmSensorsWarning[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + STATUS_WARNING_PRO + off] & 0xFF), k), this.InputInverts[k + sss]);
                    this.UpdateIOStatus(this.AlarmSensorsWarning[k + sss], this.WarningViewSensorsH[k + sss], this.WarningViewSensorsL[k + sss], 5);
                    this.AlarmSensorsMonitoring[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + STATUS_MONITORING_PRO + off] & 0xFF), k), this.InputInverts[k + sss]);
                    this.UpdateIOStatus(this.AlarmSensorsMonitoring[k + sss], this.MonitoringViewSensorsH[k + sss], this.MonitoringViewSensorsL[k + sss], 5);
                    this.AlarmSensorsHorn[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + STATUS_HORN_PRO + off] & 0xFF), k), this.InputInverts[k + sss]);
                    this.UpdateIOStatus(this.AlarmSensorsHorn[k + sss], this.HornViewSensorsH[k + sss], this.HornViewSensorsL[k + sss], 5);
                    this.AlarmSensorsSilent[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + STATUS_SILENT_PRO + off] & 0xFF), k), this.InputInverts[k + sss]);
                    this.UpdateIOStatus(this.AlarmSensorsSilent[k + sss], this.SilentViewSensorsH[k + sss], this.SilentViewSensorsL[k + sss], 5);
                    this.AlarmSensorsEarlyWarning[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + STATUS_EARLY_PRO + off] & 0xFF), k), this.InputInverts[k + sss]);
                    this.UpdateIOStatus(this.AlarmSensorsEarlyWarning[k + sss], this.EarlyViewSensorsH[k + sss], this.EarlyViewSensorsL[k + sss], 5);
                    this.AlarmSensorsSMS[k + sss] = this.ginv(this.GetInOutValue((int)(this.CurrentStatus[TotalOffset + STATUS_SMS_PRO + off] & 0xFF), k), this.InputInverts[k + sss]);
                    this.UpdateIOStatus(this.AlarmSensorsSMS[k + sss], this.SMSViewSensorsH[k + sss], this.SMSViewSensorsL[k + sss], 5);
                    ++off;
                }
            }
            this.CurrentProgram = this.CurrentStatus[TotalOffset + STATUS_PROGRAM_NR] & 0xFF;
            this.CurrentZone = this.CurrentStatus[TotalOffset + STATUS_ZONE_NR] & 0xFF;
            this.CurrentSecuProgram = this.CurrentStatus[TotalOffset + STATUS_SECU_PROGRAM_NR] & 0xFF;
            this.ADCCurrentProgram = this.CurrentStatus[TotalOffset + STATUS_ADC_PROGRAM] & 0xFF;
            this.CurrentProgramName = "";
            this.CurrentProgramName = this.CurrentProgram < 256 ? this.ProgramNames[this.CurrentProgram] : "-";
            if (this.CurrentProgramName == null) {
                this.CurrentProgramName = "-";
            }
            this.CurrentSecuProgramName = "";
            this.CurrentSecuProgramName = this.CurrentSecuProgram < 256 ? this.SecuProgramNames[this.CurrentSecuProgram] : "-";
            if (this.CurrentSecuProgramName == null) {
                this.CurrentSecuProgramName = "-";
            }
            this.CurrentZoneName = this.CurrentZone < ZONES_COUNT_PRO ? this.ZoneNames[this.CurrentZone] : "-";
            if (this.CurrentZoneName == null) {
                this.CurrentZoneName = "-";
            }
            this.ADCCurrentProgramName = "";
            for (i = 0; i < Max_ADC; ++i) {
                int temppp = this.CurrentStatus[TotalOffset + i * 2 + 1] & 0xFF;
                if (this.SensorABSValues[i] != (temppp += (this.CurrentStatus[TotalOffset + i * 2] & 0xFF) << 8)) {
                    this.changed = true;
                    this.AdcChanged = true;
                }
                this.SensorABSValues[i] = temppp;
                this.SensorTemps[i] = this.gettemplm(temppp, this.Calibration[i], 10.0, this.VCC);
                this.SensorPercents[i] = this.calculate_percent(temppp);
                this.SensorLights[i] = 100.0 - this.SensorPercents[i];
                this.SensorTempsLM35[i] = this.gettemplm35(temppp);
                this.SensorTempsMCP9700[i] = this.calculate_MCP9700(temppp);
                this.SensorTempsMCP9701[i] = this.calculate_MCP9701(temppp);
                this.SensorVolts[i] = this.calculate_voltage(temppp);
                this.UpdateADC(i, 5.0f, 0.0f, 10.0f, this.SensorViewL[i], this.SensorViewH[i], this.SensorViewOK[i], 5);
            }
            int m = 0;
            while (this.OtherViews[m].event_name != null) {
                this.CurrentViewStat[this.CurrentViewStatIndex] = new GraphicObject(this.OtherViews[m]);
                this.CurrentViewStat[this.CurrentViewStatIndex].Label_text = this.ChangeDynamic(this.CurrentViewStat[this.CurrentViewStatIndex].Label_text);
                ++this.CurrentViewStatIndex;
                if (this.CurrentViewStatIndex >= 10000) {
                    EhouseTCP.FinishedEthernet = true;
                    return false;
                }
                ++m;
            }
        }
        if (this.changed) {
            this.XmlChanged = true;
        }
        EhouseTCP.FinishedEthernet = true;
        return this.changed;
    }

    public boolean isAddress(int devadrh, int devadrl) {
        int devadrhh = devadrh;
        int devadrll = devadrl;
        if (devadrhh < 0) {
            devadrhh = 256 + devadrhh;
        }
        if (devadrll < 0) {
            devadrll = 256 + devadrll;
        }
        return devadrhh == this.DevAdrH && devadrll == this.DevAdrL;
    }
}

