/*
 * Decompiled with CFR 0.152.
 */
package ehouse4java;

import ehouse4java.EhouseTCP;
import ehouse4java.ehousecommunication;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPanel;

public class visualization
extends JPanel {
    private static final int POLYGON = 80;
    private static final int ELLIPSE = 69;
    private static final int RECTANGLE = 82;
    private static final int TEXT = 84;
    private static final int LINE = 76;
    private static final double ShiftValue = 0.1;
    Dimension size = new Dimension(10, 10);
    static double scale = 1.0;
    boolean firsttime = true;
    public boolean shifting = false;
    public int ShiftMargin = 20;
    public int ShiftingLineColor = 0xFFFFFF;
    boolean shift = false;
    public boolean ainvalidated = false;
    public boolean TerminateVisualization = false;
    int countdown = 0;
    float pressedX = 0.0f;
    float pressedY = 0.0f;
    String StatusCurrent = "";

    public void setScale(double scale) {
        visualization.scale = scale;
    }

    public double getScale() {
        return scale;
    }

    public visualization(double scale) {
        this.setPreferredSize(new Dimension(200, 800));
        this.setBackground(visualization.IntToColor(ehousecommunication.VisualizationBackgroundColor));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                float xX = e.getX();
                float yY = e.getY();
                visualization.this.chkallobject((int)xX, (int)yY);
                if (visualization.this.shifting) {
                    visualization.this.CheckShiftBounds((int)xX, (int)yY);
                }
                visualization.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.firsttime) {
            int w = this.getWidth();
            int h = this.getHeight();
            this.size.width = w;
            this.size.height = h;
        }
        this.firsttime = false;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.scale(scale, scale);
        block8: for (int i = 0; i < EhouseTCP.ViewObjectIndex; ++i) {
            int fig = EhouseTCP.TempView[i].object_type;
            int X1 = EhouseTCP.TempView[i].X1;
            int X2 = EhouseTCP.TempView[i].X2;
            int Y1 = EhouseTCP.TempView[i].Y1;
            int Y2 = EhouseTCP.TempView[i].Y2;
            int Color2 = EhouseTCP.TempView[i].color;
            int FillColor = EhouseTCP.TempView[i].fill_color;
            int DrawSolid = EhouseTCP.TempView[i].Draw_solid;
            int RadiusX = EhouseTCP.TempView[i].Radius_x;
            int RadiusY = EhouseTCP.TempView[i].Radius_y;
            int Width = EhouseTCP.TempView[i].width;
            int FontSize = EhouseTCP.TempView[i].FontSize;
            int total_points = EhouseTCP.TempView[i].total_points;
            int[] X = new int[20];
            int[] Y = new int[20];
            for (int k = 0; k < 20; ++k) {
                X[k] = EhouseTCP.TempView[i].X[k];
                Y[k] = EhouseTCP.TempView[i].Y[k];
            }
            String LabelFont = EhouseTCP.TempView[i].Font;
            String LabelText = EhouseTCP.TempView[i].Label_text;
            switch (fig) {
                case 80: {
                    this.DrawPolygon(X, Y, total_points, Color2, FillColor, Width, 0, g2d);
                    continue block8;
                }
                case 69: {
                    this.drawEllipse(X1, Y1, X2, Y2, Color2, FillColor, Width, 0, g2d);
                    continue block8;
                }
                case 82: {
                    this.drawRec(X1, Y1, X2, Y2, Color2, FillColor, Width, DrawSolid, RadiusX, RadiusY, g2d);
                    continue block8;
                }
                case 79: {
                    this.drawRoundRec(X1, Y1, X2, Y2, RadiusX, RadiusY, Color2, FillColor, Width, 0, g2d);
                    continue block8;
                }
                case 84: {
                    this.drawText(X1, Y1, LabelText, LabelFont, FontSize, Color2, FillColor, Width, DrawSolid, g2d);
                    continue block8;
                }
                case 76: {
                    this.drawLine(X1, Y1, X2, Y2, Color2, FillColor, Width, DrawSolid, g2d);
                    continue block8;
                }
                default: {
                    ehousecommunication.l("Unknown object: ");
                }
            }
        }
        this.statusc(this.StatusCurrent, g2d);
        this.status("Xof: " + String.valueOf(ehousecommunication.OffsetX) + " Yof: " + String.valueOf(ehousecommunication.OffsetY) + " Zoom: " + String.valueOf((Object)(Math.round(ehousecommunication.ScaleX * 1000.0) / 10L)), g2d);
        if (this.shifting) {
            int x1 = 0;
            int x2 = this.getWidth() / this.ShiftMargin;
            int x3 = this.getWidth() - x2;
            int x4 = this.getWidth();
            int y1 = 0;
            int y2 = this.getHeight() / this.ShiftMargin;
            int y3 = this.getHeight() - y2;
            int y4 = this.getHeight();
            this.drawLine(x1, y2, x4, y2, this.ShiftingLineColor, this.ShiftingLineColor, 1.0f, 1, g2d);
            this.drawLine(x1, y3, x4, y3, this.ShiftingLineColor, this.ShiftingLineColor, 1.0f, 1, g2d);
            this.drawLine(x2, y1, x2, y4, this.ShiftingLineColor, this.ShiftingLineColor, 1.0f, 1, g2d);
            this.drawLine(x3, y1, x3, y4, this.ShiftingLineColor, this.ShiftingLineColor, 1.0f, 1, g2d);
        }
        this.ainvalidated = false;
        this.inav();
    }

    private void drawLine(int x1, int y1, int x2, int y2, int color, int fillcolor, float penwidth, int style, Graphics2D g) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        this.SetPen(color, penwidth, style, g);
        g.draw(line);
    }

    private void drawRec(int x1, int y1, int x2, int y2, int color, int fillcolor, float penwidth, int style, int roundx, int roundy, Graphics2D g) {
        int width = x2 - x1;
        int height = y2 - y1;
        RoundRectangle2D.Double rectangle = new RoundRectangle2D.Double(x1, y1, width, height, roundx, roundy);
        this.SetPen(color, penwidth, style, g);
        g.draw(rectangle);
        g.setColor(visualization.IntToColor(fillcolor));
        g.fill(rectangle);
    }

    private void drawRoundRec(int x1, int y1, int x2, int y2, int radiusx, int radiusy, int color, int fillcolor, float penwidth, int style, Graphics2D g) {
        int width = x2 - x1;
        int height = y2 - y1;
        RoundRectangle2D.Double roundrectangle = new RoundRectangle2D.Double(x1, y1, width, height, radiusx, radiusy);
        this.SetPen(color, penwidth, style, g);
        g.draw(roundrectangle);
        g.setColor(visualization.IntToColor(fillcolor));
        g.fill(roundrectangle);
    }

    private void drawEllipse(int x1, int y1, int x2, int y2, int color, int fillcolor, float penwidth, int style, Graphics2D g) {
        int width = x2 - x1;
        int height = y1 - y2;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(x1, y2, width, height);
        this.SetPen(color, penwidth, style, g);
        g.draw(ellipse);
        g.setColor(visualization.IntToColor(fillcolor));
        g.fill(ellipse);
    }

    private void drawText(int x1, int y1, String text, String FontName, int height, int color, int fillcolor, float penwidth, int style, Graphics2D g) {
        int stylepen = style >> 4;
        int heigh = height < 1 ? 1 : height;
        heigh *= 2;
        g.setColor(visualization.IntToColor(color));
        if (style == 0) {
            style = 0;
        }
        if ((style & 1) > 0) {
            style = 1;
        }
        if ((style & 2) > 0) {
            style = 2;
        }
        if ((style & 4) > 0) {
            style = 3;
        }
        Font font = new Font(FontName, style, heigh);
        g.setFont(font);
        String Text = "";
        if (text != null) {
            Text = text;
        }
        g.drawString(Text, x1, y1 + heigh - 1);
    }

    private void SetPen(int color, float penwidth, int style, Graphics2D g) {
        g.setColor(visualization.IntToColor(color));
        switch (style) {
            case 0: {
                g.setStroke(new BasicStroke(penwidth));
                break;
            }
            case 1: {
                float[] f = new float[]{5.0f, 5.0f};
                g.setStroke(new BasicStroke(penwidth, 1, 1, 10.0f, f, 1.0f));
                break;
            }
            case 2: {
                float[] f = new float[]{1.0f, 5.0f};
                g.setStroke(new BasicStroke(penwidth, 1, 1, 10.0f, f, 1.0f));
                break;
            }
            case 3: {
                float[] f = new float[]{1.0f, 5.0f, 5.0f, 5.0f};
                g.setStroke(new BasicStroke(penwidth, 1, 1, 10.0f, f, 1.0f));
                break;
            }
            case 4: {
                float[] f = new float[]{1.0f, 5.0f, 1.0f, 5.0f, 5.0f, 5.0f};
                g.setStroke(new BasicStroke(penwidth, 1, 1, 10.0f, f, 1.0f));
                break;
            }
        }
    }

    public static Color IntToColor(int c) {
        int r = (c & 0xFF0000) >> 16;
        int g = (c & 0xFF00) >> 8;
        int b = c & 0xFF;
        int alpha = c <= 0xFFFFFF ? ehousecommunication.transparency_level : ehousecommunication.fill_transparency_level;
        Color color = new Color(b, g, r, alpha);
        return color;
    }

    void status(String str, Graphics2D g) {
        this.drawText(1, 1, str, "Arial", 10, -1601204337, -1601204337, 1.0f, 0, g);
    }

    void statusc(String str, Graphics2D g) {
        this.drawText(1, 20, str, "Arial", 10, -1601204337, -1601204337, 1.0f, 0, g);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void CheckShiftBounds(int x, int y) {
        int x1 = 0;
        int x2 = this.getWidth() / this.ShiftMargin;
        int x3 = this.getWidth() - x2;
        int x4 = this.getWidth();
        int y1 = 0;
        int y2 = this.getHeight() / this.ShiftMargin;
        int y3 = this.getHeight() - y2;
        int y4 = this.getHeight();
        if (this.IsInRectangle(x, y, x1, y1, x2, y2, 1)) {
            ehousecommunication.OffsetX = (int)((double)ehousecommunication.OffsetX - (double)this.getWidth() * (0.1 - (double)(1 / this.ShiftMargin)));
            ehousecommunication.OffsetY = (int)((double)ehousecommunication.OffsetY + (double)this.getHeight() * (0.1 - (double)(1 / this.ShiftMargin)));
            EhouseTCP.ReadViewFile(ehousecommunication.currentview);
        }
        if (this.IsInRectangle(x, y, x1, y3, x2, y4, 1)) {
            ehousecommunication.OffsetX = (int)((double)ehousecommunication.OffsetX - (double)this.getWidth() * (0.1 - (double)(1 / this.ShiftMargin)));
            ehousecommunication.OffsetY = (int)((double)ehousecommunication.OffsetY - (double)this.getHeight() * (0.1 - (double)(1 / this.ShiftMargin)));
            EhouseTCP.ReadViewFile(ehousecommunication.currentview);
        }
        if (this.IsInRectangle(x, y, x3, y1, x4, y2, 1)) {
            ehousecommunication.OffsetX = (int)((double)ehousecommunication.OffsetX + (double)this.getWidth() * (0.1 - (double)(1 / this.ShiftMargin)));
            ehousecommunication.OffsetY = (int)((double)ehousecommunication.OffsetY + (double)this.getHeight() * (0.1 - (double)(1 / this.ShiftMargin)));
            EhouseTCP.ReadViewFile(ehousecommunication.currentview);
        }
        if (this.IsInRectangle(x, y, x3, y3, x4, y4, 1)) {
            ehousecommunication.OffsetX = (int)((double)ehousecommunication.OffsetX + (double)this.getWidth() * (0.1 - (double)(1 / this.ShiftMargin)));
            ehousecommunication.OffsetY = (int)((double)ehousecommunication.OffsetY - (double)this.getHeight() * (0.1 - (double)(1 / this.ShiftMargin)));
            EhouseTCP.ReadViewFile(ehousecommunication.currentview);
        }
        if (this.IsInRectangle(x, y, x2, y1, x3, y2, 1)) {
            ehousecommunication.OffsetY = (int)((double)ehousecommunication.OffsetY + (double)this.getHeight() * (0.1 - (double)(1 / this.ShiftMargin)));
            EhouseTCP.ReadViewFile(ehousecommunication.currentview);
        }
        if (this.IsInRectangle(x, y, x2, y3, x3, y4, 1)) {
            ehousecommunication.OffsetY = (int)((double)ehousecommunication.OffsetY - (double)this.getHeight() * (0.1 - (double)(1 / this.ShiftMargin)));
            EhouseTCP.ReadViewFile(ehousecommunication.currentview);
        }
        if (this.IsInRectangle(x, y, x1, y2, x2, y3, 1)) {
            ehousecommunication.OffsetX = (int)((double)ehousecommunication.OffsetX - (double)this.getWidth() * (0.1 - (double)(1 / this.ShiftMargin)));
            EhouseTCP.ReadViewFile(ehousecommunication.currentview);
        }
        if (this.IsInRectangle(x, y, x3, y2, x4, y3, 1)) {
            ehousecommunication.OffsetX = (int)((double)ehousecommunication.OffsetX + (double)this.getWidth() * (0.1 - (double)(1 / this.ShiftMargin)));
            EhouseTCP.ReadViewFile(ehousecommunication.currentview);
        }
    }

    String chkallobject(int x, int y) {
        Byte[] evt = new Byte[10];
        boolean InsertedEvent = false;
        String tmptext = "";
        this.StatusCurrent = "";
        if (this.countdown == 0) {
            for (int i = 0; i < EhouseTCP.ViewObjectIndex; ++i) {
                int x1 = EhouseTCP.TempView[i].X1;
                int x2 = EhouseTCP.TempView[i].X2;
                int y1 = EhouseTCP.TempView[i].Y1;
                int y2 = EhouseTCP.TempView[i].Y2;
                int width = EhouseTCP.TempView[i].width;
                if (EhouseTCP.TempView[i].object_type == 82 && this.IsInRectangle(x, y, x1, y1, x2, y2, width)) {
                    this.AddEvent(EhouseTCP.TempView[i].DeviceName, EhouseTCP.TempView[i].event_name, EhouseTCP.TempView[i].DirectEvent);
                    return EhouseTCP.TempView[i].DeviceName + " - " + EhouseTCP.TempView[i].event_name;
                }
                if (EhouseTCP.TempView[i].object_type == 80 && this.IsInRectangle(x, y, x1, y1, x2, y2, width)) {
                    this.AddEvent(EhouseTCP.TempView[i].DeviceName, EhouseTCP.TempView[i].event_name, EhouseTCP.TempView[i].DirectEvent);
                    return EhouseTCP.TempView[i].DeviceName + " - " + EhouseTCP.TempView[i].event_name;
                }
                if (EhouseTCP.TempView[i].object_type == 79 && this.IsInRectangle(x, y, x1, y1, x2, y2, width)) {
                    this.AddEvent(EhouseTCP.TempView[i].DeviceName, EhouseTCP.TempView[i].event_name, EhouseTCP.TempView[i].DirectEvent);
                    return EhouseTCP.TempView[i].DeviceName + " - " + EhouseTCP.TempView[i].event_name;
                }
                if (EhouseTCP.TempView[i].object_type == 69 && this.IsInEllipse(x, y, x1, y1, x2, y2, width)) {
                    this.AddEvent(EhouseTCP.TempView[i].DeviceName, EhouseTCP.TempView[i].event_name, EhouseTCP.TempView[i].DirectEvent);
                    return EhouseTCP.TempView[i].DeviceName + " - " + EhouseTCP.TempView[i].event_name;
                }
                if (EhouseTCP.TempView[i].object_type != 84 || this.IsInText(x, y, x1, y1, x2, y2, width)) {
                    // empty if block
                }
                if (EhouseTCP.TempView[i].object_type != 76 || !this.IsInPolyline(x, y, x1, y1, x2, y2, width)) continue;
                this.AddEvent(EhouseTCP.TempView[i].DeviceName, EhouseTCP.TempView[i].event_name, EhouseTCP.TempView[i].DirectEvent);
                return EhouseTCP.TempView[i].DeviceName + " - " + EhouseTCP.TempView[i].event_name;
            }
            if (tmptext.length() > 0) {
                if (InsertedEvent) {
                    // empty if block
                }
                tmptext = tmptext.substring(0, tmptext.length() - 2);
            }
        }
        return tmptext;
    }

    int min(int x, int y) {
        if (x > y) {
            return y;
        }
        return x;
    }

    int max(int x, int y) {
        if (x < y) {
            return y;
        }
        return x;
    }

    boolean IsInRectangle(int x, int y, int x1, int y1, int x2, int y2, int width) {
        int wid = width >> 1;
        if (wid == 0) {
            wid = 1;
        }
        int xmin = this.min(x1, x2) - wid;
        int xmax = this.max(x1, x2) + wid;
        int ymin = this.min(y1, y2) - wid;
        int ymax = this.max(y1, y2) + wid;
        return x >= xmin && y >= ymin && x <= xmax && y <= ymax;
    }

    boolean IsInPolyline(int x, int y, int x1, int y1, int x2, int y2, int width) {
        int wid = width >> 1;
        if (wid == 0) {
            wid = 1;
        }
        double xmin = this.min(x1, x2) - wid;
        double xmax = this.max(x1, x2) + wid;
        double ymin = this.min(y1, y2) - wid;
        double ymax = this.max(y1, y2) + wid;
        if (x1 != x2) {
            double a = (double)(y2 - y1) / (double)(x1 - x2);
            double b = a * (double)x2 + (double)y2;
            double bmin = b - (double)wid;
            double bmax = b + (double)wid;
            if ((double)x >= xmin && (double)y >= ymin && (double)x <= xmax && (double)y <= ymax) {
                double btemp = a * (double)x + (double)y;
                return btemp >= bmin && btemp <= bmax;
            }
            return false;
        }
        return (double)x >= xmin && (double)y >= ymin && (double)x <= xmax && (double)y <= ymax;
    }

    boolean IsInEllipse(int x, int y, int x1, int y1, int x2, int y2, int width) {
        int ymax;
        double b;
        int ymin;
        int y0;
        int xmax;
        double a;
        int xmin;
        int x0;
        double l;
        int wid = width >> 1;
        if (wid == 0) {
            wid = 1;
        }
        return (l = (double)(x - (x0 = (xmin = this.min(x1, x2) - wid) + (int)(a = (double)(((xmax = this.max(x1, x2) + wid) - xmin) / 2)))) / a * ((double)(x - x0) / a) + (double)(y - (y0 = (ymin = this.min(y1, y2) - wid) + (int)(b = (double)(((ymax = this.max(y1, y2) + wid) - ymin) / 2)))) / b * ((double)(y - y0) / b)) <= 1.0;
    }

    boolean IsInText(int x, int y, int x1, int y1, int x2, int y2, int width) {
        int wid = width >> 1;
        if (wid == 0) {
            wid = 1;
        }
        int xmin = this.min(x1, x2) - wid;
        int xmax = this.max(x1, x2) + wid;
        int ymin = this.min(y1, y2) - wid;
        int ymax = this.max(y1, y2) + wid;
        return x >= xmin && y >= ymin && x <= xmax && y <= ymax;
    }

    void AddEvent(String Device, String Event2, String direv) {
        this.StatusCurrent = Device + " - " + Event2 + " >> " + direv;
        if (direv.length() > 19) {
            ehousecommunication.AddAsciiEvent(direv);
            ehousecommunication.SendWiFi(ehousecommunication.getip(direv), 9876);
        }
    }

    void inav() {
        if (this.ainvalidated) {
            return;
        }
        this.ainvalidated = true;
        this.invalidate();
    }

    private void DrawPolygon(int[] x, int[] y, int tot, int color, int fillcolor, float penwidth, int style, Graphics2D g) {
        Polygon poly = new Polygon(x, y, tot);
        this.SetPen(color, penwidth, style, g);
        g.draw(poly);
        g.setColor(visualization.IntToColor(fillcolor));
        g.fill(poly);
    }
}

