
/* 
 * eHouse Home automation intelligent system visualization and graphical control
 * 
 * 
 * 
 * 
 * To do:
 *  recent state reception,
 *  heat manager full status
 *  apache/web server integration for status update
 *  DOM indexing for optimalization if necesary  / substitute for DOM search for each data update
 *  ISSUES - Firefox & Opera do not support "GetElementsByName" must be replaced by "GetElementsByClassName" for xml documents workaround (require class tag to be declared with the same value as name): 
 *          Dom object scanning one by one is not efficient cause deadlock for several secs
 *  requires storage of dom indexes for solution
 */
//auxiliary JavaScript for eHouse control via SVG graphics (drawing object + aprox 2:1 compression for .svg comparing to .xml visualization)
//
//author Robert Jarzabek @ http://www.isys.pl/ http://inteligentny-dom.ehouse.pro/
var EHOUSE1_VIA_CM            = 1;      //Ehouse1 controllers via CM (under CommManager supervision)
var eHousePROEnabled          = 1;	//enable ehousePro status
//we are using using prepared package from eHouse4cServer
// one controller per line
// first all ERMs, 
// then all eHouse1 controllers status 
// next CommManager status
// next eHousePro servers
// 
// 
// 
// 
// eh.x?eHGlobalStatus function
var UseeHGlobalStatus=1;                    //Status received in package
var DISABLE_VISUALIZATION=false;            //Disable Visualization => do not display dynamic / replaced fields 
var xmlns="http://www.w3.org/2000/svg",xlink="http://www.w3.org/1999/xlink";
var Root=document.documentElement;
var BacgroundColor=0;
var Optimalize=false;                    //Optimalization performance - 
//                                      indexing DOM object  for better performance however initialization could takes up to 30sec
var transparencyopacity=1;      //opacity for fill color equal to background
var fill_opacity=1;             //for other fill colors 
var stroke_opacity=1;           //opacity for outline
var DecimalSeparator = Number("1.2").toLocaleString().substr(1,1);
var eHouse1=new Array();        //ehouse 1 status array
var EthernetEhouse=new Array(); //Ethernet Ehouse status Array
var eHousePRO=new Array();      //ehouse pro servers
//create eHouse1 single Object and initialize data
//Global Constants for compatibility defined as VAR
var EHOUSE1_CONTROLLER=0;          //constant for eHouse1 controller index
var ETHERNET_CONTROLLER=1;          //constant for ethernet controller index
var MAX_EHOUSE1_DEVS=15,            //Maximal count of ehouse1 devices
    MAX_ETHERNET_EHOUSE_DEVS=15;    //Maximal count of EthernetEhoue devices
var MAX_EHOUSE_PRO_DEVS = 4;
var optimalizationnodes=new Array();  //global nodes for optimalization  


//var sstatus="\r\nB400C973000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002123000203070D000000000000000000021802350007030A000400040005000500F20006000603FF03FF03FF03FF03FF0400000000000000000000000000000000000000FF0F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009DE0000000000000000\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nB20101025F0246026E024A0262025E025F0260024A024D024F0257024A024D0259025118880001000000000000000000C008DE006DFEFE0101730000000000000000000000000000000100020004000700040003000100030002000500000001000200050003000320000000A8010000000000000000000000000000422440E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000EDF000000000000000000\r\n\r\nB2370203FF025C024603FD03FF03FF037003700B10000073FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3702730000000000000000000000000000000100020004000900020000000100030002000200030002000200030002000320000000A8010000000000000000000000000000422440E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011A3000000000000000000\r\nB2370303FF0260024A037C039803BD03D103610100000C00FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3703730000000000000000000000000000000100020004000700020000000100030002000200030002000200030002000320000000A8010000000000000000000000000000422440E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001052000000000000000000\r\n\r\nB2370503F30261026303FD01F2013600FF00000518800400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3705730000000000000000000000000000000100020004000700040003000100030002000200030002000200030002000320000000A8010000000000000000000000000000422440E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001114000000000000000000\r\nB2370603FF026303FE03690346033C0337029E8039000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3706730000000000000000000000000000000100020004000700040003000100030002000200030002000200030002000320000000A8010000000000000000000000000000422440E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001081000000000000000000\r\nB2370703FF025E03FE03BD03B003AD03A1034C102A000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3707730000000000000000000000000000000100020004000700040003000100030002000200030002000200030002000320000000A8010000000000000000000000000000422440E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001147000000000000000000\r\nB2370803FE026003FE03BF039903A703B903451810000000FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3708730000000000000000000000000000000100020004000700040003000100030002000200030002000200030002000320000000A8010000000000000000000000000000422440E60BFE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000112A000000000000000000\r\n\r\nB2370A0007026103FF03FF03FF03FF03FF03FF5F00000000FF00FFFF0000000000000000000000000000000000000000000000006DFEFE370A730000000000000000000000000000000100020004000700040003000100030002000200030002000200030002000320000000A8010000000000000000000000000000422440E60BFE00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000116C000000000000000000\r\nB2370B03AE025F026400CC018D01F202B103FF8500001C01FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE370B730000000000000000000000000000000100020004000700040003000100030002000500000001000200030002000320000000A8010000000000000000000000000000422440E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011B3000000000000000000\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n";
//var pagetitle = document.getElementsByTagName('title')[0];
var pagetitle = document.getElementsByTagName('title')[0] || (document.head||document.getElementsByTagName('head')[0]||document.documentElement).appendChild(document.createElementNS('http://www.w3.org/2000/svg','title'));
//title.textContent = 'foobar';

									//Maximal values for eHouse.PRO
var     EHOUSE_PRO_MAX_ADC=128,			//Analogue to digital converters - measurement inputs
        HALF_ADC=8,                             //if 1 all inputs taken if 2 => half (EHOUSE_PRO_MAX_ADC/HALF_ADC)
	EHOUSE_PRO_MAX_INPUTS=256,		//digital inputs 
        HALF_INPUTS=2,                          //if 1 all inputs taken if 2 => half (EHOUSE_PRO_MAX_INPUTS/HALF_INPUTS)
	EHOUSE_PRO_MAX_OUTPUTS=256,		//digital outputs
        HALF_OUTPUTS=2,                         //if 1 all inputs taken if 2 => half (EHOUSE_PRO_MAX_OUTPUTS/HALF_OUTPUTS)
	EHOUSE_PRO_MAX_DIMMERS=256,		//PWM DIMMERS
        HALF_DIMMERS=16,                        //if 1 all dimmers taken if 2 => half (EHOUSE_PRO_MAX_DIMMERS/HALF_DIMMERS)
	EHOUSE_PRO_INPUTS_ALL=0,		//256 inputs if >0 else 128
	EHOUSE_PRO_OUTPUTS_ALL=0,		//256 outpust if >0 else 128	
	EHOUSE_PRO_MAX_Future=180,                       //20B for future use
	EHOUSE_PRO_MAX_AdditionalInfo=256,              //Additional info for panels, audio playback status, video status
	EHOUSE_PRO_MARK="FF55FF55",		//ehouse.pro frame preamble mark
	EHOUSE_PRO_MARK_ADDR =0,		//ehouse pro frame address locations
        EHOUSE_PRO_ADDRH_ADDR =4,               //addrh - 192.168.addrh.addrl
	EHOUSE_PRO_ADDRL_ADDR =5,               //addrl
	EHOUSE_PRO_ADC_ADDR=6,                  //adcs
	EHOUSE_PRO_OUTPUTS_ADDR=EHOUSE_PRO_ADC_ADDR+2*EHOUSE_PRO_MAX_ADC,               //digital outputs
	EHOUSE_PRO_INPUTS_ADDR=EHOUSE_PRO_OUTPUTS_ADDR+(EHOUSE_PRO_MAX_OUTPUTS/8),      //inputs
	EHOUSE_PRO_HORN_ADDR=EHOUSE_PRO_INPUTS_ADDR+(EHOUSE_PRO_MAX_INPUTS/8),          //horn
	EHOUSE_PRO_WARNING_ADDR=EHOUSE_PRO_HORN_ADDR+(EHOUSE_PRO_MAX_INPUTS/8),         //warning
	EHOUSE_PRO_MONITORING_ADDR=EHOUSE_PRO_WARNING_ADDR+(EHOUSE_PRO_MAX_INPUTS/8),   //monitoring
	EHOUSE_PRO_SILENT_ADDR=EHOUSE_PRO_MONITORING_ADDR+(EHOUSE_PRO_MAX_INPUTS/8),    //silent
	EHOUSE_PRO_EARLYWARNING_ADDR=EHOUSE_PRO_SILENT_ADDR+(EHOUSE_PRO_MAX_INPUTS/8),  //early warning
	EHOUSE_PRO_SMS_ADDR=EHOUSE_PRO_EARLYWARNING_ADDR+(EHOUSE_PRO_MAX_INPUTS/8),     //sms
	EHOUSE_PRO_ALARM_ADDR=EHOUSE_PRO_SMS_ADDR+(EHOUSE_PRO_MAX_INPUTS/8),            //alarm
	EHOUSE_PRO_DIMMER_ADDR=EHOUSE_PRO_ALARM_ADDR+(EHOUSE_PRO_MAX_INPUTS/8),         //dimmer
	EHOUSE_PRO_PROGRAM_ADDR=EHOUSE_PRO_DIMMER_ADDR+(EHOUSE_PRO_MAX_DIMMERS),        //program
	EHOUSE_PRO_ADCPROGRAM_ADDR=EHOUSE_PRO_PROGRAM_ADDR+1,                           //adcprogram
	EHOUSE_PRO_ROLLERPROGRAM_ADDR=EHOUSE_PRO_PROGRAM_ADDR+2,                        //rollers programs
	EHOUSE_PRO_SECUZONE_ADDR=EHOUSE_PRO_PROGRAM_ADDR+3,                             //zone
	EHOUSE_PRO_HWOUTS_ADDR=EHOUSE_PRO_PROGRAM_ADDR+4,                               //hardware outs - alarm, warning, monitoring, early warning, horn, silent  etc
        EHOUSE_PRO_FUTURE_ADDR=EHOUSE_PRO_HWOUTS_ADDR+4,                                //future status
	EHOUSE_PRO_ADDINFO_ADDR=EHOUSE_PRO_FUTURE_ADDR+EHOUSE_PRO_MAX_Future;           //additional info

	
	
	
var None=0,IsRM=1,IsEM=2,IsHM=3,                            //eHouse 1 - device TYPE RoomManager,ExternalManager,HeatManager
IsERM=1,IsCommManager=2,IsLevelManager=3,IsEHM =4,IsEEM=5,  //Ethernet eHouse Device type EthernetRoomManager,CommManager,LevelManager,EthernetHeatManager
IsEHPRO=6,                                                  //eHousePRO Server		
//
//eHouse One status bytes location
    //eHouse1 Indexes offset
    STATUS_OFFSET=2,                       //offset for status locations in binary buffer
                                           //byte index location of binary status query results
    RM_STATUS_ADC                 = 1  + STATUS_OFFSET,    //start of adc measurement
    RM_STATUS_OUT                 = 17 + STATUS_OFFSET,    //RM start of outputs
    HM_STATUS_OUT                 = 33 + STATUS_OFFSET,    //HM start of outputs
    RM_STATUS_IN                  = 20 + STATUS_OFFSET,    //RM start of inputs
    RM_STATUS_INT                 = 21 + STATUS_OFFSET,    //rm start of inputs (fast)
    RM_STATUS_OUT25               = 22 + STATUS_OFFSET,    //rm starts of outputs => 25-32
    RM_STATUS_LIGHT               = 23 + STATUS_OFFSET,    //rm light level start
    RM_STATUS_ZONE_PGM            = 26 + STATUS_OFFSET,    //rm current zone
    RM_STATUS_PROGRAM             = 27 + STATUS_OFFSET,    //rm current program
    RM_STATUS_INPUTEXT_A_ACTIVE   = 28 + STATUS_OFFSET,    //em input extenders A status active inputs
    RM_STATUS_INPUTEXT_B_ACTIVE   = 32 + STATUS_OFFSET,    //em input extenders B status active inputs
    RM_STATUS_INPUTEXT_C_ACTIVE   = 36 + STATUS_OFFSET,    //em input extenders C status active inputs
    RM_STATUS_INPUTEXT_A          = 40 + STATUS_OFFSET,    //em --||-
    RM_STATUS_INPUTEXT_B          = 50 + STATUS_OFFSET,    //em 
    RM_STATUS_INPUTEXT_C          = 60 + STATUS_OFFSET,    //em 
    HM_STATUS_PROGRAM             = 36 + STATUS_OFFSET,    //hm current program
    HM_STATUS_KOMINEK             = 46 + STATUS_OFFSET,    //hm status bonfire
    HM_STATUS_RECU                = 48 + STATUS_OFFSET,    //hm status recu
    HM_WENT_MODE		  = 49 + STATUS_OFFSET,    //hm went mode
//Size of resources for eHouse controllers
    OUTPUTS_COUNT_RM              = 35,        //maximal number of outputs
    OUTPUTS_COUNT_ERM             = 80,//160,  //maximal nr of outputs for ethernet devices
    SENSORS_COUNT_RM              = 16,        //maximal number of ADCs
    SENSORS_COUNT_ERM             = 16,        //maximal number of ADCs for ethernet devices
    ALARM_SENSORS_COUNT_ERM       = 48,        //96 maximal number of alarm sensors for CM 
    INPUTS_COUNT_RM               = 16,        //maximal number of Inputs
    INPUTS_COUNT_ERM              = 48,//96,   //Maximal nr of inputs for ethernet devices
    DIMMERS_COUNT_RM              = 3;         //dimers count
    
                 
    // eHouse4Ethernet status location
    //Ethernet eHouse indexes CM, ERM,EHM
    //INDEXES in current status buffer (binary status information) / location information       
var STATUS_TCP_OFFSET           =2,     //offset in current status for data
    STATUS_COMMMANAGER_OFFSET   =70,    //offset for storing CommManager status attached to eHouse 1 devices status in hybrid mode
                                        //Ehouse1 under CommManager supervisor
//in reference to STATUS_COMMMANAGER_OFFSET each ethernet controllers
    STATUS_ADC_ETH		=0,    	//adc values * 2B
    STATUS_ADC_ETH_END		=32,    //end of adc values
        //STATUS_OUT_ETH		=STATUS_ADC_ETH_END;	//4*8 32		
        //STATUS_INPUTS			=STATUS_OUT_ETH+4;		//4*8 32		
    STATUS_OUT_I2C		=STATUS_ADC_ETH_END,        //i2c output buffers states  //max=160 outputs
    STATUS_INPUTS_I2C		=STATUS_OUT_I2C+20,         //i2c input buffers states //max 96 inputs
    STATUS_ALARM_I2C		=STATUS_INPUTS_I2C+12,      //--|--- for alarm states in case of CM
    STATUS_WARNING_I2C		=STATUS_ALARM_I2C+12,       //--|--- for warning states in case of CM
    STATUS_MONITORING_I2C       =STATUS_WARNING_I2C+12,     //--|--- for monitoring states in case of CM
    STATUS_PROGRAM_NR		=STATUS_MONITORING_I2C+12,  //--|--- for alarm states in case of CM
    STATUS_ZONE_NR		=STATUS_PROGRAM_NR+1,       //current program no.
    STATUS_ADC_PROGRAM		=STATUS_ZONE_NR+1,          //current adc program no.
    STATUS_LIGHT_LEVEL		=STATUS_ADC_PROGRAM+2;		//dimmer levels
//general options    
var OptimalizePerformance=false;//true; //performance will be optimized necessary for firefox
var IgnoreAtChar = 1;                   //ignore outputs,inputs, signals with @ char in names
var COMMMANAGER_HIGH=0;                 //CommManager High
var COMMMANAGER_LOW=254;                //CommManager Low
var EHOUSEPRO_HIGH=0;			//ehousePRO HIGH addr
var EHOUSEPRO_LOW=200;			//eHousePRO LOW addr
var INITIAL_OFFSET_ERM=200;             //Offset of EHM,ERM address
var MCP9700_Offset=-500.0;          //Offset voltage at 0C [mV] global iing can be replace for array for individual calibration
var MCP9701_Offset=-400.0;          //Offset voltage at 0C [mV] global setting can be replace for array for individual calibration
var MCP9700x=10000.0;               // uV/C global setting can be replace for array for individual calibration
var MCP9701x=19500.0;               // uV/C global setting can be replace for array for individual calibration
var HEATER_KOMSTAT="";              //bonfire status
var HEATER_RECUPERATOR_MODE="";     //recuperation status
var HEATER_RECUPERATOR_SPEED="";    //recuperator speed
var HEATER_RECUPERATOR_TEMP="";     //recu temp
var HEATER_PROGRAM="";              //heatmanager program
var EXTERNAL_CURRENTZONENAME="";    //External Manager zone name
var EXTERNAL_CURRENTPROGRAM="";     //External Manager â€“ Program roller NR
var EXTERNAL_CURRENTPROGRAMNAME=""; //External Manager â€“ roller program name
var EXTERNAL_CURRENTZONE="";        //External Manager â€“ current zone Nr

//size of eHouse1 controllers
//Initialization of instances at start
for (var ii=0;ii<MAX_ETHERNET_EHOUSE_DEVS+1;ii+=1)      //Last for CommManager, EthernetEhouse[0] - for EthernetHeatManager
    EthernetEhouseCreate(ii);
for (var ii=0;ii<MAX_EHOUSE1_DEVS+1;ii+=1)  //last for update of CM
    eHouse1Create(ii);
for (var ii=0;ii<MAX_EHOUSE_PRO_DEVS+1;ii+=1)  //last for update of CM
    eHousePROCreate(ii);

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function SetTitle(title)
{
//var pagetitle = 
        document.getElementsByTagName('title')[0].textContent=title;
        
                //|| (document.head||document.getElementsByTagName('head')[0]||document.documentElement).appendChild(document.createElementNS('http://www.w3.org/2000/svg','title'));    
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function AddTitle(title)
{
//var pagetitle = 
        document.getElementsByTagName('title')[0].textContent=document.getElementsByTagName('title')[0].textContent+" > "+title;
        
                //|| (document.head||document.getElementsByTagName('head')[0]||document.documentElement).appendChild(document.createElementNS('http://www.w3.org/2000/svg','title'));    
}

//Test initial data for visualization 
function TestEhouse()
{	//update status
var ii=0;//status received as text from html get/post method    
for (ii=0;ii<MAX_EHOUSE1_DEVS;ii++)
    eHouse1[ii].PrevStat="";
for (ii=0;ii<MAX_ETHERNET_EHOUSE_DEVS+1;ii++)      //Last for CommManager, EthernetEhouse[0] - for EthernetHeatManager
    EthernetEhouse[ii].PrevStat="";
for (ii=0;ii<MAX_EHOUSE_PRO_DEVS;ii++)      //Last for CommManager, EthernetEhouse[0] - for EthernetHeatManager
    eHousePRO[ii].PrevStat="";

//ajax('/eh.x?eHGlobalStatus',"", getComplete);   automatic query status
//getComplete("");
/*
//Dummy status data from controllers for testing without eHouse uControllers 
  
eHouse1[0].Stat='B201010268025C02750248025B025C02580261025D0277024D025D024B024B0256024F18080001000000000000000000C000DE006DFEFE0101730000000000000000000000000000000000020002000B00030001000100000001000200020000000000010003000320000000A8010000000000000000000000000000632400E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E';
eHouse1[1].Stat='B23701002B025F026103FF03FF03FF03FF03FF5555010000FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3701730000000000000000000000000000000500020000000500010001000200010002000200030001000200010003000120000000A8010000000000000000000000000000432440E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012';
eHouse1[2].Stat='B2370203AE025E025803FE03FF03FF022D01640810000073FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3702730000000000000000000000000000000200000001000900010002000400010003000300030002000100010004000320000000A8010000000000000000000000000000422400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';
eHouse1[3].Stat='B237030044025F025B039E039803ED03FF036C0000000C00FFFFFFFF0018000000000000000000000000000000000000000000006DFEFE3703730000000000000000000000000000000000020001000500030001000100010003000300030001000200030002000220000000A8010000000000000000000000000000422400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';
eHouse1[5].Stat='B2370503F20261026403FC012500C800C900000018000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3705730000000000000000000000000000000000010003000800010001000300010002000200010004000100020000000420000000A8010000000000000000000000000000422400E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000F';
eHouse1[6].Stat='B2370603D1026703FE03C6039A0369033C02998038000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3706730000000000000000000000000000000100040003000700000002000300040004000100020004000400020004000320000000A8010000000000000000000000000000422400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';
eHouse1[7].Stat='B23707002C026403FD03C903A303D603B503461028000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3707730000000000000000000000000000000100040003000800010003000100010003000200030000000000030001000120000000A8010000000000000000000000000000622401E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';
eHouse1[8].Stat='B2370803BD026103FE03D003BE03B803A2030F1810000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3708730000000000000000000000000000000300020002000600000003000400020002000200030003000300030002000420000000A8010000000000000000000000000000622601E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';
eHouse1[10].Stat='B2370A00BA026403FF03FF03FF03FF03FF03FF1600000000FF00FFFF0000000000000000000000000000000000000000000000006DFEFE370A730000000000000000000000000000000300010004000700010002000200030001000100020003000100000000000220000000A8010000000000000000000000000000C22400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012';
eHouse1[11].Stat='B2370B03AD02600264027C027501F1015F00A20000001C00FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE370B730000000000000000000000000000000200020000000600000002000300010004000200010002000200020001000420000000A8010000000000000000000000000000632400E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000F';
eHouse1[1].Stat='B237010016025E026003FF03FF03FF03FF03FF0000000000FFFFFFFF0005000000000000000000000000000000000000000000006DFEFE3701730000000000000000000000000000000000020004000500020002000300020003000100030001000300010003000220000000A8010000000000000000000000000000432440E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011';
perform dummy status and assign matrixes of ehouse1 controllers + CommManager
*/
/*
eHouse1[0].Stat='B201010268025C02750248025B025C02580261025D0277024D025D024B024B0256024F18080001000000000000000000C000DE006DFEFE0101730000000000000000000000000000000000020002000B00030001000100000001000200020000000000010003000320000000A8010000000000000000000000000000632400E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E';
eHouse1[0].Stat='B20101026B02590281024C0273026902700268025E026202520264024C0251025C025418880001000000000000000000C008DE006DFEFE0101730000000000000000000000000000000400020001000A00000002000200030003000200020002000100030002000120220000A8010000000000000000000000000000422400E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000F';

eHouse1[1].Stat='B23701002B025F026103FF03FF03FF03FF03FF5555010000FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3701730000000000000000000000000000000500020000000500010001000200010002000200030001000200010003000120000000A8010000000000000000000000000000432440E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012';
eHouse1[1].Stat='B2370100000266026903FF03FF03FF03FF03FFFD3F000000FFFFFFFF0001000000000000000000000000000000000000000000006DFEFE3701730000000000000000000000000000000400020001000A00000002000200030003000200020002000100020002000120220000A8010000000000000000000000000000422400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012';

eHouse1[2].Stat='B2370203AE025E025803FE03FF03FF022D01640810000073FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3702730000000000000000000000000000000200000001000900010002000400010003000300030002000100010004000320000000A8010000000000000000000000000000422400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';
eHouse1[2].Stat='B2370203FF0263025903FE03FF03FF022C016C0F10000073FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3702730000000000000000000000000000000000020001000A00000002000200030003000200020002000100020002000420220000A8010000000000000000000000000000422400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011';

eHouse1[3].Stat='B237030044025F025B039E039803ED03FF036C0000000C00FFFFFFFF0018000000000000000000000000000000000000000000006DFEFE3703730000000000000000000000000000000000020001000500030001000100010003000300030001000200030002000220000000A8010000000000000000000000000000422400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';
eHouse1[3].Stat='B2370303FE0265025E0334035103FF03DA032E0200000C00FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3703730000000000000000000000000000000400020001000400010001000100010002000300040000000100030005000120220000A8010000000000000000000000000000422400E40BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000F';

eHouse1[5].Stat='B2370503F20261026403FC012500C800C900000018000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3705730000000000000000000000000000000000010003000800010001000300010002000200010004000100020000000420000000A8010000000000000000000000000000422400E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000F';
eHouse1[5].Stat='B2370503F10268026703FC01A601B501DD006C0518000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3705730000000000000000000000000000000000040002000900010002000200030003000200020002000100020002000420220000A8010000000000000000000000000000422400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';

eHouse1[6].Stat='B2370603D1026703FE03C6039A0369033C02998038000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3706730000000000000000000000000000000100040003000700000002000300040004000100020004000400020004000320000000A8010000000000000000000000000000422400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';
eHouse1[6].Stat='B2370603FE026C03FE039E03A603B403BD03A08039000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3706730000000000000000000000000000000400020002000800040001000100010002000300040000000100030005000120220000A8010000000000000000000000000000422400E40BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011';

eHouse1[7].Stat='B23707002C026403FD03C903A303D603B503461028000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3707730000000000000000000000000000000100040003000800010003000100010003000200030000000000030001000120000000A8010000000000000000000000000000622401E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';
eHouse1[7].Stat='B2370703ED026803FE03DA03B90395037302D6112A000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3707730000000000000000000000000000000400020002000800040003000100010002000300040000000100030005000120220000A8010000000000000000000000000000422402E40BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011';

eHouse1[8].Stat='B2370803BD026103FE03D003BE03B803A2030F1810000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3708730000000000000000000000000000000300020002000600000003000400020002000200030003000300030002000420000000A8010000000000000000000000000000622601E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';
eHouse1[8].Stat='B2370803FE026703FE039003A703C503C503091810000400FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3708730000000000000000000000000000000500010003000600030002000200030002000200020001000100050002000520220000A8010000000000000000000000000000422400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010';

eHouse1[10].Stat='B2370A00BA026403FF03FF03FF03FF03FF03FF1600000000FF00FFFF0000000000000000000000000000000000000000000000006DFEFE370A730000000000000000000000000000000300010004000700010002000200030001000100020003000100000000000220000000A8010000000000000000000000000000C22400E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012';
eHouse1[10].Stat='B2370A0032026C03FF03FF03FF03FF03FF03FF5F00000000FF00FFFF0000000000000000000000000000000000000000000000006DFEFE370A730000000000000000000000000000000400020002000800040003000100010002000300040000000100030005000120220000A8010000000000000000000000000000422402E40BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011';

eHouse1[11].Stat='B2370B03AD02600264027C027501F1015F00A20000001C00FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE370B730000000000000000000000000000000200020000000600000002000300010004000200010002000200020001000420000000A8010000000000000000000000000000632400E60BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000F';
eHouse1[11].Stat='B2370B03FF02670265031D006500AB014402218000001C00FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE370B730000000000000000000000000000000400020002000800040003000100020002000200020003000100030005000120220000A8010000000000000000000000000000422400E40BFE000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000F';

GetEhouse1Status(0);
GetEhouse1Status(1);
GetEhouse1Status(2);
GetEhouse1Status(3);
GetEhouse1Status(5);
GetEhouse1Status(6);
GetEhouse1Status(7);
GetEhouse1Status(8);
GetEhouse1Status(10);
GetEhouse1Status(11);
*/




//Dummy test of Ethernet eHouse controller
//EthernetEhouse[1].Stat='B400C97300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000250D170C04060D0000000000000000000218023400070309000400040004000400F1000503EB03FF03FF03FF03FF03FFAAAAAAAA00000000000000000000000000000000FF0F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000D';
//GetEthernetEhouseStatus(1);
//GetEthernetEhouseStatus(MAX_ETHERNET_EHOUSE_DEVS);
//GetEthernetEhouseStatus(0);
//Dummy test of Ethernet eHouse controller
eHousePRO[0].Stat="FF55FF5500C8000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005555555555555555555555555555551500000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000000000000000000000FFFEDFFDFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFEDFFDFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000555555555555555555555555555555150000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
GetEhousePROStatus(0);
}
//////////////////////////////////////////////////////////////////////////////////
function InitializeObjects()
{
    var ii=0;
    var address='0101';   
//var initialname=document.childNodes[0].childNodes.item(100);//childNodes[0];
//document.item(100).name;
//.DOM[100].nodeValue.name;//document.all.item(100).name;
//attributes["name"].value;    
//alert (initialname);
//FindFirstNode("3701010100");
if (!Optimalize) return;   
for (ii=0;ii<MAX_ETHERNET_EHOUSE_DEVS;ii++)      //Last for CommManager, EthernetEhouse[0] - for EthernetHeatManager
    {
//    EthernetEhouseCreate(ii);
    address=d2h(COMMMANAGER_HIGH)+d2h(INITIAL_OFFSET_ERM+ii);    
    EthernetEhouse[ii].PrevStat=ii;
    EthernetEhouse[ii].Stat='B2'+address+'0268025C02750248025B025C02580261025D0277024D025D024B024B0256024F0000000000000000000000000000000000000000000000000000000000000000000000000000020002000B00030001000100000001000200020000000000010003000320000000A80100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E';
    //GetEthernetEhouseStatus(ii);    
    hex2binEth(ii);                 //convert text - hex status to binary data -> eHouse1[index].BinStat;
    DecodeEthernetEhouseStatus(ii); //decode status of eHouse1 controller from binary status data
    VisualEthernetEhouse(ii);
    }
ii=MAX_ETHERNET_EHOUSE_DEVS;        //ONe additional instance for CommManager
//EthernetEhouseCreate(ii);
address=d2h(COMMMANAGER_HIGH)+d2h(COMMMANAGER_LOW);    
EthernetEhouse[ii].PrevStat=ii;
EthernetEhouse[ii].Stat='B2'+address+'0268025C02750248025B025C02580261025D0277024D025D024B024B0256024F0000000000000000000000000000000000000000000000000000000000000000000000000000020002000B00030001000100000001000200020000000000010003000320000000A80100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E';
hex2binEth(ii);                     //convert text - hex status to binary data -> eHouse1[index].BinStat;
DecodeEthernetEhouseStatus(ii);     //decode status of eHouse1 controller from binary status data
VisualEthernetEhouse(ii);

for (ii=0;ii<MAX_EHOUSE1_DEVS;ii++)
    {       
//    eHouse1Create(ii);;
    eHouse1[ii].PrevStat=ii;
    eHouse1[ii].Stat='B2'+address+'0268025C02750248025B025C02580261025D0277024D025D024B024B0256024F0000000000000000000000000000000000000000000000000000000000000000000000000000020002000B00030001000100000001000200020000000000010003000320000000A80100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000E';        
    hex2bin(ii);         //convert text - hex status to binary data -> eHouse1[index].BinStat;
    DecodeEh1Status(ii); //decode status of eHouse1 controller from binary status data
    VisualEhouse1(ii); 
    address='37'+d2h(ii+1);
    }
    
if (Optimalize) OptimalizePerformance=true;
else  OptimalizePerformance=false;
Optimalize=false;    
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//decode binary status to data and put to eHouse1[index]
function GetEhouse1Status(index)
{
if (eHouse1[index].PrevStat===eHouse1[index].Stat) return;   //the same data - no update from recent call
eHouse1[index].PrevStat=eHouse1[index].Stat;                //Update Previous state to ignore if no data reception for current controller
if (eHouse1[index].Stat.length<100) return;
//if (EHOUSE1_VIA_CM)   //if eHouse under commManager supervision

hex2bin(index);         //convert text - hex status to binary data -> eHouse1[index].BinStat;
DecodeEh1Status(index); //decode status of eHouse1 controller from binary status data
VisualEhouse1(index);    //visualization update
//ShoweHouse1Status(index); //show xml status
}
///////////////////////////////////////////////////////////////////////////////
function st(text)
{
window.status=text;
//top.document.title=text;
SetTitle(text);
}
/////////////////////////////////////////////////////////////////////////////////
// Firefox and opera do not support function getElementsByName
//
// We are doing workaround but it could cause less efficient then native function in Browsers where it is supported
//
var NODE_JUMP=20;
function GetElementsByName(str)
{
var Firefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
var Opera = /opera/i.test(navigator.userAgent);
if (!Opera && !Firefox)
    return document.getElementsByName(str.trim());
else 
    return document.getElementsByClassName(str.trim());
}
///////////////////////////////////////////////////////////////////////////////
var xhr = new XMLHttpRequest();
var CurrentIndexBinaryStatus=0;
//convert text-hex coded status string to binary for eHouse1[index] controller
function hex2bin(index)
{
var temp_length=eHouse1[index].Stat.length,
    tmp=eHouse1[index].Stat,
 m=0,
 i=0,
 k=0; 
 for (i=0;i<temp_length;i+=2)
     {
         m=parseInt(tmp[i], 16)*16+parseInt(tmp[i+1],16);   //decode hex values eg 'FE' to binary data
         if (i===0) eHouse1[index].Size=m;
             {
             if (k===1) eHouse1[index].AddrH=m;
             if (k===2) eHouse1[index].AddrL=m;
             eHouse1[index].BinStat[k]=m;
//            if (EHOUSE1_VIA_CM)             
  //               EthernetEhouse[MAX_ETHERNET_EHOUSE_DEVS].BinStat[k]=m;
             k++;
             }
     }
     //Decode eHouse1 device type by address
     if (eHouse1[index].AddrH===1) eHouse1[index].Type=IsHM;
     if (eHouse1[index].AddrH===2) eHouse1[index].Type=IsEM;
     if (eHouse1[index].AddrH===55) eHouse1[index].Type=IsRM;     
     if (eHouse1[index].Type>0)             //type eHouse1 RM|HM|EM
            if (EHOUSE1_VIA_CM)             //if eHouse1 under CommManager supervision
                {                           //status of CommManager are attached so we imediatelly perform it
                EthernetEhouse[MAX_ETHERNET_EHOUSE_DEVS].AddrH=COMMMANAGER_HIGH;     //Overwrite CommManager Address over eHouse1 Addr
                EthernetEhouse[MAX_ETHERNET_EHOUSE_DEVS].AddrL=COMMMANAGER_LOW;  
                EthernetEhouse[MAX_ETHERNET_EHOUSE_DEVS].Type=IsCommManager;        //type CommManager
                EthernetEhouse[MAX_ETHERNET_EHOUSE_DEVS].Stat=eHouse1[index].Stat;  //Copy TextStatus
                if (UseeHGlobalStatus===0)             //if not used from eHouse4cServer
                    GetEthernetEhouseStatus(MAX_ETHERNET_EHOUSE_DEVS);                  //Perform CommManager status update                
                }
}
//////////////////////////////////////////////////////////////////////////////////
//Hex 2 bin Ethernet Version decode status > store to EthernetEhouse[index]
function hex2binEth(index)
{
var temp_length=EthernetEhouse[index].Stat.length,
    tmp=EthernetEhouse[index].Stat,
    m=0,
    i=0,
    k=0,str=""; 
 while (i<temp_length)
     {
        str=tmp[i]+tmp[i+1];
         m=parseInt(str, 16);       //decode hex values eg 'FE' to binary data
         if (k===0) EthernetEhouse[index].Size=m;
             {
             if (k===1) EthernetEhouse[index].AddrH=m;
             if (k===2) EthernetEhouse[index].AddrL=m;
             EthernetEhouse[index].BinStat[k]=m;
             k++;
             }
             i=i+2;
     }
     EthernetEhouse[index].Type=IsERM;
     if (EthernetEhouse[index].AddrL>=250) EthernetEhouse[index].Type=IsCommManager;                       
     //if Ehouse1 under CommManager supervision
     if ((EthernetEhouse[index].AddrH===2) || (EthernetEhouse[index].AddrH===55) || (EthernetEhouse[index].AddrH===1)) 
        {   //assign  CM address  
            EthernetEhouse[index].AddrH=COMMMANAGER_HIGH;
            EthernetEhouse[index].AddrL=COMMMANAGER_LOW;
            EthernetEhouse[index].Type=IsCommManager;
        }
}
////////////////////////////////////////////////////////////////////////////////
//Hex 2 bin eHousePRO Version decode status > store to eHousePRO[index]
function hex2binPRO(index)
{
var temp_length=eHousePRO[index].Stat.length,
    tmp=eHousePRO[index].Stat,
    m=0, i=0, k=0,str="";
 
 while (i<temp_length)
     {
        str=tmp[i]+tmp[i+1];
        m=parseInt(str, 16);       //decode hex values eg 'FE' to binary data
        if (k===0) eHousePRO[index].Size=2000;
             {
             if (k===EHOUSE_PRO_ADDRH_ADDR) eHousePRO[index].AddrH=m;
             if (k===EHOUSE_PRO_ADDRL_ADDR) eHousePRO[index].AddrL=m;
             eHousePRO[index].BinStat[k]=m;
             k++;
             }
        i=i+2;
     }
eHousePRO[index].Type=IsEHPRO;
//if (EhousePro[index].AddrL>=250) EthernetEhouse[index].Type=IsCommManager;                       
//if Ehouse1 under CommManager supervision
/*     if ((EhousePRO[index].AddrH===2) || (EhousePRO[index].AddrH===55) || (EhousePRO[index].AddrH===1)) 
        {   //assign  CM address  
            EthernetEhouse[index].AddrH=COMMMANAGER_HIGH;
            EthernetEhouse[index].AddrL=COMMMANAGER_LOW;
            EthernetEhouse[index].Type=IsCommManager;
        }
*/
}


//////////////////////////////////////////////////////////////////////////////////
//Get templm35 temperature sensor value
function gettemplm35(dta,VCC)
    {
    var temp;
    temp=(dta*VCC/(1023*10));
//t=Math.Round(temp*10);
//temp=(t/10);
    temp = Math.round(temp*10);
    temp/=10;
    return temp;
    }

////////////////////////////////////////////////////////////////////////
//binary to hex coded string decoding
function d2h(tmp)
{
var table="0123456789ABCDEF",
 res="",
temp=tmp&0x0f,
temp2=tmp>>4;
res=table[temp2]+table[temp];
return res;
}
///////////////////////////////////////////////////////////////////////////////
// convert to hex string
//
///////////////////////////////////////////////////////////////////////////////  
function hix(str,size)
    {
        var res="";
        for (var i=0;i<size;i++)
            {
            c = str[i];                
            res += d2h(c) + '';    
            
            }
    return res;            
    }
//////////////////////////////////////////////////////////////////////////////////    
function hexToString (tmp) 
    {
    var arr = tmp.split(' '),
    str = '',
    i = 0,
    arr_len = arr.length,
    c;
    for (; i < arr_len; i += 1) 
        {
        c = String.fromCharCode( h2d( arr[i] ) );
        str += c;
        }
    document.writeln(str);
    return str;
    }

//Send status query request for controller Index
////////////////////////////////////////////////////////////////////////////////
function GetStatus(i)
{
    CurrentIndexBinaryStatus=i;

xhr.open('GET', '/eh?'+CurrentIndexBinaryStatus, true);
xhr.responseType = 'arraybuffer';
};
//Event on reception response
xhr.onload = function(e) {
var Uint8Array=new Uint8Array(this.response);
for (i=0;i<SizeOf(Uint8Array);i+=2)
    StatusMatrixEhouseOne[CurrentIndexBinaryStatus];
};
/////////////////////////////////////////////////////
//Get True/False Value of current output / input / etc - logical state
function GetInOutValue(dta, offset)
    {
    var temp=dta>>offset;
    if ((temp & 0x01)>0) 
            return true;
    else return false;
    }
////////////////////////////////////////////////////////////////////////////////
function DecodeEh1Status(index)

        { 
        var    i=0,k=0,
        Max_ADC = 8;

//        Calendar c = Calendar.getInstance(); 
  //      recent=c.getTime().toLocaleString();
     
 //       if (changed) //data changed or unconditional
        {   //update data
    
        if ((eHouse1[index].Type===IsRM) || (eHouse1[index].Type===IsEM)) 
            {
            Max_ADC=8;           
            for (k = 0; k < 8; k++) //update output and input states and visualization objects
                {
                    
                    eHouse1[index].Outs[k]      = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_OUT]&0xff, k); //outputs
                    eHouse1[index].Outs[k + 8]  = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_OUT + 1]&0xff, k); 
                    eHouse1[index].Outs[k + 16] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_OUT + 2]&0xff, k); 
                    eHouse1[index].Outs[k + 24] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_OUT25]&0xff, k); 
                    eHouse1[index].Inputs[k]    = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_IN]&0xff, k);  //inputs
                    eHouse1[index].Inputs[k+8]  = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INT]&0xff, k);
                if (eHouse1[index].Type===IsEM)   //for em additionally update input extenders alarm sensor inputs states and visualization objects
                    {
                    eHouse1[index].AlarmSensorsActive[k] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A_ACTIVE]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 8] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A_ACTIVE + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 16] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A_ACTIVE + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 24] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A_ACTIVE + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 32] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A + 4]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 40] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B_ACTIVE + 0]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 48] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B_ACTIVE + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 56] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B_ACTIVE + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 64] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B_ACTIVE + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 72] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 4]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 80] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_C_ACTIVE + 0]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 88] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_C_ACTIVE + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 96] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_C_ACTIVE + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 104] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_C_ACTIVE + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 112] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_C + 4]&0xff, k);

                    eHouse1[index].AlarmSensorsAlarm[k] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 8] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 16] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 24] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 32] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A + 4]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 40] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 0]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 48] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 56] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 64] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 72] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 4]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 80] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 0]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 88] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 96] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 104] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 112] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 4]&0xff, k);
                    }
                }

            eHouse1[index].CurrentProgram=eHouse1[index].BinStat[RM_STATUS_PROGRAM]&0xff;    //update current program nr
            eHouse1[index].CurrentZone = eHouse1[index].BinStat[RM_STATUS_ZONE_PGM]&0xff;    //update current zone
            }
        
        if (eHouse1[index].Type===IsHM)   //heatmanager
            {
            Max_ADC=16;
            eHouse1[index].CurrentProgram = eHouse1[index].BinStat[HM_STATUS_PROGRAM]&0xff;  //current program for heatmanager
            for (k = 0; k < 8; k++) //update output states and visualization objects
                {
                eHouse1[index].Outs[k] = GetInOutValue(eHouse1[index].BinStat[HM_STATUS_OUT]&0xff, k);
                eHouse1[index].Outs[k + 8] = GetInOutValue(eHouse1[index].BinStat[HM_STATUS_OUT + 1]&0xff, k);
                eHouse1[index].Outs[k + 16] = GetInOutValue(eHouse1[index].BinStat[HM_STATUS_OUT + 2]&0xff, k);
                eHouse1[index].Outs[k + 24] =false;
                eHouse1[index].Inputs[k ] =false;
                eHouse1[index].Inputs[k + 8] =false;
                }
            }
        i=0;
        while (i < Max_ADC)         //perform all adc results (2bytes per result)
                {                                               //offset od 2                       //offset od 2
                //int temppp=(CurrentStatus[i * 2 + 2] << 8) + CurrentStatus[i * 2 + 1 + 2];
                var temppp= eHouse1[index].BinStat[i * 2 + RM_STATUS_ADC+1 ]&0xff;
                if (temppp<0) temppp+=256;
                temppp+=((eHouse1[index].BinStat[RM_STATUS_ADC+i * 2 ]&0xff) << 8);
                eHouse1[index].ADCs[i] = temppp;    //update value
                eHouse1[index].SensorTemps[i] = gettemplm(temppp, eHouse1[index].Calibration[i], 10, eHouse1[index].VCC);    //calculate temp value
               //SensorLights[i] = getlight(temppp); //calculate light level value
                eHouse1[index].SensorPercents[i] = calculate_percent(temppp);  //calculate percent value
                eHouse1[index].SensorLights[i]=100- eHouse1[index].SensorPercents[i];
                eHouse1[index].SensorVolts[i]=calculate_voltage(temppp,eHouse1[index].VCC);
                i++;
               }
        //for (var ii=0;ii<DIMMERS_RGB_COUNT_RM;ii++) 
            eHouse1[index].DimmerRGB=0;
        
        for (var ii=0;ii<DIMMERS_COUNT_RM;ii++)         //set dimmer values for single dimmer and RGB consists of 3 single
            {
             eHouse1[index].DimmerRGB[ii/3]= eHouse1[index].BinStat[RM_STATUS_LIGHT+(ii%3)]&0xff;
            if ((ii%3)!==2) 
                     eHouse1[index].DimmerRGB[ii/3]= eHouse1[index].DimmerRGB[ii/3]<<8;
             eHouse1[index].Dimmers[ii]=  eHouse1[index].BinStat[RM_STATUS_LIGHT+(ii)]&0xff;
             }
        
        }
        }
////////////////////////////////////////////////////////////////////////////////////////
//Calculate Temperature for MCP9700 sensor for Ethernet eHouse controllers 
function calculate_MCP9700Eth(dta,VCC,Calibration)
            {
            var tmp = (((dta *  VCC ) / 1023))+Calibration;
             //get temp in [C]
            tmp=(Math.round((tmp/MCP9700x)*10*1000)*1.0)/10;
            return tmp;
            }
/////////////////////////////////////////////////////////////////////////
//Calculate Temperature for MCP9701 sensor for Ethernet eHouse controllers 
function calculate_MCP9701Eth(dta,VCC,Calibration)
            {
            var tmp = (((dta *  VCC ) / 1023))+Calibration;//MCP9701_Offset ;
             //get temp in [C]
            tmp=(Math.round((tmp/MCP9701x)*10*1000)*1.0)/10;
            return tmp;
            }        
///calculate LM335 termometer value + consider calibration
function gettemplm(dta, calibration, k, VCC)
    {
    var temp=0.00;
    temp=(dta*VCC/(1023*k))+calibration/100;
    temp = (((Math.round(temp*10))*1.0)/10);
    return temp;
    }
///////////////////////////////////////////////////////////////////////////////    
//    calculate percent value
function calculate_percent(dta)
            {
            return (Math.round(((dta * 100 ) / 1023)*100))/100;  //rounding to  2 digits of fractional part
            }
////////////////////////////////////////////////////////////////////////////////            
//calculate voltage comparing to VCC
function calculate_voltage(dta,VCC)
            {
            var tmp = Math.round(((dta *  VCC ) / 1023)*100);//up ot  2 decimal fractional digits
            tmp=tmp/100000;
            return tmp;
            }
/////////////////////////////////////////////////////////////////////////////////////
/// Execute event via email 2 functions
/////////////////////////////////////////////////////////////////////////////////////
function x(text)
{
//window.open('em.php?x='+text+'&m=ftp','Sending Event: '+text,'width=750,height=200,resizable=yes,scrollbars=yes,toolbar=no,location=no,directories=no,status=yes,menubar=no,copyhistory=no');
//top.document.title=text;
SetTitle(text);
ajax("/eh.x?eHEvents="+text,"",ConfirmationEventSend);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function exec(name,state,newstate,event,directevent)
{
    
//top.document[0].title=name;
SetTitle(name);
ajax("/eh.x?eHEvents="+directevent,name,ConfirmationEventSend);    
//window.open('em.php?x='+directevent,'Sending Event: '+name,'width=750,height=200,resizable=yes,scrollbars=yes,toolbar=no,location=no,directories=no,status=yes,menubar=no,copyhistory=no');
}

///////////////////////////////////////////////////////////////////////////////////////////
function X(name)
{
//top.document.title=name;    
SetTitle(name);
ajax("/eh.x?eHEvents="+name,name,ConfirmationEventSend);        
//window.open('em.php?x='+name,'Sending Event: '+name,'width=750,height=200,resizable=yes,scrollbars=yes,toolbar=no,location=no,directories=no,status=yes,menubar=no,copyhistory=no');
}

////////////////////////////////////////////////////////////////////////////////////
//svg draw circle
////////////////////////////////////////////////////////////////////////////////////
function c(x,y,rad,width,color,bkcolor,name,StatusIndex,ID,event,directevent)
{
var C=document.createElementNS(xmlns,"circle");
var Attr={r:rad,
	cx:x,
	cy:y,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":ID,
        "name":StatusIndex,
        "class":StatusIndex,
        "alt":name+" ("+directevent+")",
        "title":name+" ("+directevent+")",
	"stroke-width":width,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+StatusIndex+"','"+ID+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	};
assignAttr(C,Attr);
   if (bkcolor==="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity); 
Root.appendChild(C);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//svg draw elipse
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//e('27.373cm','15.695cm','0.533cm','0.533cm',"0.01cm",'#DA251D','#E77817','Zabezpieczenia - (Warning)','00FE7B6000','1','Zabezpieczenia - (Warning)','00fe6300000000000000');
function e(x,y,_rx,_ry,width,color,bkcolor,name,StatusIndex,ID,event,directevent){
var C=document.createElementNS(xmlns,"ellipse");
var Attr={rx:_rx,
	ry:_ry,
	cx:x,
	cy:y,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
        "name":StatusIndex,
        "class":StatusIndex,
        "alt":name+" ("+directevent+")",
        "title":name+" ("+directevent+")",
	"id":ID,
	"stroke-width":width,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+StatusIndex+"','"+ID+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	};
assignAttr(C,Attr);
   if (bkcolor==="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//svg draw rectangle
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//r('7.422cm','13.186cm','0.139cm','0.121cm','0.01cm','#1F1A17','#FFF500','Warning - Robert K (1)','00FE7B1A01','4','Warning - Robert K (1)','00fe6300000000000000');
function r(_x,_y,_width,_height,penwidth,color,bkcolor,name,StatusIndex,ID,event,directevent){
var C=document.createElementNS(xmlns,"rect");
var Attr={
	 width:_width,
	 height:_height,
	 x:_x,
	 y:_y,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":ID,
        "name":StatusIndex,
        "class":StatusIndex,
        "alt":name+" ("+directevent+")",
        "title":name+" ("+directevent+")",
	"stroke-width":penwidth,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+StatusIndex+"','"+ID+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	};
assignAttr(C,Attr);
   if (bkcolor==="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//svg draw rounded rectangle
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function rr(_x,_y,_width,_height,_rx,_ry,penwidth,color,bkcolor,name,StatusIndex,ID,event,directevent){
var C=document.createElementNS(xmlns,"rect");
var Attr={width:_width,
	height:_height,
	rx:_rx,
	ry:_ry,
	x:_x,
	y:_y,
	"name":StatusIndex,
        "class":StatusIndex,
        "alt":name+" ("+directevent+")",
        "title":name+" ("+directevent+")",
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":ID,
	"stroke-width":penwidth,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+StatusIndex+"','"+ID+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	};
assignAttr(C,Attr);
   if (bkcolor==="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//svg draw line
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function l(_x1,_y1,_x2,_y2,penwidth,color,bkcolor,name,StatusIndex,ID,event,directevent){
var C=document.createElementNS(xmlns,"line");
var Attr={
	 x2:_x2,
	 y2:_y2,
	 x1:_x1,
	 y1:_y1,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":ID,
        "name":StatusIndex,
        "class":StatusIndex,
        "alt":name+" ("+directevent+")",
        "title":name+" ("+directevent+")",
	"stroke-width":penwidth,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+StatusIndex+"','"+ID+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	};
assignAttr(C,Attr);
if (bkcolor==="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity); 
Root.appendChild(C);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//svg draw closed path 
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function p(_points,penwidth,color,bkcolor,name,StatusIndex,ID,event,directevent){
var C=document.createElementNS(xmlns,"path");
var Attr={
	 "d":_points,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke-opacity":stroke_opacity,
	"stroke": color,
	"id":ID,
        "name":StatusIndex,
        "class":StatusIndex,
        "alt":name+" ("+directevent+")",
        "title":name+" ("+directevent+")",
	"stroke-width":penwidth,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+StatusIndex+"','"+ID+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	};
assignAttr(C,Attr);
   if (bkcolor==="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//svg draw polyline
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function pl(_points,penwidth,color,bkcolor,name,StatusIndex,ID,event,directevent){
var C=document.createElementNS(xmlns,"polyline");
var Attr={"points":_points,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":ID,
        "name":StatusIndex,
        "class":StatusIndex,
        "alt":name+" ("+directevent+")",
        "title":name+" ("+directevent+")",
	"stroke-width":penwidth,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+StatusIndex+"','"+ID+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	};
assignAttr(C,Attr);
   if (bkcolor==="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//svg draw polygon
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function py(_points,penwidth,color,bkcolor,name,StatusIndex,ID,event,directevent){
var C=document.createElementNS(xmlns,"polygon");
var Attr={"points":_points,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":ID,
        "name":StatusIndex,
        "class":StatusIndex,
        "alt":name+" ("+directevent+")",
        "title":name+" ("+directevent+")",
	"stroke-width":penwidth,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+StatusIndex+"','"+ID+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	};
assignAttr(C,Attr);
if (bkcolor==="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//svg place text
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//t('7.578cm','13.315cm','Robert Okno Kon.','Arial','0.194cm','','','','','#00923F','#00923F','Active - Robert K (1)','00FE7A1A01','3','Active - Robert K (1)','00fe6300000000000000');
function t(_x,_y,_text,font,_size,b,u,i,penwidth,color,bkcolor,name,StatusIndex,ID,event,directevent){
if  ((DISABLE_VISUALIZATION) &&(_text.indexOf('%')>=0)) return;	///do not display dynamic varibles which should be replaced by engine
var C=document.createElementNS(xmlns,"text");
var pen;
if (penwidth==="none")  pen=0.1;
else 
	if (penwidth==="")  pen=0.1;
	else  pen=penwidth;
//pen=0.1;	//temporary ignore width	
var Attr={"x":_x,
	 "y":_y,
	"fill": color,
	"font-family":font,
	"font-size":_size,
	"fill-opacity":fill_opacity,
	"stroke-opacity":stroke_opacity,
	"stroke": color,
	"id":ID,
    "name":StatusIndex,
    "class":StatusIndex,
    "alt":name,
    "title":name,
	//"font-weight":"lighter",//normal",
	//"font-stretch":"wider",
	//"text-decoration":"none",
    "stroke-width":pen,   //not working generate warning and droping
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+StatusIndex+"','"+ID+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	};
    assignAttr(C,Attr);
    if (bkcolor==="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
    var textNode = document.createTextNode(_text);
    C.appendChild(textNode);
Root.appendChild(C);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function assignAttr(O,A)
	{
	for (i in A) 
       //if  (O.hasAttributeNS(null,i))
       		O.setAttributeNS(null,i, A[i]);
	}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//XML verification status print

function ShoweHouse1Status(index)
        {

var eol="<br>\r\n",Event,i=0,
XmlChanged=false,
XML="",
header,footer,body,bodyheader,bodyfooter;    
header="";
if (eHouse1[index].AddrH===2)
    header="\r\n";
header+="<?xml version=\"1.0\" encoding=\"UTF-8\" ?> \r\n <eHouse xmlns=\"http://www.isys.pl\" \r\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n            xsi:schemaLocation=\"http://www.openremote.org protocol.xsd\">";
header+="<Device>"+eol;
header+="<Name>"+eHouse1[index].Name+"</Name>"+eol;
header+="<Address>"+eHouse1[index].AddrH+","+eHouse1[index].AddrL+"</Address>"+eol;
//header+="<IPAddress>192.168."+DevAdrH+"."+DevAdrL+"</IPAddress>"+eol;            
//header+="<AddressCombined>"+DevAdr+"</AddressCombined>"+eol;
//header+="<StateModified>"+ehousecommunication.bo(changed)+"</StateModified>"+eol;
//header+="<ADCModified>"+ehousecommunication.bo(AdcChanged)+"</ADCModified>"+eol;
header+="<CurrentProgram>"+(eHouse1[index].CurrentProgram)+"</CurrentProgram>"+eol;
//header+="<CurrentProgramName> "+ CurrentProgramName+" </CurrentProgramName>"+eol;
//header+="<ADCCurrentProgram>"+i(ADCCurrentProgram)+"</ADCCurrentProgram>"+eol;
//header+="<ADCCurrentProgramName> "+ ADCCurrentProgramName+" </ADCCurrentProgramName>"+eol;
header+="<CurrentStatus>"+eHouse1[index].Stat+"</CurrentStatus>"+eol;
header+="<RecentStatus>"+eHouse1[index].Recent+"</RecentStatus>"+eol;
if (eHouse1[index].Type===IsRM) header+="<Devicetype>"+"RoomManager"+"</Devicetype>"+eol;
if (eHouse1[index].Type===IsEM) header+="<Devicetype>"+"ExternalManager"+"</Devicetype>"+eol;
if (eHouse1[index].Type===IsHM ) header+="<Devicetype>"+"HeatManager"+"</Devicetype>"+eol;
//if (IsLevelManager) header+="<Devicetype>"+"LevelManager"+"</Devicetype>"+eol;
//if (IsEthernet)  header+="<InterfaceType>"+"Ethernet"+"</InterfaceType>"+eol;;
        if (eHouse1[index].Type===IsEM)       //ExternalManager
            {
            header+="<CurrentZone>"+(eHouse1[index].CurrentZone)+"</CurrentZone>"+eol;
            //header+="<CurrentZoneName>"+ CurrentZoneName+"</CurrentZoneName>"+eol;

            }
bodyheader=eol+"<Outputs>"+eol;
body="";
var maxio=OUTPUTS_COUNT_RM;
if ((eHouse1[index].Type===IsRM) || (eHouse1[index].Type===IsEM)) maxio=35;
if (eHouse1[index].Type===IsHM) maxio=21;
var tmp= new Array(),m=0;        
for (var i=0;i<maxio;i++)
{
    if (((!IgnoreAtChar) || (eHouse1[index].OutsNames[i].indexOf("@")<0)))    //do not perform names currently
    
    {
    
    tmp[0]=eHouse1[index].AddrH;
    tmp[1]=eHouse1[index].AddrL;
    tmp[2]=0x1;
    tmp[3]=0;
    tmp[4]=1;
    tmp[5]=0;
    tmp[6]=0;
    tmp[7]=0;
    tmp[8]=0;
    tmp[9]=0;    
    //tmp={DevAdrH,DevAdrL,0x1,0,1,0,0,0,0,0};
    tmp[3]=i;
    var state="0",  value="Off";
            
    if (eHouse1[index].Outs[i]) {state="1";value="On";}
    body+="    <Item>"+eol+
    "        <Name>"+eHouse1[index].OutsNames[i]+"</Name>"+eol+
    "        <No>"+(i+1)+"</No>"+eol+
    "        <State>"+state+"</State>"+eol+
    "        <Value>"+value+"</Value>"+eol;
    if (eHouse1[index].Type!==IsHM)
    {
//    Event=hix(tmp,10);
//    body+="        <EventOn>"+Event+"</EventOn>"+eol;
//    tmp[4]=0;Event=hix(tmp,10);
//    body+="        <EventOff>"+Event+"</EventOff>"+eol;
//    tmp[4]=2;Event=hix(tmp,10);
//    body+="        <EventToggle>"+Event+"</EventToggle>"+eol            ;
            }
    body+="    </Item>"+eol+eol;
}
}
bodyfooter=eol+"</Outputs>"+eol;

header+=bodyheader+body+bodyfooter+eol;
bodyheader=eol+"<ADCInputs>"+eol;
body=eol;
bodyfooter=eol+"</ADCInputs>"+eol;
maxio=SENSORS_COUNT_RM;
if (eHouse1[index].Type!==IsHM) maxio=8;
for (i=0;i<maxio;i++)
{
    
if (((!IgnoreAtChar) || (eHouse1[index].ADCsNames[i].indexOf("@")<0)))    //names not performed
    {
    
  body+="    <Item>"+eol+
    "        <Name>"+eHouse1[index].ADCsNames[i]+"</Name>"+eol+
    "        <ADCValue>"+eHouse1[index].ADCs[i]+"</ADCValue>"+eol+
    "        <ADCTempValue>"+eHouse1[index].SensorTemps[i]+"</ADCTempValue>"+eol+
    "        <ADCLM335TempValue>"+eHouse1[index].SensorTemps[i]+"</ADCLM335TempValue>"+eol+
    /*"        <ADCLM35TempValue>"+SensorTempsLM35[i]+"</ADCLM35TempValue>"+eol+            
    "        <ADCMCP9700TempValue>"+SensorTempsMCP9700[i]+"</ADCMCP9700TempValue>"+eol+
    "        <ADCMCP9701TempValue>"+SensorTempsMCP9701[i]+"</ADCMCP9701TempValue>"+eol+*/
    "        <ADCPercentValue>"+eHouse1[index].SensorPercents[i]+"</ADCPercentValue>"+eol+
    "        <ADCInvertedPercentValue>"+eHouse1[index].SensorLights[i]+"</ADCInvertedPercentValue>"+eol+
    "        <ADCVoltageValue>"+eHouse1[index].SensorVolts[i]+"</ADCVoltageValue>"+eol+
    "        <ADCCalibrationValue>"+eHouse1[index].Calibration[i]+"</ADCCalibrationValue>"+eol+
    
    "        <No>"+(i+1)+"</No>"+eol
// +   "        <SensorType>"+eHouse1[index].SensorType[i]+"</SensorType>"+eol
    ;
  
    //Event=hix(tmp,10);
    //body+="        <EventOn>"+Event+"</EventOn>"+eol;
    //tmp[4]=0;Event=hix(tmp,10);
    //body+="        <EventOff>"+Event+"</EventOff>"+eol;
    //tmp[4]=2;Event=hix(tmp,10);
    //body+="        <EventToggle>"+Event+"</EventToggle>"+eol            
    /*String inversion="Normal";
    if (InputInverts[i]) inversion="Inverted";
     body+="        <Type>"+inversion+"</Type>"+eol;
     */
     body+="    </Item>"+eol+eol;}
}

header+=bodyheader+body+bodyfooter+eol;



bodyheader=eol+"<Inputs>"+eol;
body=eol;
bodyfooter=eol;
maxio=INPUTS_COUNT_RM;
//if ((eHouse1[index].Type===IsRM) || (eHouse1[index].Type===IsHM) || (eHouse1[index].Type===IsEM)) 
    maxio=12;
for (i=0;i<maxio;i++)
{
 if (((!IgnoreAtChar) || (eHouse1[index].InputsNames[i].indexOf("@")<0)))    
{
//    int tmp[]={DevAdrH,DevAdrL,0x21,0,1,0,0,0,0,0};
  //  tmp[3]=i;
    var state="0",value="On";   
    if ((eHouse1[index].Type===IsEM)) 
        {
        if (!((eHouse1[index].Inputs[i])))
            {state="1";value="Off";} 
        else
            {state="0";value="On";}
    
        }
    else
        {
        if ((!eHouse1[index].Inputs[i]))
            {state="0";value="On";} 
        else
            {state="1";value="Off";}
        }
    
    body+="    <Item>"+eol+
    "        <Name>"+eHouse1[index].InputsNames[i]+"</Name>"+eol+
            
    "        <No>"+(i+1)+"</No>"+eol+
    "        <State>"+state+"</State>"+eol+
    "        <Value>"+value+"</Value>"+eol;
    if ((eHouse1[index].Type===IsEM) ) 
        {

            
            
        if (!((eHouse1[index].AlarmSensorsActive[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}
        body+="        <ActiveState>"+state+"</ActiveState>"+eol+
        "        <ActiveValue>"+value+"</ActiveValue>"+eol;
            
            
            
/*        if (!((eHouse1[index].AlarmSensorsWarning[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}
        body+="        <WarningState>"+state+"</WarningState>"+eol+
        "        <WarningValue>"+value+"</WarningValue>"+eol;
        
        //MonitoringSensorsWarning
        
        body+="        <MonitoringState>"+state+"</MonitoringState>"+eol+
        "        <MonitoringValue>"+value+"</MonitoringValue>"+eol;
  */      
        
       if (!((eHouse1[index].AlarmSensorsAlarm[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}
        body+="        <AlarmState>"+state+"</AlarmState>"+eol+
        "        <AlarmValue>"+value+"</AlarmValue>"+eol;
        
        
        
        
        }
    //Event=hix(tmp,10);
    //body+="        <EventOn>"+Event+"</EventOn>"+eol;
    //tmp[4]=0;Event=hix(tmp,10);
    //body+="        <EventOff>"+Event+"</EventOff>"+eol;
    //tmp[4]=2;Event=hix(tmp,10);
    //body+="        <EventToggle>"+Event+"</EventToggle>"+eol            
    var inversion="Normal";
    //if (InputInverts[i]) inversion="Inverted";
     body+="        <Type>"+inversion+"</Type>"+eol;
     
     body+="    </Item>"+eol+eol;
}
}
bodyfooter=eol+"</Inputs>"+eol;

header+=bodyheader+body+bodyfooter+eol;
footer="</Device>\r\n";
footer+="\r\n</eHouse> \r\n";

XML=header+footer;
var stringToFind=">",stringToReplace="&gt;";
var inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
stringToFind="<",stringToReplace="&lt;";
inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
stringToFind="&lt;br&gt;",stringToReplace="<br>";
inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
document.writeln(XML);
}

///////////////////////////////////////////////////////////////////////////////
//Create and initialize eHouse1[index] object instance
function eHouse1Create(index)
{
var str="";
var i=0;
for (i=0;i<400;i+=1) str=str+'0';
byteVal=new Array();
eHouse1[index]=new Object();
for (i=0;i<200;i+=1) byteVal[i]=0;
//Status received from controller
eHouse1[index].Type=0;             //Type of eHouse1 Controller RM,EM,HM
eHouse1[index].Name="";             //Controller Name
eHouse1[index].Recent="";          //Recent Status Results Date
eHouse1[index].Size=0;             //Size of binary status
eHouse1[index].Stat=str;           //status writen in hex in string
eHouse1[index].PrevStat=str;       //previous status before update
eHouse1[index].BinStat=byteVal;    //status converted to binary form
//decoded status of controller to object
eHouse1[index].AddrH=0;            //Address High of controller
eHouse1[index].AddrL=0;            //Address Low of controller
eHouse1[index].Outs=new Array();     //Outputs States
eHouse1[index].OutsDomIndexH=new Array();//Output index in dom for sorted elements
eHouse1[index].OutsDomIndexL=new Array();//Output index in dom for sorted elements
eHouse1[index].OutsNames=new Array();     //Outputs States
eHouse1[index].DomStartIndex=0;     //DOM objects - Start  index for current RM - sorted in reverse direction
eHouse1[index].DomEndIndex=0;       //DOM objects - End  index for current RM  - sorted in reverse direction
for (i=0;i<OUTPUTS_COUNT_RM;i++) 
    {
    eHouse1[index].Outs[i]=false;  //Initialize with false
    eHouse1[index].OutsNames[i]="Out "+(i+1);  //Initialize with false
    eHouse1[index].OutsDomIndexH[i]=0;           //Initialize index in DOM elements
    eHouse1[index].OutsDomIndexL[i]=0;           //Initialize index in DOM elements
    }
eHouse1[index].Inputs=new Array();   //Input states;
eHouse1[index].InputsNames=new Array();   //Input Names
eHouse1[index].InputsDomIndexL=new Array();  //Input index in Dom Object for sorted elements
eHouse1[index].InputsDomIndexH=new Array();  //Input index in Dom Object for sorted elements
for (i=0;i<INPUTS_COUNT_RM;i++) 
    {
    eHouse1[index].InputsNames[i]="In "+(i+1);  //Initialize with false
    eHouse1[index].Inputs[i]=false;             //Initialize with false
    eHouse1[index].InputsDomIndexL[i]=0;         //Initialize inputs index in dom elements
    eHouse1[index].InputsDomIndexH[i]=0;         //Initialize inputs index in dom elements
    }
eHouse1[index].CurrentProgram=0;   //Current Program
eHouse1[index].Dimmers=new Array();   //Dimmers
eHouse1[index].DimmersDomIndex=new Array();   //Dimmers
eHouse1[index].DimmerRGB=0;            //RGB dimmer combined
for (i=0;i<3;i++) 
        {
        eHouse1[index].Dimmers[i]=0;  //Initialize with 0
        eHouse1[index].DimmersDomIndex[i]=0;
        }
eHouse1[index].ADCs=new Array();            //ADC Absolute Values
eHouse1[index].ADCsNames=new Array();            //ADC Names
eHouse1[index].SensorTemps=new Array();     //ADC calculate temp value
eHouse1[index].SensorPercents =new Array(); //ADC calculate percent value
eHouse1[index].SensorsDomIndex=new Array(); //ADC Dom element index
eHouse1[index].SensorLights=new Array();    //ADC calculate inverted percent or light level
eHouse1[index].SensorVolts=new Array();     //ADC measure voltage 
eHouse1[index].Calibration=new Array();     //Calibration value Offset for ADC measurment
eHouse1[index].VCC=5000;                    //Power Voltage for calibration 
for (i=0;i<SENSORS_COUNT_RM;i++) 
    {
    eHouse1[index].ADCs[i]=0;  //Initialize with 0
    eHouse1[index].ADCsNames[i]="ADC "+(i+1);  //Initialize with 0
    eHouse1[index].SensorTemps[i] = 0;    //calculate temp value
    eHouse1[index].SensorPercents[i] = 0;  //calculate percent value
    eHouse1[index].SensorLights[i]=100;   
    eHouse1[index].SensorVolts[i]=0;
    eHouse1[index].Calibration[i]=-27315;
    eHouse1[index].SensorsDomIndex[i]=0;    //initialize sensor DOM element index
    }
eHouse1[index].AlarmSensorsActiveDomIndexH=new Array(); //Active Dom element index    
eHouse1[index].AlarmSensorsActiveDomIndexL=new Array(); //Active Dom element index    
eHouse1[index].AlarmSensorsActive= new Array();//[128]
eHouse1[index].AlarmSensorsAlarmDomIndexH=new Array(); //Alarm Dom element index    
eHouse1[index].AlarmSensorsAlarmDomIndexL=new Array(); //Alarm Dom element index    
eHouse1[index].AlarmSensorsAlarm =new Array();//[128]
eHouse1[index].AlarmSensorsWarningDomIndexL=new Array(); //Warning Dom element index    
eHouse1[index].AlarmSensorsWarningDomIndexH=new Array(); //Warning Dom element index    
eHouse1[index].AlarmSensorsWarning =new Array();//[128]
eHouse1[index].CurrentProgramDomIndex=0;

eHouse1[index].AlarmSensorsName =new Array();//[128]
for (i=0;i<128;i+=1) 
    {
    eHouse1[index].AlarmSensorsActiveDomIndexH[i]=0; //Active Dom element index    
    eHouse1[index].AlarmSensorsAlarmDomIndexH[i]=0; //Alarm Dom element index            
    eHouse1[index].AlarmSensorsWarningDomIndexH[i]=0; //Warning Dom element index    
    eHouse1[index].AlarmSensorsActiveDomIndexL[i]=0; //Active Dom element index    
    eHouse1[index].AlarmSensorsAlarmDomIndexL[i]=0; //Alarm Dom element index            
    eHouse1[index].AlarmSensorsWarningDomIndexL[i]=0; //Warning Dom element index    
    
    eHouse1[index].AlarmSensorsName[i]="Sensor "+(i+1);     //Outputs States
    eHouse1[index].AlarmSensorsActive[i]=false;  //Initialize with false
    eHouse1[index].AlarmSensorsAlarm[i]=false;  //Initialize with false
    eHouse1[index].AlarmSensorsWarning[i]=false;  //Initialize with false
    }
eHouse1[index].CurrentZone=0;
}
/////////////////////////////////////////////////////////////////////////////////
//Ethernet eHouse controler instance create / initialize
function EthernetEhouseCreate(index)
{
var str="";
var i=0;
for (i=0;i<400;i+=1) str=str+'0';
byteVal=new Array();
EthernetEhouse[index]=new Object();
for (i=0;i<200;i+=1) byteVal[i]=0;
//Status received from controller
EthernetEhouse[index].Type=0;             //Type of eHouse1 Controller RM,EM,HM
EthernetEhouse[index].Name="";             //Controller Name
EthernetEhouse[index].Recent="";          //Recent Status Results Date
EthernetEhouse[index].Size=0;             //Size of binary status
EthernetEhouse[index].Stat=str;           //status writen in hex in string
EthernetEhouse[index].PrevStat=str;       //previous status before update
EthernetEhouse[index].BinStat=byteVal;    //status converted to binary form
EthernetEhouse[index].CurrentProgramDomIndex=0;
//decoded status of controller to object
EthernetEhouse[index].AddrH=0;            //Address High of controller
EthernetEhouse[index].AddrL=0;            //Address Low of controller
EthernetEhouse[index].Outs=new Array();     //Outputs States
EthernetEhouse[index].OutsNames=new Array();     //Outputs States
EthernetEhouse[index].OutsDomIndexH=new Array();           //Initialize index in DOM elements
EthernetEhouse[index].OutsDomIndexL=new Array();           //Initialize index in DOM elements
for (i=0;i<OUTPUTS_COUNT_ERM;i++) 
    {
    EthernetEhouse[index].Outs[i]=false;  //Initialize with false
    EthernetEhouse[index].OutsNames[i]="Out "+(i+1);  //Initialize with false
    EthernetEhouse[index].OutsDomIndexH[i]=0;           //Initialize index in DOM elements
    EthernetEhouse[index].OutsDomIndexL[i]=0;           //Initialize index in DOM elements
    }
EthernetEhouse[index].Inputs=new Array();   //Input states;
EthernetEhouse[index].InputInverts=new Array();//Inversion of input
EthernetEhouse[index].InputsNames=new Array();   //Input Names
EthernetEhouse[index].InputsDomIndexL=new Array();         //Initialize inputs index in dom elements
EthernetEhouse[index].InputsDomIndexH=new Array();         //Initialize inputs index in dom elements
for (i=0;i<INPUTS_COUNT_ERM;i++) 
    {
    EthernetEhouse[index].InputInverts[i]=0;            //Inversion =false;
    EthernetEhouse[index].InputsNames[i]="In "+(i+1);  //Initialize with false
    EthernetEhouse[index].Inputs[i]=false;  //Initialize with false
    EthernetEhouse[index].InputsDomIndexH[i]=0;         //Initialize inputs index in dom elements
    EthernetEhouse[index].InputsDomIndexL[i]=0;         //Initialize inputs index in dom elements
    }
EthernetEhouse[index].CurrentProgram=0;   //Current Program
EthernetEhouse[index].Dimmers=new Array();   //Dimmers
EthernetEhouse[index].DimmerRGB=0;            //RGB dimmer combined
EthernetEhouse[index].DimmersDomIndex=new Array();
for (i=0;i<3;i++) 
    {
     EthernetEhouse[index].Dimmers[i]=0;  //Initialize with 0
     EthernetEhouse[index].DimmersDomIndex[i]=0;
    }
EthernetEhouse[index].ADCs=new Array();            //ADC Absolute Values
EthernetEhouse[index].ADCsNames=new Array();            //ADC Names
EthernetEhouse[index].SensorTemps=new Array();     //ADC calculate temp value
EthernetEhouse[index].SensorPercents =new Array(); //ADC calculate percent value
EthernetEhouse[index].SensorLights=new Array();    //ADC calculate inverted percent or light level
EthernetEhouse[index].SensorVolts=new Array();     //ADC measure voltage 
EthernetEhouse[index].Calibration=new Array();     //Calibration value Offset for ADC measurment
EthernetEhouse[index].SensorTempsMCP9700 = new Array();    //calculate temp value from MCP9700
EthernetEhouse[index].SensorTempsMCP9701 = new Array();    //calculate temp value from MCP9701
EthernetEhouse[index].SensorTempsLM35    =new Array(); //LM35 calculate temperature sensor
EthernetEhouse[index].VCC=3300;                    //Power Voltage for calibration 
EthernetEhouse[index].SensorsDomIndex=new Array();    //initialize sensor DOM element index
    
for (i=0;i<SENSORS_COUNT_ERM;i++) 
    {
    EthernetEhouse[index].SensorsDomIndex[i]=0;    //initialize sensor DOM element index
        
    EthernetEhouse[index].ADCs[i]=0;                    //Initialize with 0
    EthernetEhouse[index].ADCsNames[i]="ADC "+(i+1);    //Initialize with 0
    EthernetEhouse[index].SensorTemps[i] = 0;           //calculate temp value
    EthernetEhouse[index].SensorTempsMCP9700[i] = 0;    //calculate temp value
    EthernetEhouse[index].SensorTempsMCP9701[i] = 0;    //calculate temp value
    EthernetEhouse[index].SensorPercents[i] = 0;        //calculate percent value
    EthernetEhouse[index].SensorLights[i]=100;
    EthernetEhouse[index].SensorTempsLM35[i]=0;          
    EthernetEhouse[index].SensorVolts[i]=0;
    EthernetEhouse[index].Calibration[i]=//-4000;
    MCP9700_Offset;//=-500; //Offset voltage at 0C [mV]
    //MCP9701_Offset;//=-400; //Offset voltage at 0C [mV]
    
    }
EthernetEhouse[index].AlarmSensorsActive    = new Array();//[128]
EthernetEhouse[index].AlarmSensorsAlarm     = new Array();//[128]
EthernetEhouse[index].AlarmSensorsName      = new Array();//[128]
EthernetEhouse[index].AlarmSensorsWarning   = new Array();  //Initialize with false
EthernetEhouse[index].AlarmSensorsMonitoring= new Array();  //Initialize with false
EthernetEhouse[index].AlarmSensorsActiveDomIndexH=new Array(); //Active Dom element index    
EthernetEhouse[index].AlarmSensorsAlarmDomIndexH=new Array(); //Alarm Dom element index    
EthernetEhouse[index].AlarmSensorsWarningDomIndexH=new Array(); //Warning Dom element index    
EthernetEhouse[index].AlarmSensorsMonitoringDomIndexH=new Array(); //Alarm Dom element index    
EthernetEhouse[index].AlarmSensorsActiveDomIndexL=new Array(); //Active Dom element index    
EthernetEhouse[index].AlarmSensorsAlarmDomIndexL=new Array(); //Alarm Dom element index    
EthernetEhouse[index].AlarmSensorsWarningDomIndexL=new Array(); //Warning Dom element index    
EthernetEhouse[index].AlarmSensorsMonitoringDomIndexL=new Array(); //Alarm Dom element index    

for (i=0;i<ALARM_SENSORS_COUNT_ERM;i++) 
    {
    EthernetEhouse[index].AlarmSensorsActiveDomIndexH[i]=0; //Active Dom element index    
    EthernetEhouse[index].AlarmSensorsAlarmDomIndexH[i]=0; //Alarm Dom element index            
    EthernetEhouse[index].AlarmSensorsWarningDomIndexH[i]=0; //Warning Dom element index    
    EthernetEhouse[index].AlarmSensorsMonitoringDomIndexH[i]=0; //Warning Dom element index    

    EthernetEhouse[index].AlarmSensorsActiveDomIndexL[i]=0; //Active Dom element index    
    EthernetEhouse[index].AlarmSensorsAlarmDomIndexL[i]=0; //Alarm Dom element index            
    EthernetEhouse[index].AlarmSensorsWarningDomIndexL[i]=0; //Warning Dom element index    
    EthernetEhouse[index].AlarmSensorsMonitoringDomIndexL[i]=0; //Warning Dom element index    
    
    EthernetEhouse[index].AlarmSensorsName[i]       ="Sensor "+(i+1);     //Outputs States
    EthernetEhouse[index].AlarmSensorsActive[i]     =false;  //Initialize with false
    EthernetEhouse[index].AlarmSensorsAlarm[i]      =false;  //Initialize with false
    EthernetEhouse[index].AlarmSensorsWarning[i]    =false;  //Initialize with false
    EthernetEhouse[index].AlarmSensorsMonitoring[i] =false;  //Initialize with false
    }
EthernetEhouse[index].CurrentZone=0;
EthernetEhouse[index].CurrentADCProgram=0;
}
//////////////////////////////////////////////////////////////////////////////////
//create eHousePRO
function eHousePROCreate(index)
{
var str="";
var i=0;
for (i=0;i<4000;i+=1) str=str+'0';
byteVal=new Array();
eHousePRO[index]=new Object();
for (i=0;i<2000;i+=1) byteVal[i]=0;
//Status received from controller
eHousePRO[index].Type=0;             //Type of eHousePro
eHousePRO[index].Name="";             //Controller Name
eHousePRO[index].Recent="";          //Recent Status Results Date
eHousePRO[index].Size=0;             //Size of binary status
eHousePRO[index].Stat=str;           //status writen in hex coded string
eHousePRO[index].PrevStat=str;       //previous status before update
eHousePRO[index].BinStat=byteVal;    //status converted to binary form
eHousePRO[index].CurrentProgramDomIndex=0;
eHousePRO[index].RollerProgramDomIndex=0;
eHousePRO[index].SecuZoneDomIndex=0;
eHousePRO[index].ADCProgramDomIndex=0;

//decoded status of controller to object
eHousePRO[index].AddrH=0;            //Address High of controller
eHousePRO[index].AddrL=0;            //Address Low of controller
eHousePRO[index].Outs=new Array();     //Outputs States
eHousePRO[index].OutsNames=new Array();     //Outputs States
eHousePRO[index].OutsDomIndexH=new Array();           //Initialize index in DOM elements
eHousePRO[index].OutsDomIndexL=new Array();           //Initialize index in DOM elements
for (i=0;i<EHOUSE_PRO_MAX_OUTPUTS;i++) 
    {
    eHousePRO[index].Outs[i]=false;  //Initialize with false
    eHousePRO[index].OutsNames[i]="Out "+(i+1);  //Initialize with false
    eHousePRO[index].OutsDomIndexH[i]=0;           //Initialize index in DOM elements
    eHousePRO[index].OutsDomIndexL[i]=0;           //Initialize index in DOM elements
    }
eHousePRO[index].Inputs=new Array();   //Input states;
eHousePRO[index].InputInverts=new Array();//Inversion of input
eHousePRO[index].InputsNames=new Array();   //Input Names
eHousePRO[index].InputsDomIndexL=new Array();         //Initialize inputs index in dom elements
eHousePRO[index].InputsDomIndexH=new Array();         //Initialize inputs index in dom elements
for (i=0;i<EHOUSE_PRO_MAX_INPUTS;i++) 
    {
    eHousePRO[index].InputInverts[i]=0;            //Inversion =false;
    eHousePRO[index].InputsNames[i]="In "+(i+1);  //Initialize with false
    eHousePRO[index].Inputs[i]=false;  //Initialize with false
    eHousePRO[index].InputsDomIndexH[i]=0;         //Initialize inputs index in dom elements
    eHousePRO[index].InputsDomIndexL[i]=0;         //Initialize inputs index in dom elements
    }
eHousePRO[index].CurrentProgram=0;   //Current Program
eHousePRO[index].Dimmers=new Array();   //Dimmers
eHousePRO[index].DimmersNames=new Array();   //Dimmers
eHousePRO[index].DimmerRGB=0;            //RGB dimmer combined
eHousePRO[index].DimmersDomIndex=new Array();
for (i=0;i<EHOUSE_PRO_MAX_DIMMERS;i++) 
    {
     eHousePRO[index].Dimmers[i]=0;  //Initialize with 0
     eHousePRO[index].DimmersDomIndex[i]=0;
     eHousePRO[index].DimmersNames[i]="Dim "+(i+1);   //Dimmers
    }
eHousePRO[index].ADCs=new Array();            //ADC Absolute Values
eHousePRO[index].ADCsNames=new Array();            //ADC Names
eHousePRO[index].SensorTemps=new Array();     //ADC calculate temp value
eHousePRO[index].SensorPercents =new Array(); //ADC calculate percent value
eHousePRO[index].SensorLights=new Array();    //ADC calculate inverted percent or light level
eHousePRO[index].SensorVolts=new Array();     //ADC measure voltage 
eHousePRO[index].Calibration=new Array();     //Calibration value Offset for ADC measurment
eHousePRO[index].SensorTempsMCP9700 = new Array();    //calculate temp value from MCP9700
eHousePRO[index].SensorTempsMCP9701 = new Array();    //calculate temp value from MCP9701
eHousePRO[index].SensorTempsLM35    =new Array(); //LM35 calculate temperature sensor
eHousePRO[index].VCC=3300;                    //Power Voltage for calibration 
eHousePRO[index].SensorsDomIndex=new Array();    //initialize sensor DOM element index
    
for (i=0;i<EHOUSE_PRO_MAX_ADC;i++)
    {
    eHousePRO[index].SensorsDomIndex[i]=0;    //initialize sensor DOM element index
        
    eHousePRO[index].ADCs[i]=0;                    //Initialize with 0
    eHousePRO[index].ADCsNames[i]="ADC "+(i+1);    //Initialize with 0
    eHousePRO[index].SensorTemps[i] = 0;           //calculate temp value
    eHousePRO[index].SensorTempsMCP9700[i] = 0;    //calculate temp value
    eHousePRO[index].SensorTempsMCP9701[i] = 0;    //calculate temp value
    eHousePRO[index].SensorPercents[i] = 0;        //calculate percent value
    eHousePRO[index].SensorLights[i]=100;
    eHousePRO[index].SensorTempsLM35[i]=0;          
    eHousePRO[index].SensorVolts[i]=0;
    eHousePRO[index].Calibration[i]=//-4000;
    MCP9700_Offset;//=-500; //Offset voltage at 0C [mV]
    //MCP9701_Offset;//=-400; //Offset voltage at 0C [mV]
    
    }
eHousePRO[index].AlarmSensorsActive    = new Array();       //Active
eHousePRO[index].AlarmSensorsAlarm     = new Array();       //Alarm
eHousePRO[index].AlarmSensorsName      = new Array();       //Name
eHousePRO[index].AlarmSensorsWarning   = new Array();       //Warning
eHousePRO[index].AlarmSensorsMonitoring= new Array();       //Monitoring
eHousePRO[index].AlarmSensorsSMS   = new Array();           //SMS
eHousePRO[index].AlarmSensorsSilent   = new Array();        //Silent
eHousePRO[index].AlarmSensorsEarlyWarning   = new Array();  //Early Warning
eHousePRO[index].AlarmSensorsHorn   = new Array();          //Horn



eHousePRO[index].AlarmSensorsActiveDomIndexH=new Array();       //Active Dom element index H
eHousePRO[index].AlarmSensorsAlarmDomIndexH=new Array();        //Alarm Dom element index H
eHousePRO[index].AlarmSensorsWarningDomIndexH=new Array();      //Warning Dom element index H    
eHousePRO[index].AlarmSensorsMonitoringDomIndexH=new Array();   //Alarm Dom element index H
eHousePRO[index].AlarmSensorsActiveDomIndexL=new Array();       //Active Dom element index L
eHousePRO[index].AlarmSensorsAlarmDomIndexL=new Array();        //Alarm Dom element index L    
eHousePRO[index].AlarmSensorsWarningDomIndexL=new Array();      //Warning Dom element index L    
eHousePRO[index].AlarmSensorsMonitoringDomIndexL=new Array();   //Alarm Dom element index L    


eHousePRO[index].AlarmSensorsEarlyWarningDomIndexH=new Array(); //Warning Dom element index H    
eHousePRO[index].AlarmSensorsEarlyWarningDomIndexL=new Array(); //Warning Dom element index L  
eHousePRO[index].AlarmSensorsHornDomIndexH=new Array(); //Warning Dom element index H
eHousePRO[index].AlarmSensorsHornDomIndexL=new Array(); //Warning Dom element index L  
eHousePRO[index].AlarmSensorsSMSDomIndexH=new Array(); //Warning Dom element index H  
eHousePRO[index].AlarmSensorsSMSDomIndexL=new Array(); //Warning Dom element index L   
eHousePRO[index].AlarmSensorsSilentDomIndexH=new Array(); //Warning Dom element index H
eHousePRO[index].AlarmSensorsSilentDomIndexL=new Array(); //Warning Dom element index L   




for (i=0;i<EHOUSE_PRO_MAX_INPUTS;i++) 
    {
    eHousePRO[index].AlarmSensorsActiveDomIndexH[i]=0; //Active Dom element index   H 
    eHousePRO[index].AlarmSensorsAlarmDomIndexH[i]=0; //Alarm Dom element index     H       
    eHousePRO[index].AlarmSensorsWarningDomIndexH[i]=0; //Warning Dom element index  H  
    eHousePRO[index].AlarmSensorsMonitoringDomIndexH[i]=0; //Warning Dom element index    H

    eHousePRO[index].AlarmSensorsActiveDomIndexL[i]=0; //Active Dom element index     L
    eHousePRO[index].AlarmSensorsAlarmDomIndexL[i]=0; //Alarm Dom element index       L     
    eHousePRO[index].AlarmSensorsWarningDomIndexL[i]=0; //Warning Dom element index   L 
    eHousePRO[index].AlarmSensorsMonitoringDomIndexL[i]=0; //Warning Dom element index L   

    eHousePRO[index].AlarmSensorsEarlyWarningDomIndexH[i]=0;
    eHousePRO[index].AlarmSensorsEarlyWarningDomIndexL[i]=0;
    eHousePRO[index].AlarmSensorsHornDomIndexH[i]=0;
    eHousePRO[index].AlarmSensorsHornDomIndexL[i]=0;
    eHousePRO[index].AlarmSensorsSMSDomIndexH[i]=0;
    eHousePRO[index].AlarmSensorsSMSDomIndexL[i]=0;
    eHousePRO[index].AlarmSensorsSilentDomIndexH[i]=0;
    eHousePRO[index].AlarmSensorsSilentDomIndexL[i]=0;
    
    eHousePRO[index].AlarmSensorsName[i]        ="Sensor "+(i+1);     //Initial name
    eHousePRO[index].AlarmSensorsActive[i]      =false;  //Initialize with false
    eHousePRO[index].AlarmSensorsAlarm[i]       =false;  //Initialize with false
    eHousePRO[index].AlarmSensorsWarning[i]     =false;  //Initialize with false
    eHousePRO[index].AlarmSensorsMonitoring[i]  =false;  //Initialize with false
    eHousePRO[index].AlarmSensorsHorn[i]        =false;  //Initialize with false
    eHousePRO[index].AlarmSensorsSMS[i]         =false;  //Initialize with false
    eHousePRO[index].AlarmSensorsEarlyWarning[i]=false;  //Initialize with false
    eHousePRO[index].AlarmSensorsSilent[i]      =false;  //Initialize with false
    }
eHousePRO[index].CurrentZone=0;
eHousePRO[index].CurrentADCProgram=0;
}


/////////////////////////////////////////////////////////////////////////////////
//Get Ethernet Ehouse status writen as string and convert to binary status and decoding
function GetEthernetEhouseStatus(index)
{
if (EthernetEhouse[index].PrevStat===EthernetEhouse[index].Stat) return;   //the same data
EthernetEhouse[index].PrevStat=EthernetEhouse[index].Stat;                //Update Previous state to ignore if no data reception for current controller
if (EthernetEhouse[index].Stat.length<100) return;
hex2binEth(index); //convert text - hex status to binary data -> eHouse1[index].BinStat;
DecodeEthernetEhouseStatus(index); //decode status of eHouse1 controller from binary status data
VisualEthernetEhouse(index);
//ShowEthernetEhouseStatus(index);
}

/////////////////////////////////////////////////////////////////////////////////
//Get Ethernet Ehouse status writen as string and convert to binary status and decoding
function GetEhousePROStatus(index)
{
if (eHousePRO[index].PrevStat===eHousePRO[index].Stat) return;   //the same data
eHousePRO[index].PrevStat=eHousePRO[index].Stat;                //Update Previous state to ignore if no data reception for current controller
if (eHousePRO[index].Stat.length<100) return;
hex2binPRO(index);              //convert text - hex status to binary data -> eHouse1[index].BinStat;
DecodeEhousePROStatus(index);   //decode status of eHouse1 controller from binary status data
VisualEhousePRO(index);
ShowEhousePROStatus(index);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function ginv(val, inv)
{
if (IsCommManager)  return val^inv;
else return (!val)^inv;
}
//
////////////////////////////////////////////////////////////////////////////////
//
function DecodeEthernetEhouseStatus(index)
        { var i,k,TotalOffset=STATUS_TCP_OFFSET;
        //if (ehousecommunication.disablestatperforme) return true;
        //if (IsCommManager) 
        TotalOffset+=STATUS_COMMMANAGER_OFFSET;
        var Max_ADC = 16;
        //int CurrentSize=dta[0]&0xff;
        //
        //Calendar c = Calendar.getInstance(); 
        //recent=c.getTime().toLocaleString();
        //if (ehousecommunication.disablestatperforme) return true;
        {   //update data
        
        //if ((IsERM) || (IsEEM)) Max_ADC=8;
        
        {
            
//            if ((IsERM) && (!InitFromPrevious))                CurrentStatus[STATUS_SIZE-1] = 0;
            
            //Update All Outputs
            for (k = 0; k < 8; k++)
                {   ///output states
                    EthernetEhouse[index].Outs[k] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C]&0xff, k);
                    EthernetEhouse[index].Outs[k + 8]  = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 1]&0xff, k);
                    EthernetEhouse[index].Outs[k + 16] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 2]&0xff, k);
                    EthernetEhouse[index].Outs[k + 24] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 3]&0xff, k);
                    EthernetEhouse[index].Outs[k + 32] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+4]&0xff, k);
                    EthernetEhouse[index].Outs[k + 40]  = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 5]&0xff, k);
                    EthernetEhouse[index].Outs[k + 48] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 6]&0xff, k);
                    EthernetEhouse[index].Outs[k + 56] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+7]&0xff, k);
                    EthernetEhouse[index].Outs[k + 64] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+8]&0xff, k);
                    EthernetEhouse[index].Outs[k + 72]  = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 9]&0xff, k);
/*                    EthernetEhouse[index].Outs[k + 80] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 10]&0xff, k);
                    EthernetEhouse[index].Outs[k + 88] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+11]&0xff, k);
                    EthernetEhouse[index].Outs[k + 96] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 12]&0xff, k);
                    EthernetEhouse[index].Outs[k + 104] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+13]&0xff, k);
                    EthernetEhouse[index].Outs[k+112] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+14]&0xff, k);
                    EthernetEhouse[index].Outs[k + 120]  = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 15]&0xff, k);
                    EthernetEhouse[index].Outs[k + 128] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 16]&0xff, k);
                    EthernetEhouse[index].Outs[k + 136] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+17]&0xff, k);
                    EthernetEhouse[index].Outs[k+144] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+18]&0xff, k);
                    EthernetEhouse[index].Outs[k + 152]  = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 19]&0xff, k);
                */
                    EthernetEhouse[index].Inputs[k]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+8]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+1]&0xff, k),EthernetEhouse[index].InputInverts[k+1]);
                    EthernetEhouse[index].Inputs[k+16]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+2]&0xff, k),EthernetEhouse[index].InputInverts[k+2]);
                    EthernetEhouse[index].Inputs[k+24]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+3]&0xff, k),EthernetEhouse[index].InputInverts[k+3]);
                    EthernetEhouse[index].Inputs[k+32]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+4]&0xff, k),EthernetEhouse[index].InputInverts[k+4]);
                    EthernetEhouse[index].Inputs[k+40]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+5]&0xff, k),EthernetEhouse[index].InputInverts[k+5]);
/*                    EthernetEhouse[index].Inputs[k+48]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+6]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+56]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+7]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+64]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+8]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+72]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+9]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+80]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+10]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+88]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+11]&0xff, k),EthernetEhouse[index].InputInverts[k]);
  */                  
                    
                    //Security sensors status Alarm, Warning, Monitoring Mask violations
                if (EthernetEhouse[index].Type===IsCommManager)
                    {
                        ////active sensors - inputs
                    EthernetEhouse[index].AlarmSensorsActive[k]      =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 8]  =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C + 1]&0xff, k),EthernetEhouse[index].InputInverts[k+1]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 16] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C + 2]&0xff, k),EthernetEhouse[index].InputInverts[k+2]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 24] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C + 3]&0xff, k),EthernetEhouse[index].InputInverts[k+3]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 32] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C + 4]&0xff, k),EthernetEhouse[index].InputInverts[k+4]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 40] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C + 5]&0xff, k),EthernetEhouse[index].InputInverts[k+5]);
/*                    EthernetEhouse[index].AlarmSensorsActive[k + 48] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+6]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 56] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+7]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 64] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+8]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 72] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+9]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 80] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+10]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 88] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+11]&0xff, k),EthernetEhouse[index].InputInverts[k]);
  */                  
                    EthernetEhouse[index].AlarmSensorsAlarm[k]      =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 8]  =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 1]&0xff, k),EthernetEhouse[index].InputInverts[k+1]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 16] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 2]&0xff, k),EthernetEhouse[index].InputInverts[k+2]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 24] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 3]&0xff, k),EthernetEhouse[index].InputInverts[k+3]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 32] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 4]&0xff, k),EthernetEhouse[index].InputInverts[k+4]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 40] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 5]&0xff, k),EthernetEhouse[index].InputInverts[k+5]);
    /*                EthernetEhouse[index].AlarmSensorsAlarm[k + 48] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 6]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 56] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 7]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 64] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 8]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 72] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 9]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 80] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 10]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 88] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 11]&0xff, k),EthernetEhouse[index].InputInverts[k]);
      */              
                    EthernetEhouse[index].AlarmSensorsWarning[k]      =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 8]  =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 1]&0xff, k),EthernetEhouse[index].InputInverts[k+1]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 16] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 2]&0xff, k),EthernetEhouse[index].InputInverts[k+2]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 24] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 3]&0xff, k),EthernetEhouse[index].InputInverts[k+3]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 32] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 4]&0xff, k),EthernetEhouse[index].InputInverts[k+4]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 40] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 5]&0xff, k),EthernetEhouse[index].InputInverts[k+5]);
        /*            EthernetEhouse[index].AlarmSensorsWarning[k + 48] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 6]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 56] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 7]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 64] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 8]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 72] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 9]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 80] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 10]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 88] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 11]&0xff, k),EthernetEhouse[index].InputInverts[k]);
          */          
                    EthernetEhouse[index].AlarmSensorsMonitoring[k]      =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 8]  =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 1]&0xff, k),EthernetEhouse[index].InputInverts[k+1]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 16] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 2]&0xff, k),EthernetEhouse[index].InputInverts[k+2]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 24] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 3]&0xff, k),EthernetEhouse[index].InputInverts[k+3]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 32] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 4]&0xff, k),EthernetEhouse[index].InputInverts[k+4]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 40] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 5]&0xff, k),EthernetEhouse[index].InputInverts[k+5]);
            /*        EthernetEhouse[index].AlarmSensorsMonitoring[k + 48] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 6]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 56] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 7]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 64] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 8]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 72] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 9]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 80] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 10]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 88] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 11]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    
*/
                    }
                }

            EthernetEhouse[index].CurrentProgram = EthernetEhouse[index].BinStat[TotalOffset+STATUS_PROGRAM_NR]&0xff;
            EthernetEhouse[index].CurrentZone    = EthernetEhouse[index].BinStat[TotalOffset+STATUS_ZONE_NR]&0xff;            
            //CurrentProgramName="";
            //if (EthernetEhouse[index].CurrentZone<ZONES_MAX)
              //  CurrentZoneName=ZoneNames[CurrentZone];
            //else CurrentZoneName="-";
            //if (CurrentZoneName==null) CurrentZoneName="";
            //ADCCurrentProgramName="";
            
            }
/*        if (IsTCPEM)
        {
            CurrentProgramName = "";
        }*/
/*        if (IsTCPHM) 
            {
            Max_ADC=16;
            CurrentProgram = CurrentStatus[HM_STATUS_PROGRAM];
            CurrentProgramName = "";//na razie
            for (k = 0; k < 8; k++)
                {
                int mm = 0;
                sss=k;UpdateIOStatus(OutputStates[sss],OutputViewH[sss],OutputViewL[sss],GRAPHICS_OBJECTS_MAX);
                OutputStates[k] = GetInOutValue(CurrentStatus[HM_STATUS_OUT], k);
                sss=k+8;UpdateIOStatus(OutputStates[sss],OutputViewH[sss],OutputViewL[sss],GRAPHICS_OBJECTS_MAX);
                OutputStates[k + 8] = GetInOutValue(CurrentStatus[HM_STATUS_OUT + 1], k); //bitoffset++; k++;
                sss=k+16;UpdateIOStatus(OutputStates[sss],OutputViewH[sss],OutputViewL[sss],GRAPHICS_OBJECTS_MAX);
                OutputStates[k + 16] = GetInOutValue(CurrentStatus[HM_STATUS_OUT + 2], k); //bitoffset++; k++;
//                InputStates[k] = GetInOutValue(CurrentStatus[RM_STATUS_IN ], k);
  //              InputStates[k + 8] = GetInOutValue(CurrentStatus[RM_STATUS_INT ], k);
                }
            }*/
        i=0;
        while (i < Max_ADC)
                {                                               //offset od 2                       //offset od 2
                var temppp= EthernetEhouse[index].BinStat[TotalOffset+i * 2 + 1 ]&0xff;
                if (temppp<0) temppp+=256;
                temppp+=((EthernetEhouse[index].BinStat[TotalOffset+i * 2 ]&0xff) << 8);
                EthernetEhouse[index].ADCs[i] = temppp;
                EthernetEhouse[index].SensorTemps[i] = gettemplm(temppp, EthernetEhouse[index].Calibration[i], 10, EthernetEhouse[index].VCC);
                EthernetEhouse[index].SensorPercents[i] = calculate_percent(temppp);
                EthernetEhouse[index].SensorLights[i] = 100-EthernetEhouse[index].SensorPercents[i]; //inverted percent
                EthernetEhouse[index].SensorTempsLM35[i]=gettemplm35(temppp,EthernetEhouse[index].VCC,EthernetEhouse[index].Calibration[i]);
                EthernetEhouse[index].SensorTempsMCP9700[i]=calculate_MCP9700Eth(temppp,EthernetEhouse[index].VCC,EthernetEhouse[index].Calibration[i]);
                EthernetEhouse[index].SensorTempsMCP9701[i]=calculate_MCP9701Eth(temppp,EthernetEhouse[index].VCC,EthernetEhouse[index].Calibration[i]);
                EthernetEhouse[index].SensorVolts[i]=calculate_voltage(temppp,EthernetEhouse[index].VCC);
                i++;
                }        
        }
        }
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function DecodeEhousePROStatus(index)
{ 
var i,k,        TotalOffset=0;
var Max_ADC = 16;            
for (k = 0; k < 8; k++)
    {   ///output states				
    eHousePRO[index].Outs[k] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR]&0xff, k);
    eHousePRO[index].Outs[k + 8]  = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 1]&0xff, k);
    eHousePRO[index].Outs[k + 16] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 2]&0xff, k);
    eHousePRO[index].Outs[k + 24] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 3]&0xff, k);                                     
    eHousePRO[index].Outs[k + 32] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 4]&0xff, k);
    eHousePRO[index].Outs[k + 40] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 5]&0xff, k);
    eHousePRO[index].Outs[k + 48] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 6]&0xff, k);
    eHousePRO[index].Outs[k + 56] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 7]&0xff, k);
    eHousePRO[index].Outs[k + 64] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 8]&0xff, k);
    eHousePRO[index].Outs[k + 72] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 9]&0xff, k);
    eHousePRO[index].Outs[k + 80] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR +10]&0xff, k);
    eHousePRO[index].Outs[k + 88] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR +11]&0xff, k);
    eHousePRO[index].Outs[k + 96] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR +12]&0xff, k);
    eHousePRO[index].Outs[k +104] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR +13]&0xff, k);
    eHousePRO[index].Outs[k +112] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR +14]&0xff, k);
    eHousePRO[index].Outs[k +120] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR +15]&0xff, k);
    if (EHOUSE_PRO_OUTPUTS_ALL)
            {
            eHousePRO[index].Outs[k + 128] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 16]&0xff, k);
            eHousePRO[index].Outs[k + 136] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 17]&0xff, k);
            eHousePRO[index].Outs[k + 144] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 18]&0xff, k);
            eHousePRO[index].Outs[k + 152] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 19]&0xff, k);
            eHousePRO[index].Outs[k + 160] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 20]&0xff, k);
            eHousePRO[index].Outs[k + 168] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 21]&0xff, k);
            eHousePRO[index].Outs[k + 176] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 22]&0xff, k);
            eHousePRO[index].Outs[k + 184] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 23]&0xff, k);
            eHousePRO[index].Outs[k + 192] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 24]&0xff, k);
            eHousePRO[index].Outs[k + 200] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 25]&0xff, k);
            eHousePRO[index].Outs[k + 208] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 26]&0xff, k);
            eHousePRO[index].Outs[k + 216] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 27]&0xff, k);
            eHousePRO[index].Outs[k + 224] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 28]&0xff, k);
            eHousePRO[index].Outs[k + 232] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 29]&0xff, k);
            eHousePRO[index].Outs[k + 240] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 30]&0xff, k);
            eHousePRO[index].Outs[k + 248] = GetInOutValue(eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_OUTPUTS_ADDR + 31]&0xff, k);
             }       
                    
				
				
    TempOffset=	EHOUSE_PRO_INPUTS_ADDR;
    eHousePRO[index].Inputs[k]     = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset]&0xff, k),  eHousePRO[index].InputInverts[k]);
    eHousePRO[index].Inputs[k+  8] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 1]&0xff, k),eHousePRO[index].InputInverts[k+ 1]);
    eHousePRO[index].Inputs[k+ 16] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 2]&0xff, k),eHousePRO[index].InputInverts[k+ 2]);
    eHousePRO[index].Inputs[k+ 24] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 3]&0xff, k),eHousePRO[index].InputInverts[k+ 3]);
    eHousePRO[index].Inputs[k+ 32] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 4]&0xff, k),eHousePRO[index].InputInverts[k+ 4]);
    eHousePRO[index].Inputs[k+ 40] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 5]&0xff, k),eHousePRO[index].InputInverts[k+ 5]);
    eHousePRO[index].Inputs[k+ 48] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 6]&0xff, k),eHousePRO[index].InputInverts[k+ 6]);
    eHousePRO[index].Inputs[k+ 56] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 7]&0xff, k),eHousePRO[index].InputInverts[k+ 7]);
    eHousePRO[index].Inputs[k+ 64] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 8]&0xff, k),eHousePRO[index].InputInverts[k+ 8]);
    eHousePRO[index].Inputs[k+ 72] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 9]&0xff, k),eHousePRO[index].InputInverts[k+ 9]);
    eHousePRO[index].Inputs[k+ 80] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+10]&0xff, k),eHousePRO[index].InputInverts[k+10]);
    eHousePRO[index].Inputs[k+ 88] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+11]&0xff, k),eHousePRO[index].InputInverts[k+11]);
    eHousePRO[index].Inputs[k+ 96] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+12]&0xff, k),eHousePRO[index].InputInverts[k+12]);
    eHousePRO[index].Inputs[k+104] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+13]&0xff, k),eHousePRO[index].InputInverts[k+13]);
    eHousePRO[index].Inputs[k+112] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+14]&0xff, k),eHousePRO[index].InputInverts[k+14]);
    eHousePRO[index].Inputs[k+120] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+15]&0xff, k),eHousePRO[index].InputInverts[k+15]);
    if (EHOUSE_PRO_INPUTS_ALL)
            {
            eHousePRO[index].Inputs[k+128] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+16]&0xff, k),eHousePRO[index].InputInverts[k+16]);
            eHousePRO[index].Inputs[k+136] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+17]&0xff, k),eHousePRO[index].InputInverts[k+17]);
            eHousePRO[index].Inputs[k+144] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+18]&0xff, k),eHousePRO[index].InputInverts[k+18]);
            eHousePRO[index].Inputs[k+152] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+19]&0xff, k),eHousePRO[index].InputInverts[k+19]);
            eHousePRO[index].Inputs[k+160] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+20]&0xff, k),eHousePRO[index].InputInverts[k+20]);
            eHousePRO[index].Inputs[k+168] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+21]&0xff, k),eHousePRO[index].InputInverts[k+21]);
            eHousePRO[index].Inputs[k+176] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+22]&0xff, k),eHousePRO[index].InputInverts[k+22]);
            eHousePRO[index].Inputs[k+184] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+23]&0xff, k),eHousePRO[index].InputInverts[k+23]);
            eHousePRO[index].Inputs[k+192] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+24]&0xff, k),eHousePRO[index].InputInverts[k+24]);
            eHousePRO[index].Inputs[k+200] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+25]&0xff, k),eHousePRO[index].InputInverts[k+25]);
            eHousePRO[index].Inputs[k+208] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+26]&0xff, k),eHousePRO[index].InputInverts[k+26]);
            eHousePRO[index].Inputs[k+216] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+27]&0xff, k),eHousePRO[index].InputInverts[k+27]);
            eHousePRO[index].Inputs[k+224] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+28]&0xff, k),eHousePRO[index].InputInverts[k+28]);
            eHousePRO[index].Inputs[k+232] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+29]&0xff, k),eHousePRO[index].InputInverts[k+29]);
            eHousePRO[index].Inputs[k+240] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+30]&0xff, k),eHousePRO[index].InputInverts[k+30]);
            eHousePRO[index].Inputs[k+248] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+31]&0xff, k),eHousePRO[index].InputInverts[k+31]);
            }
			
    TempOffset=	EHOUSE_PRO_ALARM_ADDR;
    eHousePRO[index].AlarmSensorsAlarm[k]     = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset]&0xff, k),  eHousePRO[index].InputInverts[k]);
    eHousePRO[index].AlarmSensorsAlarm[k+  8] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+1]&0xff, k),eHousePRO[index].InputInverts[k+ 1]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 16] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+2]&0xff, k),eHousePRO[index].InputInverts[k+ 2]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 24] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+3]&0xff, k),eHousePRO[index].InputInverts[k+ 3]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 32] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+4]&0xff, k),eHousePRO[index].InputInverts[k+ 4]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 40] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+5]&0xff, k),eHousePRO[index].InputInverts[k+ 5]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 48] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+6]&0xff, k),eHousePRO[index].InputInverts[k+ 6]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 56] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+7]&0xff, k),eHousePRO[index].InputInverts[k+ 7]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 64] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+8]&0xff, k),eHousePRO[index].InputInverts[k+ 8]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 72] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+9]&0xff, k),eHousePRO[index].InputInverts[k+ 9]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 80] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+10]&0xff, k),eHousePRO[index].InputInverts[k+10]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 88] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+11]&0xff, k),eHousePRO[index].InputInverts[k+11]);
    eHousePRO[index].AlarmSensorsAlarm[k+ 96] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+12]&0xff, k),eHousePRO[index].InputInverts[k+12]);
    eHousePRO[index].AlarmSensorsAlarm[k+104] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+13]&0xff, k),eHousePRO[index].InputInverts[k+13]);
    eHousePRO[index].AlarmSensorsAlarm[k+112] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+14]&0xff, k),eHousePRO[index].InputInverts[k+14]);
    eHousePRO[index].AlarmSensorsAlarm[k+120] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+15]&0xff, k),eHousePRO[index].InputInverts[k+15]);
    if (EHOUSE_PRO_INPUTS_ALL)
            {
            eHousePRO[index].AlarmSensorsAlarm[k+128] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+16]&0xff, k),eHousePRO[index].InputInverts[k+16]);
            eHousePRO[index].AlarmSensorsAlarm[k+136] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+17]&0xff, k),eHousePRO[index].InputInverts[k+17]);
            eHousePRO[index].AlarmSensorsAlarm[k+144] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+18]&0xff, k),eHousePRO[index].InputInverts[k+18]);
            eHousePRO[index].AlarmSensorsAlarm[k+152] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+19]&0xff, k),eHousePRO[index].InputInverts[k+19]);
            eHousePRO[index].AlarmSensorsAlarm[k+160] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+20]&0xff, k),eHousePRO[index].InputInverts[k+20]);
            eHousePRO[index].AlarmSensorsAlarm[k+168] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+21]&0xff, k),eHousePRO[index].InputInverts[k+21]);
            eHousePRO[index].AlarmSensorsAlarm[k+176] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+22]&0xff, k),eHousePRO[index].InputInverts[k+22]);
            eHousePRO[index].AlarmSensorsAlarm[k+184] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+23]&0xff, k),eHousePRO[index].InputInverts[k+23]);
            eHousePRO[index].AlarmSensorsAlarm[k+192] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+24]&0xff, k),eHousePRO[index].InputInverts[k+24]);
            eHousePRO[index].AlarmSensorsAlarm[k+200] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+25]&0xff, k),eHousePRO[index].InputInverts[k+25]);
            eHousePRO[index].AlarmSensorsAlarm[k+208] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+26]&0xff, k),eHousePRO[index].InputInverts[k+26]);
            eHousePRO[index].AlarmSensorsAlarm[k+216] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+27]&0xff, k),eHousePRO[index].InputInverts[k+27]);
            eHousePRO[index].AlarmSensorsAlarm[k+224] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+28]&0xff, k),eHousePRO[index].InputInverts[k+28]);
            eHousePRO[index].AlarmSensorsAlarm[k+232] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+29]&0xff, k),eHousePRO[index].InputInverts[k+29]);
            eHousePRO[index].AlarmSensorsAlarm[k+240] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+30]&0xff, k),eHousePRO[index].InputInverts[k+30]);
            eHousePRO[index].AlarmSensorsAlarm[k+248] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+31]&0xff, k),eHousePRO[index].InputInverts[k+31]);
            }	
			
			
    TempOffset=	EHOUSE_PRO_HORN_ADDR;
    eHousePRO[index].AlarmSensorsHorn[k]     = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset]&0xff, k),  eHousePRO[index].InputInverts[k]);
    eHousePRO[index].AlarmSensorsHorn[k+  8] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 1]&0xff, k),eHousePRO[index].InputInverts[k+ 1]);
    eHousePRO[index].AlarmSensorsHorn[k+ 16] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 2]&0xff, k),eHousePRO[index].InputInverts[k+ 2]);
    eHousePRO[index].AlarmSensorsHorn[k+ 24] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 3]&0xff, k),eHousePRO[index].InputInverts[k+ 3]);
    eHousePRO[index].AlarmSensorsHorn[k+ 32] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 4]&0xff, k),eHousePRO[index].InputInverts[k+ 4]);
    eHousePRO[index].AlarmSensorsHorn[k+ 40] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 5]&0xff, k),eHousePRO[index].InputInverts[k+ 5]);
    eHousePRO[index].AlarmSensorsHorn[k+ 48] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 6]&0xff, k),eHousePRO[index].InputInverts[k+ 6]);
    eHousePRO[index].AlarmSensorsHorn[k+ 56] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 7]&0xff, k),eHousePRO[index].InputInverts[k+ 7]);
    eHousePRO[index].AlarmSensorsHorn[k+ 64] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 8]&0xff, k),eHousePRO[index].InputInverts[k+ 8]);
    eHousePRO[index].AlarmSensorsHorn[k+ 72] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 9]&0xff, k),eHousePRO[index].InputInverts[k+ 9]);
    eHousePRO[index].AlarmSensorsHorn[k+ 80] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+10]&0xff, k),eHousePRO[index].InputInverts[k+10]);
    eHousePRO[index].AlarmSensorsHorn[k+ 88] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+11]&0xff, k),eHousePRO[index].InputInverts[k+11]);
    eHousePRO[index].AlarmSensorsHorn[k+ 96] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+12]&0xff, k),eHousePRO[index].InputInverts[k+12]);
    eHousePRO[index].AlarmSensorsHorn[k+104] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+13]&0xff, k),eHousePRO[index].InputInverts[k+13]);
    eHousePRO[index].AlarmSensorsHorn[k+112] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+14]&0xff, k),eHousePRO[index].InputInverts[k+14]);
    eHousePRO[index].AlarmSensorsHorn[k+120] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+15]&0xff, k),eHousePRO[index].InputInverts[k+15]);        
    if (EHOUSE_PRO_INPUTS_ALL)
            {
            eHousePRO[index].AlarmSensorsHorn[k+128] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+16]&0xff, k),eHousePRO[index].InputInverts[k+16]);
            eHousePRO[index].AlarmSensorsHorn[k+136] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+17]&0xff, k),eHousePRO[index].InputInverts[k+17]);
            eHousePRO[index].AlarmSensorsHorn[k+144] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+18]&0xff, k),eHousePRO[index].InputInverts[k+18]);
            eHousePRO[index].AlarmSensorsHorn[k+152] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+19]&0xff, k),eHousePRO[index].InputInverts[k+19]);
            eHousePRO[index].AlarmSensorsHorn[k+160] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+20]&0xff, k),eHousePRO[index].InputInverts[k+20]);
            eHousePRO[index].AlarmSensorsHorn[k+168] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+21]&0xff, k),eHousePRO[index].InputInverts[k+21]);
            eHousePRO[index].AlarmSensorsHorn[k+176] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+22]&0xff, k),eHousePRO[index].InputInverts[k+22]);
            eHousePRO[index].AlarmSensorsHorn[k+184] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+23]&0xff, k),eHousePRO[index].InputInverts[k+23]);
            eHousePRO[index].AlarmSensorsHorn[k+192] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+24]&0xff, k),eHousePRO[index].InputInverts[k+24]);
            eHousePRO[index].AlarmSensorsHorn[k+200] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+25]&0xff, k),eHousePRO[index].InputInverts[k+25]);
            eHousePRO[index].AlarmSensorsHorn[k+208] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+26]&0xff, k),eHousePRO[index].InputInverts[k+26]);
            eHousePRO[index].AlarmSensorsHorn[k+216] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+27]&0xff, k),eHousePRO[index].InputInverts[k+27]);
            eHousePRO[index].AlarmSensorsHorn[k+224] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+28]&0xff, k),eHousePRO[index].InputInverts[k+28]);
            eHousePRO[index].AlarmSensorsHorn[k+232] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+29]&0xff, k),eHousePRO[index].InputInverts[k+29]);
            eHousePRO[index].AlarmSensorsHorn[k+240] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+30]&0xff, k),eHousePRO[index].InputInverts[k+30]);
            eHousePRO[index].AlarmSensorsHorn[k+248] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+31]&0xff, k),eHousePRO[index].InputInverts[k+31]);
            }
            
    TempOffset=	EHOUSE_PRO_WARNING_ADDR;
    eHousePRO[index].AlarmSensorsWarning[k]     = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset]&0xff, k),  eHousePRO[index].InputInverts[k]);
    eHousePRO[index].AlarmSensorsWarning[k+  8] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 1]&0xff, k),eHousePRO[index].InputInverts[k+ 1]);
    eHousePRO[index].AlarmSensorsWarning[k+ 16] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 2]&0xff, k),eHousePRO[index].InputInverts[k+ 2]);
    eHousePRO[index].AlarmSensorsWarning[k+ 24] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 3]&0xff, k),eHousePRO[index].InputInverts[k+ 3]);
    eHousePRO[index].AlarmSensorsWarning[k+ 32] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 4]&0xff, k),eHousePRO[index].InputInverts[k+ 4]);
    eHousePRO[index].AlarmSensorsWarning[k+ 40] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 5]&0xff, k),eHousePRO[index].InputInverts[k+ 5]);
    eHousePRO[index].AlarmSensorsWarning[k+ 48] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 6]&0xff, k),eHousePRO[index].InputInverts[k+ 6]);
    eHousePRO[index].AlarmSensorsWarning[k+ 56] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 7]&0xff, k),eHousePRO[index].InputInverts[k+ 7]);
    eHousePRO[index].AlarmSensorsWarning[k+ 64] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 8]&0xff, k),eHousePRO[index].InputInverts[k+ 8]);
    eHousePRO[index].AlarmSensorsWarning[k+ 72] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 9]&0xff, k),eHousePRO[index].InputInverts[k+ 9]);
    eHousePRO[index].AlarmSensorsWarning[k+ 80] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+10]&0xff, k),eHousePRO[index].InputInverts[k+10]);
    eHousePRO[index].AlarmSensorsWarning[k+ 88] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+11]&0xff, k),eHousePRO[index].InputInverts[k+11]);
    eHousePRO[index].AlarmSensorsWarning[k+ 96] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+12]&0xff, k),eHousePRO[index].InputInverts[k+12]);
    eHousePRO[index].AlarmSensorsWarning[k+104] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+13]&0xff, k),eHousePRO[index].InputInverts[k+13]);
    eHousePRO[index].AlarmSensorsWarning[k+112] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+14]&0xff, k),eHousePRO[index].InputInverts[k+14]);
    eHousePRO[index].AlarmSensorsWarning[k+120] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+15]&0xff, k),eHousePRO[index].InputInverts[k+15]);
    if (EHOUSE_PRO_INPUTS_ALL)
            {
            eHousePRO[index].AlarmSensorsWarning[k+128] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+16]&0xff, k),eHousePRO[index].InputInverts[k+16]);
            eHousePRO[index].AlarmSensorsWarning[k+136] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+17]&0xff, k),eHousePRO[index].InputInverts[k+17]);
            eHousePRO[index].AlarmSensorsWarning[k+144] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+18]&0xff, k),eHousePRO[index].InputInverts[k+18]);
            eHousePRO[index].AlarmSensorsWarning[k+152] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+19]&0xff, k),eHousePRO[index].InputInverts[k+19]);
            eHousePRO[index].AlarmSensorsWarning[k+160] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+20]&0xff, k),eHousePRO[index].InputInverts[k+20]);
            eHousePRO[index].AlarmSensorsWarning[k+168] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+21]&0xff, k),eHousePRO[index].InputInverts[k+21]);
            eHousePRO[index].AlarmSensorsWarning[k+176] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+22]&0xff, k),eHousePRO[index].InputInverts[k+22]);
            eHousePRO[index].AlarmSensorsWarning[k+184] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+23]&0xff, k),eHousePRO[index].InputInverts[k+23]);
            eHousePRO[index].AlarmSensorsWarning[k+192] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+24]&0xff, k),eHousePRO[index].InputInverts[k+24]);
            eHousePRO[index].AlarmSensorsWarning[k+200] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+25]&0xff, k),eHousePRO[index].InputInverts[k+25]);
            eHousePRO[index].AlarmSensorsWarning[k+208] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+26]&0xff, k),eHousePRO[index].InputInverts[k+26]);
            eHousePRO[index].AlarmSensorsWarning[k+216] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+27]&0xff, k),eHousePRO[index].InputInverts[k+27]);
            eHousePRO[index].AlarmSensorsWarning[k+224] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+28]&0xff, k),eHousePRO[index].InputInverts[k+28]);
            eHousePRO[index].AlarmSensorsWarning[k+232] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+29]&0xff, k),eHousePRO[index].InputInverts[k+29]);
            eHousePRO[index].AlarmSensorsWarning[k+240] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+30]&0xff, k),eHousePRO[index].InputInverts[k+30]);
            eHousePRO[index].AlarmSensorsWarning[k+248] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+31]&0xff, k),eHousePRO[index].InputInverts[k+31]);
            }
			
    TempOffset=	EHOUSE_PRO_MONITORING_ADDR;
    eHousePRO[index].AlarmSensorsMonitoring[k]     = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset]&0xff, k),  eHousePRO[index].InputInverts[k]);
    eHousePRO[index].AlarmSensorsMonitoring[k+  8] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 1]&0xff, k),eHousePRO[index].InputInverts[k+ 1]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 16] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 2]&0xff, k),eHousePRO[index].InputInverts[k+ 2]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 24] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 3]&0xff, k),eHousePRO[index].InputInverts[k+ 3]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 32] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 4]&0xff, k),eHousePRO[index].InputInverts[k+ 4]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 40] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 5]&0xff, k),eHousePRO[index].InputInverts[k+ 5]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 48] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 6]&0xff, k),eHousePRO[index].InputInverts[k+ 6]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 56] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 7]&0xff, k),eHousePRO[index].InputInverts[k+ 7]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 64] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 8]&0xff, k),eHousePRO[index].InputInverts[k+ 8]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 72] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 9]&0xff, k),eHousePRO[index].InputInverts[k+ 9]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 80] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+10]&0xff, k),eHousePRO[index].InputInverts[k+10]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 88] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+11]&0xff, k),eHousePRO[index].InputInverts[k+11]);
    eHousePRO[index].AlarmSensorsMonitoring[k+ 96] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+12]&0xff, k),eHousePRO[index].InputInverts[k+12]);
    eHousePRO[index].AlarmSensorsMonitoring[k+104] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+13]&0xff, k),eHousePRO[index].InputInverts[k+13]);
    eHousePRO[index].AlarmSensorsMonitoring[k+112] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+14]&0xff, k),eHousePRO[index].InputInverts[k+14]);
    eHousePRO[index].AlarmSensorsMonitoring[k+120] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+15]&0xff, k),eHousePRO[index].InputInverts[k+15]);
    if (EHOUSE_PRO_INPUTS_ALL)
            {
            eHousePRO[index].AlarmSensorsMonitoring[k+128] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+16]&0xff, k),eHousePRO[index].InputInverts[k+16]);
            eHousePRO[index].AlarmSensorsMonitoring[k+136] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+17]&0xff, k),eHousePRO[index].InputInverts[k+17]);
            eHousePRO[index].AlarmSensorsMonitoring[k+144] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+18]&0xff, k),eHousePRO[index].InputInverts[k+18]);
            eHousePRO[index].AlarmSensorsMonitoring[k+152] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+19]&0xff, k),eHousePRO[index].InputInverts[k+19]);
            eHousePRO[index].AlarmSensorsMonitoring[k+160] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+20]&0xff, k),eHousePRO[index].InputInverts[k+20]);
            eHousePRO[index].AlarmSensorsMonitoring[k+168] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+21]&0xff, k),eHousePRO[index].InputInverts[k+21]);
            eHousePRO[index].AlarmSensorsMonitoring[k+176] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+22]&0xff, k),eHousePRO[index].InputInverts[k+22]);
            eHousePRO[index].AlarmSensorsMonitoring[k+184] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+23]&0xff, k),eHousePRO[index].InputInverts[k+23]);
            eHousePRO[index].AlarmSensorsMonitoring[k+192] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+24]&0xff, k),eHousePRO[index].InputInverts[k+24]);
            eHousePRO[index].AlarmSensorsMonitoring[k+200] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+25]&0xff, k),eHousePRO[index].InputInverts[k+25]);
            eHousePRO[index].AlarmSensorsMonitoring[k+208] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+26]&0xff, k),eHousePRO[index].InputInverts[k+26]);
            eHousePRO[index].AlarmSensorsMonitoring[k+216] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+27]&0xff, k),eHousePRO[index].InputInverts[k+27]);
            eHousePRO[index].AlarmSensorsMonitoring[k+224] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+28]&0xff, k),eHousePRO[index].InputInverts[k+28]);
            eHousePRO[index].AlarmSensorsMonitoring[k+232] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+29]&0xff, k),eHousePRO[index].InputInverts[k+29]);
            eHousePRO[index].AlarmSensorsMonitoring[k+240] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+30]&0xff, k),eHousePRO[index].InputInverts[k+30]);
            eHousePRO[index].AlarmSensorsMonitoring[k+248] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+31]&0xff, k),eHousePRO[index].InputInverts[k+31]);
            }
			
    TempOffset=	EHOUSE_PRO_SILENT_ADDR;
    eHousePRO[index].AlarmSensorsSilent[k ]    = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset]&0xff, k),  eHousePRO[index].InputInverts[k]);
    eHousePRO[index].AlarmSensorsSilent[k+  8] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 1]&0xff, k),eHousePRO[index].InputInverts[k+ 1]);
    eHousePRO[index].AlarmSensorsSilent[k+ 16] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 2]&0xff, k),eHousePRO[index].InputInverts[k+ 2]);
    eHousePRO[index].AlarmSensorsSilent[k+ 24] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 3]&0xff, k),eHousePRO[index].InputInverts[k+ 3]);
    eHousePRO[index].AlarmSensorsSilent[k+ 32] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 4]&0xff, k),eHousePRO[index].InputInverts[k+ 4]);
    eHousePRO[index].AlarmSensorsSilent[k+ 40] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 5]&0xff, k),eHousePRO[index].InputInverts[k+ 5]);
    eHousePRO[index].AlarmSensorsSilent[k+ 48] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 6]&0xff, k),eHousePRO[index].InputInverts[k+ 6]);
    eHousePRO[index].AlarmSensorsSilent[k+ 56] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 7]&0xff, k),eHousePRO[index].InputInverts[k+ 7]);
    eHousePRO[index].AlarmSensorsSilent[k+ 64] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 8]&0xff, k),eHousePRO[index].InputInverts[k+ 8]);
    eHousePRO[index].AlarmSensorsSilent[k+ 72] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 9]&0xff, k),eHousePRO[index].InputInverts[k+ 9]);
    eHousePRO[index].AlarmSensorsSilent[k+ 80] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+10]&0xff, k),eHousePRO[index].InputInverts[k+10]);
    eHousePRO[index].AlarmSensorsSilent[k+ 88] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+11]&0xff, k),eHousePRO[index].InputInverts[k+11]);
    eHousePRO[index].AlarmSensorsSilent[k+ 96] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+12]&0xff, k),eHousePRO[index].InputInverts[k+12]);
    eHousePRO[index].AlarmSensorsSilent[k+104] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+13]&0xff, k),eHousePRO[index].InputInverts[k+13]);
    eHousePRO[index].AlarmSensorsSilent[k+112] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+14]&0xff, k),eHousePRO[index].InputInverts[k+14]);
    eHousePRO[index].AlarmSensorsSilent[k+120] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+15]&0xff, k),eHousePRO[index].InputInverts[k+15]);
    if (EHOUSE_PRO_INPUTS_ALL)
	   {
            eHousePRO[index].AlarmSensorsSilent[k+128] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+16]&0xff, k),eHousePRO[index].InputInverts[k+16]);
            eHousePRO[index].AlarmSensorsSilent[k+136] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+17]&0xff, k),eHousePRO[index].InputInverts[k+17]);
            eHousePRO[index].AlarmSensorsSilent[k+144] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+18]&0xff, k),eHousePRO[index].InputInverts[k+18]);
            eHousePRO[index].AlarmSensorsSilent[k+152] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+19]&0xff, k),eHousePRO[index].InputInverts[k+19]);
            eHousePRO[index].AlarmSensorsSilent[k+160] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+20]&0xff, k),eHousePRO[index].InputInverts[k+20]);
            eHousePRO[index].AlarmSensorsSilent[k+168] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+21]&0xff, k),eHousePRO[index].InputInverts[k+21]);
            eHousePRO[index].AlarmSensorsSilent[k+176] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+22]&0xff, k),eHousePRO[index].InputInverts[k+22]);
            eHousePRO[index].AlarmSensorsSilent[k+184] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+23]&0xff, k),eHousePRO[index].InputInverts[k+23]);
            eHousePRO[index].AlarmSensorsSilent[k+192] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+24]&0xff, k),eHousePRO[index].InputInverts[k+24]);
            eHousePRO[index].AlarmSensorsSilent[k+200] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+25]&0xff, k),eHousePRO[index].InputInverts[k+25]);
            eHousePRO[index].AlarmSensorsSilent[k+208] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+26]&0xff, k),eHousePRO[index].InputInverts[k+26]);
            eHousePRO[index].AlarmSensorsSilent[k+216] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+27]&0xff, k),eHousePRO[index].InputInverts[k+27]);
            eHousePRO[index].AlarmSensorsSilent[k+224] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+28]&0xff, k),eHousePRO[index].InputInverts[k+28]);
            eHousePRO[index].AlarmSensorsSilent[k+232] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+29]&0xff, k),eHousePRO[index].InputInverts[k+29]);
            eHousePRO[index].AlarmSensorsSilent[k+240] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+30]&0xff, k),eHousePRO[index].InputInverts[k+30]);
            eHousePRO[index].AlarmSensorsSilent[k+248] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+31]&0xff, k),eHousePRO[index].InputInverts[k+31]);
            }
            
    TempOffset=	EHOUSE_PRO_SMS_ADDR;
    eHousePRO[index].AlarmSensorsSMS[k ]    = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset]&0xff, k),   eHousePRO[index].InputInverts[k]);
    eHousePRO[index].AlarmSensorsSMS[k+  8] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 1]&0xff, k),eHousePRO[index].InputInverts[k+ 1]);
    eHousePRO[index].AlarmSensorsSMS[k+ 16] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 2]&0xff, k),eHousePRO[index].InputInverts[k+ 2]);
    eHousePRO[index].AlarmSensorsSMS[k+ 24] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 3]&0xff, k),eHousePRO[index].InputInverts[k+ 3]);
    eHousePRO[index].AlarmSensorsSMS[k+ 32] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 4]&0xff, k),eHousePRO[index].InputInverts[k+ 4]);
    eHousePRO[index].AlarmSensorsSMS[k+ 40] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 5]&0xff, k),eHousePRO[index].InputInverts[k+ 5]);
    eHousePRO[index].AlarmSensorsSMS[k+ 48] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 6]&0xff, k),eHousePRO[index].InputInverts[k+ 6]);
    eHousePRO[index].AlarmSensorsSMS[k+ 56] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 7]&0xff, k),eHousePRO[index].InputInverts[k+ 7]);
    eHousePRO[index].AlarmSensorsSMS[k+ 64] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 8]&0xff, k),eHousePRO[index].InputInverts[k+ 8]);
    eHousePRO[index].AlarmSensorsSMS[k+ 72] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 9]&0xff, k),eHousePRO[index].InputInverts[k+ 9]);
    eHousePRO[index].AlarmSensorsSMS[k+ 80] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+10]&0xff, k),eHousePRO[index].InputInverts[k+10]);
    eHousePRO[index].AlarmSensorsSMS[k+ 88] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+11]&0xff, k),eHousePRO[index].InputInverts[k+11]);
    eHousePRO[index].AlarmSensorsSMS[k+ 96] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+12]&0xff, k),eHousePRO[index].InputInverts[k+12]);
    eHousePRO[index].AlarmSensorsSMS[k+104] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+13]&0xff, k),eHousePRO[index].InputInverts[k+13]);
    eHousePRO[index].AlarmSensorsSMS[k+112] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+14]&0xff, k),eHousePRO[index].InputInverts[k+14]);
    eHousePRO[index].AlarmSensorsSMS[k+120] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+15]&0xff, k),eHousePRO[index].InputInverts[k+15]);
    if (EHOUSE_PRO_INPUTS_ALL)
            {
            eHousePRO[index].AlarmSensorsSMS[k+128] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+16]&0xff, k),eHousePRO[index].InputInverts[k+16]);
            eHousePRO[index].AlarmSensorsSMS[k+136] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+17]&0xff, k),eHousePRO[index].InputInverts[k+17]);
            eHousePRO[index].AlarmSensorsSMS[k+144] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+18]&0xff, k),eHousePRO[index].InputInverts[k+18]);
            eHousePRO[index].AlarmSensorsSMS[k+152] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+19]&0xff, k),eHousePRO[index].InputInverts[k+19]);
            eHousePRO[index].AlarmSensorsSMS[k+160] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+20]&0xff, k),eHousePRO[index].InputInverts[k+20]);
            eHousePRO[index].AlarmSensorsSMS[k+168] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+21]&0xff, k),eHousePRO[index].InputInverts[k+21]);
            eHousePRO[index].AlarmSensorsSMS[k+176] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+22]&0xff, k),eHousePRO[index].InputInverts[k+22]);
            eHousePRO[index].AlarmSensorsSMS[k+184] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+23]&0xff, k),eHousePRO[index].InputInverts[k=23]);
            eHousePRO[index].AlarmSensorsSMS[k+192] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+24]&0xff, k),eHousePRO[index].InputInverts[k+24]);
            eHousePRO[index].AlarmSensorsSMS[k+200] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+25]&0xff, k),eHousePRO[index].InputInverts[k+25]);
            eHousePRO[index].AlarmSensorsSMS[k+208] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+26]&0xff, k),eHousePRO[index].InputInverts[k+26]);
            eHousePRO[index].AlarmSensorsSMS[k+216] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+27]&0xff, k),eHousePRO[index].InputInverts[k+27]);
            eHousePRO[index].AlarmSensorsSMS[k+224] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+28]&0xff, k),eHousePRO[index].InputInverts[k+28]);
            eHousePRO[index].AlarmSensorsSMS[k+232] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+29]&0xff, k),eHousePRO[index].InputInverts[k+29]);
            eHousePRO[index].AlarmSensorsSMS[k+240] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+30]&0xff, k),eHousePRO[index].InputInverts[k+30]);
            eHousePRO[index].AlarmSensorsSMS[k+248] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+31]&0xff, k),eHousePRO[index].InputInverts[k+31]);
            }
			
    TempOffset=	EHOUSE_PRO_EARLYWARNING_ADDR;
    eHousePRO[index].AlarmSensorsEarlyWarning[k]     = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset]&0xff, k),   eHousePRO[index].InputInverts[k]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+  8] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 1]&0xff, k),eHousePRO[index].InputInverts[k+ 1]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 16] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 2]&0xff, k),eHousePRO[index].InputInverts[k+ 2]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 24] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 3]&0xff, k),eHousePRO[index].InputInverts[k+ 3]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 32] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 4]&0xff, k),eHousePRO[index].InputInverts[k+ 4]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 40] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 5]&0xff, k),eHousePRO[index].InputInverts[k+ 5]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 48] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 6]&0xff, k),eHousePRO[index].InputInverts[k+ 6]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 56] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 7]&0xff, k),eHousePRO[index].InputInverts[k+ 7]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 64] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 8]&0xff, k),eHousePRO[index].InputInverts[k+ 8]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 72] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+ 9]&0xff, k),eHousePRO[index].InputInverts[k+ 9]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 80] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+10]&0xff, k),eHousePRO[index].InputInverts[k+10]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 88] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+11]&0xff, k),eHousePRO[index].InputInverts[k+11]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+ 96] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+12]&0xff, k),eHousePRO[index].InputInverts[k+12]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+104] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+13]&0xff, k),eHousePRO[index].InputInverts[k+13]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+112] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+14]&0xff, k),eHousePRO[index].InputInverts[k+14]);
    eHousePRO[index].AlarmSensorsEarlyWarning[k+120] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+15]&0xff, k),eHousePRO[index].InputInverts[k+15]);
    if (EHOUSE_PRO_INPUTS_ALL)
            {
            eHousePRO[index].AlarmSensorsEarlyWarning[k+128] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+16]&0xff, k),eHousePRO[index].InputInverts[k+16]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+136] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+17]&0xff, k),eHousePRO[index].InputInverts[k+17]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+144] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+18]&0xff, k),eHousePRO[index].InputInverts[k+18]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+152] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+19]&0xff, k),eHousePRO[index].InputInverts[k+19]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+160] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+20]&0xff, k),eHousePRO[index].InputInverts[k+20]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+168] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+21]&0xff, k),eHousePRO[index].InputInverts[k+21]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+176] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+22]&0xff, k),eHousePRO[index].InputInverts[k+22]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+184] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+23]&0xff, k),eHousePRO[index].InputInverts[k+23]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+192] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+24]&0xff, k),eHousePRO[index].InputInverts[k+24]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+200] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+25]&0xff, k),eHousePRO[index].InputInverts[k+25]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+208] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+26]&0xff, k),eHousePRO[index].InputInverts[k+26]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+216] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+27]&0xff, k),eHousePRO[index].InputInverts[k+27]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+224] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+28]&0xff, k),eHousePRO[index].InputInverts[k+28]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+232] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+29]&0xff, k),eHousePRO[index].InputInverts[k+29]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+240] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+30]&0xff, k),eHousePRO[index].InputInverts[k+30]);
            eHousePRO[index].AlarmSensorsEarlyWarning[k+248] = ginv( GetInOutValue(eHousePRO[index].BinStat[TotalOffset+TempOffset+31]&0xff, k),eHousePRO[index].InputInverts[k+31]);
            }

			
             
    }

    eHousePRO[index].CurrentProgram=eHousePRO[index].BinStat[TotalOffset+STATUS_PROGRAM_NR]&0xff;
    eHousePRO[index].CurrentZone = eHousePRO[index].BinStat[TotalOffset+STATUS_ZONE_NR]&0xff;            
            
    i=0;
    while (i < EHOUSE_PRO_MAX_ADC/HALF_ADC)
                {                                               //offset od 2                       //offset od 2
                var temppp= eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_ADC_ADDR+i * 2 + 1 ]&0xff;
                if (temppp<0) temppp+=256;
                temppp+=((eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_ADC_ADDR+i * 2 ]&0xff) << 8);
                    eHousePRO[index].ADCs[i] = temppp;
                    eHousePRO[index].SensorTemps[i] = gettemplm(temppp, eHousePRO[index].Calibration[i], 10, eHousePRO[index].VCC);
                    eHousePRO[index].SensorPercents[i] = calculate_percent(temppp);
                    eHousePRO[index].SensorLights[i] = 100-eHousePRO[index].SensorPercents[i]; //inverted percent
                    eHousePRO[index].SensorTempsLM35[i]=gettemplm35(temppp,eHousePRO[index].VCC,eHousePRO[index].Calibration[i]);
                    eHousePRO[index].SensorTempsMCP9700[i]=calculate_MCP9700Eth(temppp,eHousePRO[index].VCC,eHousePRO[index].Calibration[i]);
                    eHousePRO[index].SensorTempsMCP9701[i]=calculate_MCP9701Eth(temppp,eHousePRO[index].VCC,eHousePRO[index].Calibration[i]);
                    eHousePRO[index].SensorVolts[i]=calculate_voltage(temppp,eHousePRO[index].VCC);
                    i++;
                }
                i=0;
    while (i < EHOUSE_PRO_MAX_DIMMERS/HALF_DIMMERS)
                {                         
                eHousePRO[index].Dimmers[i]=temppp= ((eHousePRO[index].BinStat[TotalOffset+EHOUSE_PRO_DIMMER_ADDR+i]&0xff)/0xff)*100;
                i++;
                }        
        }


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Show eHouseEthernet status XML
function ShowEthernetEhouseStatus(index)
        {    
            //this.
            
{

var eol="\r\n<br>\r\n",Event,XML="";;

var header,footer,body,bodyheader,bodyfooter;    
header="<?xml version=\"1.0\" encoding=\"UTF-8\" ?> \r\n <eHouse xmlns=\"http://www.isys.pl\" \r\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n            xsi:schemaLocation=\"http://www.openremote.org protocol.xsd\">";
header+="<Device>"+eol;
header+="<Name>"+EthernetEhouse[index].Name+"</Name>"+eol;
header+="<Address>"+EthernetEhouse[index].AddrH+","+EthernetEhouse[index].AddrL+"</Address>"+eol;
header+="<IPAddress>192.168."+EthernetEhouse[index].AddrH+"."+EthernetEhouse[index].AddrL+"</IPAddress>"+eol;            
header+="<AddressCombined>"+EthernetEhouse[index].Addr+"</AddressCombined>"+eol;
//header+="<StateModified>"+ehousecommunication.bo(changed)+"</StateModified>"+eol;
//header+="<ADCModified>"+ehousecommunication.bo(AdcChanged)+"</ADCModified>"+eol;
header+="<CurrentProgram>"+EthernetEhouse[index].CurrentProgram+"</CurrentProgram>"+eol;
//header+="<CurrentProgramName> "+ CurrentProgramName+" </CurrentProgramName>"+eol;
header+="<ADCCurrentProgram>"+EthernetEhouse[index].ADCCurrentProgram+"</ADCCurrentProgram>"+eol;
//header+="<ADCCurrentProgramName> "+ ADCCurrentProgramName+" </ADCCurrentProgramName>"+eol;
header+="<CurrentStatus>"+EthernetEhouse[index].Stat+"</CurrentStatus>"+eol;
//header+="<RecentStatus>"+EthernetEhouse[index].recent+"</RecentStatus>"+eol;
if (EthernetEhouse[index].Type===IsERM) header+="<Devicetype>"+"EthernetRoomManager"+"</Devicetype>"+eol;
if (EthernetEhouse[index].Type===IsCommManager) header+="<Devicetype>"+"CommManager"+"</Devicetype>"+eol;
if (EthernetEhouse[index].Type===IsEHM ) header+="<Devicetype>"+"EthernetRoomManager"+"</Devicetype>"+eol;
if (EthernetEhouse[index].Type===IsLevelManager) header+="<Devicetype>"+"LevelManager"+"</Devicetype>"+eol;
//if (IsEthernet)  header+="<InterfaceType>"+"Ethernet"+"</InterfaceType>"+eol;;
        if (EthernetEhouse[index].Type===IsCommManager)       //communicationManager
            {
            header+="<CurrentZone>"+EthernetEhouse[index].CurrentZone+"</CurrentZone>"+eol;
//            header+="<CurrentZoneName>"+ CurrentZoneName+"</CurrentZoneName>"+eol;

            }
bodyheader=eol+"<Outputs>"+eol;
body="";
var maxio=OUTPUTS_COUNT_ERM;
if ((EthernetEhouse[index].Type===IsERM) || (EthernetEhouse[index].Type===IsEHM) || (EthernetEhouse[index].Type===IsEEM)) maxio=40;
for (var i=0;i<maxio;i++)
{    
if (((!IgnoreAtChar) || (EthernetEhouse[index].OutsNames[i].indexOf("@")<0)))    
    {
    
    var tmp=new Array();
    tmp[0]=EthernetEhouse[index].AddrH;
    tmp[1]=EthernetEhouse[index].AddrL;
    tmp[2]=0x21;
    tmp[3]=0;
    tmp[4]=1;
    tmp[5]=0;
    tmp[6]=0;
    tmp[7]=0;
    tmp[8]=0;
    tmp[9]=0;
    
    tmp[3]=i;
    var state="0", value="Off";   if (EthernetEhouse[index].Outs[i]) {state="1";value="On";}
    body+="    <Item>"+eol+
    "        <Name>"+EthernetEhouse[index].OutsNames[i]+"</Name>"+eol+
    "        <No>"+(i+1)+"</No>"+eol+
    "        <State>"+state+"</State>"+eol+
    "        <Value>"+value+"</Value>"+eol;
//    Event=hix(tmp,10);
//    body+="        <EventOn>"+Event+"</EventOn>"+eol;
//    tmp[4]=0;Event=hix(tmp,10);
//    body+="        <EventOff>"+Event+"</EventOff>"+eol;
//    tmp[4]=2;Event=hix(tmp,10);
//    body+="        <EventToggle>"+Event+"</EventToggle>"+eol;            
   body +="    </Item>"+eol+eol;
    }
}
bodyfooter=eol+"</Outputs>"+eol;

header+=bodyheader+body+bodyfooter+eol;
bodyheader=eol+"<ADCInputs>"+eol;
body=eol;
bodyfooter=eol+"</ADCInputs>"+eol;
var maxio=SENSORS_COUNT_ERM;
for (var i=0;i<maxio;i++)
{
 if (((!IgnoreAtChar) || (EthernetEhouse[index].ADCsNames[i].indexOf("@")<0)))    
    {
        body+="    <Item>"+eol+
    "        <Name>"+EthernetEhouse[index].ADCsNames[i]+"</Name>"+eol+
    "        <ADCValue>"+EthernetEhouse[index].ADCs[i]+"</ADCValue>"+eol+
    "        <ADCTempValue>"+EthernetEhouse[index].SensorTemps[i]+"</ADCTempValue>"+eol+
    "        <ADCLM335TempValue>"+EthernetEhouse[index].SensorTemps[i]+"</ADCLM335TempValue>"+eol+
    "        <ADCLM35TempValue>"+EthernetEhouse[index].SensorTempsLM35[i]+"</ADCLM35TempValue>"+eol+            
    "        <ADCMCP9700TempValue>"+EthernetEhouse[index].SensorTempsMCP9700[i]+"</ADCMCP9700TempValue>"+eol+
    "        <ADCMCP9701TempValue>"+EthernetEhouse[index].SensorTempsMCP9701[i]+"</ADCMCP9701TempValue>"+eol+
    "        <ADCPercentValue>"+EthernetEhouse[index].SensorPercents[i]+"</ADCPercentValue>"+eol+
    "        <ADCInvertedPercentValue>"+EthernetEhouse[index].SensorLights[i]+"</ADCInvertedPercentValue>"+eol+
    "        <ADCVoltageValue>"+EthernetEhouse[index].SensorVolts[i]+"</ADCVoltageValue>"+eol+
    "        <ADCCalibrationValue>"+EthernetEhouse[index].Calibration[i]+"</ADCCalibrationValue>"+eol+
    
    "        <No>"+(i+1)+"</No>"+eol;
//    "        <SensorType>"+SensorType[i]+"</SensorType>"+eol+
//    "        <SensorTypeName>"+SensorTypeName[i]+"</SensorTypeName>"+eol;
    //Event=hix(tmp,10);
    //body+="        <EventOn>"+Event+"</EventOn>"+eol;
    //tmp[4]=0;Event=hix(tmp,10);
    //body+="        <EventOff>"+Event+"</EventOff>"+eol;
    //tmp[4]=2;Event=hix(tmp,10);
    //body+="        <EventToggle>"+Event+"</EventToggle>"+eol            
    /*String inversion="Normal";
    if (InputInverts[i]) inversion="Inverted";
     body+="        <Type>"+inversion+"</Type>"+eol;
     */
     body+="    </Item>"+eol+eol;
    }
}

header+=bodyheader+body+bodyfooter+eol;



bodyheader=eol+"<Inputs>"+eol;
body=eol;
bodyfooter=eol;
maxio=INPUTS_COUNT_ERM;
if ((EthernetEhouse[index].Type===IsERM) || (EthernetEhouse[index].Type===IsEHM) || (EthernetEhouse[index].Type===IsEEM)) maxio=16;
for (var i=0;i<maxio;i++)
{
    
if (((IgnoreAtChar) || (EthernetEhouse[index].InputNames[i].indexOf("@")<0)))    
{
//    int tmp[]={DevAdrH,DevAdrL,0x21,0,1,0,0,0,0,0};
  //  tmp[3]=i;
    var state="0", value="Off";   
    /*if ((IsCommManager) || (IsLevelManager)) 
        {
        if (!((InputStates[i])^(InputInverts[i])))
            {state="1";value="Off";} 
        else
            {state="0";value="On";}
    
        }
    else
        {
        if ((InputStates[i])^(InputInverts[i]))
            {state="0";value="On";} 
        else
            {state="1";value="Off";}
        }*/
    if (((EthernetEhouse[index].Inputs[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
    
    body+="    <Item>"+eol+
    "        <Name>"+EthernetEhouse[index].InputsNames[i]+"</Name>"+eol+
            
    "        <No>"+(i+1)+"</No>"+eol+
    "        <State>"+state+"</State>"+eol+
    "        <Value>"+value+"</Value>"+eol;
    if ((IsCommManager) || (IsLevelManager)) 
        {

            
if (((EthernetEhouse[index].AlarmSensorsActive[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}            
        /*if (!((AlarmSensorsActive[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <ActiveState>"+state+"</ActiveState>"+eol+
        "        <ActiveValue>"+value+"</ActiveValue>"+eol;
          
if (((EthernetEhouse[index].AlarmSensorsWarning[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}            
/*            
        if (!((AlarmSensorsWarning[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <WarningState>"+state+"</WarningState>"+eol+
        "        <WarningValue>"+value+"</WarningValue>"+eol;
        
        //MonitoringSensorsWarning
        if (((EthernetEhouse[index].AlarmSensorsMonitoring[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
        /*if (!((AlarmSensorsMonitoring[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <MonitoringState>"+state+"</MonitoringState>"+eol+
        "        <MonitoringValue>"+value+"</MonitoringValue>"+eol;
        
        if (((EthernetEhouse[index].AlarmSensorsAlarm[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
       /*if (!((AlarmSensorsAlarm[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <AlarmState>"+state+"</AlarmState>"+eol+
        "        <AlarmValue>"+value+"</AlarmValue>"+eol;
        
        
        
        
        }
    //Event=hix(tmp,10);
    //body+="        <EventOn>"+Event+"</EventOn>"+eol;
    //tmp[4]=0;Event=hix(tmp,10);
    //body+="        <EventOff>"+Event+"</EventOff>"+eol;
    //tmp[4]=2;Event=hix(tmp,10);
    //body+="        <EventToggle>"+Event+"</EventToggle>"+eol            
    var inversion="Normal";
    if (EthernetEhouse[index].InputInverts[i]) inversion="Inverted";
     body+="        <Type>"+inversion+"</Type>"+eol;
     
     body+="    </Item>"+eol+eol;
}
}
bodyfooter=eol+"</Inputs>"+eol;

header+=bodyheader+body+bodyfooter+eol;
footer="</Device>\r\n";
footer+="\r\n</eHouse> \r\n";


XML= header+footer;
var stringToFind=">",stringToReplace="&gt;";
var inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
stringToFind="<",stringToReplace="&lt;";
inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
stringToFind="&lt;br&gt;",stringToReplace="<br>";
inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
        
//XML=XML.replaceAll(">","&gt;");
//XML=XML.replaceAll("<","&lt;");
document.writeln(XML);
}
	}
///////////////////////////////////////////////////////////////////////////////////////
//
//Show eHousePRO XML STATUS
//
function ShowEhousePROStatus(index)
        {    
            //this.
            
{

var eol="\r\n<br>\r\n",Event,XML="";;

var header,footer,body,bodyheader,bodyfooter;    
header="<?xml version=\"1.0\" encoding=\"UTF-8\" ?> \r\n <eHouse xmlns=\"http://www.isys.pl\" \r\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n            xsi:schemaLocation=\"http://www.openremote.org protocol.xsd\">";
header+="<Device>"+eol;
header+="<Name>"+eHousePRO[index].Name+"</Name>"+eol;
header+="<Address>"+eHousePRO[index].AddrH+","+eHousePRO[index].AddrL+"</Address>"+eol;
header+="<IPAddress>192.168."+eHousePRO[index].AddrH+"."+eHousePRO[index].AddrL+"</IPAddress>"+eol;            
//header+="<AddressCombined>"+EthernetEhouse[index].Addr+"</AddressCombined>"+eol;
//header+="<StateModified>"+ehousecommunication.bo(changed)+"</StateModified>"+eol;
//header+="<ADCModified>"+ehousecommunication.bo(AdcChanged)+"</ADCModified>"+eol;
header+="<CurrentProgram>"+eHousePRO[index].CurrentProgram+"</CurrentProgram>"+eol;
//header+="<CurrentProgramName> "+ CurrentProgramName+" </CurrentProgramName>"+eol;
header+="<ADCCurrentProgram>"+eHousePRO[index].ADCCurrentProgram+"</ADCCurrentProgram>"+eol;
//header+="<ADCCurrentProgramName> "+ ADCCurrentProgramName+" </ADCCurrentProgramName>"+eol;
header+="<CurrentStatus>"+eHousePRO[index].Stat+"</CurrentStatus>"+eol;
//header+="<RecentStatus>"+EthernetEhouse[index].recent+"</RecentStatus>"+eol;
header+="<Devicetype>"+"eHousePro"+"</Devicetype>"+eol;
//if (EthernetEhouse[index].Type===IsCommManager) header+="<Devicetype>"+"CommManager"+"</Devicetype>"+eol;
//if (EthernetEhouse[index].Type===IsEHM ) header+="<Devicetype>"+"EthernetRoomManager"+"</Devicetype>"+eol;
//if (EthernetEhouse[index].Type===IsLevelManager) header+="<Devicetype>"+"LevelManager"+"</Devicetype>"+eol;
//if (IsEthernet)  header+="<InterfaceType>"+"Ethernet"+"</InterfaceType>"+eol;;
  //      if (EthernetEhouse[index].Type===IsCommManager)       //communicationManager
            {
            header+="<CurrentZone>"+eHousePRO[index].CurrentZone+"</CurrentZone>"+eol;
//            header+="<CurrentZoneName>"+ CurrentZoneName+"</CurrentZoneName>"+eol;

            }
bodyheader=eol+"<Outputs>"+eol;
body="";
var maxio=EHOUSE_PRO_MAX_OUTPUTS/HALF_OUTPUTS;
//if ((eHousePRO[index].Type===IsERM) || (EthernetEhouse[index].Type===IsEHM) || (EthernetEhouse[index].Type===IsEEM)) maxio=40;
for (var i=0;i<maxio;i++)
{    
if (((!IgnoreAtChar) || (eHousePRO[index].OutsNames[i].indexOf("@")<0)))    
    {
    
    var tmp=new Array();
    tmp[0]=eHousePRO[index].AddrH;
    tmp[1]=eHousePRO[index].AddrL;
    tmp[2]=0x21;
    tmp[3]=0;
    tmp[4]=1;
    tmp[5]=0;
    tmp[6]=0;
    tmp[7]=0;
    tmp[8]=0;
    tmp[9]=0;
    
    tmp[3]=i;
    var state="0", value="Off";   if (eHousePRO[index].Outs[i]) {state="1";value="On";}
    body+="    <Item>"+eol+
    "        <Name>"+eHousePRO[index].OutsNames[i]+"</Name>"+eol+
    "        <No>"+(i+1)+"</No>"+eol+
    "        <State>"+state+"</State>"+eol+
    "        <Value>"+value+"</Value>"+eol;
//    Event=hix(tmp,10);
//    body+="        <EventOn>"+Event+"</EventOn>"+eol;
//    tmp[4]=0;Event=hix(tmp,10);
//    body+="        <EventOff>"+Event+"</EventOff>"+eol;
//    tmp[4]=2;Event=hix(tmp,10);
//    body+="        <EventToggle>"+Event+"</EventToggle>"+eol;            
   body +="    </Item>"+eol+eol;
    }
}
bodyfooter=eol+"</Outputs>"+eol;

header+=bodyheader+body+bodyfooter+eol;
bodyheader=eol+"<ADCInputs>"+eol;
body=eol;
bodyfooter=eol+"</ADCInputs>"+eol;
var maxio=EHOUSE_PRO_MAX_ADC/HALF_ADC;
for (var i=0;i<maxio;i++)
{
 if (((!IgnoreAtChar) || (eHousePRO[index].ADCsNames[i].indexOf("@")<0)))    
    {
        body+="    <Item>"+eol+
    "        <Name>"+eHousePRO[index].ADCsNames[i]+"</Name>"+eol+
    "        <ADCValue>"+eHousePRO[index].ADCs[i]+"</ADCValue>"+eol+
    "        <ADCTempValue>"+eHousePRO[index].SensorTemps[i]+"</ADCTempValue>"+eol+
    "        <ADCLM335TempValue>"+eHousePRO[index].SensorTemps[i]+"</ADCLM335TempValue>"+eol+
    "        <ADCLM35TempValue>"+eHousePRO[index].SensorTempsLM35[i]+"</ADCLM35TempValue>"+eol+            
    "        <ADCMCP9700TempValue>"+eHousePRO[index].SensorTempsMCP9700[i]+"</ADCMCP9700TempValue>"+eol+
    "        <ADCMCP9701TempValue>"+eHousePRO[index].SensorTempsMCP9701[i]+"</ADCMCP9701TempValue>"+eol+
    "        <ADCPercentValue>"+eHousePRO[index].SensorPercents[i]+"</ADCPercentValue>"+eol+
    "        <ADCInvertedPercentValue>"+eHousePRO[index].SensorLights[i]+"</ADCInvertedPercentValue>"+eol+
    "        <ADCVoltageValue>"+eHousePRO[index].SensorVolts[i]+"</ADCVoltageValue>"+eol+
    "        <ADCCalibrationValue>"+eHousePRO[index].Calibration[i]+"</ADCCalibrationValue>"+eol+
    
    "        <No>"+(i+1)+"</No>"+eol;
//    "        <SensorType>"+SensorType[i]+"</SensorType>"+eol+
//    "        <SensorTypeName>"+SensorTypeName[i]+"</SensorTypeName>"+eol;
    //Event=hix(tmp,10);
    //body+="        <EventOn>"+Event+"</EventOn>"+eol;
    //tmp[4]=0;Event=hix(tmp,10);
    //body+="        <EventOff>"+Event+"</EventOff>"+eol;
    //tmp[4]=2;Event=hix(tmp,10);
    //body+="        <EventToggle>"+Event+"</EventToggle>"+eol            
    /*String inversion="Normal";
    if (InputInverts[i]) inversion="Inverted";
     body+="        <Type>"+inversion+"</Type>"+eol;
     */
     body+="    </Item>"+eol+eol;
    }
}

header+=bodyheader+body+bodyfooter+eol;



bodyheader=eol+"<Inputs>"+eol;
body=eol;
bodyfooter=eol;
maxio=EHOUSE_PRO_MAX_INPUTS/HALF_INPUTS;
//if ((eHousePRO[index].Type===IsERM) || (EthernetEhouse[index].Type===IsEHM) || (EthernetEhouse[index].Type===IsEEM)) maxio=16;
for (var i=0;i<maxio;i++)
{
    
if (((IgnoreAtChar) || (eHousePRO[index].InputNames[i].indexOf("@")<0)))    
{
//    int tmp[]={DevAdrH,DevAdrL,0x21,0,1,0,0,0,0,0};
  //  tmp[3]=i;
    var state="0", value="Off";   
    /*if ((IsCommManager) || (IsLevelManager)) 
        {
        if (!((InputStates[i])^(InputInverts[i])))
            {state="1";value="Off";} 
        else
            {state="0";value="On";}
    
        }
    else
        {
        if ((InputStates[i])^(InputInverts[i]))
            {state="0";value="On";} 
        else
            {state="1";value="Off";}
        }*/
    if (((eHousePRO[index].Inputs[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
    
    body+="    <Item>"+eol+
    "        <Name>"+eHousePRO[index].InputsNames[i]+"</Name>"+eol+
            
    "        <No>"+(i+1)+"</No>"+eol+
    "        <State>"+state+"</State>"+eol+
    "        <Value>"+value+"</Value>"+eol;
//    if ((IsCommManager) || (IsLevelManager)) 
        {

//active            
if (((eHousePRO[index].AlarmSensorsActive[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}            
        /*if (!((AlarmSensorsActive[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <ActiveState>"+state+"</ActiveState>"+eol+
        "        <ActiveValue>"+value+"</ActiveValue>"+eol;
//warning          
if (((eHousePRO[index].AlarmSensorsWarning[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}            
/*            
        if (!((AlarmSensorsWarning[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <WarningState>"+state+"</WarningState>"+eol+
        "        <WarningValue>"+value+"</WarningValue>"+eol;
        
//Monitoring
if (((eHousePRO[index].AlarmSensorsMonitoring[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
        /*if (!((AlarmSensorsMonitoring[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <MonitoringState>"+state+"</MonitoringState>"+eol+
        "        <MonitoringValue>"+value+"</MonitoringValue>"+eol;
//alarm        
if (((eHousePRO[index].AlarmSensorsAlarm[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
       /*if (!((AlarmSensorsAlarm[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <AlarmState>"+state+"</AlarmState>"+eol+
        "        <AlarmValue>"+value+"</AlarmValue>"+eol;
//SMS        
if (((eHousePRO[index].AlarmSensorsSMS[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
       /*if (!((AlarmSensorsAlarm[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <SMSState>"+state+"</SMSState>"+eol+
        "        <SMSValue>"+value+"</SMSValue>"+eol;
//Silent
if (((eHousePRO[index].AlarmSensorsSilent[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
       /*if (!((AlarmSensorsAlarm[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <SilentState>"+state+"</SilentState>"+eol+
        "        <SilentValue>"+value+"</SilentValue>"+eol;
//EarlyWarning
if (((eHousePRO[index].AlarmSensorsEarlyWarning[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
       /*if (!((AlarmSensorsAlarm[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <EarlyWarningState>"+state+"</EarlyWarningState>"+eol+
        "        <EarlyWarningValue>"+value+"</EarlyWarningValue>"+eol;
//Horn
if (((eHousePRO[index].AlarmSensorsHorn[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
       /*if (!((AlarmSensorsAlarm[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <HornState>"+state+"</HornState>"+eol+
        "        <HornValue>"+value+"</HornValue>"+eol;

        
        
        }
    //Event=hix(tmp,10);
    //body+="        <EventOn>"+Event+"</EventOn>"+eol;
    //tmp[4]=0;Event=hix(tmp,10);
    //body+="        <EventOff>"+Event+"</EventOff>"+eol;
    //tmp[4]=2;Event=hix(tmp,10);
    //body+="        <EventToggle>"+Event+"</EventToggle>"+eol            
    var inversion="Normal";
    if (eHousePRO[index].InputInverts[i]) inversion="Inverted";
     body+="        <Type>"+inversion+"</Type>"+eol;
     
     body+="    </Item>"+eol+eol;
}
}
bodyfooter=eol+"</Inputs>"+eol;


header+=bodyheader+body+bodyfooter+eol;
bodyheader=eol+"<Dimmers>"+eol;
body=eol;
bodyfooter=eol+"</Dimmers>"+eol;
var maxio=EHOUSE_PRO_MAX_DIMMERS/HALF_DIMMERS;
for (var i=0;i<maxio;i++)
{
 if (((!IgnoreAtChar) || (eHousePRO[index].DimmersNames[i].indexOf("@")<0)))    
    {
        body+="    <Item>"+eol+
    "        <Name>"+eHousePRO[index].DimmersNames[i]+"</Name>"+eol+
    "        <Value>"+eHousePRO[index].Dimmers[i]+"</Value>"+eol+
    "        <No>"+(i+1)+"</No>"+eol;
     body+="    </Item>"+eol+eol;
    }
}


header+=bodyheader+body+bodyfooter+eol;








footer="</Device>\r\n";
footer+="\r\n</eHouse> \r\n";


XML= header+footer;
var stringToFind=">",stringToReplace="&gt;";
var inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
stringToFind="<",stringToReplace="&lt;";
inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
stringToFind="&lt;br&gt;",stringToReplace="<br>";
inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
        
//XML=XML.replaceAll(">","&gt;");
//XML=XML.replaceAll("<","&lt;");
document.writeln(XML);
}
	}
///////////////////////////////////////////////////////////////////////////////////////
// Highlight on mouse over normal when leaving
///////////////////////////////////////////////////////////////////////////////////////
function hilight(evt,text,fill){
var T=evt.target;
if (T.id==="background") return;
if (evt.type==="mouseover") 
	{
	T.setAttributeNS(null,"stroke-opacity",0.8);
	T.setAttributeNS(null,"fill-opacity",0.8)	;			
	window.status=text;
	}
else 
	{
	if (fill==="none") T.setAttributeNS(null,"fill-opacity",transparencyopacity);
	else T.setAttributeNS(null,"fill-opacity",fill_opacity);
	T.setAttributeNS(null,"stroke-opacity",stroke_opacity);
        window.status='';
	}
}

var   VISUAL_ADC_IN           =110;
var   VISUAL_TEMP_IN          =111;
var VISUAL_LIGHT_IN         =112;
var VISUAL_LM35_IN          =113;
var VISUAL_LM335_IN	        =114;
var VISUAL_MCP9700_IN	= 115;
var VISUAL_MCP9701_IN	=116;
var VISUAL_PERCENT_IN	=117;
var VISUAL_INVERTED_PERCENT_IN=118;
var VISUAL_VOLTAGE_IN	=119;
var VISUAL_DYNAMIC_TEXT	=120;
var  VISUAL_INPUT_IN	=121;
var VISUAL_ACTIVE_IN	=122;
var VISUAL_WARNING_IN	=123;
var VISUAL_MONITORING_IN	=124;
var VISUAL_ALARM_IN		=125;
var VISUAL_DIMMER_OUT	=126;
var VISUAL_SILENT_IN=127;
var VISUAL_EARLYWARNING_IN=128;
var VISUAL_SMS_IN=129;
var VISUAL_HORN_IN=127;
/*
VISUAL_ADC_IN
VISUAL_TEMP_IN
VISUAL_LIGHT_IN
VISUAL_LM35_IN
VISUAL_LM335_IN
VISUAL_MCP9700_IN
VISUAL_MCP9701_IN
VISUAL_PERCENT_IN
VISUAL_INVERTED_PERCENT_IN
VISUAL_VOLTAGE_IN
VISUAL_INPUT_IN
VISUAL_ACTIVE_IN
VISUAL_WARNING_IN
VISUAL_MONITORING_IN
VISUAL_ALARM_IN
VISUAL_DIMMER_OUT
*/
function VisualEhouse1(ind) 
{
var StatusCode="";
var i,k;
var EventCode=1;
if (ind===0)     EventCode=VISUAL_LM335_IN; //for hm other signal then inputs
for (i=0;i<(OUTPUTS_COUNT_RM);i++)    
    {
    StatusCode=d2h(eHouse1[ind].AddrH)+d2h(eHouse1[ind].AddrL)+d2h(EventCode)+d2h(i+1);
    
     if (Optimalize)
                {
                eHouse1[ind].OutsDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHouse1[ind].OutsDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }
    else
        {
        if (eHouse1[ind].Outs[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHouse1[ind].OutsDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHouse1[ind].OutsDomIndexH[i]);
            }    
         else
            {
            VisibleItems(StatusCode+'00',true,eHouse1[ind].OutsDomIndexL[i]);
            VisibleItems(StatusCode+'01',false,eHouse1[ind].OutsDomIndexH[i]);   
            }
        } 
    }

for (i=0;i<(INPUTS_COUNT_RM);i++)    
    {    
    StatusCode=d2h(eHouse1[ind].AddrH)+d2h(eHouse1[ind].AddrL)+d2h(VISUAL_INPUT_IN)+d2h(i+1);
    if (eHouse1[ind].Inputs[i]) 
         {
         VisibleItems(StatusCode+'00',false,eHouse1[ind].InputsDomIndexL[i]);
         VisibleItems(StatusCode+'01',true,eHouse1[ind].InputsDomIndexH[i]);
         }
     else
         {
         VisibleItems(StatusCode+'00',true,eHouse1[ind].InputsDomIndexL[i]);
         VisibleItems(StatusCode+'01',false,eHouse1[ind].InputsDomIndexH[i]);   
         }                  
    if (Optimalize)
        {
        eHouse1[ind].InputsDomIndexH[i]=FindFirstNode(StatusCode+'01');
        eHouse1[ind].InputsDomIndexL[i]=FindFirstNode(StatusCode+'00');
        }                
    }
	
    for (i=0;i<SENSORS_COUNT_RM;i++)
        {
        StatusCode=d2h(eHouse1[ind].AddrH)+d2h(eHouse1[ind].AddrL)+d2h(VISUAL_ADC_IN)+d2h(i+1)+"00";            
        ReplaceText(StatusCode,"%TEMP%",eHouse1[ind].SensorTemps[i],eHouse1[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%TEMP"+(i)+"%",eHouse1[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%CURRENTPROGRAM%", String.valueOf(eHouse1[ind].CurrentProgram),eHouse1[ind].SensorsDomIndex[i]); //current program nr
        if (ind>0)  //for RM make calculations for known optional sensors
            {
            ReplaceText(StatusCode,"%LIGHT%",eHouse1[ind].SensorLights[i],eHouse1[ind].SensorsDomIndex[i]);         //light value / 100% - percent
            ReplaceText(StatusCode,"%ADC%",eHouse1[ind].ADCs[i],eHouse1[ind].SensorsDomIndex[i]);                   //absolute value
            ReplaceText(StatusCode,"%PERCENT%",eHouse1[ind].SensorPercents[i],eHouse1[ind].SensorsDomIndex[i]);     //percent value
            ReplaceText(StatusCode,"%VOLT%",eHouse1[ind].SensorVolts[i],eHouse1[ind].SensorsDomIndex[i]);           //voltage value
            ReplaceText(StatusCode,"%LIGHT"+(i)+"%",eHouse1[ind].SensorLights[i],eHouse1[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%ADC"+(i)+"%",eHouse1[ind].ADCs[i],eHouse1[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%PERCENT"+(i)+"%",eHouse1[ind].SensorPercents[i],eHouse1[ind].SensorsDomIndex[i]);  //calculate percent value
            ReplaceText(StatusCode,"%VOLT"+(i)+"%",eHouse1[ind].SensorVolts[i],eHouse1[ind].SensorsDomIndex[i]);              
            }   
         else       //heat manager replacement status
             {
              ReplaceText(StatusCode,"%HEATER_RECUPERATOR_TEMP%",HEATER_RECUPERATOR_TEMP,eHouse1[ind].SensorsDomIndex[i]);  // â€“ Internal recu temp
              ReplaceText(StatusCode,"%HEATER_RECUPERATOR_SPEED%",HEATER_RECUPERATOR_SPEED,eHouse1[ind].SensorsDomIndex[i]);  // â€“ Internal recu speed
              ReplaceText(StatusCode,"%HEATER_RECUPERATOR_MODE%",HEATER_RECUPERATOR_MODE,eHouse1[ind].SensorsDomIndex[i]);   //â€“ REcu mode
              ReplaceText(StatusCode,"%HEATER_PROGRAM%",HEATER_PROGRAM,eHouse1[ind].SensorsDomIndex[i]);            // â€“ Program of HeatManager
              ReplaceText(StatusCode,"%HEATER_KOMSTAT%",HEATER_KOMSTAT,eHouse1[ind].SensorsDomIndex[i]);            // â€“ Status of bonfire                
             }
        if (Optimalize)
                {
                eHouse1[ind].SensorsDomIndex[i]=FindFirstNode(StatusCode);
			    }
				
        }
StatusCode=d2h(eHouse1[ind].AddrH)+d2h(eHouse1[ind].AddrL)+d2h(VISUAL_DYNAMIC_TEXT)+d2h(0)+d2h(0);		
for (i=0;i<SENSORS_COUNT_RM;i++)
		{
		
		ReplaceText(StatusCode,"%LIGHT"+(i)+"%",eHouse1[ind].SensorLights[i],eHouse1[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%ADC"+(i)+"%",eHouse1[ind].ADCs[i],eHouse1[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%PERCENT"+(i)+"%",eHouse1[ind].SensorPercents[i],eHouse1[ind].SensorsDomIndex[i]);  //calculate percent value
        ReplaceText(StatusCode,"%VOLT"+(i)+"%",eHouse1[ind].SensorVolts[i],eHouse1[ind].SensorsDomIndex[i]);                          
		}
   if (ind===0)    //for HM status also accept other unknown layers
        {
		//StatusCode=d2h(eHouse1[ind].AddrH)+d2h(eHouse1[ind].AddrL)+d2h(VISUAL_DYNAMIC_TEXT)+d2h(0)+d2h(0);
        //StatusCode="";            //VISUAL_DYNAMIC_TEXT
        for (i=0;i<SENSORS_COUNT_RM;i++)
            {
            ReplaceText(StatusCode,"%TEMP"+(i)+"%",eHouse1[ind].SensorTemps[i],eHouse1[ind].SensorsDomIndex[i]);
            }
       ReplaceText(StatusCode,"%HEATER_RECUPERATOR_TEMP%",HEATER_RECUPERATOR_TEMP,eHouse1[ind].SensorsDomIndex[i]);     // â€“ Internal recu temp
       ReplaceText(StatusCode,"%HEATER_RECUPERATOR_SPEED%",HEATER_RECUPERATOR_SPEED,eHouse1[ind].SensorsDomIndex[i]);   // â€“ Internal recu speed
       ReplaceText(StatusCode,"%HEATER_RECUPERATOR_MODE%",HEATER_RECUPERATOR_MODE,eHouse1[ind].SensorsDomIndex[i]);     //â€“ REcu mode
       ReplaceText(StatusCode,"%HEATER_PROGRAM%",HEATER_PROGRAM,eHouse1[ind].SensorsDomIndex[i]);                       // â€“ Program of HeatManager
       ReplaceText(StatusCode,"%HEATER_KOMSTAT%",HEATER_KOMSTAT,eHouse1[ind].SensorsDomIndex[i]);                       // â€“ Status of bonfire
       }
    else	   
   if (eHouse1[ind].AddrH===2)
		{
		ReplaceText(StatusCode,"%EXTERNAL_CURRENTZONENAME%",EXTERNAL_CURRENTZONENAME,eHouse1[ind].SensorsDomIndex[i]);  // â€“ Nazwa Strefy zabezpieczeĹ„ â€“ External Managera
        ReplaceText(StatusCode,"%EXTERNAL_CURRENTPROGRAM%",EXTERNAL_CURRENTPROGRAM,eHouse1[ind].SensorsDomIndex[i]);    //â€“ External Manager â€“ Program rolet NR
        ReplaceText(StatusCode,"%EXTERNAL_CURRENTPROGRAMNAME%",EXTERNAL_CURRENTPROGRAMNAME,eHouse1[ind].SensorsDomIndex[i]); //â€“ External Manager â€“ Nazwa Programu Rolet
        ReplaceText(StatusCode,"%EXTERNAL_CURRENTZONE%",EXTERNAL_CURRENTZONE,eHouse1[ind].SensorsDomIndex[i]);        //â€“ External Manager â€“ Nr strefy zabezpieczeĹ„
		}
	else
		{
        ReplaceText(StatusCode,"%CURRENTPROGRAM%",eHouse1[ind].CurrentProgram,eHouse1[ind].CurrentProgramDomIndex);    //â€“ External Manager â€“ Program rolet NR
        //ReplaceText(StatusCode,"%CURRENTPROGRAMNAME%","",eHouse1[ind].SensorsDomIndex[i]); //â€“ External Manager â€“ Nazwa Programu Rolet

		}
}
////////////////////////////////////////////////////////////////////////////////
function VisualEthernetEhouse(ind) 
{
//check all object if index starts from 0 or 1 >> d2h(i)
var StatusCode="";
var i,k;
var EventCode=0x21;
if (ind===0)     EventCode=VISUAL_LM335_IN; //for hm other signal then inputs
for (i=0;i<(OUTPUTS_COUNT_ERM);i++)    
    {
    StatusCode=d2h(EthernetEhouse[ind].AddrH)+d2h(EthernetEhouse[ind].AddrL)+d2h(EventCode)+d2h(i);//+1);
    if (EthernetEhouse[ind].Outs[i]) 
            {
            VisibleItems(StatusCode+'00',false,EthernetEhouse[ind].OutsDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,EthernetEhouse[ind].OutsDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,EthernetEhouse[ind].OutsDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,EthernetEhouse[ind].OutsDomIndexH[i]);   
         }
       if (Optimalize)
                {
                EthernetEhouse[ind].OutsDomIndexH[i]=FindFirstNode(StatusCode+'01');
                EthernetEhouse[ind].OutsDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }
    }

for (i=0;i<(INPUTS_COUNT_ERM);i++)    
    {    
    StatusCode=d2h(EthernetEhouse[ind].AddrH)+d2h(EthernetEhouse[ind].AddrL)+d2h(VISUAL_INPUT_IN)+d2h(i);//+1);
    if (EthernetEhouse[ind].Inputs[i]) 
            {
            VisibleItems(StatusCode+'00',false,EthernetEhouse[ind].InputsDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,EthernetEhouse[ind].InputsDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,EthernetEhouse[ind].InputsDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,EthernetEhouse[ind].InputsDomIndexH[i]);   
         }                  
    if (Optimalize)
                {
                EthernetEhouse[ind].InputsDomIndexH[i]=FindFirstNode(StatusCode+'01');
                EthernetEhouse[ind].InputsDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }         
    }
    
for (i=0;i<SENSORS_COUNT_ERM;i++)
        {
        StatusCode=d2h(EthernetEhouse[ind].AddrH)+d2h(EthernetEhouse[ind].AddrL)+d2h(VISUAL_ADC_IN)+d2h(i)/*+1)*/+"00";            
        ReplaceText(StatusCode,"%TEMP%",EthernetEhouse[ind].SensorTemps[i],EthernetEhouse[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%TEMP"+(i)+"%",EthernetEhouse[ind].SensorTemps[i],EthernetEhouse[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%CURRENTPROGRAM%", EthernetEhouse[ind].CurrentProgram,EthernetEhouse[ind].SensorsDomIndex[i]); //current program nr
        ReplaceText(StatusCode,"%CURRENTADCPROGRAM%", EthernetEhouse[ind].CurrentADCProgram,EthernetEhouse[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%CURRENTZONE%", EthernetEhouse[ind].CurrentZone,EthernetEhouse[ind].SensorsDomIndex[i]);

//EthernetEhouse[index].CurrentADCProgram=0;

        if (ind>0)  //for RM make calculations for known optional sensors
            {
            ReplaceText(StatusCode,"%LIGHT%",EthernetEhouse[ind].SensorLights[i],EthernetEhouse[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%ADC%",EthernetEhouse[ind].ADCs[i],EthernetEhouse[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%PERCENT%",EthernetEhouse[ind].SensorPercents[i],EthernetEhouse[ind].SensorsDomIndex[i]);  //calculate percent value
            ReplaceText(StatusCode,"%VOLT%",EthernetEhouse[ind].SensorVolts[i],EthernetEhouse[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%INVADC"+"%", (1023-EthernetEhouse[ind].ADCs[i]),EthernetEhouse[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%INVPERCENT"+"%", (100-EthernetEhouse[ind].SensorPercents[i]),EthernetEhouse[ind].SensorsDomIndex[i]); 
            
            ReplaceText(StatusCode,"%LIGHT"+(i)+"%",EthernetEhouse[ind].SensorLights[i],EthernetEhouse[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%ADC"+(i)+"%",EthernetEhouse[ind].ADCs[i],EthernetEhouse[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%PERCENT"+(i)+"%",EthernetEhouse[ind].SensorPercents[i],EthernetEhouse[ind].SensorsDomIndex[i]);  //calculate percent value
            ReplaceText(StatusCode,"%VOLT"+(i)+"%",EthernetEhouse[ind].SensorVolts[i],EthernetEhouse[ind].SensorsDomIndex[i]);              
            ReplaceText(StatusCode,"%INVADC"+(i)+"%", (1023-EthernetEhouse[ind].ADCs[i]),EthernetEhouse[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%INVPERCENT"+(i)+"%", (100-EthernetEhouse[ind].SensorPercents[i]),EthernetEhouse[ind].SensorsDomIndex[i]);                     
            }   
         else       //heat manager replacement status
             {
              ReplaceText(StatusCode,"%HEATER_RECUPERATOR_TEMP%",HEATER_RECUPERATOR_TEMP,EthernetEhouse[ind].SensorsDomIndex[i]);  // â€“ Internal recu temp
              ReplaceText(StatusCode,"%HEATER_RECUPERATOR_SPEED%",HEATER_RECUPERATOR_SPEED,EthernetEhouse[ind].SensorsDomIndex[i]);  // â€“ Internal recu speed
              ReplaceText(StatusCode,"%HEATER_RECUPERATOR_MODE%",HEATER_RECUPERATOR_MODE,EthernetEhouse[ind].SensorsDomIndex[i]);   //â€“ REcu mode
              ReplaceText(StatusCode,"%HEATER_PROGRAM%",HEATER_PROGRAM,EthernetEhouse[ind].SensorsDomIndex[i]);            // â€“ Program of HeatManager
              ReplaceText(StatusCode,"%HEATER_KOMSTAT%",HEATER_KOMSTAT,EthernetEhouse[ind].SensorsDomIndex[i]);            // â€“ Status of bonfire                
             }
       if (Optimalize)
                {
                EthernetEhouse[ind].SensorsDomIndex[i]=FindFirstNode(StatusCode);                
                }
             
        }
   if (ind===0)    //for HM status also accept other unknown layers
        {
        for (i=0;i<SENSORS_COUNT_ERM;i++)
            {
            StatusCode="";            
            ReplaceText(StatusCode,"%TEMP"+(i)+"%",EthernetEhouse[ind].SensorTemps[i],EthernetEhouse[ind].SensorsDomIndex[i]);
            }
       ReplaceText(StatusCode,"%HEATER_RECUPERATOR_TEMP%",HEATER_RECUPERATOR_TEMP,EthernetEhouse[ind].SensorsDomIndex[i]);     // â€“ Internal recu temp
       ReplaceText(StatusCode,"%HEATER_RECUPERATOR_SPEED%",HEATER_RECUPERATOR_SPEED,EthernetEhouse[ind].SensorsDomIndex[i]);   // â€“ Internal recu speed
       ReplaceText(StatusCode,"%HEATER_RECUPERATOR_MODE%",HEATER_RECUPERATOR_MODE,EthernetEhouse[ind].SensorsDomIndex[i]);     //â€“ REcu mode
       ReplaceText(StatusCode,"%HEATER_PROGRAM%",HEATER_PROGRAM,EthernetEhouse[ind].SensorsDomIndex[i]);                       // â€“ Program of HeatManager
       ReplaceText(StatusCode,"%HEATER_KOMSTAT%",HEATER_KOMSTAT,EthernetEhouse[ind].SensorsDomIndex[i]);                       // â€“ Status of bonfire
       ReplaceText(StatusCode,"%EXTERNAL_CURRENTZONENAME%",EXTERNAL_CURRENTZONENAME,EthernetEhouse[ind].SensorsDomIndex[i]);  // â€“ Nazwa Strefy zabezpieczeĹ„ â€“ External Managera
       ReplaceText(StatusCode,"%EXTERNAL_CURRENTPROGRAM%",EXTERNAL_CURRENTPROGRAM,EthernetEhouse[ind].SensorsDomIndex[i]);    //â€“ External Manager â€“ Program rolet NR
       ReplaceText(StatusCode,"%EXTERNAL_CURRENTPROGRAMNAME%",EXTERNAL_CURRENTPROGRAMNAME,EthernetEhouse[ind].SensorsDomIndex[i]); //â€“ External Manager â€“ Nazwa Programu Rolet
       ReplaceText(StatusCode,"%EXTERNAL_CURRENTZONE%",EXTERNAL_CURRENTZONE,EthernetEhouse[ind].SensorsDomIndex[i]);        //â€“ External Manager â€“ Nr strefy zabezpieczeĹ„
       }
       
for (i=0;i<ALARM_SENSORS_COUNT_ERM;i++) 
    {
        
    StatusCode=d2h(EthernetEhouse[ind].AddrH)+d2h(EthernetEhouse[ind].AddrL)+d2h(VISUAL_ACTIVE_IN)+d2h(i);//+1);
    if (EthernetEhouse[ind].AlarmSensorsActive[i]) 
            {
            VisibleItems(StatusCode+'00',false,EthernetEhouse[ind].AlarmSensorsActiveDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,EthernetEhouse[ind].AlarmSensorsActiveDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,EthernetEhouse[ind].AlarmSensorsActiveDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,EthernetEhouse[ind].AlarmSensorsActiveDomIndexH[i]);   
         }                  
       if (Optimalize)  
                {
                EthernetEhouse[ind].AlarmSensorsActiveDomIndexH[i]=FindFirstNode(StatusCode+'01');
                EthernetEhouse[ind].AlarmSensorsActiveDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }

    StatusCode=d2h(EthernetEhouse[ind].AddrH)+d2h(EthernetEhouse[ind].AddrL)+d2h(VISUAL_ALARM_IN)+d2h(i);//+1);
    if (EthernetEhouse[ind].AlarmSensorsAlarm[i]) 
            {
            VisibleItems(StatusCode+'00',false,EthernetEhouse[ind].AlarmSensorsAlarmDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,EthernetEhouse[ind].AlarmSensorsAlarmDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,EthernetEhouse[ind].AlarmSensorsAlarmDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,EthernetEhouse[ind].AlarmSensorsAlarmDomIndexH[i]);   
         }                  
    if (Optimalize)
                {
                EthernetEhouse[ind].AlarmSensorsAlarmDomIndexH[i]=FindFirstNode(StatusCode+'01');
                EthernetEhouse[ind].AlarmSensorsAlarmDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }             
                
    StatusCode=d2h(EthernetEhouse[ind].AddrH)+d2h(EthernetEhouse[ind].AddrL)+d2h(VISUAL_MONITORING_IN)+d2h(i);//+1);
    if (EthernetEhouse[ind].AlarmSensorsMonitoring[i]) 
            {
            VisibleItems(StatusCode+'00',false,EthernetEhouse[ind].AlarmSensorsMonitoringDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,EthernetEhouse[ind].AlarmSensorsMonitoringDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,EthernetEhouse[ind].AlarmSensorsMonitoringDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,EthernetEhouse[ind].AlarmSensorsMonitoringDomIndexH[i]);   
         }                  
    if (Optimalize)
                {
                EthernetEhouse[ind].AlarmSensorsMonitoringDomIndexH[i]=FindFirstNode(StatusCode+'01');
                EthernetEhouse[ind].AlarmSensorsMonitoringDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }
         
         
StatusCode=d2h(EthernetEhouse[ind].AddrH)+d2h(EthernetEhouse[ind].AddrL)+d2h(VISUAL_WARNING_IN)+d2h(i);//+1);
    if (EthernetEhouse[ind].AlarmSensorsWarning[i]) 
            {
            VisibleItems(StatusCode+'00',false,EthernetEhouse[ind].AlarmSensorsWarningDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,EthernetEhouse[ind].AlarmSensorsWarningDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,EthernetEhouse[ind].AlarmSensorsWarningDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,EthernetEhouse[ind].AlarmSensorsWarningDomIndexH[i]);   
         }                          
    if (Optimalize)
                {
                EthernetEhouse[ind].AlarmSensorsWarningDomIndexH[i]=FindFirstNode(StatusCode+'01');
                EthernetEhouse[ind].AlarmSensorsWarningDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }         
    }
}
////////////////////////////////////////////////////////////////////////////////
// eHousePRO Visualization
//
function VisualEhousePRO(ind) 
{
//check all object if index starts from 0 or 1 >> d2h(i)
var StatusCode="";
var i,k;
var EventCode=0x21;
//if (ind===0)     EventCode=VISUAL_LM335_IN; //for hm other signal then inputs
for (i=0;i<(EHOUSE_PRO_MAX_OUTPUTS);i++)    
    {
    StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(EventCode)+d2h(i);//+1);
    if (eHousePRO[ind].Outs[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHousePRO[ind].OutsDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHousePRO[ind].OutsDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,eHousePRO[ind].OutsDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,eHousePRO[ind].OutsDomIndexH[i]);   
         }
       if (Optimalize)
                {
                eHousePRO[ind].OutsDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHousePRO[ind].OutsDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }
    }

for (i=0;i<(EHOUSE_PRO_MAX_INPUTS);i++)    
    {    
    StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(VISUAL_INPUT_IN)+d2h(i);//+1);
    if (eHousePRO[ind].Inputs[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHousePRO[ind].InputsDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHousePRO[ind].InputsDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,eHousePRO[ind].InputsDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,eHousePRO[ind].InputsDomIndexH[i]);   
         }                  
    if (Optimalize)
                {
                eHousePRO[ind].InputsDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHousePRO[ind].InputsDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }         
    }
    

for (i=0;i<EHOUSE_PRO_MAX_ADC;i++)
        {
        StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(VISUAL_ADC_IN)+d2h(i)/*+1)*/+"00";            
        ReplaceText(StatusCode,"%TEMP%",eHousePRO[ind].SensorTemps[i],eHousePRO[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%TEMP"+(i)+"%",eHousePRO[ind].SensorTemps[i],eHousePRO[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%CURRENTPROGRAM%", eHousePRO[ind].CurrentProgram,eHousePRO[ind].SensorsDomIndex[i]); //current program nr
        ReplaceText(StatusCode,"%CURRENTADCPROGRAM%", eHousePRO[ind].CurrentADCProgram,eHousePRO[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%CURRENTZONE%", eHousePRO[ind].CurrentZone,eHousePRO[ind].SensorsDomIndex[i]);
        ReplaceText(StatusCode,"%CURRENTROLLERPROGRAM%", eHousePRO[ind].CurrentRollerProgram,eHousePRO[ind].SensorsDomIndex[i]);
//EthernetEhouse[index].CurrentADCProgram=0;

//        if (ind>0)  //for RM make calculations for known optional sensors
            {
            ReplaceText(StatusCode,"%LIGHT%",eHousePRO[ind].SensorLights[i],eHousePRO[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%ADC%",eHousePRO[ind].ADCs[i],eHousePRO[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%PERCENT%",eHousePRO[ind].SensorPercents[i],eHousePRO[ind].SensorsDomIndex[i]);  //calculate percent value
            ReplaceText(StatusCode,"%VOLT%",eHousePRO[ind].SensorVolts[i],eHousePRO[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%INVADC"+"%", (1023-eHousePRO[ind].ADCs[i]),eHousePRO[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%INVPERCENT"+"%", (100-eHousePRO[ind].SensorPercents[i]),eHousePRO[ind].SensorsDomIndex[i]); 
            
            ReplaceText(StatusCode,"%LIGHT"+(i)+"%",eHousePRO[ind].SensorLights[i],eHousePRO[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%ADC"+(i)+"%",eHousePRO[ind].ADCs[i],eHousePRO[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%PERCENT"+(i)+"%",eHousePRO[ind].SensorPercents[i],eHousePRO[ind].SensorsDomIndex[i]);  //calculate percent value
            ReplaceText(StatusCode,"%VOLT"+(i)+"%",eHousePRO[ind].SensorVolts[i],eHousePRO[ind].SensorsDomIndex[i]);              
            ReplaceText(StatusCode,"%INVADC"+(i)+"%", (1023-eHousePRO[ind].ADCs[i]),eHousePRO[ind].SensorsDomIndex[i]);
            ReplaceText(StatusCode,"%INVPERCENT"+(i)+"%", (100-eHousePRO[ind].SensorPercents[i]),eHousePRO[ind].SensorsDomIndex[i]);                     
            }   
/*         else       //heat manager replacement status
             {
              ReplaceText(StatusCode,"%HEATER_RECUPERATOR_TEMP%",HEATER_RECUPERATOR_TEMP,EthernetEhouse[ind].SensorsDomIndex[i]);  // â€“ Internal recu temp
              ReplaceText(StatusCode,"%HEATER_RECUPERATOR_SPEED%",HEATER_RECUPERATOR_SPEED,EthernetEhouse[ind].SensorsDomIndex[i]);  // â€“ Internal recu speed
              ReplaceText(StatusCode,"%HEATER_RECUPERATOR_MODE%",HEATER_RECUPERATOR_MODE,EthernetEhouse[ind].SensorsDomIndex[i]);   //â€“ REcu mode
              ReplaceText(StatusCode,"%HEATER_PROGRAM%",HEATER_PROGRAM,EthernetEhouse[ind].SensorsDomIndex[i]);            // â€“ Program of HeatManager
              ReplaceText(StatusCode,"%HEATER_KOMSTAT%",HEATER_KOMSTAT,EthernetEhouse[ind].SensorsDomIndex[i]);            // â€“ Status of bonfire                
             }*/
       if (Optimalize)
                {
                eHousePRO[ind].SensorsDomIndex[i]=FindFirstNode(StatusCode);                
                }
             
        }
/*   if (ind===0)    //for HM status also accept other unknown layers
        {
        for (i=0;i<SENSORS_COUNT_ERM;i++)
            {
            StatusCode="";            
            ReplaceText(StatusCode,"%TEMP"+(i)+"%",EthernetEhouse[ind].SensorTemps[i],EthernetEhouse[ind].SensorsDomIndex[i]);
            }
       ReplaceText(StatusCode,"%HEATER_RECUPERATOR_TEMP%",HEATER_RECUPERATOR_TEMP,EthernetEhouse[ind].SensorsDomIndex[i]);     // â€“ Internal recu temp
       ReplaceText(StatusCode,"%HEATER_RECUPERATOR_SPEED%",HEATER_RECUPERATOR_SPEED,EthernetEhouse[ind].SensorsDomIndex[i]);   // â€“ Internal recu speed
       ReplaceText(StatusCode,"%HEATER_RECUPERATOR_MODE%",HEATER_RECUPERATOR_MODE,EthernetEhouse[ind].SensorsDomIndex[i]);     //â€“ REcu mode
       ReplaceText(StatusCode,"%HEATER_PROGRAM%",HEATER_PROGRAM,EthernetEhouse[ind].SensorsDomIndex[i]);                       // â€“ Program of HeatManager
       ReplaceText(StatusCode,"%HEATER_KOMSTAT%",HEATER_KOMSTAT,EthernetEhouse[ind].SensorsDomIndex[i]);                       // â€“ Status of bonfire
       ReplaceText(StatusCode,"%EXTERNAL_CURRENTZONENAME%",EXTERNAL_CURRENTZONENAME,EthernetEhouse[ind].SensorsDomIndex[i]);  // â€“ Nazwa Strefy zabezpieczeĹ„ â€“ External Managera
       ReplaceText(StatusCode,"%EXTERNAL_CURRENTPROGRAM%",EXTERNAL_CURRENTPROGRAM,EthernetEhouse[ind].SensorsDomIndex[i]);    //â€“ External Manager â€“ Program rolet NR
       ReplaceText(StatusCode,"%EXTERNAL_CURRENTPROGRAMNAME%",EXTERNAL_CURRENTPROGRAMNAME,EthernetEhouse[ind].SensorsDomIndex[i]); //â€“ External Manager â€“ Nazwa Programu Rolet
       ReplaceText(StatusCode,"%EXTERNAL_CURRENTZONE%",EXTERNAL_CURRENTZONE,EthernetEhouse[ind].SensorsDomIndex[i]);        //â€“ External Manager â€“ Nr strefy zabezpieczeĹ„
       }
  */     
for (i=0;i<EHOUSE_PRO_MAX_INPUTS;i++) 
    {
//ACTIVE        
    StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(VISUAL_ACTIVE_IN)+d2h(i);//+1);
    if (eHousePRO[ind].AlarmSensorsActive[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHousePRO[ind].AlarmSensorsActiveDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHousePRO[ind].AlarmSensorsActiveDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,eHousePRO[ind].AlarmSensorsActiveDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,eHousePRO[ind].AlarmSensorsActiveDomIndexH[i]);   
         }                  
       if (Optimalize)  
                {
                eHousePRO[ind].AlarmSensorsActiveDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHousePRO[ind].AlarmSensorsActiveDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }
//ALARM
    StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(VISUAL_ALARM_IN)+d2h(i);//+1);
    if (eHousePRO[ind].AlarmSensorsAlarm[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHousePRO[ind].AlarmSensorsAlarmDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHousePRO[ind].AlarmSensorsAlarmDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,eHousePRO[ind].AlarmSensorsAlarmDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,eHousePRO[ind].AlarmSensorsAlarmDomIndexH[i]);   
         }                  
    if (Optimalize)
                {
                eHousePRO[ind].AlarmSensorsAlarmDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHousePRO[ind].AlarmSensorsAlarmDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }             
//MONITORING                
    StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(VISUAL_MONITORING_IN)+d2h(i);//+1);
    if (eHousePRO[ind].AlarmSensorsMonitoring[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHousePRO[ind].AlarmSensorsMonitoringDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHousePRO[ind].AlarmSensorsMonitoringDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,eHousePRO[ind].AlarmSensorsMonitoringDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,eHousePRO[ind].AlarmSensorsMonitoringDomIndexH[i]);   
         }                  
    if (Optimalize)
                {
                eHousePRO[ind].AlarmSensorsMonitoringDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHousePRO[ind].AlarmSensorsMonitoringDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }
         
//WARNING         
StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(VISUAL_WARNING_IN)+d2h(i);//+1);
    if (eHousePRO[ind].AlarmSensorsWarning[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHousePRO[ind].AlarmSensorsWarningDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHousePRO[ind].AlarmSensorsWarningDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,eHousePRO[ind].AlarmSensorsWarningDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,eHousePRO[ind].AlarmSensorsWarningDomIndexH[i]);   
         }                          
    if (Optimalize)
                {
                eHousePRO[ind].AlarmSensorsWarningDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHousePRO[ind].AlarmSensorsWarningDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }         
//SILENT                
StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(VISUAL_SILENT_IN)+d2h(i);//+1);
    if (eHousePRO[ind].AlarmSensorsSilent[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHousePRO[ind].AlarmSensorsSilentDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHousePRO[ind].AlarmSensorsSilentDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,eHousePRO[ind].AlarmSensorsSilentDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,eHousePRO[ind].AlarmSensorsSilentDomIndexH[i]);   
         }                          
    if (Optimalize)
                {
                eHousePRO[ind].AlarmSensorsSilentDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHousePRO[ind].AlarmSensorsSilentDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }         
//Early WARNING                
StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(VISUAL_EARLYWARNING_IN)+d2h(i);//+1);
    if (eHousePRO[ind].AlarmSensorsEarlyWarning[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHousePRO[ind].AlarmSensorsEarlyWarningDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHousePRO[ind].AlarmSensorsEarlyWarningDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,eHousePRO[ind].AlarmSensorsEarlyWarningDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,eHousePRO[ind].AlarmSensorsEarlyWarningDomIndexH[i]);   
         }                          
    if (Optimalize)
                {
                eHousePRO[ind].AlarmSensorsEarlyWarningDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHousePRO[ind].AlarmSensorsEarlyWarningDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }         
//SMS
StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(VISUAL_SMS_IN)+d2h(i);//+1);
    if (eHousePRO[ind].AlarmSensorsSMS[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHousePRO[ind].AlarmSensorsSMSDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHousePRO[ind].AlarmSensorsSMSDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,eHousePRO[ind].AlarmSensorsSMSDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,eHousePRO[ind].AlarmSensorsSMSDomIndexH[i]);   
         }                          
    if (Optimalize)
                {
                eHousePRO[ind].AlarmSensorsSMSDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHousePRO[ind].AlarmSensorsSMSDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }                         
//HORN
StatusCode=d2h(eHousePRO[ind].AddrH)+d2h(eHousePRO[ind].AddrL)+d2h(VISUAL_HORN_IN)+d2h(i);//+1);
    if (eHousePRO[ind].AlarmSensorsHorn[i]) 
            {
            VisibleItems(StatusCode+'00',false,eHousePRO[ind].AlarmSensorsHornDomIndexL[i]);
            VisibleItems(StatusCode+'01',true,eHousePRO[ind].AlarmSensorsHornDomIndexH[i]);
            }    
     else
         {
          VisibleItems(StatusCode+'00',true,eHousePRO[ind].AlarmSensorsHornDomIndexL[i]);
          VisibleItems(StatusCode+'01',false,eHousePRO[ind].AlarmSensorsHornDomIndexH[i]);   
         }                          
    if (Optimalize)
                {
                eHousePRO[ind].AlarmSensorsHornDomIndexH[i]=FindFirstNode(StatusCode+'01');
                eHousePRO[ind].AlarmSensorsHornDomIndexL[i]=FindFirstNode(StatusCode+'00');
                }                         
                
                
                
    }
}

/////////////////////////////////////////////////////////////////////////////////
//Find node by name of Status code - auxiliary for test and developement
function findNodes(StatusCode)
{
var  nodes=GetElementsByName(StatusCode);
var str="";
var i=0;
if (nodes.length)
    {
        for (i=0;i<nodes.length;i++)
            {
            str=str+"; "+nodes[i].attributes["alt"].value;                
            }
        alert(str);
    }
}
////////////////////////////////////////////////////////////////////////////////
//find dom items search by field uses indexof for similar names display aux function
//for verification data for developement
function findNodesByFieldTot(StatusCode,field)
{
 var i;   
    var str="";
    var temp="";
    var nodes=document.getElementsByTagNameNS("*","*");
for (i=0;i<nodes.length;i++)
    {
        {
        if (nodes[i].attributes.hasOwnProperty(field))
            {
            temp=(nodes[i].attributes[field].value).trim();
            if (temp.indexOf(StatusCode)>=0)
                {
                str=str+(nodes[i].attributes["alt"].value).trim()+";"+(nodes[i].attributes["name"].value).trim()+"\n";
                }
            }
        }
    }
if (str.length>0) alert(str);
}
//find first dom items search by name for optimalization and efficiency
//Creating indexes
function FindFirstNode(StatusCode)
{

if (!Optimalize) return 0;

var nodes=GetElementsByName(StatusCode);
if (nodes.length===0)  return 0;
var temp=parseInt(nodes[0].attributes["id"].value,10);
if (temp==="NaN") return 0;
return temp;

}
/////////////////////////////////////////////////////////////////////
//Replace dynamic fields directly on DOM elements
function ReplaceText(StatusCode,find,replace,item)
{
if (!OptimalizePerformance)    
    {
    var  nodes=GetElementsByName(StatusCode);
    for (var i=0;i<nodes.length;i++)
        {
        nodes[i].textContent=nodes[i].textContent.replace(find,replace);
        }    
    }
else
    {
    if (item===0)     return;   //first document element ==== no object   
    var node=document.getElementById(item);   //initial Status Index for comparison
    var initialname="";
    if (node)
        {
        initialname=node.attributes["name"].value.trim();
        while (1)  //iterate for the same status index
            {
            if (node===null)    break;          //last node in set
            if (node.attributes)                //do not have attributes no graphic index
                if (node.attributes.hasOwnProperty("name"))     //no name attribute
                    if (node.attributes["name"].value===initialname)       //invalid name of Status Index
                            {
                            //Ok then show/hide objects
                            node.textContent=node.textContent.replace(find,replace);
                            //if (visible)    node.style.display='block';
                            //else            node.style.display='none';
                            }
                    else break;         // other name then break
            node=node.nextSibling;      // next node
            }
        }
        
    }
}
////////////////////////////////////////////////////////////////////////////////
//Show and hide objects for on and off valuses
function VisibleItems(str,visible,item)
{

        
if (!OptimalizePerformance) //no optimalization Except FireFox and Opera
    {
    var  nodes=Array();
    nodes =GetElementsByName((str));
    for (var i=0;i<nodes.length;i++)
        {
        if (visible)
            nodes[i].style.display='block';
        else     
            nodes[i].style.display='none';
        }
    }
else
    {
    if (item===0)     return;   //first document element ==== no object   
    var node=document.getElementById(item);   //initial Status Index for comparison
    var initialname="";
    if (node)
        {
        initialname=node.attributes["name"].value.trim();
        while (1)  //iterate for the same status index
            {
            if (node===null)    break;          //last node in set
            if (node.attributes)                //do not have attributes no graphic index
                if (node.attributes.hasOwnProperty("name"))     //no name attribute
                    if (node.attributes["name"].value===initialname)       //invalid name of Status Index
                            {
                            //Ok then show/hide objects
                            if (visible)    node.style.display='block';
                            else            node.style.display='none';
                            }
                    else break;         // other name then break
            node=node.nextSibling;      // next node
            }
        }
    }
}



  function ajax(url,param2, callbackFunction) 
  {
    var request =  new XMLHttpRequest();
    request.open("GET", url, true);
    request.setRequestHeader("Content-Type",
      "application/x-www-form-urlencoded");// "text/html");

    request.onreadystatechange = function() 
    {
      var done = 4, ok = 200;
      if (request.readyState === done && request.status === ok) 
      {
         
        if (request.responseText)
            {
             
            callbackFunction(request.responseText,param2);
            }
      }
    };
    request.send();
  }

var ConfirmationEventSend =function (text,param2)
{
//SetTitle(text);
AddTitle(text.trim());
if (text.trim().indexOf("OK")>=0)
    {
        //top.document.title
               AddTitle("Event Sent OK");
    }
else
if (text.trim().indexOf("ERROR")>=0)
    {
        //top.document.title
                AddTitle("ERROR Sending Event");
    }    
else //top.document.title
    AddTitle(text.trim());
};
//////////////////////////////////////////////////////////////////
  var getRes = function (text,param2) 
    {
    
    var ii=0;
    //text=sstatus;
    var temp=text.split("\r\n");
	SetTitle(temp);
    };

///////////////////////////////////////////////////////////////////////////
  var getComplete = function (text,param2) 
    {
    
    var ii=0;
    //text=sstatus;
    var temp=text.split("\r\n");
	if (temp.length<MAX_ETHERNET_EHOUSE_DEVS+MAX_EHOUSE1_DEVS) return;
    for (ii=0;ii<MAX_ETHERNET_EHOUSE_DEVS;ii++)      //Last for CommManager, EthernetEhouse[0] - for EthernetHeatManager
            {
            EthernetEhouse[ii].Stat=temp[ii].trim();
            GetEthernetEhouseStatus(ii);
            }
            
    for (ii=0;ii<MAX_EHOUSE1_DEVS+1;ii++)
            {
            eHouse1[ii].Stat=temp[ii+MAX_ETHERNET_EHOUSE_DEVS+1].trim();
            GetEhouse1Status(ii);
            }
    
    GetEthernetEhouseStatus(MAX_ETHERNET_EHOUSE_DEVS);
 //   ShowEthernetEhouseStatus(MAX_ETHERNET_EHOUSE_DEVS);
    };
    
var myVar=setInterval(function(){myTimer();},5* /*MAX_EHOUSE1_DEVS*/1000);

function myTimer()
{
//ajax('/eh.x?eHGlobalStatus',"", getComplete);
}
