<?php
/**
 * eHouse4CAN Home Automation system, all rights reserved to iSys.Pl
 * Author: Robert Jarzabek
 * Invalid usage & modification  may kill eHouse4CAN controllers permanently
 * 
 * 
 */
ini_set('display_startup_errors','1');
ini_set('display_errors','1');
error_reporting(E_ALL | E_WARNING | E_PARSE | E_NOTICE | E_STRICT);
ini_set('error_reporting',E_ALL);
//Events Commands 
$SETADC_EVENT=12;	//ustawianie progów analogowych arg1=nr wej arg2=vlow arg3=vhigh
$INPUT_EVENT=0x20;		//change input params
$OUTPUT_EVENT=0x21;		//output state
$ROLLER_EVENT=100;		//single rollers execution

set_time_limit(60);
$eHousePath="/usr/local/e-house/eH4c/CAN/"; //keep all ehouse files at /usr/local/e-house/....
$eHouseDir='/usr/local/e-house/';
/*$eHousePath="d:/e-comm/e-house/eH4c/CAN/";
$eHouseDir='d:/e-comm/e-house/';*/
$address="7f01";
$func="";       //function
$update="";     //update settings mode
$get=0;         //get ! post
if (isset($_GET['address'])) {$get=1;$address=  (urldecode($_GET['address']));}; //device address
if (isset($_POST['address'])) {$get=0;$address=  (urldecode($_POST['address']));}; //device address
if (isset($_GET['func'])) {$func=  (urldecode($_GET['func']));}; //function
if (isset($_POST['func'])) {$func=  (urldecode($_POST['func']));}; //function
if (isset($_GET['update'])) {$update=  (urldecode($_GET['update']));}; //update data
if (isset($_POST['update'])) {$update=  (urldecode($_POST['update']));}; //update data
$address=mb_strtolower($address);   //controller address
$func=mb_strtolower($func);         //function to perform
$data=Array("");	//stores data from config file
$comment=Array("");	//stores comment from config file
$DevName='';            //device name (controller)
$outn=array("");        //output names
$inn=array("");         //input names
$adcn=array("");        //adc names
$dimmn=array("");       //dimmer names
$progn=array("");       //program names
$adcprogn=array("");    //adc program names
$adccfgn=array("");     //adc sensor names
//convert int data to hex representation string with limited length
function dhex($dta,$length)
{
$res=dechex($dta);
while (strlen($res)<$length)
    {
    $res='0'.$res;
    }
    return $res;
}
////////////////////////////////////////////////////////////////////////////////////////////////////
//get file content according to ehouse4cServer specification until <tab> "\t" store in $data[] after <tab> store to $comment[]
function get_content($file)
{
global $data,$comment;
if (!file_exists($file))
	{
	echo "File: $file not exists\n<br>";
        for ($i=0;$i<1000;$i++)
            {
            $data[$i]='';
            $comment[$i]='';
            }
//	RECREATE()
	return;
	}
$fi=file($file);
for ($i=0;$i<count($fi);$i++)
	{
	if (strpos($fi[$i],"\t",0)!==FALSE)
		{
		$data[$i]=trim(substr($fi[$i],0,strpos($fi[$i],"\t",0)));
		$comment[$i]=trim(substr($fi[$i],strpos($fi[$i],"\t",0)),strlen($fi[$i]));
		}
	else 
		{
		$data[$i]=$fi[$i];
		$comment[$i]="";		
		}
	$data[$i]=trim($data[$i]);
	$comment[$i]=trim($comment[$i]);
	}
}
////////////////////////////////////////////////////////
//fill empty event for eeprom write
function GetDirectEvent($ev)
{
    $event=$ev;
    while (strlen($event)<20)
        {
        $event.='F';
        }
return $event;        
}
/////////////////////////////////////////////////////////////////////////////////
//
// All In One Configuration
//
////////////////////////////////////////////////////////////////////////////////
function AdvancedOutputSettings()
{
global $data,$comment,$address,$eHousePath,$eHouseDir,$get,$update,$_GET,$_POST,$DevName,$outn,$inn,$adcn,$dimmn,$progn,$adcprogn,$adccfgn,$INPUT_EVENT,$SETADC_EVENT,$OUTPUT_EVENT,$ROLLER_EVENT;
get_content($eHousePath."$address.txt");
$adcoptions=file($eHouseDir.'ADCSensorTypes.txt');  //get names of adc sensor types
$header="\n";
$footer="\n";
if (file_exists($eHousePath."advancedoutputs.head"))
    $header=file_get_contents($eHousePath."advancedoutputs.head");
if (file_exists($eHousePath."advancedoutputs.foot"))
    $footer=file_get_contents($eHousePath."advancedoutputs.foot");

$k=0;
$dt=array("");
$cm=array("");
$eeprom=array("");
//read names for display
$DevName=$data[$k++];
for ($i=0;$i<8;$i++)	{$outn[$i]=$data[$k++];}
for ($i=0;$i<8;$i++)	{$inn[$i]=$data[$k++];}
for ($i=0;$i<4;$i++)
	{
	$adcn[$i]=$data[$k++];
	$adccfg[$i]=$data[$k++];
	$adccfgn[$i]=$adcoptions[$adccfg[$i]];
	}
for ($i=0;$i<4;$i++)	{$dimmn[$i]=$data[$k++];}
for ($i=0;$i<24;$i++)	{$progn[$i]=$data[$k++];}
for ($i=0;$i<12;$i++)	{$adcprogn[$i]=$data[$k++];}
$query=array("","");
// if data update from old data

if ($update) 
	{
        if ($get==1) {$query=$_GET;}
        else {$query=$_POST;}
        $saveconfig="";
        $k=0;
        $i=0;
        $ep=0;
        $alarmdelay=0;
        $rememberstate=0;
        for ($i=0;$i<100;$i++)
            {$eeprom[$i]='';}
        for ($i=0;$i<8;$i++)        //inputs create eeprom done
            {
            $opts=0x00;
            $m=$i+1;
            if (isset($query["invin$m"]))
                {
                $opts|=0x04|0x80;//
                $saveconfig.="1"."\t//Inverted Input ".$m."\n";                
                }
            else
                {
                $saveconfig.="0"."\t//Inverted Input $m\n";                
                }         
            if (isset($query["alarmin$m"]))
                {
                $opts|=0x01|0x80;//
                $saveconfig.="1"."\t//Alarm from input $m enabled\n";                
                }
            else
                {
                $saveconfig.="0"."\t//Alarm from input $m enabled\n";                
                }
            $saveconfig.=$query["alarmdelay$m"]."\t//Alarm Delay for input $m\n";       //delay  before alarm initialized            
            $alarmdelay    =dhex($query["alarmdelay$m"],4);
/*            if (isset($query["indisev$m"]))
                {
                $opts|=0x02|0x80;//
                $saveconfig.="1"."\t//Disable Event Execution for in $m \n";                
                } //disable event execution
            else 
                {
                $saveconfig.="0"."\t//Disable Event Execution for in $m \n";
                } //disable event execution                 //nr            
  */          
            
            
            $saveconfig.=$query["rememberstate$m"]."\t//Time for storing input $m state\n"; //remember input state
            $rememberstate    =dhex($query["rememberstate$m"],4);
            if (isset($query["indisev$m"]))
                {
                $opts|=0x02|0x80;//
                $saveconfig.="1"."\t//Disable Event Execution for in $m \n";                
                } //disable event execution
            else 
                {
                $saveconfig.="0"."\t//Disable Event Execution for in $m \n";
                } //disable event execution                 //nr            
            $saveconfig.=$query["inev$m"]."\t//Event name assigned to input $m\n"; //Event to run when input activated
            $saveconfig.=$query["indiev$m"]."\t//Direct Event to execute on input $m activity\n"; //direct event code
            $eeprom[$ep++]=GetDirectEvent($query["indiev$m"]);
            
            $eeprom[$ep++] = $address . dhex($INPUT_EVENT,2) . dhex($m,2).dhex($opts,2).dhex($rememberstate,4).dhex($alarmdelay, 4).'00';
            }
            $ep=36;
        for ($m=1;$m<9;$m++)        //outputs create eeprom done
		{
                $opts=0;
                if (isset($query["adminout$m"]))
                    {
                    $opts|=0x80;
                    $saveconfig.="1". "\t//Enable admin operation for out $m\n";                    //Admin Operations
                    }
                else
                    {
                    $saveconfig.="0". "\t//Enable admin operation for out $m\n";                   //Admin Operations                    
                    }
		if (isset($query["disableout$m"]))
                    {
                    $opts=0x40;
                    $saveconfig.="1"."\t//Disable single output $m set manualy for double or multiple output usage\n";                     //Disable single output for multi output action must be set manually
                    }
                else
                    {
                    $saveconfig.="0"."\t//Disable single output $m set manualy for double or multiple output usage\n";                    //Disable single output for multi output action must be set manually
                    } 
                if ($query["stateout$m"]=='0') $opts&=0xf0;
                if ($query["stateout$m"]=='1') {$opts&=0xf0;$opts|=1;}
                if ($query["stateout$m"]=='2') {$opts&=0xf0;$opts|=2;}
                $saveconfig.=$query["stateout$m"]    ."\t//State\n";
                $saveconfig.=$query["repeatouts$m"]."\t//Repeat count of cyclic operations for out $m\n"; //alarm timeout
                $saveconfig.=$query["timeonout$m"]. "\t//Time for turn on output $m\n"; //remember input state
                $saveconfig.=$query["timeoffout$m"]."\t//Time for switch off output $m\n"; //remember input state                       
                $eeprom[$ep++] = $address . dhex($OUTPUT_EVENT,2) . dhex($m,2) . dhex($opts,2) . dhex($query["timeonout$m"],4).dhex($query["timeoffout$m"], 4).dhex($query["repeatouts$m"],2);
		}
                $ep=44;
        for ($m=1;$m<5;$m++)
		{              
                $opts=$m;
                $repeat=0;
                if (isset($query["disabledrv$m"]))
                    {
                    $opts|=0xc0;
                    $saveconfig.="1"."\t//Disable Double outputs alghoritm pair $m\n";                    
                    } //Disable double output for single & multi output action must be set manually
                else 
                    {$saveconfig.="0"."\t//Disable Double outputs alghoritm pair $m\n";} //Disable double output for single & multi output action must be set manually
                if (isset($query["admindrv$m"]))
                    {$saveconfig.="1"."\t//Enable Admin Settings\n";}   //Admin Operations
                else
                    {$saveconfig.="0"."\t//Enable Admin Settings\n";}   //Admin Operations
                if (isset($query["somfydrv$m"]))
                    {$saveconfig.="1"."\t//Enable Somfy Mode\n";}   //Admin Operations
                else
                    {$saveconfig.="0"."\t//Enable Somfy Mode\n";}   //Admin Operations                    
                $saveconfig.=$query["statedrv$m"]    ."\t//State\n";
                $saveconfig.=$query["repeatdrv$m"]."\t//Cyclic Repeat Count\n"; //alarm timeout
                $saveconfig.=$query["timeondrv$m"]."\t//Time of Turn On\n"; //remember input state
                $saveconfig.=$query["timedisabledrv$m"]."\t//Time for disable between switching direction line\n"; //remember input state
                $saveconfig.=$query["timeoffdrv$m"]."\t//Time of turn off output\n"; 
                $repeat=$query["repeatdrv$m"];
                $repeat=$repeat<<3; //repeat and state=0 - dont change;
                $eeprom[$ep++] = $address . dhex($ROLLER_EVENT,2) . dhex($opts,2) .dhex($repeat,2). dhex($query["timeonout$m"],4).dhex($query["timeoffout$m"], 4).dhex($query["timedisabledrv$m"], 2);
                }
                
$ep=16;                
$adccfg='';
	for ($m=1;$m<5;$m++)
		{
                $opts=0x0;
                if (isset($query["invertadc$m"]))
                    {
                    $opts|=0x08;
                    $saveconfig.="1"."\t//Invert ADC $m value - negative scale sensor\n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//Invert ADC $m value - negative scale sensor\n";                    
                    } //invert input state
                if (isset($query["alarmadcl$m"]))
                    {
                    $opts|=0x20;
                    $saveconfig.="1". "\t//Generate Alarm for ADC $m low \n";                    
                    }   //alarm enabled
                else 
                    {
                    $saveconfig.="0". "\t//Generate Alarm for ADC $m low \n";
                    }   //alarm enabled
                if (isset($query["alarmadch$m"]))
                    {
                    $opts|=0x40;
                    $saveconfig.="1". "\t//Generate Alarm for ADC $m high \n";                    
                    }   //alarm enabled
                else 
                    {
                    $saveconfig.="0". "\t//Generate Alarm for ADC $m high \n";                    
                    }   //alarm enabled                    
                $saveconfig.=$query["alarmdelayadc$m"]."\t//Delay before alarm interval ADC $m \n"; //alarm timeout
                
                if (isset($query["adcevdis$m"]))
                    {
                    $opts|=0x10;//
                    $saveconfig.="1"."\t//Disable Event Execution for ADC $m \n";                
                    } //disable event execution
                else 
                    {
                    $saveconfig.="0"."\t//Disable Event Execution for ADC $m \n";
                    } //disable event execution                 //nr            
            
                if (isset($query["adcadmin$m"]))
                    {
                    $opts|=0x80;//
                    $saveconfig.="1"."\t//Admin mode for ADC $m \n";                
                    } //disable event execution
                else 
                    {
                    $saveconfig.="0"."\t//Admin mode for ADC $m \n";
                    } //disable event execution                 //nr            
            
                    
                
                    
                    
                    
                $saveconfig.=$query["adclowev$m"]."\t//Adc $m Low threshold event name to run\n"; //event name
                $saveconfig.=$query["adclowdiev$m"]."\t//Adc $m Low threshold direct event to run\n"; //direct event code
                $saveconfig.=$query["lleveladc$m"]."\t//Adc $m Low threshold \n"; //direct event code
                $saveconfig.=$query["adcokev$m"]."\t//Adc $m OK threshold event name to run\n"; //event name
                $saveconfig.=$query["adcokdiev$m"]."\t//Adc $m OK threshold direct event to run\n"; //direct event code
                $saveconfig.=$query["adchighev$m"]."\t//Adc $m High threshold event name to run\n"; //event name
                $saveconfig.=$query["adchighdiev$m"]."\t//Adc $m High threshold direct event to run\n"; //direct event code
                $saveconfig.=$query["hleveladc$m"]."\t//Adc $m High threshold \n"; //direct event code
                $eeprom[$ep++]=  GetDirectEvent($query["adclowdiev$m"]);
                $eeprom[$ep++]=  GetDirectEvent($query["adcokdiev$m"]);
                $eeprom[$ep++]=  GetDirectEvent($query["adchighdiev$m"]);
                $eeprom[$ep++] = $address . dhex($SETADC_EVENT,2) . dhex($m,2) . dhex($query["lleveladc$m"],4) . dhex($query["hleveladc$m"],4) . dhex($query["alarmdelayadc$m"],2) . dhex($opts,2);
		}
                $i=0;
                $RGB_DIMMER_EVENT=8;
                $DIMMER_EVENT=4;                
$ep=32;         
$rgb=array("");
for ($m=1;$m<5;$m++)
		{
                $opts=0x0;
                if (isset($query["invertdimm$m"]))
                    {
                    $opts|=0x40;   //enable advanced settings
                    $saveconfig.="1"."\t//Invert PWM/Dimmer $m value - negative 100%-x\n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//Invert PWM/Dimmer $m value - negative 100%-x\n";                    
                    } //invert input state
                if (isset($query["admindimm$m"]))
                    {
                    $opts|=0x80;   //enable advanced settings
                    $saveconfig.="1"."\t//Admin mode for PWM/Dimmer $m \n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//Admin mode for PWM/Dimmer $m \n";                    
                    } //invert input state                    
                if (isset($query["disabledimm$m"]))
                    {
                    $opts|=0x20;   //enable advanced settings
                    $saveconfig.="1"."\t//Disable PWM/Dimmer $m \n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//Disable PWM/Dimmer $m \n";                    
                    } //invert input state                    
                    
                $saveconfig.=$query["mindimm$m"]."\t//Minimal PWM/Dimmer  value $m \n"; //alarm timeout
                $saveconfig.=$query["valuedimm$m"]."\t//Value of PWM/DIMMER $m\n"; //event name
                $rgb[$m]=$query["valuedimm$m"];
                $saveconfig.=$query["modedimm$m"]."\t//Mode PWM/Dimmer $m stop, inc, dec, immediate assign\n"; //direct event code
                $saveconfig.=$query["stepdimm$m"]."\t//Step value of PWM/Dimmer $m inc, dec\n"; //direct event code
                $saveconfig.=$query["maxdimm$m"]."\t//Maximal PWM/Dimmer $m value\n"; //direct event code
                
//                $eeprom[$ep++]=  GetDirectEvent($query["adclowdiev$m"]);
//                $eeprom[$ep++]=  GetDirectEvent($query["adcokdiev$m"]);
  //              $eeprom[$ep++]=  GetDirectEvent($query["adchighdiev$m"]);

                $eeprom[$ep++] = $address . dhex($DIMMER_EVENT,2) . dhex($m,2) . dhex($query["modedimm$m"],2) . dhex($query["valuedimm$m"],2) . dhex($query["stepdimm$m"],2) .dhex($query["mindimm$m"],2) .dhex($query["maxdimm$m"],2) . dhex($opts,2);
		}
                $saveconfig.=$query["modergbdimm"]."\t//Mode RGB PWM/Dimmer\n"; //alarm timeout                
                if (isset($query["rgbwdimmr"]))
                    {
                    $opts|=0x80;   //enable advanced settings
                    $saveconfig.="1"."\t//Red PWM/Dimmer Continuous Mode\n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//Red PWM/Dimmer Continuous Mode\n";                    
                    } //invert input state                    
                
               if (isset($query["rgbwdimmg"]))
                    {
                    $opts|=0x40;   //enable advanced settings
                    $saveconfig.="1"."\t//Green PWM/Dimmer Continuous Mode\n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//Green PWM/Dimmer Continuous Mode\n";
                    } //invert input state                    
              if (isset($query["rgbwdimmb"]))
                    {
                    $opts|=0x20;   //enable advanced settings
                    $saveconfig.="1"."\t//Blue PWM/Dimmer Continuous Mode\n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//Blue PWM/Dimmer Continuous Mode\n";                    
                    } //invert input state                    
            if (isset($query["rgbwdimmw"]))
                    {
                    $opts|=0x10;   //enable advanced settings
                    $saveconfig.="1"."\t//White PWM/Dimmer Continuous Mode\n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//White PWM/Dimmer Continuous Mode\n"; 
                    } //invert input state                    
                                       
                if (isset($query["rgbwdimmar"]))
                    {
                    $opts|=0x8;   //enable advanced settings
                    $saveconfig.="1"."\t//Red PWM/Dimmer Future Mode\n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//Red PWM/Dimmer Future Mode\n";                    
                    } //invert input state                    
                
               if (isset($query["rgbwdimmag"]))
                    {
                    $opts|=0x4;   //enable advanced settings
                    $saveconfig.="1"."\t//Green PWM/Dimmer Future Mode\n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//Green PWM/Dimmer Future Mode\n";                    
                    } //invert input state                    
              if (isset($query["rgbwdimmab"]))
                    {
                    $opts|=0x2;   //enable advanced settings
                    $saveconfig.="1"."\t//Blue PWM/Dimmer Future Mode\n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//Blue PWM/Dimmer Future Mode\n";                    
                    } //invert input state                    
            if (isset($query["rgbwdimmaw"]))
                    {
                    $opts|=0x1;   //enable advanced settings
                    $saveconfig.="1"."\t//White PWM/Dimmer Future Mode\n";                    
                    } //invert input state
                else 
                    {
                    $saveconfig.="0"."\t//White PWM/Dimmer Future Mode\n";                    
                    } //invert input state                    
                $ep=48;
                
                
                $eeprom[$ep++] = $address . dhex($RGB_DIMMER_EVENT,2) . dhex(1,2) . dhex($query["modergbdimm"],2) . dhex($rgb[0],2) . dhex($rgb[1],2) .dhex($rgb[2],2) .dhex($rgb[3],2) . dhex($opts,2);
                $i=0;
        file_put_contents($eHousePath."$address.cfg",$saveconfig);
        $str='';
        for ($i=0;$i<count($eeprom);$i++)
            {
            $str.=GetDirectEvent($eeprom[$i])."\n";            
            }
            $str.="\r\n";
            file_put_contents($eHousePath."$address.hex", $str);
	////write_content(); 
	}
        get_content($eHousePath."$address.cfg");
echo $header;        
//echo 
echo "<form name='advsettings' method='get'>\n";
echo "<input type='hidden' name='func' value='advancedsettings'>\n";
echo "<input type='hidden' name='address' value='$address'>\n";
echo "<input type='hidden' name='update' value='1'>\n";
echo "<input type='hidden' name='startdta' value='startdta'>\n";
echo "<strong>Inputs Settings:</strong>\n<br>\n";
echo '<div id="inputscfg">'."\n";
$k=0;
//$data[$k++];
$temp='';
 for ($i=0;$i<8;$i++)
    {$m=$i+1;
    echo "<div class='inputcfg' id='in$m'>\n";
    echo "$m) $inn[$i]:\n";
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='invertinput' name='invin$m' $temp type='checkbox'>Invert\n"; //invert input state
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='alarminput' name='alarmin$m' $temp type='checkbox'>Alarm\n";   //alarm enabled
    echo ", Alarm Delay: <select class='alarmdelay' name='alarmdelay$m'> \n"; //alarm timeout
    $o=0;
    //
    while ($o<0xffff)
	{	
        $ho= (int) ($o/3600);
        $min=($o/60)%60;
        $min=round($min);
        $sec=$o%60;
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}
	echo  "  <option value='$o' $temp>$ho h, $min m, $sec s</option>\n";
        if ($o<60) {$o++;}
        else if ($o<300) {$o+=10;}
        else if ($o<1200) {$o+=30;}
        else {$o+=60;}
	}
    echo " </select>\n";
    $k++;
    echo "Remember State: <select class='rememberstate' name='rememberstate$m'> \n"; //remember input state
    $o=0;
    while ($o<0xffff)
	{	
        $ho= (int) ($o/3600);
        $min=($o/60)%60;
        $min=round($min);
        $sec=$o%60;
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}
	echo  "  <option value='$o' $temp>$ho h, $min m, $sec s</option>\n";
        if ($o<60) {$o++;}
        else if ($o<300) {$o+=10;}
        else if ($o<1200) {$o+=30;}
        else {$o+=60;}
	}
    echo " </select>\n";
    $k++;
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='disableevent' name='indisev$m' $temp type='checkbox'>Disable Execution\n"; //disable event execution
    echo  "\n&nbsp;<a href=\"javascript:GetInputEvent('$address',$m,'invin$m','alarmin$m','alarmdelay$m','rememberstate$m','indisev$m',1);\">Run</a>\n";
    echo  "\n&nbsp;<a href=\"javascript:GetInputEvent('$address',$m,'invin$m','alarmin$m','alarmdelay$m','rememberstate$m','indisev$m',0);\">Copy</a>\n";
    echo "<br>\nEvent: <input class='event' name='inev$m'  id='inev$m' type='text' value='".$data[$k++]."'>\n"; //Event to run when input activated
    echo "Direct Event: <input class='event' name='indiev$m' id='indiev$m' type='text' value='".$data[$k++]."'>\n"; //direct event code
    
    echo "</div>"."\n";
        
    }
    

    
echo "\n<br><strong>Single Output Settings [On/Off]:</strong>\n<br>\n";
echo '<div id="outsscfg">'."\n";
 for ($i=0;$i<8;$i++)
    {$m=$i+1;
    echo "<div class='outscfg' id='out$m'>\n";
    echo "$m) $outn[$i]:\n";
    if ($data[$k++]==='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='disableout' name='disableout$m' $temp id='disableout$m' type='checkbox'>Disable\n"; //Disable single output for multi output action must be set manually
    if ($data[$k++]==='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='adminout' $temp name='adminout$m' type='checkbox'>Admin\n";   //Cyclic Operations
    echo "<select class='stateout' name='stateout$m'>\n  \n";
    if ($data[$k]==="0")         {echo  "  <option value='0' selected>Off</option>\n";}
    else {echo  "  <option value='0'>Off</option>\n";}
    if ($data[$k]==="1")         {echo  "  <option value='1' selected>On</option>\n";}
    else {echo  "  <option value='1'>On</option>\n";}
    if ($data[$k]==="2")         {echo  "  <option value='2' selected>Toggle</option>\n";}
    else {echo  "  <option value='2'>Toggle</option>\n";}
    
    
    echo " \n</select>\n"; 
    $k++;
    echo " Repeats: <select class='repeatsout' name='repeatouts$m'> \n"; //alarm timeout
    for ($o=0;$o<256;$o++)
	{	
        if ($data[$k]=="$o") {$temp='selected';}
    else {$temp='';}
	echo  "  <option value='$o' $temp>$o</option>\n";
	}    
        $k++;
    echo " </select>\n";
    
    
    echo "Time On: <select class='timeonout' $temp id='timeonout$m' name='timeonout$m'> \n"; //remember input state
    $o=0;
    while ($o<0xffff)
        {
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}
        $ho= (int) ($o/3600);
        $min=($o/60)%60;
        $min=round($min);
        $sec=$o%60;
	echo  "  <option value='$o' $temp>$ho h, $min m, $sec s</option>\n";
        if ($o<60) {$o++;}
        else if ($o<300) {$o+=10;}
        else if ($o<1200) {$o+=30;}
        else {$o+=60;}
	}
        $k++;
    echo " </select>\n";
    
    echo "Time Off: <select class='timeoffout' id='timeoffout$m' name='timeoffout$m'> \n"; //remember input state
    $o=0;
    while ($o<0xffff)
	{	
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}
        $ho= (int) ($o/3600);
        $min=($o/60)%60;
        $min=round($min);
        $sec=$o%60;
	echo  "  <option value='$o' $temp>$ho h, $min m, $sec s</option>\n";
        if ($o<60) {$o++;}
        else if ($o<300) {$o+=10;}
        else if ($o<1200) {$o+=30;}
        else {$o+=60;}
	}
        $k++;
    echo " </select>\n";
    echo  "\n&nbsp;<a href=\"javascript:GetOutputEvent('$address',$m,'stateout$m','disableout$m','adminout$m','repeatouts$m','timeonout$m','timeoffout$m',1);\">Run</a>\n";
    echo  "\n&nbsp;<a href=\"javascript:GetOutputEvent('$address',$m,'stateout$m','disableout$m','adminout$m','repeatouts$m','timeonout$m','timeoffout$m',0);\">Copy</a>\n";
    echo "</div>"."\n";
        
    }
    
echo "</div>\n";
    
    
echo "\n<br><strong>Double Output Settings [+/-/stop] (rollers, gates, drives, cut-off) - One Output => One Direction:</strong>\n<br>\n";
echo '<div id="drvscfg">'."\n";
 for ($i=0;$i<8;$i+=2)
    {$m=$i+1;
    $c=(int)(($i/2)+1);
    echo "<div class='drvscfg' id='drv$c'>\n";
    echo ((int)($i/2)+1) .") $outn[$i]/$outn[$m]:\n";
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='disabledrv' $temp id='disabledrv$c' name='disabledrv$c' type='checkbox'>Disable\n"; //Disable double output for single & multi output action must be set manually
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='admindrv' $temp name='admindrv$c' type='checkbox'>Admin\n";   //Admin Operations
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='somfydrv' $temp name='somfydrv$c' type='checkbox'>Somfy\n";   //Somfy Operations
    echo "<select class='statedrv' name='statedrv$c'>\n";    
    if ($data[$k]=="0")         {echo  "  <option value='0' selected>N/A</option>\n";}
    else {echo  "  <option value='0'>N/A</option>\n";}
    if ($data[$k]=="1")         {echo  "  <option value='1' selected>Down</option>\n";}
    else {echo  "  <option value='1'>Down</option>\n";}
    if ($data[$k]=="2")         {echo  "  <option value='2' selected>Up</option>\n";}
    else {echo  "  <option value='2'>Up</option>\n";}
    if ($data[$k]=="3")         {echo  "  <option value='3' selected>Both</option>\n";}
    else {echo  "  <option value='3'>Both</option>\n";}
    echo "</select> \n";
    $k++;
    echo " Repeats: <select class='repeatsdrv' name='repeatdrv$c'> \n"; //alarm timeout
    
    for ($o=0;$o<32;$o++)
	{	
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}
	echo  "  <option value='$o' $temp>$o</option>\n";
	}    
    echo " </select>\n";
    $k++;
    echo "Time On: <select class='timeondrv' id='timeondrv$c' name='timeondrv$c'> \n"; //remember input state
    $o=0;
    while ($o<0xffff)
	{	
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}
        $ho= (int) ($o/3600);
        $min=($o/60)%60;
        $min=round($min);
        $sec=$o%60;
	echo  "  <option value='$o' $temp>$ho h, $min m, $sec s</option>\n";
        if ($o<60) {$o++;}
        else if ($o<300) {$o+=10;}
        else if ($o<1200) {$o+=30;}
        else {$o+=60;}
	}
    echo " </select>\n";
    $k++;
    echo "Disable Time: <select class='timedisabledrv' id='timedisabledrv$c' name='timedisabledrv$c'> \n"; //remember input state
    $o=0;
    while ($o<0x100)
	{
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}
        $ho= (int) ($o/3600);
        $min=($o/60)%60;
        $min=round($min);
        $sec=$o%60;
	echo  "  <option value='$o' $temp>$min m, $sec s</option>\n";
        $o++;
/*        if ($o<60) {$o++;}
        else if ($o<300) {$o+=10;}
        else if ($o<1200) {$o+=30;}
        else {$o+=60;}*/
	}
    echo " </select>\n";
    
    $k++;
    echo "Time Off: <select class='timeoffdrv' id='timeoffdrv$c' name='timeoffdrv$c'> \n"; //remember input state
    $o=0;
    while ($o<0xffff)
	{
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}
        $ho= (int) ($o/3600);
        $min=($o/60)%60;
        $min=round($min);
        $sec=$o%60;
	echo  "  <option value='$o' $temp>$ho h, $min m, $sec s</option>\n";
        if ($o<60) {$o++;}
        else if ($o<300) {$o+=10;}
        else if ($o<1200) {$o+=30;}
        else {$o+=60;}
	}
    echo " </select>\n";
    $k++;
    
    
    echo  "\n&nbsp;<a href=\"javascript:GetDriverEvent('$address',$c,'statedrv$c','repeatdrv$c','timeondrv$c','timeoffdrv$c','timedisabledrv$c','disabledrv$c',1);\">Run</a>\n";
    echo  "\n&nbsp;<a href=\"javascript:GetDriverEvent('$address',$c,'statedrv$c','repeatdrv$c','timeondrv$c','timeoffdrv$c','timedisabledrv$c','disabledrv$c',0);\">Copy</a>\n";
    
    echo "</div>"."\n";
        
    }
echo    '</div>';        
/////////////////////////////////////////////////////////////////////////////////
echo "\n<br><strong>ADC Measurement Settings:</strong>\n<br>\n";
echo '<div id="adcincfg">'."\n";
 for ($i=0;$i<4;$i++)
    {$m=$i+1;
    echo "<div class='adccfg' id='adc$m'>\n";
    echo "$m) $adcn[$i]:\n";
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    
    echo "<input class='invertadc' name='invertadc$m' $temp type='checkbox'>Invert\n"; //invert input state
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    
    echo "<input class='alarmadcl' name='alarmadcl$m' $temp type='checkbox'>Alarm Low\n";   //alarm enabled
    
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    
    echo "<input class='alarmadch' name='alarmadch$m' $temp type='checkbox'>Alarm High\n";   //alarm enabled
    echo ", Alarm Delay: <select class='alarmdelayadc' name='alarmdelayadc$m'> \n"; //alarm timeout
    $o=0;
    while ($o<0x100)
        {
        $ss=$o*20;   //MAX_ADC * 5s
        $ho= (int) ($ss/3600);
        $min=($ss/60)%60;
        $min=round($min);
        $sec=$ss%60;
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}    
	echo  "  <option value='$o' $temp>$ho h, $min m, $sec s</option>\n";
        $o++;
	}
        $k++;
    echo " </select>\n";
    
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='adcevdis' name='adcevdis$m' id='adcevdis$m' $temp type='checkbox'>Event Disable\n";   //event disabled
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='adcadmin' name='adcadmin$m' id='adcadmin$m' $temp type='checkbox'>Admin\n";   //admin
    echo "<br>\n";
    echo "\nLOW Event: <input class='adclowevent' id='adclowev$m' name='adclowev$m' type='text' value='".$data[$k++]  ."'>\n"; //Event to run when input activated
    echo "LOW Direct: <input class='adclowevent' name='adclowdiev$m' id='adclowdiev$m' type='text' value='".$data[$k++]  ."'>\n"; //direct event code
echo "\nLow Level <select class='adcllevel' name='lleveladc$m'> \n"; //alarm timeout
    $o=0;
    while ($o<0x1000)
	{
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}
	echo  "  <option value='$o' $temp>$o</option>\n";
        $o++;
	}
        
    echo " </select>\n<br>\n";
    $k++;
    echo "OK Event: <input class='adcokevent' id='adcokev$m' name='adcokev$m' type='text' value='".$data[$k++]  ."'>\n"; //Event to run when input activated
    echo "OK Direct: <input class='adcokevent' id='adcokdiev$m' name='adcokdiev$m' type='text' value='".$data[$k++]  ."'>\n"; //direct event code
    echo  "\n&nbsp;<a href=\"javascript:GetADCEvent('$address',$m,'invertadc$m','alarmadcl$m','alarmadch$m','alarmdelayadc$m','lleveladc$m','hleveladc$m','adcevdis$m',1);\">Run</a>\n";
    echo  "\n&nbsp;<a href=\"javascript:GetADCEvent('$address',$m,'invertadc$m','alarmadcl$m','alarmadch$m','alarmdelayadc$m','lleveladc$m','hleveladc$m','adcevdis$m',0);\">Copy</a>\n";
    echo "\n<br>HIGH Event: <input class='adchighevent' id='adchighev$m' name='adchighev$m' type='text' value='".$data[$k++]  ."'>\n"; //Event to run when input activated
    echo "HIGH Direct: <input class='adchighevent' id='adchighdiev$m' name='adchighdiev$m' type='text' value='".$data[$k++]  ."'>\n"; //direct event code
echo "\nHigh Level <select class='adchlevel' name='hleveladc$m'> \n"; //alarm timeout
    $o=0;
    while ($o<0x1000)
        {
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}    
	echo  "  <option value='$o' $temp>$o</option>\n";
        $o++;
	}
    echo " </select>\n<br>\n";    
    
    
    echo "</div>"."\n";
    $k++;
    }    
echo "</div>"."\n";        


/////////////////////////////////////////////////////////////////////////////////
echo "\n<br><strong>Dimmers:</strong>\n<br>\n";
echo '<div id="dimmcfg">'."\n";
 for ($i=0;$i<4;$i++)
    {$m=$i+1;
    echo "<div class='dimmcfg' id='dimm$m'>\n";
    echo "$m) $dimmn[$i]:\n";
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='invertdimm' name='invertdimm$m' $temp type='checkbox'>Invert\n"; //invert input state

    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='admindimm' name='admindimm$m' $temp type='checkbox'>Admin\n"; //invert input state
    
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}    
    echo "<input class='disabledimm' name='disabledimm$m' $temp type='checkbox'>Disable\n"; //invert input state

    echo ", Value Min: <select class='mindimm' name='mindimm$m'> \n"; //alarm timeout
    $o=0;
    while ($o<0x100)
        {        
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}    
	echo  "  <option value='$o' $temp>$o</option>\n";
        $o++;
	}
        $k++;
    echo " </select>\n";
    
    echo ", Value: <select class='valuedimm' name='valuedimm$m'> \n"; //alarm timeout
    $o=0;
    while ($o<0x100)
        {        
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}    
	echo  "  <option value='$o' $temp>$o</option>\n";
        $o++;
	}
        $k++;
    echo " </select>\n";
    
    echo ", Mode: <select class='modedimm' name='modedimm$m'> \n"; //alarm timeout
    $o=0;    
    if ($data[$k]=="0")         {echo  "  <option value='0' selected>N/A</option>\n";}
                           else {echo  "  <option value='0'>N/A</option>\n";}
    if ($data[$k]=="1")         {echo  "  <option value='1' selected>Stop</option>\n";}
                           else {echo  "  <option value='1'>Stop</option>\n";}
    if ($data[$k]=="2")         {echo  "  <option value='2' selected>+</option>\n";}
                           else {echo  "  <option value='2'>+</option>\n";}
    if ($data[$k]=="3")         {echo  "  <option value='3' selected>-</option>\n";}
                           else {echo  "  <option value='3'>-</option>\n";}
    if ($data[$k]=="4")         {echo  "  <option value='4' selected>Set</option>\n";}
                           else {echo  "  <option value='4'>Set</option>\n";}
    echo "</select> \n";
    $k++;

    
    echo ", Step: <select class='stepdimm' name='stepdimm$m'> \n"; //alarm timeout
    $o=0;
    while ($o<0x100)
        {        
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}    
	echo  "  <option value='$o' $temp>$o</option>\n";
        $o++;
	}
        $k++;
    echo " </select>\n";
    
    echo ", Value Max: <select class='maxdimm' name='maxdimm$m'> \n"; //alarm timeout
    $o=0;
    while ($o<0x100)
        {        
        if ($data[$k]=="$o") {$temp='selected';}
        else {$temp='';}    
	echo  "  <option value='$o' $temp>$o</option>\n";
        $o++;
	}
        $k++;
    echo " </select>\n";
    
    
    echo  "\n&nbsp;<a href=\"javascript:GetDimmerEvent('$address',$m,'invertdimm$m','mindimm$m','valuedimm$m','modedimm$m','stepdimm$m','maxdimm$m',1);\">Run</a>\n";
    echo  "\n&nbsp;<a href=\"javascript:GetDimmerEvent('$address',$m,'invertdimm$m','mindimm$m','valuedimm$m','modedimm$m','stepdimm$m','maxdimm$m',0);\">Copy</a>\n";
    
    
    echo "</div>"."\n";
    
    }    
    echo  "<br>\nRGBW Dimmer: <br>\n";
    echo " Mode: <select class='modergbdimm' name='modergbdimm'> \n"; //alarm timeout
    $o=0;    
    if ($data[$k]=="0")         {echo  "  <option value='0' selected>N/A</option>\n";}
                           else {echo  "  <option value='0'>N/A</option>\n";}
    if ($data[$k]=="1")         {echo  "  <option value='1' selected>Stop</option>\n";}
                           else {echo  "  <option value='1'>Stop</option>\n";}
    if ($data[$k]=="2")         {echo  "  <option value='2' selected>+</option>\n";}
                           else {echo  "  <option value='2'>+</option>\n";}
    if ($data[$k]=="3")         {echo  "  <option value='3' selected>-</option>\n";}
                           else {echo  "  <option value='3'>-</option>\n";}
    if ($data[$k]=="4")         {echo  "  <option value='4' selected>Set</option>\n";}
                           else {echo  "  <option value='4'>Set</option>\n";}
    echo "</select> \n";
    $k++;

    echo " Continuous Mode:";
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='rgbwdimmr' name='rgbwdimmr' $temp type='checkbox'>Red\n"; 
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='rgbwdimmg' name='rgbwdimmg' $temp type='checkbox'>Green\n"; 
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='rgbwdimmb' name='rgbwdimmb' $temp type='checkbox'>Blue\n"; 
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='rgbwdimmw' name='rgbwdimmw' $temp type='checkbox'>White\n"; 
    
    echo "Advanced: \n";
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='rgbwdimmar' name='rgbwdimmar' $temp type='checkbox'>Red\n"; 
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='rgbwdimmag' name='rgbwdimmag' $temp type='checkbox'>Green\n"; 
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='rgbwdimmab' name='rgbwdimmab' $temp type='checkbox'>Blue\n"; 
    if ($data[$k++]=='1') {$temp='checked';}
    else {$temp='';}
    echo "<input class='rgbwdimmaw' name='rgbwdimmaw' $temp type='checkbox'>White\n"; 

    
    echo "<a href=\"javascript:GetRGBDimmerEvent('$address',0,'modedimm1','valuedimm1','valuedimm2','valuedimm3','valuedimm4','rgbwdimm',1);\">Run</a>\n"; 
    echo  "\n&nbsp;<a href=\"javascript:GetRGBDimmerEvent('$address',0,'modedimm1','valuedimm1','valuedimm2','valuedimm3','valuedimm4','rgbwdimm',0);\">Copy</a>\n<br>\n";



    
    
//echo    '</div>';    
echo "<input type='submit' value='Update'>\n";
echo "</form>\n";
//echo "</div>\n";

echo "<br><br><a href=\"javascript:X('$address"."fe55aaa55a960000');\">Write Config</a>\n ";
echo " <a href=\"javascript:X('$address"."fe55aaa55a690000');\">Upgrade Firmware</a>\n ";
echo " <a href=\"javascript:X('$address"."fe55aa0000000000');\">Reset - Run</a>\n ";
echo " <a href=\"javascript:CopyToClipboard('$address"."fe55aa0000000000');\">Reset - Copy</a>\n";
echo $footer;

}
/////////////////////////////////////////////////////////
//change device names, signal names and ADC params
function ChangeNames()
{
global $data,$comment,$address,$eHousePath,$eHouseDir,$get,$update,$_GET,$_POST,$DevName,$outn,$inn,$adcn,$dimmn,$progn,$adcprogn;
$k=0;
$header="\n";
$footer="\n";
if (file_exists($eHousePath."names.head"))
    $header=file_get_contents($eHousePath."names.head");
if (file_exists($eHousePath."names.foot"))
    $footer=file_get_contents($eHousePath."names.foot");

$cols=2;
$query=array("","");
if ($update) 
	{
	if ($get==1) $query=$_GET;
	else $query=$_POST;
	   //var_dump($_GET);
	 get_content($eHousePath."$address.txt");
	 $startdta=false;
	 $data[$k++]=$query["devname"];
	 for ($i=0;$i<8;$i++)
		{
		$m=$i+1;
		$data[$k++]=$query["o$m"];
		}
	 for ($i=0;$i<8;$i++)
		{
		$m=$i+1;
		$data[$k++]=$query["i$m"];
		}
	for ($i=0;$i<4;$i++)
		{
		$m=$i+1;
		$data[$k++]=$query["a$m"];
		$data[$k++]=$query["adct$m"];
		}

	for ($i=0;$i<4;$i++)
		{
		$m=$i+1;
		$data[$k++]=$query["d$m"];
		}

	for ($i=0;$i<24;$i++)
		{
		$m=$i+1;
		$data[$k++]=$query["p$m"];
		}
	for ($i=0;$i<12;$i++)
		{
		$m=$i+1;
		$data[$k++]=$query["ap$m"];
		}


	write_content($eHousePath."$address.txt");
	}
$k=0;
get_content($eHousePath."$address.txt");

$DevName=$data[$k++];
$adccfg=array("","");
$adcoptions=file($eHouseDir.'ADCSensorTypes.txt');
echo $header;
echo "<form method='get'>\n";
echo "<input type='hidden' name='func' value='changename'>\n";
echo "<input type='hidden' name='address' value='$address'>\n";
echo "<input type='hidden' name='update' value='1'>\n";
echo "<input type='hidden' name='startdta' value='startdta'>\n";
echo "<div id='devname'>\nDevice Name: <input type='text' name='devname' value='$DevName' id='devname'></div>\n";
echo "<div id='outputs'>\n";
for ($i=0;$i<8;$i++)
	{
	$m=$i+1;
	$outn[$i]=$data[$k++];
	echo " Output $m: <input type='text' name='o$m'  value='$outn[$i]' class='output'>\n";
	if (($i%$cols)==$cols-1) echo "<br>\n";
	}
echo "</div>\n";
echo "<br><br>\n";
echo "<div id='inputs'>\n";
for ($i=0;$i<8;$i++)
	{
	$m=$i+1;
	$inn[$i]=$data[$k++];
	echo " Input $m: <input type='text' name='i$m' value='$inn[$i]' class='input'>\n";
	if ($i%($cols)==$cols-1) echo "<br>\n";
	}
echo "</div>\n";
echo "<br><br>\n";
echo "<div id='adcs'>\n";
for ($i=0;$i<4;$i++)
	{
	$m=$i+1;
	$adcn[$i]=$data[$k++];
	$adccfg[$i]=$data[$k++];
	echo " ADC $m: <input type='text' name='a$m' value='$adcn[$i]' class='adc'>\n";
	echo " <select name='adct$m'> \n";
for ($o=0;$o<count($adcoptions);$o++)
	{
	$selected='';
	$adcoptions[$o]=trim($adcoptions[$o]);
//	echo    $k  .'=='. $adccfg[$i]."\n<br>";
	if ("$o"==$adccfg[$i]) 
		{
		$selected='selected';
//		echo "SELECTED\n";
		}
	echo  "  <option value='$o' $selected>$adcoptions[$o]</option>\n";
	}
	echo " </select>\n";
//if ($i%($cols)==$cols-1) 
	echo "<br>\n";
	}
echo "</div>\n";
echo "<br><br>\n";
echo "<div id='dimmers'>\n";
for ($i=0;$i<4;$i++)
	{
	$m=$i+1;
	$dimmn[$i]=$data[$k++];
	echo " Dimmer $m: <input type='text' name='d$m' value='$dimmn[$i]' class='dimmer'>\n";
	if ($i%($cols)==$cols-1) echo "<br>\n";
	}
echo "</div>\n";
echo "<br><br>\n";
echo "<div id='programs'>\n";
for ($i=0;$i<24;$i++)
	{
	$m=$i+1;
	$progn[$i]=$data[$k++];
	echo " Program $m: <input type='text' name='p$m' value='$progn[$i]' class='program'>\n";
	if ($i%($cols)==$cols-1) echo "<br>\n";
	}
echo "</div>\n";
echo "<br><br>\n";

echo "<div id='adcprograms'>\n";
for ($i=0;$i<12;$i++)
	{
	$m=$i+1;
	$adcprogn[$i]=$data[$k++];
	echo "ADC Program $m: <input type='text' name='ap$m' value='$adcprogn[$i]' class='adcprogram'>\n";
	if ($i%($cols)==$cols-1) echo "<br>\n";
	}
echo "</div>\n";
echo "<br><br>\n";
echo "<input type='submit' value='Update'>\n";
echo "</form>\n";
echo "</div>\n";
echo $footer;
}

//////////////////////////////////////////////////////////
//write config from $data, $commands arrays
function write_content($file)
{
global $data,$comment;
$f=fopen($file,"w");
for ($i=0;$i<count($data);$i++)
 fwrite($f,trim($data[$i])."\t".trim($comment[$i])."\n");
fflush($f);
fclose($f);
}
if ($func=='changename')
		ChangeNames();
else 
	if ($func=='advancedsettings')
	    AdvancedOutputSettings();
	else echo "no function selectedd";
?>




<!DOCTYPE html>
<!--
To change this license header, choose License Headers in Project Properties.
To change this template file, choose Tools | Templates
and open the template in the editor.
-->
<!--<html>
    <head>
        <meta charset="UTF-8">
        <title></title>
    </head>
    <body>
   
    </body>
</html>
-->
